

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnalyticsMAList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAnalyticsMAList.sp,v $ $Id: AppGetAnalyticsMAList.sp,v 1.5.12.9 2019/05/09 15:47:43 pveeravalli Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAnalyticsMAList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnalyticsMAList <<<'
	drop procedure AppGetAnalyticsMAList
END
IF EXISTS (select * from GxQscripts where name='AppGetAnalyticsMAList')
	delete from GxQscripts where name = 'AppGetAnalyticsMAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsMAList')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsMAList'
GO
print '... Creating Procedure: AppGetAnalyticsMAList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAnalyticsMAList
  @i_archGroupId INT=0,
  @i_maType INT=0,
  @i_userId INT=0,
  @i_clientGrpId INT=0
AS
  DECLARE @o_xmlOut XML =''
DECLARE @isAllAssociationsCapSet INT = 0
IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL     DROP TABLE #getObjectsTable
    CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
DECLARE @MAClientListTbl 	TABLE(
				type integer NOT NULL DEFAULT 2,
				Id	integer,
				Name  nvarchar(255),
			        displayName nvarchar(255))
DECLARE @IndexServerClientsTbl TABLE
(
	ServiceLink			NVARCHAR(512),
	ClientId			INT,
	name				VARCHAR(256),
	cloudId				INT,
	net_hostname        NVARCHAR(256),
	portNo				INT,
	roleTypeVersion      VARCHAR(32),
	engineName			NVARCHAR(256),
	serverType			INT,
	indexServerClientId		INT,
	cloudInternalName			NVARCHAR(256)
)
--GET INDEX SERVER CLIENTS INSTEAD OF MA
IF @i_maType = 0  --index server
BEGIN
	INSERT INTO @IndexServerClientsTbl(ServiceLink, ClientId, name, cloudId, net_hostname, portNo, roleTypeVersion, engineName, serverType, indexServerClientId, cloudInternalName)
EXEC DM2GetAllAnalyticsEngine 'Data Analytics', @i_userId, 2
	INSERT INTO @MAClientListTbl (type, ID, name)
	SELECT DISTINCT 1, indexServerClientId, engineName
	FROM @IndexServerClientsTbl
END
--First let us see if we have got the permissions on commcell level.
IF OBJECT_ID('tempdb.dbo.#commcellLevelAssociations') IS NOT NULL DROP TABLE #commcellLevelAssociations
CREATE TABLE #commcellLevelAssociations (permissionId INT)
EXEC sec_getPermissionsOnEntity '#commcellLevelAssociations', @i_userId, 1, 2
IF EXISTS (SELECT 1 FROM #commcellLevelAssociations WHERE permissionId IN (4, 12, 2))
	SET @isAllAssociationsCapSet = 1
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL      DROP TABLE #permissionIdTable
    CREATE TABLE #permissionIdTable (permissionId INT)
    INSERT INTO #permissionIdTable
SELECT 2
        UNION
SELECT 12
        UNION
SELECT 4
    EXEC sec_getObjectsWithPermissionsV2 @i_userId,
3,
                                        0
END
IF  @isAllAssociationsCapSet = 1 OR EXISTS (SELECT TOP 1 1 FROM #getObjectsTable)
BEGIN
	IF @i_archGroupId > 0
	BEGIN
		--get client lists for which backup is run on the sp
		insert into @MAClientListTbl ( iD, Name,displayName)
		EXEC archClientsByPolicy @i_archGroupId, 0
		--delete unassociated client & MA, EDGE clients
		DELETE  T
		FROM @MAClientListTbl T
			 JOIN APP_Client C WITH (NOLOCK) ON T.Id =C.id
		WHERE type =2
			AND  ( (@isAllAssociationsCapSet = 0 AND T.Id NOT IN (SELECT DISTINCT entityId FROM #getObjectsTable)	)
OR ((C.status & 0x10000000) > 0)
				 )
	END
	ELSE IF @i_clientGrpId > 0
	BEGIN
		--get client lists for client group
		insert into @MAClientListTbl ( iD, Name)
		SELECT CG.clientId,  C.name
		FROM APP_ClientGroupAssoc CG WITH (NOLOCK)
		JOIN APP_CLIENT C WITH (NOLOCK)  ON CG.clientId = c.Id
		WHERE clientGroupId = @i_clientGrpId
			AND  ( (@isAllAssociationsCapSet = 1 OR C.Id NOT IN (SELECT DISTINCT entityId FROM #getObjectsTable)	)
OR ((C.status & 0x10000000) > 0)
				 )
	END
END
--select * from @MAClientListTbl
--output
SET @o_xmlOut = ISNULL(( 	SELECT
							(
								SELECT
								T.Id AS '@clientId',
								T.Name AS '@clientName'
								FROM @MAClientListTbl T
								WHERE type =1
								FOR XML PATH('indexServers'), TYPE
							),
							(
							SELECT
								T.Id AS '@clientId',
								T.Name AS '@clientName'
								FROM @MAClientListTbl T
								WHERE type =2
								FOR XML PATH('clients'), TYPE
					 ) FOR XML PATH('TMMsg_MediaAgentListResp')
					 ),'<TMMsg_MediaAgentListResp/>')
SELECT @o_xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnalyticsMAList')
	delete from GxQscripts where name = 'AppGetAnalyticsMAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsMAList')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsMAList'
GO

insert into GXDBVersions values(2, 'AppGetAnalyticsMAList',  '00010005001200090000', 'AppGetAnalyticsMAList', '00010005001200090000')
GO

