

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAnalyticsCloudDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAnalyticsCloudDetails.sp,v $ $Id: AppGetAnalyticsCloudDetails.sp,v 1.1.4.13 2020/05/19 18:45:23 pankajkumar Exp $";
--     +-----------------------------------------------------------------------+
--     |                       PROCEDURE: "AppGetAnalyticsCloudDetails"        |
--     +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAnalyticsCloudDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAnalyticsCloudDetails <<<'
	drop procedure AppGetAnalyticsCloudDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetAnalyticsCloudDetails')
	delete from GxQscripts where name = 'AppGetAnalyticsCloudDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsCloudDetails')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsCloudDetails'
GO
print '... Creating Procedure: AppGetAnalyticsCloudDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAnalyticsCloudDetails
  @i_userId INT = 0,
  @i_ClientId INT = 0,
  @i_CloudType INT = 0
AS
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(512)
  DECLARE @o_hostName NVARCHAR(512)
  DECLARE @o_isEnabled INT 
  DECLARE @o_jvmMax VARCHAR(32)
  DECLARE @o_PortNo VARCHAR(32)
  DECLARE @o_URL VARCHAR(255)
  DECLARE @o_isWebserver VARCHAR(10)
  DECLARE @o_indexServerPoolClientId INT
  DECLARE @o_indexServerPoolName NVARCHAR(512)
  DECLARE @o_clientType INT
  DECLARE @o_clientDisplayName NVARCHAR(512)
  DECLARE @o_defaultIndexDir NVARCHAR(1024)
IF OBJECT_ID('tempdb.dbo.#solrCloudInfoTbl') IS NOT NULL DROP TABLE #solrCloudInfoTbl
CREATE TABLE #solrCloudInfoTbl (t_clientId INT DEFAULT 0,
							t_clientName NVARCHAR(512) DEFAULT '',
							t_hostName NVARCHAR(512) DEFAULT '',
							t_isEnabled INT DEFAULT 0,
							t_jvmMax VARCHAR(32) DEFAULT '4096',
							t_PortNo VARCHAR(32) DEFAULT '0' ,
							t_URL VARCHAR(255) DEFAULT '',
							t_isWebserver VARCHAR(1024) DEFAULT 'false',
							t_indexServerPoolClientId INT DEFAULT 0,
							t_indexServerPoolName NVARCHAR(512) DEFAULT '',
							t_clientType INT DEFAULT 0,
                            t_clientDisplayName NVARCHAR(512) DEFAULT '',
							t_defaultIndexDir NVARCHAR(1024) DEFAULT '')
IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
CREATE TABLE #clientList
(
	t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
--get ALL association COMMCELL LEVEL check for Agent Management permission
DECLARE @isAllAssociationsSetAgent INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 2  /*EV_MANAGE_APPLICATION*/, @isAllAssociationsSetAgent OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
IF @isAllAssociationsSetAgent = 0
BEGIN
		--EV_MANAGE_APPLICATION
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 2, 0, '#clientList'
END
ELSE
BEGIN
	-- all clients
	INSERT INTO #clientList (t_clientId)
	VALUES (0)
END
BEGIN
	IF @i_CloudType = 5
	BEGIN
		--index server pool name
        INSERT INTO #solrCloudInfoTbl(t_indexServerPoolClientId, t_indexServerPoolName, t_clientDisplayName, t_clientType)
        SELECT DISTINCT C.id, C.name,C.displayName, 1 --pool
		FROM APP_CLIENT C (NOLOCK)
		JOIN #clientList CL ON C.id = CL.t_clientId OR CL.t_clientId = 0
		JOIN DM2Cloud DC (NOLOCK) ON C.id = DC.pseudoClientId
		WHERE DC.cloudType = 9 --CloudServerType::IndexServerPool
			AND DC.status =1
	END
	IF @i_CloudType IN (1,5)
	BEGIN
		--Legacy engine
		--DO NOT INCLUDE  nodes from existing analytics engine / index server pool
        INSERT INTO #solrCloudInfoTbl(t_clientId, t_clientName, t_clientDisplayName, t_hostName, t_clientType)
		SELECT DISTINCT C.id, C.name, C.displayName, C.net_hostName, 2 -- nodes
		FROM APP_CLIENT C (NOLOCK)
		JOIN #clientList CL ON C.id = CL.t_clientId OR CL.t_clientId = 0
		JOIN simInstalledPackages P (NOLOCK) ON C.id = P.ClientId
		LEFT JOIN DM2SearchServerCoreInfo S(NOLOCK) ON P.ClientId = S.clientId AND S.CloudType IN (1,4,5,9)
WHERE P.simPackageID IN ( 55, 1306) AND S.clientId IS NULL
	END
	IF @i_CloudType IN (1)
	BEGIN
		--port no should be same as instance no
		UPDATE #solrCloudInfoTbl
		SET t_PortNo = (CASE WHEN  attrVal = 'Instance001' THEN '20000' ELSE ('2000'+ SUBSTRING (attrVal, LEN(ATTRVAL), LEN(ATTRVAL))) END)
		FROM APP_ClientProp CP (NOLOCK)
		INNER JOIN #solrCloudInfoTbl T ON  T.t_clientId = CP.componentNameId AND attrName = 'Galaxy Instance name'
		WHERE t_PortNo = '0' AND t_clientType = 2 --nodes
		--provide default index directory for standalone index server
		UPDATE #solrCloudInfoTbl
		SET t_defaultIndexDir = dbo.GetDefaultAnalyticsIndexPath(t_clientId, '')
		FROM #solrCloudInfoTbl
		WHERE t_clientType = 2
	END
	--is webserver package installed on node client
	UPDATE #solrCloudInfoTbl
	SET t_isWebserver = 'true'
	FROM simInstalledPackages P (nolock)
	INNER JOIN #solrCloudInfoTbl T ON  T.t_clientId = P.clientId
WHERE P.simPackageID IN (252, 263, 1156,1174)
	AND t_clientType = 2
END
--OUTPUT
SELECT * FROM #solrCloudInfoTbl
IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
IF OBJECT_ID('tempdb.dbo.#solrCloudInfoTbl') IS NOT NULL DROP TABLE #solrCloudInfoTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAnalyticsCloudDetails')
	delete from GxQscripts where name = 'AppGetAnalyticsCloudDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAnalyticsCloudDetails')
	delete from GXDBVersions where aliasname = 'AppGetAnalyticsCloudDetails'
GO

insert into GXDBVersions values(2, 'AppGetAnalyticsCloudDetails',  '00010001000400130000', 'AppGetAnalyticsCloudDetails', '00010001000400130000')
GO

