

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAllAGClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAllAGClients.sp,v $ $Id: AppGetAllAGClients.sp,v 1.1.2.1 2018/07/11 06:08:08 shussain Exp $";
--1. Input xml would be as below. It has list of client id to match with existing replicas.
--<App_GetAllAGClientsRequest>
--	<clients clientId="8"/>
--	<clients clientId="10"/>
--</App_GetAllAGClientsRequest>
--
--2. Check if at least one AG is configured. If AG is configured then instance has property 'Availability Group'. If not then exit.
--
--3. Get property 'Availability Replicas' from all MSSQL instances. The xml value would be as below. It has replica clients, example client id 7, 8.
--<App_SQLAvailabilityReplicas>
--	<SQLAvailabilityReplicasList availabilityMode="0" backupPriority="50" connectionState="1" failoverMode="1" name="OLIVE" role="1">
--		<replicaClient _type_="3" clientId="7" clientName="olive"/>
--	</SQLAvailabilityReplicasList>
--	<SQLAvailabilityReplicasList availabilityMode="0" backupPriority="50" connectionState="1" failoverMode="1" name="POPEYE" role="2">
--		<replicaClient _type_="3" clientId="8" clientName="popeye"/>
--	</SQLAvailabilityReplicasList>
--</App_SQLAvailabilityReplicas>
--
--4. The output would be list of AG clients which given client IDs are part of.
--		Example, client 10 is AG client to which given 8 is associated to.
--<App_GetAllAGClientsResponse>
--  <clients clientId="10" />
--</App_GetAllAGClientsResponse>
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetAllAGClients <<<'

IF EXISTS (select * from sysobjects where name='AppGetAllAGClients')
	drop procedure AppGetAllAGClients
IF EXISTS (select * from GxQscripts where name='AppGetAllAGClients')
	delete from GxQscripts where name = 'AppGetAllAGClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAllAGClients')
	delete from GXDBVersions where aliasname = 'AppGetAllAGClients'
GO
print '... Creating Procedure: AppGetAllAGClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAllAGClients
  @inputXML XML
AS
DECLARE @xmlQuery XML = '<App_GetAllAGClientsResponse/>'
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--2.
IF(NOT EXISTS(SELECT 1 FROM APP_INSTANCEPROP WITH(NOLOCK) WHERE ATTRNAME = 'Availability Group' AND modified = 0))
BEGIN
	GOTO RETURN_OUTPUT
END
--3.
IF OBJECT_ID('tempdb.dbo.#Replicas') IS NOT NULL
    DROP TABLE #Replicas
CREATE TABLE #Replicas (instanceId INT, availableReplicas XML)
INSERT #Replicas
SELECT DISTINCT instance.componentNameId, instance.attrVal
FROM APP_Application subclient WITH(NOLOCK)
INNER JOIN APP_InstanceProp instance WITH(NOLOCK) ON instance.componentNameId = subclient.instance
	WHERE subclient.appTypeId = 81
	AND instance.attrName = N'Availability Replicas' and instance.modified = 0
--4.
IF OBJECT_ID('tempdb.dbo.#AGClients') IS NOT NULL
    DROP TABLE #AGClients
CREATE TABLE #AGClients (clientId INT)
INSERT #AGClients
	SELECT DISTINCT subclient.clientId FROM
		(SELECT
				S.instanceId, M.C.value('@clientId', 'INT') AS ReplicaId
			FROM #Replicas AS S
				OUTER APPLY S.availableReplicas.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') as M(C)) ReplicaTable
		JOIN
		(SELECT T.C.value('@clientId', 'int') AS id
			FROM @inputXML.nodes('App_GetAllAGClientsRequest/clients') T(C) ) InputCLients
		ON ReplicaTable.ReplicaId = InputCLients.id
		JOIN
			APP_Application subclient
		ON subclient.instance = ReplicaTable.instanceId
SET @xmlQuery=  (SELECT
                        (SELECT clientId AS '@clientId'
								FROM #AGClients
                                FOR XML PATH('clients'), TYPE)
                    FOR XML PATH('App_GetAllAGClientsResponse'),TYPE)
RETURN_OUTPUT:
SELECT @xmlQuery
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAllAGClients')
	delete from GxQscripts where name = 'AppGetAllAGClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAllAGClients')
	delete from GXDBVersions where aliasname = 'AppGetAllAGClients'
GO

insert into GXDBVersions values(2, 'AppGetAllAGClients',  '00010001000200010000', 'AppGetAllAGClients', '00010001000200010000')
GO

