

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAdvancedIndexingInfo.sp] ---------- 

--  +===================================================================================================+
--  |		 		 Name:  AppPlanGetEnitityDefaultPlan()
--  | Description:  Fetches applicable Plan for the entity provided from any where in the hierarchy
--  +===================================================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAdvancedIndexingInfo.sp,v $ $Id: AppGetAdvancedIndexingInfo.sp,v 1.1.2.7.6.1 2021/02/02 23:41:07 alakra Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetAdvancedIndexingInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAdvancedIndexingInfo <<<'
	drop procedure AppGetAdvancedIndexingInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetAdvancedIndexingInfo')
	delete from GxQscripts where name = 'AppGetAdvancedIndexingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAdvancedIndexingInfo')
	delete from GXDBVersions where aliasname = 'AppGetAdvancedIndexingInfo'
GO
print '... Creating Procedure: AppGetAdvancedIndexingInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetAdvancedIndexingInfo
  @xmlString XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	-- Get subclient Id
	DECLARE @subclientId INT = ISNULL((SELECT ISNULL(ref.value('@subClientId', 'INT'), ref.value('@entityId', 'INT')) FROM @xmlString.nodes('Api_AdvancedIndexingInfoRequest/entity') R ( ref ) WHERE ref.value('@entityType', 'INT') = 7), 0)
	-- User Id
   DECLARE @i_userId INT = ISNULL((SELECT ref.value('@userId', 'INT')
           FROM @xmlString.nodes('Api_AdvancedIndexingInfoRequest/processinginstructioninfo/user') r (ref)), 1)
   -- Locale
   DECLARE @i_localeId INT = ISNULL((SELECT  ref.value('@localeId', 'INT')
           FROM @xmlString.nodes('Api_AdvancedIndexingInfoRequest/processinginstructioninfo/locale') R ( ref )),0)
	-- Code below this will be changed soon in next checkin
	DECLARE @clientId			INTEGER  = ISNULL((SELECT clientId FROM APP_APPLICATION WHERE id=@subclientId), 0)
	DECLARE @errCode			INTEGER = 0 -- error code
	DECLARE @errString			VARCHAR(1024)  ='' -- error string
	DECLARE @planId				INTEGER
	DECLARE @planName			NVARCHAR(1024)
	DECLARE @ciPolicyId			INTEGER = 0
	DECLARE @indexServer		INTEGER = 0
	DECLARE @isIndexingEnabled	INTEGER = 0
	DECLARE @ciPolicyXML 		XML
	DECLARE @isV2VSAClient  	INTEGER = 0
	-- Global flag
	-- If 0, then assume CVSolr
	-- If missing or any other value, then assume Ctree indexing
	DECLARE @globalVSAFlag		INTEGER = ISNULL( (SELECT 0 FROM GXGlobalParam WHERE name='VSAFileIndexingType' AND value='0') , 0)
	SET @indexServer = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Associated index server id' AND modified = 0 AND cs_attrName=CHECKSUM(N'Associated index server id')), 0)
	SET @ciPolicyId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Indexing Configuration Policy' AND modified = 0 AND cs_attrName=CHECKSUM(N'Indexing Configuration Policy')), 0)
SET @planId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Associated Plan' AND modified = 0 AND cs_attrName=CHECKSUM(N'Associated Plan')), 0)
	SET @planName = (SELECT name FROM App_Plan WITH (NOLOCK) WHERE id=@planId)
	IF (@ciPolicyId > 0)
	BEGIN
		-- If we got the configuration Policy , then get the entire configuration policy reponse
		SET @ciPolicyXML = (
                                SELECT 30 AS '@propertyLevel',  -- ListPropertyLevels_AllProperties
                                (
                                    SELECT
                                    (
                                        SELECT @ciPolicyId AS '@policyId' FOR XML PATH('policyEntity'), TYPE
                                    )
                                    FOR XML PATH('policy'), TYPE
                                ) ,
								(
									SELECT
										(
											SELECT 'skipSelectStatment' AS '@name', '1' AS '@value'
											FOR XML PATH('attributes'), TYPE
										)
									FOR XML PATH('processinginstructioninfo'), TYPE
								)
								FOR XML PATH('Ida_GetConfigurationPolicyReq'), TYPE
                              )
		EXEC AppConfigurationPolicyGet @ciPolicyXML OUTPUT
	END
	SET @isV2VSAClient = ISNULL((SELECT 1 FROM APP_ClientProp WHERE componentNameId=@clientId AND attrName = 'IndexingV2_VSA' AND attrval='1' AND modified = 0), 0)
	IF ((@ciPolicyId > 0) AND ((@indexServer > 0 ) OR ((@globalVSAFlag = 1) AND (@isV2VSAClient=1))))
		SET @isIndexingEnabled = 1
	-- Let's Form the XML
	SET @xmlString = (
                SELECT @isIndexingEnabled AS '@isIndexingEnabled',
					(
						SELECT @indexServer AS '@clientId'
							FOR XML PATH('indexServer'), TYPE
					),
					(
						SELECT @planId AS '@planId', @planName AS '@planName'
							FOR XML PATH('plan'), TYPE
					),
					(
						SELECT 0  AS '@errCode', '' AS '@errorMessage'
							FOR    XML PATH('error'), TYPE
					),
					(SELECT @ciPolicyXML.value('(/Ida_GetConfigurationPolicyResp/policies[1]/@policyType)[1]', 'INT') as '@policyType',
							@ciPolicyXML.value('(/Ida_GetConfigurationPolicyResp/policies[1]/@flags)[1]', 'INT') as '@flags',
							@ciPolicyXML.query('/Ida_GetConfigurationPolicyResp/policies[1]/*')
						FOR XML PATH('ciPolicy'), TYPE)
                 FOR XML PATH('Api_AdvancedIndexingInfoResponse'), TYPE
                )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @xmlString = ( SELECT
					(
						SELECT @errCode  AS '@errCode', @errString AS '@errorMessage'
							FOR    XML PATH('error'), TYPE
					)
                 FOR XML PATH('Api_AdvancedIndexingInfoResponse'), TYPE
                )
END CATCH
SCRIPT_EXIT:
 SELECT @xmlString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAdvancedIndexingInfo')
	delete from GxQscripts where name = 'AppGetAdvancedIndexingInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAdvancedIndexingInfo')
	delete from GXDBVersions where aliasname = 'AppGetAdvancedIndexingInfo'
GO

insert into GXDBVersions values(2, 'AppGetAdvancedIndexingInfo',  'v1.1.2.7.6.1', 'AppGetAdvancedIndexingInfo', 'v1.1.2.7.6.1')
GO

