

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAdditionalSettingsFromDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetAdditionalSettingsFromDB.sp,v $ $Id: AppGetAdditionalSettingsFromDB.sp,v 1.6.66.6 2019/05/25 07:58:31 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAdditionalSettingsFromDB')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAdditionalSettingsFromDB <<<'
	drop procedure AppGetAdditionalSettingsFromDB
END
IF EXISTS (select * from GxQscripts where name='AppGetAdditionalSettingsFromDB')
	delete from GxQscripts where name = 'AppGetAdditionalSettingsFromDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAdditionalSettingsFromDB')
	delete from GXDBVersions where aliasname = 'AppGetAdditionalSettingsFromDB'
GO
print '... Creating Procedure: AppGetAdditionalSettingsFromDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAdditionalSettingsFromDB
  @entityIdParam INTEGER,
  @entityTypeParam INTEGER,
  @sourceEntityIdParam INTEGER,
  @sourceEntityTypeParam INTEGER,
  @includeDBKeysParam INTEGER = 0,
  @includeDeletedParam INTEGER = 0,
  @filterDebugKeysParam INTEGER = 0   
AS
  DECLARE @enabled integer
  DECLARE @deleted integer
  DECLARE @entityType integer
  DECLARE @sourceId integer
  DECLARE @sourceEntityType integer
  DECLARE @type nvarchar(128)
  DECLARE @value nvarchar(max)
  DECLARE @keyName nvarchar(max)
  DECLARE @relativePath nvarchar(max)
  DECLARE @comment nvarchar(max)
  DECLARE @hidden integer
DECLARE @nowTime BIGINT = dbo.GetUnixTime(GetUTCDate())
DECLARE @idtable TABLE (id INTEGER)
DECLARE  @APP_AdvanceSettingsTemp TABLE
	(
	id		integer	identity(1,1),
	entityId		integer,
	keyName			nvarchar(MAX),
	type			nvarchar(40),
	relativePath		nvarchar(MAX) ,
	value			ntext,
	enabled			tinyint,
	deleted			tinyint,
	entityType		integer,
	sourceId		integer,
	sourceEntityType 	integer,
	exProp 		xml,
	hidden			integer,
	primary key (id)
	)
DECLARE @sourceTable table (sourceId integer,sourceEntity integer)
DECLARE @expiryDays INTEGER = ISNULL((SELECT value FROM GxGlobalParam WHERE name like 'DebugKeyExpiryInDays' and modified = 0),7)
DECLARE @expirySeconds INTEGER = @expiryDays * 24 * 3600
DECLARE @orderByDeleted TINYINT = 1		-- yes order by deleted column default op, turned off when not required
IF @filterDebugKeysParam = 1
BEGIN
	INSERT INTO @idtable
		SELECT adv.id
		FROM APP_AdvanceSettings adv WITH(NOLOCK) INNER JOIN APP_AdvanceSettings adv1 WITH(NOLOCK)
		ON adv.entityId = adv1.entityId AND adv.entityType = adv1.entityType AND adv1.keyName like '%_UNTIL'
		AND  adv.keyname = LTRIM(RTRIM(REPLACE(adv1.keyname,'_UNTIL','')))
		WHERE CAST(CONVERT(nvarchar(max),adv1.value) as BIGINT) < @nowTime
		UNION ALL	-- performance do as 1 data set operation
		SELECT adv1.id
		FROM APP_AdvanceSettings adv WITH(NOLOCK) INNER JOIN APP_AdvanceSettings adv1 WITH(NOLOCK)
		ON adv.entityId = adv1.entityId AND adv.entityType = adv1.entityType AND adv1.keyName like '%_UNTIL'
		AND  adv.keyname = LTRIM(RTRIM(REPLACE(adv1.keyname,'_UNTIL','')))
		WHERE CAST(CONVERT(nvarchar(max),adv1.value) as BIGINT) < @nowTime
	UPDATE APP_AdvanceSettings
    SET deleted = 1
    WHERE id in (SELECT id FROM @idtable)
END
ELSE IF @includeDBKeysParam = 0
BEGIN
	IF @includeDeletedParam = 1
	BEGIN
		INSERT INTO @APP_AdvanceSettingsTemp
			SELECT entityId,keyName,type,relativePath,value,enabled,deleted,entityType,sourceId,sourceEntityType,AdvEx.details,AdvEx.hidden
				FROM APP_AdvanceSettings appAdv WITH(NOLOCK)
				        LEFT OUTER JOIN App_AdvanceSettingsEx AdvEx WITH(NOLOCK)
					     ON AdvEx.keyId = appAdv.id
						WHERE entityId = @entityIdParam and entityType = @entityTypeParam and relativePath NOT LIKE 'CommServDB%'
						ORDER BY deleted DESC	-- can probably remove as well since final output is ordered
	END
	ELSE
	BEGIN
		INSERT INTO @APP_AdvanceSettingsTemp
			SELECT entityId,keyName,type,relativePath,value,enabled,deleted,entityType,sourceId,sourceEntityType,AdvEx.details,AdvEx.hidden
				FROM APP_AdvanceSettings appAdv WITH(NOLOCK)
				        LEFT OUTER JOIN App_AdvanceSettingsEx AdvEx WITH(NOLOCK)
					     ON AdvEx.keyId = appAdv.id
					        WHERE entityId = @entityIdParam and entityType = @entityTypeParam and deleted = 0 and sourceId = @sourceEntityIdParam and relativePath NOT LIKE 'CommServDB%' and sourceEntityType = @sourceEntityTypeParam
					        --ORDER BY deleted DESC		-- Performance: order by for deleted column is wasted performance when all rows return have deleted=0, remove in SP17
		SET @orderByDeleted = 0
	END
END
ELSE
BEGIN
	IF @includeDeletedParam = 1
	BEGIN
		INSERT INTO @APP_AdvanceSettingsTemp
			SELECT entityId,keyName,type,relativePath,value,enabled,deleted,entityType,sourceId,sourceEntityType,AdvEx.details,ISNULL(AdvEx.hidden,0)
				FROM APP_AdvanceSettings appAdv WITH(NOLOCK)
				        LEFT OUTER JOIN App_AdvanceSettingsEx AdvEx WITH(NOLOCK)
					     ON AdvEx.keyId = appAdv.id
				     		WHERE entityId = @entityIdParam and entityType = @entityTypeParam
				     		ORDER BY deleted DESC	-- can probably remove as well since final output is ordered
	END
	ELSE
	BEGIN
		INSERT INTO @APP_AdvanceSettingsTemp
			SELECT entityId,keyName,type,relativePath,value,enabled,deleted,entityType,sourceId,sourceEntityType,AdvEx.details,ISNULL(AdvEx.hidden,0)
				FROM APP_AdvanceSettings appAdv WITH(NOLOCK)
				        LEFT OUTER JOIN App_AdvanceSettingsEx AdvEx WITH(NOLOCK)
					     ON AdvEx.keyId = appAdv.id
						WHERE entityId = @entityIdParam and entityType = @entityTypeParam and deleted = 0 and sourceId = @sourceEntityIdParam and sourceEntityType = @sourceEntityTypeParam
						--ORDER BY deleted DESC		 -- Performance: order by for deleted column is wasted performance when all rows return have deleted=0, remove in SP17
		SET @orderByDeleted = 0
	END
END
IF (@orderByDeleted = 1)
BEGIN
	SELECT enabled,deleted,entityType,sourceId,sourceEntityType,type,value,keyName,relativePath,ISNULL(exProp.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as comment,hidden
	FROM @APP_AdvanceSettingsTemp
	ORDER BY deleted DESC
END
ELSE
BEGIN
	-- Performance: Do not order by deleted column deleted=0 for all rows
	SELECT enabled,deleted,entityType,sourceId,sourceEntityType,type,value,keyName,relativePath,ISNULL(exProp.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as comment,hidden
	FROM @APP_AdvanceSettingsTemp
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAdditionalSettingsFromDB')
	delete from GxQscripts where name = 'AppGetAdditionalSettingsFromDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAdditionalSettingsFromDB')
	delete from GXDBVersions where aliasname = 'AppGetAdditionalSettingsFromDB'
GO

insert into GXDBVersions values(2, 'AppGetAdditionalSettingsFromDB',  '00010006006600060000', 'AppGetAdditionalSettingsFromDB', '00010006006600060000')
GO

