

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAdditionalSettings.sp] ---------- 

--  +==========================================================================================
--  | Stored Procedure: Gets commcell additional settings
--  +==========================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetAdditionalSettings')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAdditionalSettings <<<'
	drop procedure AppGetAdditionalSettings
END
IF EXISTS (select * from GxQscripts where name='AppGetAdditionalSettings')
	delete from GxQscripts where name = 'AppGetAdditionalSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAdditionalSettings')
	delete from GXDBVersions where aliasname = 'AppGetAdditionalSettings'
GO
print '... Creating Procedure: AppGetAdditionalSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetAdditionalSettings
  @i_xml XML
AS
    SET NOCOUNT ON
	DECLARE @error XML
	DECLARE @errorCode int = 0
	DECLARE @errorMsg NVARCHAR(510)
BEGIN TRY
	/** Sample Request
	'<Api_GetAdditionalSettingsRequest getAllSettings="1" getAllCommservDBAdminConsole="1"  getAllCommservDBWebConsole="1" getAllWebconsole="1" >
		<filter>
			<relativePathFilter relativePath="CommservDB.AdminConsole">
				<keyNameList val="showSharedLaptopUsage"/>
				<keyNameList val="test2"/>
			</relativePathFilter>
			<relativePathFilter relativePath="CommServDB.WebConsole">
				<keyNameList val="test3"/>
			</relativePathFilter>
		</filter>
		<entity entityType="3" entityId ="2"/>
	</Api_GetAdditionalSettingsRequest>'
	**/
	DECLARE @getAllSettings INT
	DECLARE @getAllCommservDBAdminConsole INT
	DECLARE @getAllCommservDBWebConsole INT
	DECLARE @getAllWebconsole INT
	DECLARE @getAllCommservDBConsole INT
	DECLARE @entityType INT
	DECLARE @entityId INT
	SELECT  @getAllSettings = ISNULL(ref.value('@getAllSettings', 'INT'),0),
			@getAllCommservDBAdminConsole = ISNULL(ref.value('@getAllCommservDBAdminConsole', 'INT'),0) ,
			@getAllCommservDBWebConsole = ISNULL(ref.value('@getAllCommservDBWebConsole', 'INT'),0) ,
			@getAllWebconsole = ISNULL(ref.value('@getAllWebconsole', 'INT'),0) ,
			@getAllCommservDBConsole = ISNULL(ref.value('@getAllCommservDBConsole', 'INT'),0),
@entityType = ISNULL(ref.value('(entity/@entityType)[1]', 'INT'),3),
			@entityId = ISNULL(ref.value('(entity/@entityId)[1]', 'INT'),2/*COMMSERV*/)
	FROM @i_xml.nodes('Api_GetAdditionalSettingsRequest') R ( ref )
	IF OBJECT_ID('tempdb.dbo.#relativePathKeyFilter') IS NOT null DROP TABLE #relativePathKeyFilter
	CREATE TABLE #relativePathKeyFilter(relativePath NVARCHAR(max), KeyName NVARCHAR(512))
	IF object_id('tempdb.dbo.#resultAdditionalSettings') IS NOT null DROP TABLE #resultAdditionalSettings
	CREATE TABLE #resultAdditionalSettings(relativePath nvarchar(max), KeyName nvarchar(512),value ntext,type INT)
	-- get filters
	INSERT INTO #relativePathKeyFilter
		SELECT
			ref.value('../@relativePath', 'NVARCHAR(max)'),
			ref.value('@val', 'NVARCHAR(512)')
		FROM @i_xml.nodes('/Api_GetAdditionalSettingsRequest/filter/relativePathFilter/keyNameList') R(ref)
	INSERT INTO #resultAdditionalSettings
		SELECT	relativePath,
				keyName,
				value,
				(CASE type  WHEN N'INTEGER' THEN '0'
					WHEN N'BOOLEAN' THEN '1'
					WHEN N'STRING' THEN '2'
					WHEN N'ENCRYPTED' THEN '3'
					WHEN N'MULTISTRING' THEN '4'
					END) AS type
		FROM APP_AdvanceSettings ADV WITH(NOLOCK)
		WHERE deleted = 0 and enabled = 1 and entityId = @entityId and entityType = @entityType
		AND (@getAllSettings=1
		OR (@getAllCommservDBAdminConsole = 1 AND ADV.relativePath = 'CommservDB.AdminConsole')
		OR (@getAllCommservDBWebConsole = 1 AND ADV.relativePath = 'CommservDB.WebConsole')
		OR (@getAllWebconsole = 1 AND ADV.relativePath = 'WebConsole')
		OR (@getAllCommservDBConsole = 1 AND ADV.relativePath = 'CommservDB.Console')
		OR (@getAllCommservDBAdminConsole = 0 AND @getAllCommservDBWebConsole = 0 AND @getAllWebconsole = 0 AND @getAllCommservDBConsole = 0 AND
			EXISTS ( SELECT 1 FROM #relativePathKeyFilter filter WHERE ADV.relativePath = filter.relativePath AND ADV.keyName = filter.KeyName )))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode = ERROR_NUMBER()
        SET @errorMsg ='Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END  CATCH
	SELECT
		@error,
		(
			SELECT R1.relativePath as '@relativePath',
				(
					SELECT
						R2.type as '@attrType',
						(SELECT R2.KeyName as '@name', R2.value as '@value' FOR XML PATH('attrNameValue'), TYPE)
					FROM #resultAdditionalSettings as R2
					WHERE r2.relativePath = r1.relativePath
					FOR XML PATH('nameValueAttrType'), TYPE
				)
			FROM #resultAdditionalSettings AS R1
			GROUP BY relativePath
			FOR XML PATH('additionalSettingList'),TYPE
		)
	FOR  XML PATH('Api_GetAdditionalSettingsResponse'),TYPE
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAdditionalSettings')
	delete from GxQscripts where name = 'AppGetAdditionalSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAdditionalSettings')
	delete from GXDBVersions where aliasname = 'AppGetAdditionalSettings'
GO

insert into GXDBVersions values(2, 'AppGetAdditionalSettings',  '00000000000000000000', 'AppGetAdditionalSettings', '00000000000000000000')
GO

