

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetActivationFlag.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetAssociatedPlan()
--  |
--  | Description:  Get associated plan for an user
--  |
--  |       Input:  user id , locale id
--  |      Output:  ProfileId,ErrorCode, ErrorString to determine status of the operation
--  |				errorCode- 0 if successfull, non zero if profile is not found with appropriate error string.
--  |
--  |
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetActivationFlag')
BEGIN
	print '>>> Drop Stored Procedure: AppGetActivationFlag <<<'
	drop procedure AppGetActivationFlag
END
IF EXISTS (select * from GxQscripts where name='AppGetActivationFlag')
	delete from GxQscripts where name = 'AppGetActivationFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetActivationFlag')
	delete from GXDBVersions where aliasname = 'AppGetActivationFlag'
GO
print '... Creating Procedure: AppGetActivationFlag'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetActivationFlag
  @clientId INT,
  @userId INT,
  @localeId INT,
  @flag INT
AS
  DECLARE @activationFlag INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @activationFlag = 0
SET @errorCode = 0
SET @errorString = N'Success'
BEGIN TRY
DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
-- Case where activation is not needed and nothing to try.
-- Given plan id is not in DB or no laptop plans found then set activation is not needed.
IF (SELECT COUNT(id) FROM APP_PLAN WHERE subType = 33554439
		and  (id > 0) ) = 0
BEGIN
	 SET @activationFlag = 0
	 GOTO GENERATE_OUTPUT
END
-- Gxglobal param set send activation = false
IF EXISTS (SELECT 1 FROM GxGlobalParam WHERE name = 'SkipActivation' and value = 1)
BEGIN
	 SET @activationFlag = 0
	 SET @errorString = 'Global parameter is set to skip activation. Hence not proceeding with activation.'
	 GOTO GENERATE_OUTPUT
END
--When reaches here, This CommCell needs activation and activate call will figure out the activated mode and plan Id.
SET @activationFlag = 1
-- @flag 0 (GET) 1 (UPDATE)
-- Check if the update should be skipped. We should never have this property in DB
-- Reinstall / Reconfigure of physical from GUI
IF @flag = 1
BEGIN
	IF @clientId <> 0
	BEGIN
				UPDATE app_clientprop set attrval = @activationFlag
WHERE attrname = 'Need Activation'
				and componentNameId = @clientId
		IF @@ROWCOUNT = 0
			INSERT INTO App_ClientProp VALUES
(@clientId, 'Need Activation', 10, @activationFlag, @nowTime, 0, 0)
		-- CCS Laptop Activation moved to APPPlanPostInstallActions SP
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @activationFlag, @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetActivationFlag')
	delete from GxQscripts where name = 'AppGetActivationFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetActivationFlag')
	delete from GXDBVersions where aliasname = 'AppGetActivationFlag'
GO

insert into GXDBVersions values(2, 'AppGetActivationFlag',  '00000000000000000000', 'AppGetActivationFlag', '00000000000000000000')
GO

