

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetActivationDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetActivationDetails()
--  |
--  | Description:  Checks if client is activated and returns its owner
--  |
--  |       Input:  client id
--  |      Output:  ownerId,ownerName,ErrorCode,ErrorString to determine status of the operation
--  |				errorCode- 0 if successfull, non zero if there exists no owner.
--  |
--  |
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetActivationDetails <<<'

IF EXISTS (select * from sysobjects where name='AppGetActivationDetails')
	drop procedure AppGetActivationDetails
IF EXISTS (select * from GxQscripts where name='AppGetActivationDetails')
	delete from GxQscripts where name = 'AppGetActivationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetActivationDetails')
	delete from GXDBVersions where aliasname = 'AppGetActivationDetails'
GO
print '... Creating Procedure: AppGetActivationDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetActivationDetails
  @clientId INTEGER
AS
  DECLARE @ownerId INTEGER
  DECLARE @ownerName NVARCHAR(MAX)
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorString = N''
SET @ownerId = 0
SET @ownerName = N''
BEGIN TRY
-- Check if device already activated using activated user id property
SET @ownerId = ISNULL((select CONVERT(INT,attrVal) FROM App_ClientProp WHERE attrName = 'Activated User Id' AND componentNameId = @clientId AND modified = 0),0)
IF @ownerId = 0
BEGIN
	-- Check if owners exist for this particular client
	SET @ownerId = ISNULL((select TOP 1 userId FROM sec_getClientOwners(1) WHERE clientId = @clientId),0)
END
IF @ownerId <> 0
BEGIN
	SET @errorString = ''
	SET @ownerName = (select login FROM UMUsers WHERE id = @ownerId)
	GOTO GENERATE_OUTPUT
END
ELSE
BEGIN
	SET @errorString = 'Could not retrieve owner info for the activated laptop.'
	SET @ownerId = 0
	SET @errorCode = 1
	GOTO GENERATE_OUTPUT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @ownerId,@ownerName,@errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetActivationDetails')
	delete from GxQscripts where name = 'AppGetActivationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetActivationDetails')
	delete from GXDBVersions where aliasname = 'AppGetActivationDetails'
GO

insert into GXDBVersions values(2, 'AppGetActivationDetails',  '00000000000000000000', 'AppGetActivationDetails', '00000000000000000000')
GO

