

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetActivateOnHoldLaptop.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetActivateOnHoldLaptop()
--  |
--  | Description:  SP to get physical client id for the diactivated user centric laptop
--  |
--  |       Input:   pseudo client id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  nshah  	to get physical client id for the diactivated user centric laptop
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetActivateOnHoldLaptop')
BEGIN
	print '>>> Drop Stored Procedure: AppGetActivateOnHoldLaptop <<<'
	drop procedure AppGetActivateOnHoldLaptop
END
IF EXISTS (select * from GxQscripts where name='AppGetActivateOnHoldLaptop')
	delete from GxQscripts where name = 'AppGetActivateOnHoldLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetActivateOnHoldLaptop')
	delete from GXDBVersions where aliasname = 'AppGetActivateOnHoldLaptop'
GO
print '... Creating Procedure: AppGetActivateOnHoldLaptop'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetActivateOnHoldLaptop
  @localeId INT,
  @pseudoClientId INT
AS
  DECLARE @physicalClientId INT
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
SET @errorCode = 0
SET @errorString = ''
SET @physicalClientId = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	--This will be only called for user centric clients
SELECT @physicalClientId = attrval FROM APP_CLIENTPROP WHERE attrname = 'Physical Client Id' and modified = 0 AND componentNameId=@pseudoClientId
	IF (@physicalClientId <> 0 )
	BEGIN
		--Cannot activate the laptop as it is already activated.
SET @errorCode = (4541 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4541 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		GOTO GENERATE_OUTPUT
	END
	SELECT @physicalClientId=a.id FROM APP_ClientProp p
	INNER JOIN app_client a ON CAST(a.id AS varchar(10))= p.attrVal
	INNER JOIN simInstalledPackages pkg on pkg.ClientId=a.id
WHERE attrName  = 'Physical Client Id on hold' AND p.componentNameId=@pseudoClientId
	IF (@physicalClientId =0)
	BEGIN
SET @errorCode = (4544 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		--Failed to find the associated physical client for the given client.
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4544 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		GOTO GENERATE_OUTPUT
	END
	--check if another user centric laptop is activated for same user and same physical client
	DECLARE @existingActivatedLaptop nvarchar(1024) = null
	SELECT @existingActivatedLaptop=c.displayName
	FROM APP_ClientProp p
INNER JOIN APP_ClientProp P1 on p.componentNameId=p1.componentNameId AND p1.attrName='Physical Client Id' AND p1.attrVal=CAST(@physicalClientId AS varchar(10)) AND p1.modified=0--change--
	INNER JOIN app_client c on c.id= p.componentNameId
	INNER JOIN sec_getClientOwners(1) o on o.clientId=@pseudoClientId
WHERE p.attrName =  'Installation User ID' AND p.attrVal = cast(o.userId as varchar(10)) and p.modified=0
	IF(@existingActivatedLaptop is not null)
	BEGIN
SET @errorCode = (4543 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		--'Cannot activate this laptop as other laptop is already activated for this user.'
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4543 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s',@existingActivatedLaptop)
		GOTO GENERATE_OUTPUT
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @physicalClientId, @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetActivateOnHoldLaptop')
	delete from GxQscripts where name = 'AppGetActivateOnHoldLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetActivateOnHoldLaptop')
	delete from GXDBVersions where aliasname = 'AppGetActivateOnHoldLaptop'
GO

insert into GXDBVersions values(2, 'AppGetActivateOnHoldLaptop',  '00000000000000000000', 'AppGetActivateOnHoldLaptop', '00000000000000000000')
GO

