

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetAccessNodes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Precedure: AppGetAccessNodes
--  |
--  | Description:
--  |  This SP will return access nodes from clientid and instance id
--  |  based on if its an archiving solution or not.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetAccessNodes')
BEGIN
	print '>>> Drop Stored Procedure: AppGetAccessNodes <<<'
	drop procedure AppGetAccessNodes
END
IF EXISTS (select * from GxQscripts where name='AppGetAccessNodes')
	delete from GxQscripts where name = 'AppGetAccessNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAccessNodes')
	delete from GXDBVersions where aliasname = 'AppGetAccessNodes'
GO
print '... Creating Procedure: AppGetAccessNodes'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetAccessNodes
  @clientId INTEGER,
  @instanceId INTEGER,
  @isArchival INTEGER,
  @o_xml XML OUTPUT
AS
DECLARE @allAccessNodes TABLE(backupSetId INT, subClientId INT, accessNodes NVARCHAR(MAX))
DECLARE @dataAccessNodes XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
INSERT INTO @allAccessNodes
SELECT AppBP.componentNameId, App.id, SProp.attrVal
FROM App_Application App WITH (NOLOCK)
						INNER JOIN App_SubclientProp SProp WITH (NOLOCK)
						ON App.id = SProp.componentNameId
AND SProp.attrName = 'Data Access Nodes'
AND SProp.cs_attrName = CHECKSUM(N'Data Access Nodes')
						AND SProp.modified = 0
                        INNER JOIN APP_BackupSetName AppB WITH (NOLOCK)
                        ON App.backupSet = AppB.id
						LEFT JOIN APP_BackupSetProp AppBP WITH (NOLOCK)
						ON AppB.id = AppBP.componentNameId
AND AppBP.attrName = 'Is Archiving Enabled'
							AND AppBP.attrVal = '1'
							AND AppBP.modified = 0
						WHERE App.instance = @instanceId
                        AND App.clientId = @clientId
                        AND App.subclientstatus & 8 = 8
						AND ((AppBP.componentNameId IS NULL AND AppB.status & 8 = 8) OR (AppBP.componentNameId IS NOT NULL))
IF @isArchival = 1
BEGIN
DECLARE @default_archive_subclient_id INT
SET @default_archive_subclient_id = (SELECT ISNULL(MIN(Ac.subClientId), 0)
								FROM @allAccessNodes Ac
								WHERE Ac.backupSetId IS NOT NULL)
SET @dataAccessNodes =  (SELECT ISNULL(Ac.accessNodes, '<App_DataAccessNodes />')
						FROM @allAccessNodes Ac
						WHERE Ac.subClientId = @default_archive_subclient_id
						)
END
ELSE
BEGIN
SET @dataAccessNodes =  (SELECT ISNULL(Ac.accessNodes, '<App_DataAccessNodes />')
						FROM @allAccessNodes Ac
						WHERE Ac.backupSetId IS NULL)
END
SELECT @o_xml = (select isnull((select T.c.value('@clientId', 'int') as '@clientId',
					T.c.value('@clientName', 'nvarchar(max)') as '@clientName'
					from @dataAccessNodes.nodes('/App_DataAccessNodes/dataAccessNodes') T(c)
					inner join app_client AppC
					on AppC.id = T.c.value('@clientId', 'int')
					where AppC.status & 2 <>2
					for xml path('dataAccessNodes'), root('App_DataAccessNodes')),  '<App_DataAccessNodes/>'))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetAccessNodes')
	delete from GxQscripts where name = 'AppGetAccessNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetAccessNodes')
	delete from GXDBVersions where aliasname = 'AppGetAccessNodes'
GO

insert into GXDBVersions values(2, 'AppGetAccessNodes',  '00000000000000000000', 'AppGetAccessNodes', '00000000000000000000')
GO

