

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetADClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetADClients.sp,v $ $Id: AppGetADClients.sp,v 1.1.2.18 2020/12/09 22:27:13 rchandora Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetADClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetADClients <<<'
	drop procedure AppGetADClients
END
IF EXISTS (select * from GxQscripts where name='AppGetADClients')
	delete from GxQscripts where name = 'AppGetADClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetADClients')
	delete from GXDBVersions where aliasname = 'AppGetADClients'
GO
print '... Creating Procedure: AppGetADClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetADClients
  @i_userId INT,
  @i_apptypeId INT,
  @o_xmlData XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isCommcellLevelAssociation int = 0
	BEGIN
		-- Apply security
		IF object_id('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
create table  #tempSubclientSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 2013, 0, '#tempSubclientSecurityObjects'
SELECT @isCommcellLevelAssociation=1 from #tempSubclientSecurityObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
		IF OBJECT_ID('tempdb.dbo.#adSubclientInfo') IS NOT NULL DROP TABLE #adSubclientInfo
		CREATE table #adSubclientInfo (clientId int, clientName nvarchar(256), backupsetId int, backupsetName nvarchar(256), subclientId int, subclientName nvarchar(256), planId int, planName nvarchar(256), username nvarchar(256), pswd nvarchar(256),  lastBackupTime int, lastBackupSize bigint, totalBackupSize bigint, backupStatus nvarchar(16), sla nvarchar(16), isDefaultBackupSet int, isDefaultSubclient int, lastBackupType int, isAzureADClient int, azureConnections nvarchar(max), indexServerId int, indexServerName nvarchar(256),  memberServers nvarchar(max), azureAdminAccounts nvarchar(max), serviceAccounts  XML, azureAppList XML, storagePolicyID int, storagePolicyName nvarchar(256), isConfigured int, appTypeID int, isDeletedClient int, lastBackupJobInfo XML, displayName NVARCHAR(255))
		-- Insert subclient details
		Insert into #adSubclientInfo
		select A.clientId, C.name, A.backupset, B.name, A.id, A.subclientName , 0, '', '', '',  0, 0, 0, '', '', 0, 0, 0,
			--isAzureADClient
			(select
				case
when A.appTypeId = 139 then 1
					else 0 end
			) isAzureADClient,
			'', 0, '',  '', '', NULL, NULL, A.dataArchGrpID, '', 0, A.appTypeId, 0, '', C.displayName
		from APP_Application A WITH(NOLOCK)
		JOIN App_BackupSetName B WITH(NOLOCK) ON B.id = A.backupset
		Join App_Client C WITH(NOLOCK) ON C.id = A.clientId
		Left Join #tempSubclientSecurityObjects T ON A.id = T.subClientId
where  ((A.appTypeId = @i_apptypeId)  OR  (@i_apptypeId = 0 AND A.appTypeId IN (41, 139)))
			AND  (@isCommcellLevelAssociation = 1  OR (C.id IN (SELECT DISTINCT clientId FROM #tempSubclientSecurityObjects where subClientId = 0)) OR (A.id IN (SELECT DISTINCT subclientId FROM #tempSubclientSecurityObjects)))
		--Update client released licensed status
		Update #adSubclientInfo
		SET isDeletedClient = ISNULL(CS.attrVal, 0)
		FROM (
			select T.clientId, attrVal FROM #adSubclientInfo T
			JOIN App_ClientProp (NOLOCK) CP On T.clientId = CP.componentNameId
			WHERE AttrName ='PlatformDeleted 4'
		) CS WHERE #adSubclientInfo.clientId = CS.clientId
		--Update Plan details
		UPDATE #adSubclientInfo
		SET planId=AP.id,
		planName=AP.name
		FROM #adSubclientInfo AD
INNER JOIN APP_SubClientProp ACP WITH(NOLOCK) ON ACP.componentNameId=AD.subclientId AND ACP.attrName =  'Associated Plan' AND ACP.modified=0
INNER JOIN App_Plan AP WITH(NOLOCK) ON AP.id=CAST(ACP.attrVal AS INT) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
		--Update lastBackupJobInfo
		UPDATE #adSubclientInfo
		SET lastBackupJobInfo = ACP.attrVal
		FROM #adSubclientInfo AD
INNER JOIN APP_SubClientProp ACP WITH(NOLOCK) ON ACP.componentNameId=AD.subclientId AND ACP.attrName =  'Last Backup Job Info' AND ACP.modified=0
		--Update storagePolicyName
		UPDATE #adSubclientInfo
		SET storagePolicyName=ag.name
		FROM #adSubclientInfo AD
			INNER JOIN archgroup ag WITH(NOLOCK) ON AD.storagePolicyID = ag.id
		-- -- Update AD user Account , Azure AD properties
		;WITH CTE
		AS
		(
			select [AD User Name] userName, [AD User Password] passcode, clientId,
					[AD Azure Connections] azureConnections, [Azure AD Admin Accounts] azureAdminAccounts, [Azure AD Index Server] indexServerId, [Azure AD Member Servers] memberServers from
			(
			SELECT p.attrName, p.attrVal, ad.clientId FROM #adSubclientInfo AD
JOIN APP_IdaName I WITH(NOLOCK) ON I.clientId = AD.clientId AND (I.apptypeId = @i_appTypeId OR  (@i_apptypeId = 0 AND I.appTypeId IN (41, 139)))
			JOIN APP_IdaProp P WITH(NOLOCK) ON P.componentNameId = I.id AND P.modified = 0 AND (P.attrname = 'AD User Name' OR P.attrName = 'AD User Password'
				OR P.attrName = 'AD Azure Connections' OR P.attrName = 'Azure AD Admin Accounts'  OR P.attrName = 'Azure AD Index Server' OR P.attrName = 'Azure AD Member Servers' )
			) a
			pivot
			(max(attrval)
			for attrName
			in ([AD User Name], [AD User Password], [AD Azure Connections], [Azure AD Admin Accounts], [Azure AD Index Server], [Azure AD Member Servers])
			) as x
		)
		UPDATE T
		SET T.username = CTE.userName, T.azureConnections = CTE.azureConnections, T.azureAdminAccounts = CTE.azureAdminAccounts, T.indexServerId= CTE.indexServerId, T.memberServers = CTE.memberServers, T.pswd = CTE.passcode
		FROM #adSubclientInfo T
		JOIN CTE ON CTE.clientId = T.clientId
		-- Update Index server name
		UPDATE  SI
		SET     SI.indexServerName = A.name
		FROM    #adSubclientInfo SI
				INNER JOIN APP_Client A WITH(NOLOCK) ON SI.indexServerId = A.id
		--Update isDefaultBackupSet
		UPDATE  SI
		SET     SI.isDefaultBackupSet = 1
		FROM    #adSubclientInfo SI
				INNER JOIN APP_BackupSetName  BS WITH(NOLOCK)
ON BS.id = SI.backupsetId AND ((BS.status & 0x00008) = 0x00008)
		--Update isDefaultSubclient
		UPDATE  SI
		SET     SI.isDefaultSubclient = 1
		FROM    #adSubclientInfo SI
				INNER JOIN APP_Application A WITH(NOLOCK)
ON A.id = SI.subclientId AND ((A.subclientStatus & 0x00008) = 0x00008)
		--Update backup info
		UPDATE SI
        SET SI.lastBackupTime = JBS.lastBackupTime,
			SI.totalBackupSize = JBS.totalBackupSize
		FROM #adSubclientInfo SI
		INNER JOIN (SELECT MAX(JB.servEndDate) lastBackupTime,
						SUM(JB.totalUncompBytes) totalBackupSize,
						clientId, appTypeId
					FROM APP_Application AAP  WITH(NOLOCK)
						INNER JOIN JMBkpStats JB  WITH(NOLOCK)
                        ON JB.appId=AAP.id AND JB.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
                        AND JB.dataStatus = 0 -- DATA_STATUS_VALID
					GROUP BY clientId, appTypeId) JBS
        ON JBS.clientId = SI.clientId AND JBS.appTypeId = SI.appTypeID
		--Update SLA status
		IF OBJECT_ID('tempdb.dbo.#SLA_Details') IS NOT NULL DROP TABLE dbo.#SLA_Details
		CREATE TABLE #SLA_Details (clientId INT, appTypeId INT, appId INT, status INT, category INT, slaDays INT)
		DECLARE @DateAsOf DATETIME
		EXEC RptGetSLA @i_userId, -1, 0, 0, @DateAsOf OUTPUT
		UPDATE  SI
            	SET     SI.sla = (CASE WHEN S.SlaStatus = 1 THEN 'Met' WHEN S.SlaStatus = 2 THEN 'Missed' ELSE 'Excluded' END)
            	FROM    #adSubclientInfo SI
                 	LEFT OUTER JOIN (
						SELECT A.clientId, MAX((CASE WHEN SD.category = 1 THEN 1 WHEN SD.category IN (2, 3, 4, 12) THEN 2 ELSE 0 END)) AS SlaStatus
						FROM #SLA_Details SD INNER JOIN APP_Application A WITH(NOLOCK) on SD.appId = A.id group by A.clientId) S
					ON  SI.clientId = S.clientId
		IF OBJECT_ID('tempdb.dbo.#SLA_Details') IS NOT NULL DROP TABLE dbo.#SLA_Details
		--Update Service Accounts
		UPDATE #adSubclientInfo
            SET serviceAccounts = (
									SELECT
									(
										SELECT po.query('.')
										FROM
										(
											SELECT CAST(REPLACE(azureAdminAccounts,'UTF-8','UTF-16') AS XML) serviceAccounts
										) PROP
										CROSS APPLY PROP.serviceAccounts.nodes('./App_AzureADServiceAccounts/accounts') P(po)
										FOR XML PATH(''),TYPE
									)
								)
		WHERE isAzureADClient = 1
		 --ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
        UPDATE #adSubclientInfo
            SET serviceAccounts = '<serviceAccounts></serviceAccounts>'
        WHERE serviceAccounts IS NULL
		--Update configured flag
		UPDATE #adSubclientInfo
            SET isConfigured = 1
		WHERE isAzureADClient = 1 or (isAzureADClient = 0 and (ISNULL(planId,0) >0 or ISNULL(storagePolicyID,0) >0) and ISNULL(username,'') != '' and ISNULL(pswd,'') != '')
		--Reset AD password fields
        UPDATE #adSubclientInfo
            SET pswd = ''
		--Remove password fields for Azure AD
        UPDATE #adSubclientInfo
            SET serviceAccounts.modify('delete //@password')
		WHERE isAzureADClient = 1
		--Update Azure Connections
		UPDATE #adSubclientInfo
            SET azureAppList = (
									SELECT
									(
										SELECT po.query('.')
										FROM
										(
											SELECT CAST(REPLACE(azureConnections,'UTF-8','UTF-16') AS XML) azureConnections
										) PROP
										CROSS APPLY PROP.azureConnections.nodes('./App_Office365AzureConnections/azureApps') P(po)
										FOR XML PATH(''),TYPE
									)
								)
        WHERE isAzureADClient = 1
		--ADD DUMMY DATA WHEN azure connections IS EMPTY TO PREVENT ERROR IN XML MODIFY
        UPDATE #adSubclientInfo
            SET azureAppList = '<azureAppList></azureAppList>'
        WHERE azureAppList IS NULL
		--Remove password fields for Azure AD
        UPDATE #adSubclientInfo
            SET azureAppList.modify('delete //@azureAppKeyValue')
        WHERE isAzureADClient = 1
		SET @o_xmlData =(SELECT adinfo.sla AS '@sla', adinfo.lastBackupTime as '@lastBackupTime', adinfo.isConfigured as '@isConfigured',
								adinfo.isDefaultBackupSet as '@isDefaultBackupSet', adinfo.isDefaultSubclient as '@isDefaultSubclient',
								adinfo.totalBackupSize as '@totalBackupSize', adinfo.backupStatus as '@backupStatus', adinfo.isAzureADClient as '@isAzureADClient',
								adinfo.isDeletedClient as '@isDeletedClient',
							(SELECT  adinfo.clientId AS '@clientId', adinfo.clientName AS '@clientName',
								adinfo.backupsetId AS '@backupsetId', adinfo.backupsetName AS '@backupsetName',
								adinfo.subclientId AS '@subclientId', adinfo.subclientName AS '@subclientName'
								FOR XML PATH('subClientEntity'),TYPE),
							(SELECT adinfo.planId AS '@planId', adinfo.planName AS '@planName'
								FOR XML PATH('planEntity'),TYPE),
							(SELECT adinfo.username AS '@userName', adinfo.pswd AS '@password'
								FOR XML PATH('userAccount'),TYPE),
							(SELECT adinfo.storagePolicyId AS '@storagePolicyId', adinfo. storagePolicyName AS '@storagePolicyName'
								FOR XML PATH('storagePolicy'),TYPE),
							(SELECT
									(SELECT adinfo.indexServerId AS '@clientId', adinfo.indexServerName AS '@clientName'
										FOR XML PATH('indexServer'),TYPE
									),
									azureAppList,
									(
										SELECT
										(
											SELECT po.query('.')
											FROM
											(
												SELECT CAST(REPLACE(adinfo.MemberServers,'UTF-8','UTF-16') AS XML) memberServers
											) PROP
											CROSS APPLY PROP.memberServers.nodes('./App_MemberServers/memberServers') P(po)
											FOR XML PATH(''),TYPE
										)
										FOR XML PATH('memberServers'),TYPE
									),
									serviceAccounts
								FOR XML PATH('azureADProperties'),TYPE),
								(SELECT clientId as '@clientId', clientName as '@clientName', displayName as '@displayName' FOR XML PATH('client'), TYPE),
								(SELECT s.n.query('.') FROM lastBackupJobInfo.nodes('lastBackupJobInfo') s(n))
					FROM #adSubclientInfo 	adinfo
					WHERE isDefaultBackupSet = 1 and isDefaultSubclient = 1
					FOR XML PATH('adClient'), ROOT('App_AppGetADClientsResp'))
		IF object_id('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
		IF OBJECT_ID('tempdb.dbo.#adSubclientInfo') IS NOT NULL	DROP TABLE #adSubclientInfo
		SELECT @o_xmlData = ISNULL(@o_xmlData, '<App_AppGetADClientsResp/>')
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetADClients')
	delete from GxQscripts where name = 'AppGetADClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetADClients')
	delete from GXDBVersions where aliasname = 'AppGetADClients'
GO

insert into GXDBVersions values(2, 'AppGetADClients',  '00010001000200180000', 'AppGetADClients', '00010001000200180000')
GO

