

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGenerateCompanyAuthToken.sp] ---------- 

--  +=========================================================================================================+
--  |		 		 Name:  AppGenerateCompanyAuthToken()
--  | Description:  This procedure will be used after creating a company, to generate and save an auth token.
--  +=========================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGenerateCompanyAuthToken.sp,v $ $Id: AppGenerateCompanyAuthToken.sp,v 1.1.2.8 2019/11/18 18:16:28 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGenerateCompanyAuthToken')
BEGIN
	print '>>> Drop Stored Procedure: AppGenerateCompanyAuthToken <<<'
	drop procedure AppGenerateCompanyAuthToken
END
IF EXISTS (select * from GxQscripts where name='AppGenerateCompanyAuthToken')
	delete from GxQscripts where name = 'AppGenerateCompanyAuthToken'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGenerateCompanyAuthToken')
	delete from GXDBVersions where aliasname = 'AppGenerateCompanyAuthToken'
GO
print '... Creating Procedure: AppGenerateCompanyAuthToken'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGenerateCompanyAuthToken
  @i_userId INTEGER,
  @i_companyId INTEGER,
  @i_localeId INTEGER
AS
  DECLARE @oxml XML
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(1024) =''
  DECLARE @newAuthCode VARCHAR(9)=''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
    DECLARE @ownerCompany INT = 0
	DECLARE @canManageProvider INT
	DECLARE @opMsgId            INTEGER
	DECLARE @opEvMsgId          INTEGER
	DECLARE @opId               INTEGER
	DECLARE @paramMsgId         INTEGER
	DECLARE @paramData          NVARCHAR(1024)
	DECLARE @dataIsEvent        INTEGER = 0
	DECLARE @csGuid uniqueidentifier = (SELECT csGUID FROM APP_CommCell WHERE id = 2)
    SET @ownerCompany = dbo.AppGetCompanyForProvider(@i_companyId)
	IF EXISTS(SELECT 1 FROM UMDSProviders WHERE id = @ownerCompany AND enabled = 1)
	BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
		IF @canManageProvider = 1
		BEGIN
            --setting auth code enable property
IF NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @ownerCompany AND attrName = 'Enable Auth Code Generation'  AND modified = 0 )
            BEGIN
                INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@ownerCompany, 'Enable Auth Code Generation', 7, '1', @nowTime, 0)
            END
            ELSE
            BEGIN
UPDATE App_CompanyProp SET attrVal = '1', created = @nowTime  WHERE componentNameId = @ownerCompany AND attrName = 'Enable Auth Code Generation'  AND modified = 0
            END
            SET @newAuthCode = CONVERT(VARCHAR(9), RIGHT(NEWID(),6)+RIGHT(@csGuid,3))
IF NOT EXISTS ( SELECT Id FROM App_CompanyProp WHERE componentNameId = @ownerCompany AND attrName = 'Authorization Code'  AND modified = 0 ) AND @newAuthCode <> ''
            BEGIN
                INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@ownerCompany, 'Authorization Code', 1, @newAuthCode, @nowTime, 0)
            END
            ELSE
            BEGIN
UPDATE App_CompanyProp SET attrVal = @newAuthCode, created = @nowTime  WHERE componentNameId = @ownerCompany AND attrName = 'Authorization Code'  AND modified = 0
            END
            ------------------------------------------------------
            -- Audit Trail
            ------------------------------------------------------
SET @opMsgId = (566 | (CAST(POWER(2, 24) AS BIGINT) * 84))
            EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
            --Auth code Generated
SET @paramMsgId  = (1551 | (CAST(POWER(2, 24) AS BIGINT) * 85))
            SET @paramData = (SELECT hostname FROM UMDSProviders WHERE id = @ownerCompany AND enabled <> 0)
            EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
            EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
            --User
SET @paramMsgId  = (1189 | (CAST(POWER(2, 24) AS BIGINT) * 85))
            SET @paramData = (SELECT login FROM UMUsers WHERE id = @i_userId)
            EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
            EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		ELSE
		BEGIN
SET @errCode = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
SET @errString = REPLACE(@errString, '^1%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 2), 0,2))
		END
	END
	ELSE
	BEGIN
SET @errCode = (3465 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (3465 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SET @oxml = (SELECT
					(SELECT @newAuthCode as '@authCode' FOR XML PATH ( 'organizationProperties' ),TYPE),
					(SELECT @errCode AS '@errorCode', @errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
						FOR XML PATH ('Api_GenerateCompanyAuthTokenResp'))
SELECT @oxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGenerateCompanyAuthToken')
	delete from GxQscripts where name = 'AppGenerateCompanyAuthToken'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGenerateCompanyAuthToken')
	delete from GXDBVersions where aliasname = 'AppGenerateCompanyAuthToken'
GO

insert into GXDBVersions values(2, 'AppGenerateCompanyAuthToken',  '00010001000200080000', 'AppGenerateCompanyAuthToken', '00010001000200080000')
GO

