

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGenEntityExtendedProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGenEntityExtendedProp.sp,v $ $Id: AppGenEntityExtendedProp.sp,v 1.7 2014/06/19 12:27:15 sjohnson Exp $"
--
--  +========================================================================+
--  | Stored Precedure: AppGenEntityExtendedProp()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Gokul		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGenEntityExtendedProp <<<'

IF EXISTS (select * from sysobjects where name='AppGenEntityExtendedProp')
	drop procedure AppGenEntityExtendedProp
IF EXISTS (select * from GxQscripts where name='AppGenEntityExtendedProp')
	delete from GxQscripts where name = 'AppGenEntityExtendedProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGenEntityExtendedProp')
	delete from GXDBVersions where aliasname = 'AppGenEntityExtendedProp'
GO
print '... Creating Procedure: AppGenEntityExtendedProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGenEntityExtendedProp
  @i_entity INT
AS
BEGIN TRY
  DECLARE @o_storedProc NVARCHAR(MAX)
BEGIN
DECLARE @LINEBREAK NVARCHAR(3) = CHAR(13)+CHAR(10)
IF @i_entity <= 0
BEGIN
	PRINT 'Entity Type is empty'
	RETURN
END
DECLARE @entityName varchar(max) = ISNULL((SELECT entityName FROM App_Entitydetails WHERE entityType = @i_entity),'')
IF @entityName IS NULL OR LEN(@entityName) = 0
BEGIN
	PRINT 'INVALID EntityType passed'
	RETURN
END
DECLARE @storedProc NVARCHAR(MAX) =
N'CREATE PROCEDURE Get' + @entityName + 'ExtendedProperties
@i_entityFilter XML ,
@o_header XML OUTPUT ,
@o_data XML OUTPUT
AS
BEGIN
	DECLARE @header XML
	DECLARE @data XML
	DECLARE @clientId INT = ISNULL((SELECT ref.value(''@clientId'', ''INT'') FROM @i_entityFilter.nodes (''App_ExtendedSummaryReq/entity'') R(ref)),0)
	DECLARE @appTypeId INT = ISNULL((SELECT ref.value(''@applicationId'', ''INT'') FROM @i_entityFilter.nodes (''App_ExtendedSummaryReq/entity'') R(ref)),0)
	DECLARE @instanceId INT = ISNULL((SELECT ref.value(''@instanceId'', ''INT'') FROM @i_entityFilter.nodes (''App_ExtendedSummaryReq/entity'') R(ref)),0)
	DECLARE @backupSetId INT = ISNULL((SELECT ref.value(''@backupsetId'', ''INT'') FROM @i_entityFilter.nodes (''App_ExtendedSummaryReq/entity'') R(ref)),0)
	DECLARE @subclientId INT = ISNULL((SELECT ref.value(''@subclientId'', ''INT'') FROM @i_entityFilter.nodes (''App_ExtendedSummaryReq/entity'') R(ref)),0)
	DECLARE @localeId INT = ISNULL((SELECT ref.value(''@localeId'', ''INT'') FROM @i_entityFilter.nodes (''App_ExtendedSummaryReq'') R(ref)),0)
	DECLARE @entityHeaderTable TABLE (
										value NVARCHAR(max) ,
										type  NVARCHAR(max) ,
										name NVARCHAR(max)
									 )'
-- Check if the stored procedure exists
DECLARE @entitySPName VARCHAR(MAX) = 'Get' + @entityName + 'ExtendedProperties'
--PRINT @entitySpName
IF OBJECT_ID(@entitySPName) <> 0
BEGIN
	DECLARE @dropSP nvarchar(max) = N'DROP PROCEDURE ' + @entitySPName
	EXEC sp_executeSql @dropSP
END
-- Generate the header xml proc part
SET @storedProc = @storedProc + @LINEBREAK + ' INSERT @entityHeaderTable VALUES(''' + '//' + @entityName + '/@name'',''string'', ''Name'') '
SET @storedProc = @storedProc + @LINEBREAK + ' INSERT @entityHeaderTable VALUES(''' + '//' + @entityName + '/@entityPropId'',''int'', ''Id'') '
DECLARE HeaderXmlCur CURSOR
FOR SELECT attrName, attrType, displayName, localizedMsgId FROM App_EntityExtendedProp WHERE entityType = @i_entity AND (flag & 0x1 = 0) ORDER BY displayOrder
DECLARE @value NVARCHAR(MAX)
DECLARE @attrName NVARCHAR(MAX)
DECLARE @attrType NVARCHAR(MAX)
DECLARE @displayName NVARCHAR(MAX)
DECLARE @localizedId INT
DECLARE @valueTableCol NVARCHAR(MAX) = ' name nvarchar(max), entityPropId nvarchar(max),'
OPEN HeaderXmlCur
FETCH NEXT FROM HeaderXmlCur INTO @attrName, @attrType, @displayName, @localizedId
WHILE @@FETCH_STATUS = 0
BEGIN
	IF LOWER(@attrName) <> 'entityPropId' AND LOWER(@attrName) <> 'name'
	BEGIN
		SET @value = '//' + @entityName + '/@' +  @attrName
		--CASE localizedMsgId WHEN 0 THEN displayName ELSE dbo.fn_EvFormatEventMsgText(0,0,localizedMsgId,0,0) END
		SET @storedProc = @storedProc + @LINEBREAK + ' INSERT @entityHeaderTable VALUES(''' + @value + ''',''' + @attrType
		+ ''',(SELECT CASE WHEN (@localeId > 0 AND ' + CAST (@localizedId AS NVARCHAR(MAX)) + ' > 0) THEN dbo.fn_EvFormatEventMsgText(0,@localeId,' + CAST(@localizedId AS NVARCHAR(MAX)) + ',0,0) ELSE ''' +  @displayName + ''' END))'
		SET @valueTableCol = @valueTableCol + ' ' + @attrName + ' nvarchar(max) NULL,'
	END
	FETCH NEXT FROM HeaderXmlCur INTO @attrName, @attrType, @displayName, @localizedId
END
CLOSE HeaderXmlCur
DEALLOCATE HeaderXmlCur
SET @storedProc = @storedProc + @LINEBREAK + N' SET @o_header = ( SELECT [value] AS ''@value'' ,[type] AS ''@type'' , [name] AS ''@name'' FROM @entityHeaderTable FOR XML PATH(''query'') ,ROOT(''header''))'
--Generate the value xml proc part
SET @valueTableCol = SUBSTRING(@valueTableCol,1,LEN(@valueTableCol) - 1) -- Remove the last ","
SET @storedProc = @storedProc + @LINEBREAK + N' DECLARE @entityValueTable TABLE ( ' + @valueTableCol + ') '
DECLARE @dataQueryEntity NVARCHAR(MAX) = ISNULL((SELECT entityDataQuery FROM APP_EntityDetails WHERE entityType = @i_entity),'')
IF @dataQueryEntity IS NULL OR LEN(@dataQueryEntity) = 0
BEGIN
	RETURN
END
SET @storedProc = @storedProc + @LINEBREAK + ' INSERT INTO @entityValueTable(entityPropId,name) ' +  @dataQueryEntity
DECLARE @dataQuery NVARCHAR(MAX)
DECLARE @dataQueryType int
DECLARE ValueXmlCur CURSOR
FOR SELECT attrName, dataQuery, dataQueryType FROM App_EntityExtendedProp WHERE entityType = @i_entity AND (flag & 0x1 = 0) ORDER BY displayOrder
OPEN ValueXmlCur
FETCH NEXT FROM ValueXmlCur INTO @attrName, @dataQuery, @dataQueryType
DECLARE @outputValSelect NVARCHAR(max) = 'SELECT name as ''@name'', entityPropId as ''@entityPropId'','
WHILE @@FETCH_STATUS = 0
BEGIN
	IF LOWER(@attrName) <> 'entityPropId' AND LOWER(@attrName) <> 'name'
	BEGIN
		SET @outputValSelect  = @outputValSelect + @attrName + ' AS ''@' + @attrName + ''','
		IF @dataQueryType = 1
		BEGIN
			SET @storedProc = @storedProc + @LINEBREAK + ' UPDATE @entityValueTable SET ' + @attrName + ' = ' + @dataQuery + ' (entityPropId) '
		END
		ELSE
			SET @storedProc = @storedProc + @LINEBREAK + ' UPDATE @entityValueTable SET ' + @attrName + ' = (' + @dataQuery + ') FROM @entityValueTable '
	END
	FETCH NEXT FROM ValueXmlCur INTO @attrName, @dataQuery, @dataQueryType
END
CLOSE ValueXmlCur
DEALLOCATE ValueXmlCur
SET @outputValSelect = SUBSTRING(@outputValSelect,1,LEN(@outputValSelect) - 1) -- Remove the last ","
SET @storedProc = @storedProc + @LINEBREAK + N' SET @o_data = ( ' +  @outputValSelect + ' FROM @entityValueTable FOR XML PATH(''' + @entityName + '''), ROOT(''data''))'
SET @storedProc = @storedProc + @LINEBREAK + ' SELECT @o_header, @o_data END '
EXEC sp_executeSql @storedProc
END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

set @storedProc='Error Number:'+ERROR_NUMBER()+' Error Line:'+ERROR_LINE()+' Error Message:'+ERROR_MESSAGE()
END CATCH
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO
exec AppGenEntityExtendedProp 3
GO
exec AppGenEntityExtendedProp 4
GO
exec AppGenEntityExtendedProp 5
GO
exec AppGenEntityExtendedProp 6
GO
exec AppGenEntityExtendedProp 7
GO

IF EXISTS (select * from GxQscripts where name = 'AppGenEntityExtendedProp')
	delete from GxQscripts where name = 'AppGenEntityExtendedProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGenEntityExtendedProp')
	delete from GXDBVersions where aliasname = 'AppGenEntityExtendedProp'
GO

insert into GXDBVersions values(2, 'AppGenEntityExtendedProp',  '00010007000000000000', 'AppGenEntityExtendedProp', '00010007000000000000')
GO

