

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGeAnomalousEntityList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGeAnomalousEntityList()
--  |
--  | Description:  Returns list of anomalous entity.
--  |
--  |       Input:  request XML
--  |
--  |      Output:  list of anomalous entity.
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Mohammad Dilshad		Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGeAnomalousEntityList <<<'

IF EXISTS (select * from sysobjects where name='AppGeAnomalousEntityList')
	drop procedure AppGeAnomalousEntityList
IF EXISTS (select * from GxQscripts where name='AppGeAnomalousEntityList')
	delete from GxQscripts where name = 'AppGeAnomalousEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGeAnomalousEntityList')
	delete from GXDBVersions where aliasname = 'AppGeAnomalousEntityList'
GO
print '... Creating Procedure: AppGeAnomalousEntityList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGeAnomalousEntityList
  @xml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userId INT = ISNULL((SELECT @xml.value('(//processinginstructioninfo/user/@userId)[1]', 'INT')), 1)
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @MinimumRuntime INT = @secondsInhour
	DECLARE @anomalyTypeFlag INT = ISNULL((SELECT @xml.value('(//@anomalyTypeFlag)[1]', 'INT')), 0)
	DECLARE @isInfrastructure INT = ISNULL((SELECT @xml.value('(//@isInfrastructure)[1]', 'INT')), 0)
	DECLARE @toTime INT = @time
	DECLARE @fromTime INT =  @toTime - @secondsInDay
	IF OBJECT_ID('tempdb.dbo.#anomalousClients') IS NOT NULL DROP TABLE #anomalousClients
	CREATE TABLE #anomalousClients
	(
		   clientId INT,
		   threshold FLOAT,
		   forecasted FLOAT,
		   currentCount FLOAT,
		   anomalyType INT,
		   infrastructureType INT
	)
	DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @userId, 1, @isAdmin OUTPUT, 1, 2
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
	CREATE TABLE #userClients
	(
		   t_clientId INT,
		   t_appTypeId INT,
		   t_instanceId INT,
		   t_backupsetId INT,
		   t_subclientId INT
	)
	IF @isAdmin <> 1
	BEGIN
		EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
	END
	IF @isInfrastructure = 0 -- Populating anomalous Clients list
	BEGIN
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 1 = 1 -- Based on failed Job
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
				SELECT CLCount.componentNameId, CAST(CLThreshold.attrVal AS FLOAT), CAST(CLCount.attrVal AS FLOAT), 1
				FROM APP_ClientProp CLThreshold
				INNER JOIN APP_ClientProp CLCount
					ON CLThreshold.componentNameId = CLCount.componentNameId
						AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
						AND CLThreshold.modified = 0
						AND CLCount.attrName = N'Client Failed Job Count For Today'
						AND CLCount.modified = 0
						AND CLCount.created > @fromTime
						AND CLCount.created > CLThreshold.created
				WHERE CAST(CLThreshold.attrVal AS FLOAT) > 10 AND CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT)
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
				SELECT CLCount.componentNameId, CAST(CLThreshold.attrVal AS FLOAT), CAST(CLCount.attrVal AS FLOAT), 1
				FROM APP_ClientProp CLThreshold
				INNER JOIN APP_ClientProp CLCount
					ON CLThreshold.componentNameId = CLCount.componentNameId
						AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
						AND CLThreshold.modified = 0
						AND CLCount.attrName = N'Client Failed Job Count For Today'
						AND CLCount.modified = 0
						AND CLCount.created > @fromTime
						AND CLCount.created > CLThreshold.created
				INNER JOIN #userClients CL ON CL.t_clientId = CLThreshold.componentNameId AND CL.t_clientId = CLCount.componentNameId
				WHERE CAST(CLThreshold.attrVal AS FLOAT) > 10 AND CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT)
			END
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 2 = 2 -- Based on Missed SLA
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
				SELECT clientId, 100, CASE WHEN (metSLA + missedSLA) = 0 THEN 100 ELSE CEILING(((missedSLA * 1.0)/ (metSLA + missedSLA))*100) END, 2
				FROM
				(
					SELECT CL.clientId AS clientId, SUM(CASE SC.status WHEN 1 THEN 1 ELSE 0 END) AS metSLA, SUM(CASE SC.status WHEN 2 THEN 1 ELSE 0 END) AS missedSLA
					FROM RptSLAClient CL INNER JOIN RptSLASubclient SC ON CL.clientId = SC.clientId AND CL.status = 2 AND CL.fullJobsOnly = 0 AND CL.days = -1
					GROUP BY CL.clientId
				)SLAClient
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
				SELECT clientId, 100, CASE WHEN (metSLA + missedSLA) = 0 THEN 100 ELSE CEILING(((missedSLA * 1.0)/ (metSLA + missedSLA))*100) END, 2
					FROM
					(
						SELECT CL.clientId AS clientId, SUM(CASE SC.status WHEN 1 THEN 1 ELSE 0 END) AS metSLA, SUM(CASE SC.status WHEN 2 THEN 1 ELSE 0 END) AS missedSLA
						FROM RptSLAClient CL
						INNER JOIN #userClients UCL ON  CL.clientId = UCL.t_clientId
						INNER JOIN RptSLASubclient SC ON CL.clientId = SC.clientId AND CL.status = 2 AND CL.fullJobsOnly = 0 AND CL.days = -1
						GROUP BY CL.clientId
					)SLAClient
			END
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 32 = 32 -- Based on unreachability
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType)
				SELECT clientId, 32 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleClients
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType)
				SELECT clientId, 32 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleClients INNER JOIN #userClients CL ON UnreachbleClients.clientId = CL.t_clientId
			END
		END
	END
	ELSE -- Calculating anomalous count for Media Agents
	BEGIN
		IF @isAdmin = 1
		BEGIN
			INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
			SELECT MACount.componentNameId, CAST(MAThreshold.attrVal AS FLOAT), CAST(MACount.attrVal AS FLOAT), 1
			FROM APP_ClientProp MAThreshold
			INNER JOIN APP_ClientProp MACount
				ON MAThreshold.componentNameId = MACount.componentNameId
					AND MAThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
					AND MAThreshold.modified = 0
					AND MACount.attrName = N'Media Agent Failed Job Count For Today'
					AND MACount.modified = 0
					AND MACount.created > @fromTime
					AND MACount.created > MAThreshold.created
					AND CAST(MAThreshold.attrVal AS FLOAT) > 10
				WHERE CAST(MAThreshold.attrVal AS FLOAT) < CAST(MACount.attrVal AS FLOAT)
		END
		ELSE
		BEGIN
			INSERT INTO #anomalousClients(clientId, threshold, currentCount, anomalyType)
			SELECT MACount.componentNameId, CAST(MAThreshold.attrVal AS FLOAT), CAST(MACount.attrVal AS FLOAT), 1
			FROM APP_ClientProp MAThreshold
			INNER JOIN APP_ClientProp MACount
				ON MAThreshold.componentNameId = MACount.componentNameId
					AND MAThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
					AND MAThreshold.modified = 0
					AND MACount.attrName = N'Media Agent Failed Job Count For Today'
					AND MACount.modified = 0
					AND MACount.created > @fromTime
					AND MACount.created > MAThreshold.created
					AND CAST(MAThreshold.attrVal AS FLOAT) > 10
			INNER JOIN #userClients CL ON CL.t_clientId = MAThreshold.componentNameId AND CL.t_clientId = MACount.componentNameId
			WHERE CAST(MAThreshold.attrVal AS FLOAT) < CAST(MACount.attrVal AS FLOAT)
		END
		IF @anomalyTypeFlag = 0 OR @anomalyTypeFlag & 32 = 32 -- Based on unreachability
		BEGIN
			IF @isAdmin = 1
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType, infrastructureType)
				SELECT MM.clientId, 32, 1 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
				SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
			)UnreachbleMediaAgents INNER JOIN MMHost MM ON UnreachbleMediaAgents.clientId = MM.clientId
				UNION ALL
				SELECT SIM.clientId, 32, 2 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
				SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
			)UnreachbleWebServers INNER JOIN simInstalledPackages SIM ON UnreachbleWebServers.clientId = SIM.clientId AND SIM.simPackageID = 252
			END
			ELSE
			BEGIN
				INSERT INTO #anomalousClients(clientId, anomalyType, infrastructureType)
				SELECT MM.ClientId, 32, 1 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
			SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
			)UnreachbleMediaAgents INNER JOIN MMHost MM ON UnreachbleMediaAgents.clientId = MM.clientId
				INNER JOIN #userClients CL ON CL.t_clientId = MM.ClientId
				UNION ALL
				SELECT SIM.clientId, 32, 2 FROM
				(
					SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
					UNION
					SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
				)UnreachbleWebServers INNER JOIN simInstalledPackages SIM ON UnreachbleWebServers.clientId = SIM.clientId AND SIM.simPackageID = 252
				INNER JOIN #userClients CL ON CL.t_clientId = SIM.ClientId
			END
		END
	END
	-- Populating XML result
	SET @xml = ISNULL((SELECT
		[@infrastructureType] = ACL.infrastructureType,
		[entity/@clientTid] = ACL.clientId,
		[entity/@clientName] = CL.name,
		[entity/@_type_] = 3,
			(SELECT
				[@type] = FLAG.anomalyType,
				[@threshold] = FORMAT(FLAG.threshold,'N2'),
				[@forecasted] = FORMAT(FLAG.forecasted,'N2'),
				[@currentCount] = FORMAT(FLAG.currentCount,'N2')
			FROM #anomalousClients FLAG WHERE FLAG.clientId = ACL.clientId
			FOR XML PATH ('anomalyDetails'), TYPE)
		FROM #anomalousClients ACL
		INNER JOIN APP_Client CL ON ACL.clientId = CL.id
		GROUP BY ACL.clientId,CL.name, ACL.infrastructureType
		FOR XML PATH('anomalousClients'),
		ROOT('App_GetAnomalousEntityListResp')), N'<App_GetAnomalousEntityListResp/>')
	SELECT @xml
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL
		DROP TABLE dbo.#userClients
	IF OBJECT_ID('tempdb.dbo.#anomalousClients') IS NOT NULL
		DROP TABLE dbo.#anomalousClients
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGeAnomalousEntityList')
	delete from GxQscripts where name = 'AppGeAnomalousEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGeAnomalousEntityList')
	delete from GXDBVersions where aliasname = 'AppGeAnomalousEntityList'
GO

insert into GXDBVersions values(2, 'AppGeAnomalousEntityList',  '00000000000000000000', 'AppGeAnomalousEntityList', '00000000000000000000')
GO

