

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGSuiteAllUsersAssocGetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2020  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -----------------------------------------------------------------------
--  +====================================================================+
--  |   AppGSuiteAllUsersAssocGetInfo									 |
--  |   Procedure to get all associated users of a gsuite client         |
--  +====================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGSuiteAllUsersAssocGetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGSuiteAllUsersAssocGetInfo <<<'
	drop procedure AppGSuiteAllUsersAssocGetInfo
END
IF EXISTS (select * from GxQscripts where name='AppGSuiteAllUsersAssocGetInfo')
	delete from GxQscripts where name = 'AppGSuiteAllUsersAssocGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGSuiteAllUsersAssocGetInfo')
	delete from GXDBVersions where aliasname = 'AppGSuiteAllUsersAssocGetInfo'
GO
print '... Creating Procedure: AppGSuiteAllUsersAssocGetInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGSuiteAllUsersAssocGetInfo
  @inOutXML XML OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(512) = ''
	DECLARE @userId INT = 0
	DECLARE @clientId INT = 0
	DECLARE @pageNumber INT = 0
	DECLARE @pageSize INT = 0
	DECLARE @search INT = 0
	DECLARE @searchKey NVARCHAR(MAX) = ''
	DECLARE @sortColumn INT = 0
	DECLARE @sortOrder INT = 0
	DECLARE @filterColumn INT = 0
	DECLARE @autoDiscovered NVARCHAR(8) = '%::1%'
	DECLARE @O365Field_DISPLAYNAME INT = 1
	DECLARE @O365Field_AUTO_DISCOVER  INT = 9
	DECLARE @O365Field_SMTP_ADDRESS INT = 12
	DECLARE @O365Field_SUBCLIENT_NAME INT = 18
	SELECT
		@userId = ISNULL(ref.value('processinginstructioninfo[1]/user[1]/@userId','INT'), 0),
		@clientId = ISNULL(ref.value('subclientEntity[1]/@clientId','INT'), 0),
		@pageNumber = ISNULL(ref.value('pagingInfo[1]/@pageNumber', 'INT'), 0),
		@pageSize = ISNULL(ref.value('pagingInfo[1]/@pageSize', 'INT'), 0),
		@search = ISNULL(ref.value('searchInfo[1]/@isSearch', 'INT'), 0),
		@searchKey = ISNULL(ref.value('searchInfo[1]/@searchKey','NVARCHAR(MAX)'), ''),
		@sortColumn = ISNULL(ref.value('sortInfo[1]/@sortColumn', 'INT'), 0),
		@sortOrder = ISNULL(ref.value('sortInfo[1]/@sortOrder', 'INT'), 0)
	FROM @inOutXML.nodes ('Ida_GetGSuiteAllUsersReq') R(ref)
	/*Prepare Filter list table*/
    DECLARE @filtertbl TABLE (filter xml)
    DECLARE @filterlisttbl TABLE (fCol nvarchar(max), fStr nvarchar(max), rangeMin BIGINT, rangeMax BIGINT)
    INSERT INTO @filtertbl SELECT R.ref.query('.') AS filter
    FROM @inOutXML.nodes ('Ida_GetGSuiteAllUsersReq/filterInfoList') R(ref)
    INSERT INTO @filterlisttbl SELECT DISTINCT
        filter.value ('filterInfoList[1]/@filterColumn', 'INT') AS fCol ,
        filter.value('filterInfoList[1]/@filterString', 'nvarchar(max)') AS fStr,
        filter.value ('filterInfoList[1]/@filterRangeMin', 'BIGINT') AS rangeMin ,
        filter.value('filterInfoList[1]/@filterRangeMax', 'BIGINT') AS rangeMax
    FROM @filtertbl
	IF EXISTS (SELECT TOP 1 1 FROM @filterlisttbl) SET @filterColumn = 1
	IF @userId = 0
		BEGIN
			SELECT @errorCode = 1, @errorString = 'Error: Invalid user id [0]'
			GOTO ERROR_EXIT
		END
	IF @clientId = 0
		BEGIN
			SELECT @errorCode = 1, @errorString = 'Error: Invalid client id [0]'
			GOTO ERROR_EXIT
		END
	IF @search = 1 AND @searchKey = ''
		BEGIN
			SELECT @errorCode = 1, @errorString = 'Error: Invalid search string ['']'
			GOTO ERROR_EXIT
		END
	/*Set defaults*/
	IF @pageNumber < 0 SET @pageNumber = 0
	IF @pageSize < 0 SET @pageSize = 0
	/*Security*/
    IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @userId, 7, 0 , 0,'#getIdaObjects', 0,'2, 20, 22, 13, 141, 25, 12, 253, 1, 16, 107'
	BEGIN TRY
		SET @inOutXML =
		(
			SELECT
				(
					SELECT U.smtpAddress AS '@smtpAddress',
					(CASE WHEN U.displayName LIKE @autoDiscovered THEN LEFT(U.displayName, LEN(U.displayName) - 3) ELSE U.displayName END) AS '@displayName',
					(CASE WHEN U.displayName LIKE @autoDiscovered THEN 1 ELSE 0 END) AS '@isAutoDiscoveredUser'
					FOR XML PATH ('userAccountInfo'), TYPE
				),
				(
					SELECT U.subclientId AS '@subclientId', U.subclientName AS '@subclientName'
					FOR XML PATH ('subclientEntity'), TYPE
				),
				(SELECT U.totalRows AS '@totalRecords' FOR XML PATH ('pagingInfo'), TYPE)
			FROM
			(
				SELECT *, ROW_NUMBER() OVER (ORDER BY CASE WHEN @SortColumn = @O365Field_DISPLAYNAME AND @SortOrder = 1 THEN displayName END DESC,
													CASE WHEN @SortColumn = @O365Field_DISPLAYNAME AND @SortOrder = 0 THEN displayName END ,
													CASE WHEN @SortColumn = @O365Field_SMTP_ADDRESS AND @SortOrder = 1 THEN smtpAddress END DESC,
													CASE WHEN @SortColumn = @O365Field_SMTP_ADDRESS AND @SortOrder = 0 THEN smtpAddress END ,
													CASE WHEN @SortColumn = @O365Field_SUBCLIENT_NAME AND @SortOrder = 1 THEN subclientName END DESC,
													CASE WHEN @SortColumn = @O365Field_SUBCLIENT_NAME AND @SortOrder = 0  THEN subclientName END ) AS rowNumber
				FROM
				(
					SELECT SP.attrName AS smtpAddress, SP.attrVal AS displayName, SP.componentNameId AS subclientId, AA.subclientName AS subclientName, COUNT(SP.attrName) OVER (PARTITION BY 1) AS totalRows
					FROM APP_SubClientProp(NOLOCK) SP
					INNER JOIN #getIdaObjects I ON SP.componentNameId = I.subclientID
					INNER JOIN APP_Application(NOLOCK) AA ON AA.id = I.subclientID AND AA.clientId = @clientId
WHERE SP.attrType = 134 AND SP.modified = 0 AND AA.appTypeId = 134
					AND AA.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND AA.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND AA.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
					AND ((@search = 0) OR (SP.attrName LIKE (CASE WHEN LEN(@searchKey) > 0 THEN @searchKey ELSE '%%' END)))
					AND ((@filterColumn = 0 )
                    OR ((SP.attrVal LIKE ISNULL((select fStr from @filterlisttbl WHERE fCol = @O365Field_DISPLAYNAME),  '%%' ))
                    AND (SP.attrVal LIKE ISNULL((select fStr from @filterlisttbl WHERE fCol = @O365Field_AUTO_DISCOVER),  '%%' ))
                    AND (SP.attrName LIKE ISNULL((select fStr from @filterlisttbl WHERE fCol = @O365Field_SMTP_ADDRESS) , '%%' ))
                    AND ((SP.componentNameId IN ( select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCol = @O365Field_SUBCLIENT_NAME))  OR  (@O365Field_SUBCLIENT_NAME NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) ))
                    ))
				) P
			) U
			WHERE (@pageSize = 0) OR   ((rowNumber > (@pageNumber * @pageSize))  AND  (rowNumber <= ((@pageNumber * @pageSize)+ @pageSize)))
			ORDER BY rowNumber
			FOR XML PATH ('userAssoc'),
			ROOT('Ida_GetGSuiteAllUsersResp')
		)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
	ERROR_EXIT:
        IF @errorCode <> 0
            SET @inOutXML = (SELECT ISNULL(@errorCode, 0) AS '@errorCode', ISNULL(@errorString, '')
                                        AS '@errorMessage' FOR XML PATH('Ida_GetGSuiteAllUsersResp'))
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGSuiteAllUsersAssocGetInfo')
	delete from GxQscripts where name = 'AppGSuiteAllUsersAssocGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGSuiteAllUsersAssocGetInfo')
	delete from GXDBVersions where aliasname = 'AppGSuiteAllUsersAssocGetInfo'
GO

insert into GXDBVersions values(2, 'AppGSuiteAllUsersAssocGetInfo',  '00000000000000000000', 'AppGSuiteAllUsersAssocGetInfo', '00000000000000000000')
GO

