

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppForceNextBackpAsFullOrDiff.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  AppForceNextBackpAsFullOrDiff.sp                           */
/*                                                                            */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppForceNextBackpAsFullOrDiff.sp,v $ $Id: AppForceNextBackpAsFullOrDiff.sp,v 1.2.2.4 2019/03/20 18:57:05 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppForceNextBackpAsFullOrDiff')
BEGIN
	print '>>> Drop Stored Procedure: AppForceNextBackpAsFullOrDiff <<<'
	drop procedure AppForceNextBackpAsFullOrDiff
END
IF EXISTS (select * from GxQscripts where name='AppForceNextBackpAsFullOrDiff')
	delete from GxQscripts where name = 'AppForceNextBackpAsFullOrDiff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppForceNextBackpAsFullOrDiff')
	delete from GXDBVersions where aliasname = 'AppForceNextBackpAsFullOrDiff'
GO
print '... Creating Procedure: AppForceNextBackpAsFullOrDiff'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppForceNextBackpAsFullOrDiff
  @i_fullOrDiff int,
  @i_appIdListXml XML,
  @i_forceReason varchar(32)
AS
  DECLARE @o_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @l_retVal INT = 0
	DECLARE @l_currentTime INT = dbo.getUnixTime(GETUTCDATE())
	/*
	Input XML List format
		<AppIdList>
		  <row appId="7" />
		  <row appId="8" />
		</AppIdList>
	*/
	DECLARE @tblAppIdList table(appId int)
	INSERT @tblAppIdList
	SELECT r.value('@appId','int')
	FROM @i_appIdListXml.nodes('AppIdList/row') AS x(r)
	SET @l_retVal = @@ERROR
	IF @l_retVal <> 0 GOTO EXIT_HERE
	IF NOT EXISTS(SELECT 1 FROM @tblAppIdList)
	BEGIN
		SET @l_retVal = -1
		GOTO EXIT_HERE
	END
	IF(@i_fullOrDiff NOT IN(1, 2))
	BEGIN
		SET @l_retVal = -2
		GOTO EXIT_HERE
	END
	--Do not do this for turbosubclients
	DELETE @tblAppIdList
	FROM @tblAppIdList A INNER JOIN App_SubclientProp B WITH(NOLOCK)
	ON A.appId = B.componentNameId AND B.attrName = 'Is Turbo Subclient' AND B.attrVal = '1' AND B.modified = 0
	SET @l_retVal = @@ERROR
	IF @l_retVal <> 0 GOTO EXIT_HERE
	--Do not do this for edge drive subclients
	DELETE @tblAppIdList
	FROM @tblAppIdList A INNER JOIN App_Application B WITH(NOLOCK)
	ON A.appId = B.id
WHERE B.subclientStatus & 0x20000 > 0 OR
(B.appTypeId IN(59, 77)
AND B.subclientStatus & 0x0080 > 0)
	SET @l_retVal = @@ERROR
	IF @l_retVal <> 0 GOTO EXIT_HERE
	IF(@i_fullOrDiff = 1) --Force next job to full
	BEGIN
		DELETE  APP_SubClientProp
		FROM    APP_SubClientProp PROP WITH(NOLOCK), @tblAppIdList APP
		WHERE   PROP.ComponentNameId = APP.appId
		AND     PROP.attrName = N'sys:last full'
		AND     modified    = 0
		AND     attrVal   <> '0'
		AND     attrVal   <> ''
		SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
		UPDATE	APP_SubClientProp
		SET 	modified = @l_currentTime
		FROM 	APP_SubClientProp PROP, @tblAppIdList APP
		WHERE	PROP.ComponentNameId = APP.appId
		AND		PROP.attrName = N'Reason last backup time cleared'
		AND		PROP.modified = 0
		SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
		INSERT INTO APP_SubClientProp
		SELECT 	APP.appId, 'Reason last backup time cleared', 7, @i_forceReason, @l_currentTime, 0, 0
		FROM 	@tblAppIdList APP
		SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
		DECLARE @tblSnapFSAppIdList table (appId int)
		INSERT INTO @tblSnapFSAppIdList
		SELECT List.appId FROM
		@tblAppIdList List INNER JOIN
		APP_Application A WITH (NOLOCK) ON List.appId = A.id AND A.appTypeId IN(SELECT appTypeId from dbo.GetDeferredCatalogSupportedAppTypes())
        INNER JOIN App_SubClientProp prop WITH (NOLOCK) ON A.id = prop.componentNameId AND prop.attrNAme = 'Enable Snap Backups'
        WHERE prop.modified = 0 AND prop.attrVal = '1'
		SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		SELECT A.appId, 'Convert Next Job To Full', 8, @i_forceReason, @l_currentTime, 0,0
		FROM @tblSnapFSAppIdList A LEFT OUTER JOIN APP_SubClientProp PROP ON A.appId = PROP.componentNameId
		AND PROP.attrName = 'Convert Next Job To Full' AND PROP.modified = 0 AND PROP.attrVal != '0'
		WHERE PROP.id IS NULL
       	SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
	END
	ELSE IF(@i_fullOrDiff = 2) --Force to diff
	BEGIN
		UPDATE	APP_SubClientProp
		SET 	modified = @l_currentTime
		FROM 	APP_SubClientProp PROP, @tblAppIdList APP
		WHERE	PROP.ComponentNameId = APP.appId
		AND		PROP.attrName = N'force differential backup'
		AND		PROP.modified = 0
		SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
		INSERT INTO APP_SubClientProp
		SELECT 	APP.appId, 'force differential backup', 2, '1', @l_currentTime, 0, 0
		FROM 	@tblAppIdList APP
		SET @l_retVal = @@ERROR
		IF @l_retVal <> 0 GOTO EXIT_HERE
	END
EXIT_HERE:
	SELECT @l_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'AppForceNextBackpAsFullOrDiff')
	delete from GxQscripts where name = 'AppForceNextBackpAsFullOrDiff'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppForceNextBackpAsFullOrDiff')
	delete from GXDBVersions where aliasname = 'AppForceNextBackpAsFullOrDiff'
GO

insert into GXDBVersions values(2, 'AppForceNextBackpAsFullOrDiff',  '00010002000200040000', 'AppForceNextBackpAsFullOrDiff', '00010002000200040000')
GO

