

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppFindSiblingBackupSets.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppFindSiblingBackupSets.sp,v $ $Id: AppFindSiblingBackupSets.sp,v 1.1.4.3 2018/03/27 09:11:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppFindSiblingBackupSets <<<'

IF EXISTS (select * from sysobjects where name='AppFindSiblingBackupSets')
	drop procedure AppFindSiblingBackupSets
IF EXISTS (select * from GxQscripts where name='AppFindSiblingBackupSets')
	delete from GxQscripts where name = 'AppFindSiblingBackupSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppFindSiblingBackupSets')
	delete from GXDBVersions where aliasname = 'AppFindSiblingBackupSets'
GO
print '... Creating Procedure: AppFindSiblingBackupSets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppFindSiblingBackupSets
-- Input arguments
  @backupSetId integer,
  @backupSetName nvarchar(128)
AS
  DECLARE @siblingBackupSetId integer
  DECLARE @siblingBackupSetName nvarchar(128)
	SET NOCOUNT ON
	SELECT DISTINCT
		b.id,
		b.name
	FROM
		APP_BackupSetName b WITH(NOLOCK)
		INNER JOIN 	APP_Application a WITH(NOLOCK) ON
			a.backupset = b.id
		LEFT OUTER JOIN APP_Application ea WITH(NOLOCK) ON
			ea.backupset = @backupSetId
			AND ea.clientId = a.clientId
			AND ea.instance = a.instance
			AND ea.appTypeId = a.appTypeId
	WHERE
		b.id <> @backupSetId
		AND b.name = @backupSetName
		AND ea.id IS NOT NULL	-- sibling exist
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppFindSiblingBackupSets')
	delete from GxQscripts where name = 'AppFindSiblingBackupSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppFindSiblingBackupSets')
	delete from GXDBVersions where aliasname = 'AppFindSiblingBackupSets'
GO

insert into GXDBVersions values(2, 'AppFindSiblingBackupSets',  '00010001000400030000', 'AppFindSiblingBackupSets', '00010001000400030000')
GO

