

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppFieldsForMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intENDed publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: AppFieldsForMonitoringPolicy()
--  |
--  |   Revisions  	Author 		    Description
--  |   ---------  	----------    	----------------------------------------
--  |   1.5			Saurabh Yadav	AppFieldsForMonitoringPolicy to fetch display name for solr fields and type of fields
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppFieldsForMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='AppFieldsForMonitoringPolicy')
	drop procedure AppFieldsForMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='AppFieldsForMonitoringPolicy')
	delete from GxQscripts where name = 'AppFieldsForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppFieldsForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'AppFieldsForMonitoringPolicy'
GO
print '... Creating Procedure: AppFieldsForMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppFieldsForMonitoringPolicy
  @i_xml XML,
  @o_xml XML	OUTPUT
AS
SET NOCOUNT ON
-- Priority to fetch template fields: Monitoring PolicyId >> Template Id >> TemplateEntity templateId >> templateEntity templateName
DECLARE @monitoringPolicyIds TABLE(id INT)
DECLARE @monitoringTemplateInfo TABLE( monPolId INT, templateId INT)
DECLARE @templateInfo TABLE( templateId INT, templateXML XML, templateType INT )
DECLARE @templateColumnFields TABLE (templateId INT, solrFieldName NVARCHAR(1024), solrFieldNameWithoutFieldTypeIdentifier NVARCHAR(1024), displayName NVARCHAR(1024),
										descriptionOfField NVARCHAR(1024),	type INT, datatype INT, formatType INT, templateType INT)
DECLARE @templateColumnFieldsSecondary TABLE (templateId INT, solrFieldName NVARCHAR(1024), solrFieldNameWithoutFieldTypeIdentifier NVARCHAR(1024), displayName NVARCHAR(1024),
													descriptionOfField NVARCHAR(1024), type INT, datatype INT, formatType int, templateType INT )
DECLARE @templateInputFields INT = 0
INSERT @monitoringPolicyIds
SELECT N.policyId.value('@val','varchar(20)') as id
FROM @i_xml.nodes('LogMonitoring_GetDisplayNameForFieldNamesReq/monitoringPolicyId')  as N(policyId)
INSERT @monitoringTemplateInfo
SELECT monPol.id, AT.templateId
FROM APP_MonitorTemplateAssoc AA WITH (NOLOCK),
	@monitoringPolicyIds monPol,
	APP_Template AT WITH (NOLOCK)
WHERE AA.monitorPolicyId = monPol.id
	AND AA.templateId = AT.templateId
	AND AT.status = 4    --Choose Discover type template id first.
INSERT @monitoringTemplateInfo
SELECT monPol.id, AA.templateId
FROM APP_MonitorTemplateAssoc AA WITH (NOLOCK),
	@monitoringPolicyIds monPol
WHERE AA.monitorPolicyId = monPol.id
--	AND monPol.id NOT IN ( SELECT monPolId FROM @monitoringTemplateInfo)
INSERT @templateInfo
SELECT DISTINCT templateId, NULL, NULL
FROM @monitoringTemplateInfo
IF NOT EXISTS ( SELECT 1 FROM @templateInfo)
BEGIN
	INSERT @templateInfo
	SELECT DISTINCT N.template.value('@val','varchar(20)') as id, NULL , NULL
	FROM @i_xml.nodes('LogMonitoring_GetDisplayNameForFieldNamesReq/templateId')  as N(template)
	SET @templateInputFields = 1
END
IF NOT EXISTS ( SELECT 1 FROM @templateInfo)
BEGIN
 INSERT @templateInfo
	SELECT N.temp.value('@templateId','varchar(20)') as id, NULL, NULL
	FROM @i_xml.nodes('LogMonitoring_GetDisplayNameForFieldNamesReq/templateInfo')   as N(temp)
	WHERE N.temp.value('@templateId','varchar(20)') IS NOT NULL
	SET @templateInputFields = 1
END
IF NOT EXISTS ( SELECT 1 FROM @templateInfo)
BEGIN
	DECLARE @templates TABLE(templateName VARCHAR(MAX) )
	INSERT @templates
	SELECT N.temp.value('@templateName','nvarchar(max)') as name
	FROM @i_xml.nodes('LogMonitoring_GetDisplayNameForFieldNamesReq/templateInfo')   as N(temp)
	INSERT @templateInfo
	SELECT templateId, NULL, NULL
	FROM @templates A
		INNER JOIN APP_Template B WITH (NOLOCK)
			ON A.templateName = B.templateName
	SET @templateInputFields = 1
END
UPDATE T
SET T.templateXML = CONVERT(XML,CONVERT(varchar(MAX),AT.templateXML)) , T.templateType = AT.status
FROM @templateInfo  T, APP_Template AT WITH (NOLOCK)
WHERE T.templateId = AT.templateId
DECLARE @errorCode INT = 0
-- default field names for display.
INSERT @templateColumnFields
VALUES(0,'ClientName','ClientName','Client','',7,1,0,0),
--(0,'FileName','FileName','File','',7,1,0,0),
(0,'eventTime','eventTime','Event Time','',7,14,2,0),
(0,'timestamp','timestamp','Indexed Time','',7,14,2,0)
IF EXISTS ( SELECT 1
             FROM @monitoringPolicyIds A, APP_MonitoringPolicyProp AP WITH (NOLOCK)
             WHERE A.id = AP.monitorPolicyId
             AND AP.attrName = 'Monitoring Type'
             AND AP.attrVal = '7' ) OR @templateInputFields = 1
BEGIN
	INSERT @templateColumnFields
	VALUES
	(0,'commserver_sf','commserver_sf','Commcell','',7,1,0,0)
END
UPDATE @templateColumnFields
SET type = type + 8
INSERT @templateColumnFields
SELECT  templateId, (CASE WHEN templateType = 4  AND LEN(N.tableInfoList.value('(dataExtractionOption/@regexPattern)[1]', 'NVARCHAR(1024)')) > 0
						THEN
							LOWER(N.tableInfoList.value('@solrFieldName', 'NVARCHAR(1024)')) + LOWER(N.tableInfoList.value('@index', 'NVARCHAR(1024)'))
						ELSE
							LOWER(N.tableInfoList.value('@solrFieldName', 'NVARCHAR(1024)'))
						END) as solrFieldName ,
					(CASE WHEN templateType = 4  AND LEN(N.tableInfoList.value('(dataExtractionOption/@regexPattern)[1]', 'NVARCHAR(1024)')) > 0
						THEN
							LOWER(N.tableInfoList.value('@solrFieldName', 'NVARCHAR(1024)')) + LOWER(N.tableInfoList.value('@index', 'NVARCHAR(1024)'))
						ELSE
							LOWER(N.tableInfoList.value('@solrFieldName', 'NVARCHAR(1024)'))
						END) as solrFieldNameWithoutFieldTypeIdentifier,
    ISNULL(N.tableInfoList.value('@aliasName', 'NVARCHAR(1024)'), N.tableInfoList.value(('(column/@columnName)[1]'), 'NVARCHAR(1024)')) as displayName,
    '',
    N.tableInfoList.value('@isFacet', 'INT')*1
		+ N.tableInfoList.value('@isIndexed', 'INT')*2+4
		+ ISNULL(N.tableInfoList.value('@showAsColumn', 'INT'),1) * 8
		+ ISNULL(N.tableInfoList.value('@isMultiValued', 'INT'),0) * 16
		+ ISNULL(N.tableInfoList.value('@isTokenized', 'INT'),0) * 32
		+ ISNULL(N.tableInfoList.value('@convertInUTC', 'INT'),0) * 64,
    N.tableInfoList.value(('@primaryDataType'),'INT') as datatype,
    N.tableInfoList.value(('@primaryTypeFormat'),'INT') as formatType,
	templateType
FROM @templateInfo
CROSS APPLY  templateXML.nodes('LogMonitoring_TemplateXML/columns')as N(tableInfoList)
WHERE ISNULL(N.tableInfoList.value('@isStored','INT'),1)<>0
DELETE @templateColumnFields
WHERE solrFieldName IS NULL
-- we maintain two SETs ok keys for facet type columns. one for display another is for search.
-- display one is of type string and search is of type lowerCASE
--first take out keys which are of string type and are faceted. and add field of type lower non faceted.
INSERT @templateColumnFieldsSecondary
SELECT	templateId,
		(CASE
			WHEN type&16 = 16
			THEN solrFieldName+'_ls'
			ELSE solrFieldName+'_lf'
		END),
		solrFieldNameWithoutFieldTypeIdentifier,
		displayName,
		descriptionOfField,
		type - 1,
		datatype,
		formatType,
		templateType
FROM @templateColumnFields
WHERE datatype IN (1)
	AND  ((type & 1) <> 0)
	AND templateId >0
	AND (solrFieldName NOT IN ('threadid','jobid')
	AND templateId <> 1) --special CASE for simpana
-- for non faceted string type fields we have lower CASE indexed.
UPDATE @templateColumnFields
SET solrFieldName = solrFieldName+ '_'	+	(CASE
												WHEN datatype=0
												THEN	(CASE
															WHEN formatType = 1 OR formatType = 2
															THEN 's' --hex or binary
															WHEN formatType = 26
															THEN 'd' -- float
															ELSE 'i'
														END)
												WHEN datatype=1
												THEN 'l'
												WHEN datatype=2
												THEN (	CASE WHEN templateType = 4
														THEN CASE WHEN type & 64 <> 0
															THEN 'u_t'
															ELSE 't'
															END
                                                         ELSE 's'
                                                    END )
												WHEN datatype = 3
												THEN (	CASE WHEN templateType = 4
														 THEN
																CASE WHEN type &64 <> 0
																THEN  'u_t_i'
																ELSE 't_i'
																END
														 ELSE 's'
                                                    END )
											END)
										+	(CASE
												WHEN type&16 = 16
												THEN 's'
												WHEN type&1 = 1
												THEN 'f'
												WHEN type&2 = 2
												THEN	(CASE
															WHEN type&32 = 32
															THEN 't'
															ELSE 'f'
														END)
												ELSE 'n'
											END)
WHERE ((type & 1) = 0)
	AND templateId > 0
-- faceted of type string.
UPDATE @templateColumnFields
SET solrFieldName = solrFieldName+ '_'	+	(CASE
											WHEN datatype=0
											THEN	(CASE
														WHEN formatType = 1 OR formatType = 2
														THEN 's' --hex or binary
														WHEN formatType = 26
														THEN 'd' -- float
														ELSE 'i'
													END)
											WHEN datatype=1
											THEN 's'
											WHEN datatype=2
												THEN (	CASE WHEN templateType = 4
														THEN CASE WHEN type & 64 <> 0
															THEN 'u_t'
															ELSE 't'
															END
                                                         ELSE 's'
                                                    END )
												WHEN datatype = 3
												THEN (	CASE WHEN templateType = 4
														 THEN
																CASE WHEN type &64 <> 0
																THEN  'u_t_i'
																ELSE 't_i'
																END
														 ELSE 's'
                                                    END )
											END)
										+	(CASE
												WHEN type&16 = 16
												THEN 's'
												WHEN type&1 = 1
												THEN 'f'
												WHEN type&2 = 2
												THEN 'f'
												ELSE 'n'
											END)
WHERE ((type & 1) <> 0)
	AND templateId >0
DELETE P
FROM @templateColumnFieldsSecondary S , @templateColumnFields P
WHERE P.displayName = S.displayName
    AND P.datatype = 1
    AND S.datatype = 1
    AND P.templateId = S.templateId
    AND P.templateId <> 1
--add lower CASE keys
INSERT @templateColumnFields
SELECT templateId, solrFieldName, solrFieldNameWithoutFieldTypeIdentifier, displayName, descriptionOfField, type, datatype, formatType, templateType
FROM @templateColumnFieldsSecondary
--special CASE
UPDATE @templateColumnFields
SET solrFieldName = 'jobid_if'
WHERE solrFieldName = 'jobid_sf'
	AND (templateId = 1 OR templateId IN (SELECT templateId
										  FROM APP_Template WITH(NOLOCK)
										  WHERE templateForMonitoringType = 5))
UPDATE @templateColumnFields
SET solrFieldName = 'threadid_sf'
WHERE solrFieldName = 'threadid_if'
          AND templateId = 1
UPDATE T
SET solrFieldName = 'date_sf'
FROM @templateColumnFields T, APP_Template AT WITH (NOLOCK)
WHERE T.templateId = AT.templateId AND AT.status <> 4 AND  solrFieldName = 'date_tf'
UPDATE T
SET solrFieldName = 'time_sf'
FROM @templateColumnFields T, APP_Template AT WITH (NOLOCK)
WHERE T.templateId = AT.templateId AND AT.status <> 4 AND solrFieldName = 'time_tf'
UPDATE @templateColumnFields
SET datatype = CASE
				WHEN solrFieldName LIKE '%_sf'
				THEN  0
				WHEN solrFieldName LIKE '%_sn'
				THEN  1
				WHEN solrFieldName LIKE '%_xf'
				THEN  2
				WHEN solrFieldName LIKE '%_xn'
				THEN  3
				WHEN solrFieldName LIKE '%_if'
				THEN  4
				WHEN solrFieldName LIKE '%_in'
				THEN  5
				WHEN solrFieldName LIKE '%_df'
				THEN  6
				WHEN solrFieldName LIKE '%_dn'
				THEN  7
				WHEN solrFieldName LIKE '%_DEC_OF_HEX'
				THEN  8
				WHEN solrFieldName LIKE '%_DEC_OF_BIN'
				THEN  9
				WHEN solrFieldName LIKE '%_FLOAT_OF_HEX'
				THEN  10
				WHEN solrFieldName LIKE '%_FLOAT_OF_BIN'
				THEN  11
				WHEN solrFieldName LIKE '%_lf'
				THEN  12
				WHEN solrFieldName LIKE '%_ln'
				THEN  13
				WHEN solrFieldName LIKE '%_tf'
				THEN  14
				WHEN solrFieldName LIKE '%_tn'
				THEN  15
				ELSE
				datatype
				END
SET @o_xml = (SELECT 0 AS "@errorcode",
					'' AS "@errorMessage",
					( SELECT templateId AS "@templateId",
						solrFieldName AS "@solrFieldName",
						solrFieldNameWithoutFieldTypeIdentifier AS "@solrFieldNameWithoutFieldTypeIdentifier",
						displayName AS "@displayName",
						descriptionOfField AS "@descriptioOfField",
						type AS "@type",
						dataType AS "@dataType"
						FROM @templateColumnFields
						ORDER BY templateId
						FOR XML PATH('displayNames'), TYPE
					)
					FOR XML PATH('LogMonitoring_GetDisplayNameForFieldNamesResp'))
GO
GO

IF EXISTS (select * from GxQscripts where name = 'AppFieldsForMonitoringPolicy')
	delete from GxQscripts where name = 'AppFieldsForMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppFieldsForMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'AppFieldsForMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'AppFieldsForMonitoringPolicy',  '00000000000000000000', 'AppFieldsForMonitoringPolicy', '00000000000000000000')
GO

