

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppExchangeCloudAppUserGetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================================================================================+
--	|  												AppExchangeCloudAppUserGetInfo																							|
--	| Procedure for Get details of Email/User of Exchagne or CloudApp from  APP_CloudAppConfigPolicyAssoc/ APP_EmailConfigPolicyAssoc table	|
--	+=======================================================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppExchangeCloudAppUserGetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppExchangeCloudAppUserGetInfo <<<'
	drop procedure AppExchangeCloudAppUserGetInfo
END
IF EXISTS (select * from GxQscripts where name='AppExchangeCloudAppUserGetInfo')
	delete from GxQscripts where name = 'AppExchangeCloudAppUserGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppExchangeCloudAppUserGetInfo')
	delete from GXDBVersions where aliasname = 'AppExchangeCloudAppUserGetInfo'
GO
print '... Creating Procedure: AppExchangeCloudAppUserGetInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppExchangeCloudAppUserGetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @o_xmlString			XML
	DECLARE	@errorCode				INT = 0
	DECLARE @errorString			NVARCHAR(MAX) = ''
	DECLARE @nowTime				INT = datediff(second,'01/01/1970',GETDATE())
	DECLARE @subClientId			INT = 0
	DECLARE @discoverByType			INT = 0
	DECLARE @ClientId				INT = 0
	DECLARE @appType				INT = 0
	DECLARE @instanceId				INT = 0
	DECLARE @backupSetId			INT = 0
	DECLARE @UserGUID				NVARCHAR(40) = ''
	DECLARE @DISCOVERTYPE_CLOUDAPP_USER		INT = 1
	DECLARE @DISCOVERTYPE_EXCHANGE_EMAIL	INT = 1
		SELECT	@subClientId = ISNULL(ref.value('subclientEntity[1]/@subclientId', 'INT'),0),
				@UserGUID = ISNULL(ref.value('user[1]/@userGUID','NVARCHAR(40)'),'')
		FROM @i_xmlString.nodes ('Ida_GetExchangeCloudAppUserRequest') R(ref)
	SET @appType = ISNULL((SELECT TOP 1 appTypeId FROM APP_Application (NOLOCK) WHERE id = @subClientId),0)
IF @subClientId<=0 OR @UserGUID = '' OR @appType NOT IN (134,137,78)
	BEGIN
		SET @errorCode = 101
		IF @subClientId <=0
			SET @errorString = 'Error : Invalid Subclient Id passed'
		ELSE IF @UserGUID = ''
			SET @errorString = 'Error : Invalid/Empty GUID passed'
		ELSE
			SET @errorString = 'Error : Invalid AppType passed'
		GOTO ERROR_EXIT
	END
IF @appType = 134 OR @appType = 78
	BEGIN
		SET @o_xmlString =
			(
				SELECT CA.discoverByType '@discoverByType',CA.status '@accountStatus',
				(
					SELECT CA.displayName '@displayName', CA.aliasName '@aliasName' , CA.smtpAddress '@smtpAddress',CA.isAutoDiscovered '@isAutoDiscoveredUser',
					CA.flags '@commonFlags',CA.userAccountSize '@accountSize',CA.itemType '@itemType',CA.ParentWebGuid '@ParentWebGuid',CA.BackupSetId '@BackupSetId',
					CA.ItemClassification '@ItemClassification', CA.numberOfItems '@numberOfItems',
					(SELECT CA.created as '@time' FOR XML PATH ('created'), TYPE),
					( SELECT CA.backupReferenceTime as '@time'  FOR XML PATH ('lastBackupJobRanTime'), TYPE ),
					( SELECT CA.IdxCollectionTime as '@time'  FOR XML PATH ('IdxCollectionTime'), TYPE ),
					(
						SELECT 13 '@_type_', CA.userGuid '@userGUID'
						FOR XML PATH('user'), TYPE
					),
					(
						SELECT CA.xmlGeneric
					)
					FOR XML PATH('userAccountInfo'), TYPE
				),
				(
					SELECT
					(
						SELECT 6 '@policyType',
						(
							SELECT CP.PolicyType 'cloudAppPolicy/@cloudAppPolicyType'
							FOR XML PATH ('detail'), TYPE
						),
						(
							SELECT CP.policyId '@policyId' , CP.policyName '@policyName'
							FOR XML PATH ('policyEntity') , TYPE
						)
						FROM
						(
							SELECT T.policyId , T.policyName, T.PolicyType
							FROM APP_ConfigurationPolicy (READUNCOMMITTED) T
							JOIN APP_ConfigurationPolicyDetails (READUNCOMMITTED) C ON C.componentNameId = T.policyId
							JOIN App_PlanProp (READUNCOMMITTED) P ON  P.attrVal = T.policyId AND P.componentNameId = CA.planId
							WHERE  P.attrName IN( 'Office 365 backup policy', 'Office 365 retention policy') AND C.modified = 0
						)CP
						FOR XML PATH ('cloudAppPolicies'), TYPE
					)
					FOR XML PATH ('policies') , TYPE
				),
				(
					SELECT CA.subClientId '@subClientId', CA.BackupSetId '@backupsetId'
					FOR XML PATH ('subclientEntity') , TYPE
				),
				(
						SELECT CA.planId '@planId', CA.name '@planName'
						FOR XML PATH('plan'), TYPE
				)
				FROM
				(
					SELECT U.userAssocId , U.userGuid , U.displayName , U.aliasName , U.smtpAddress , U.discoverByType , U.isAutoDiscovered ,
					U.subClientId , U.planId , U.flags, U.status , U.deleted , U.userAccountSize, U.xmlGeneric,U.itemType,U.ParentWebGuid,U.BackupSetId,U.ItemClassification, PP.name,
					U.backupReferenceTime, U.IdxCollectionTime,U.numberOfItems,
					(SELECT MIN(created) FROM APP_CloudAppUserDetails(READUNCOMMITTED) WHERE subClientId = @subClientId AND userGuid = @UserGUID) AS created
					FROM APP_CloudAppUserDetails U (READUNCOMMITTED)
					LEFT JOIN App_Plan (NOLOCK) PP ON PP.id = U.planId
					WHERE (U.modified = 0 OR U.status = 1 OR U.deleted = 1)
					AND U.subClientId = @subClientId AND U.userGUID = @UserGUID
				)CA
				FOR XML PATH('cloudAppUser'),
				ROOT('Ida_GetExchangeCloudAppUserResponse')
			)
	END
ELSE IF @appType = 137
	BEGIN
		SET @o_xmlString =
			(
					SELECT discoverByType '@discoverType', EA.status '@emailStatus',
					(
						(
							SELECT EA.displayName '@displayName', EA.aliasName '@aliasName', EA.smtpAdrress '@smtpAdrress',
							EA.databaseName '@databaseName', EA.exchangeServer '@exchangeServer', EA.mailBoxType '@mailBoxType', isAutoDiscovered '@isAutoDiscoveredUser',
							EA.exchangeVersion '@exchangeVersion', EA.msExchRecipientTypeDetails '@msExchRecipientTypeDetails',
							EA.objectGuid '@objectGuid', EA.azureGuid '@azureGuid', EA.immutableId '@immutableId', EA.numberOfEmails '@numberOfEmails', EA.mailboxSize '@mailboxSize',
							(
								SELECT 13 '@_type_',  EA.userGuid '@userGUID'
								FOR XML PATH('user'), TYPE
							)
							, ( SELECT EA.backupReferenceTime as '@time'  FOR XML PATH ('lastArchiveJobRanTime'), TYPE )
							, ( SELECT EA.idxCollectionTime as '@time'  FOR XML PATH ('idxCollectionTime'), TYPE )
							, ( SELECT EA.modified as '@time'  FOR XML PATH ('modified'), TYPE )
							, (SELECT EA.created as '@time' FOR XML PATH ('created'), TYPE)
							FOR XML PATH('userMailBoxInfo'), TYPE
						)
					),
					(
						SELECT
						(
							SELECT CP.ConfigPolicytype AS '@policyType',
							(
								-- Valid for ARCHIVE, CLEANUP, RETENTION, JOURNAL
								CASE WHEN Cp.policyType IN (1,2,3,4)
								THEN
									(SELECT CP.policyType 'emailPolicy/@emailPolicyType'
									FOR XML PATH ('detail'), TYPE)
								-- Valid for CONTAINERS
								 WHEN CP.policyType IN (6)
								 THEN
									(SELECT CP.policyType 'eePolicy/@extractionPolicyType'
										FOR XML PATH ('detail'), TYPE)
								 END
							),
							(
								SELECT CP.policyId '@policyId', CP.policyName '@policyName'
								FOR XML PATH ('policyEntity'), TYPE
							)
							FROM
							(
								SELECT EP.policyId, T.policyName, EP.policyType, T.policyType AS 'ConfigPolicytype'
								FROM APP_ConfigurationPolicy (READUNCOMMITTED) T
								JOIN APP_EmailConfigPolicies (READUNCOMMITTED) EP ON EP.modified = 0 AND EP.componentNameId = EA.assocId AND T.policyId = EP.policyId
								WHERE T.status = 0
							) CP
							FOR XML PATH ('emailPolicies'), TYPE
						)
						FOR XML PATH ('policies'), TYPE
					),
					(
						SELECT EA.autoDiscover '@enableAutoDiscovery'
						FOR XML PATH('additionalOptions'), TYPE
					),
					(
						SELECT EA.subClientId '@subClientId'
						FOR XML PATH('subclientEntity'), TYPE
					),
					(
						SELECT  158 '@_type_', EA.planId '@planId', P.name '@planName'
						FOR XML PATH('plan'), TYPE
					)
					FROM
					(
						SELECT U.assocId, U.userGuid, U.displayName, U.aliasName, U.smtpAdrress, U.databaseName, U.exchangeServer, U.discoverByType, U.isAutoDiscovered, U.mailBoxType,
							U.subClientId, U.adGroupName, U.autoDiscover, U.planId, U.deleted, U.status,
							U.exchangeVersion, (CASE WHEN U.msExchRecipientTypeDetails IS NULL OR U.msExchRecipientTypeDetails = 0 THEN 1 ELSE U.msExchRecipientTypeDetails  END) as msExchRecipientTypeDetails, U.objectGuid, U.azureGuid, U.immutableId, U.backupReferenceTime, U.numberOfEmails, U.idxCollectionTime, U.mailboxSize, U.modified,
							(SELECT MIN(created) FROM APP_EmailConfigPolicyAssoc(READUNCOMMITTED) WHERE subClientId = @subClientId AND userGuid = @UserGUID) AS created
						FROM APP_EmailConfigPolicyAssoc U (READUNCOMMITTED)
						WHERE
						(U.modified = 0 OR U.status = 1 OR U.deleted = 1)
						AND U.subClientId = @subClientId
						AND U.userGuid = @UserGUID
					)EA
					LEFT OUTER JOIN App_Plan (READUNCOMMITTED) P ON P.id = EA.planId
					ORDER BY smtpAdrress
					FOR XML PATH('ExchangeEmail'),
					ROOT('Ida_GetExchangeCloudAppUserResponse')
				)
	END
ERROR_EXIT:
	IF @o_xmlString IS NULL
	BEGIN
		SET @o_xmlString =
		(
			SELECT
				(SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
					FOR XML PATH ('resp'), TYPE
				)
			FOR XML PATH(''),
			ROOT('Ida_GetExchangeCloudAppUserResponse')
		)
	END
	SELECT @o_xmlString
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'AppExchangeCloudAppUserGetInfo')
	delete from GxQscripts where name = 'AppExchangeCloudAppUserGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppExchangeCloudAppUserGetInfo')
	delete from GXDBVersions where aliasname = 'AppExchangeCloudAppUserGetInfo'
GO

insert into GXDBVersions values(2, 'AppExchangeCloudAppUserGetInfo',  '00000000000000000000', 'AppExchangeCloudAppUserGetInfo', '00000000000000000000')
GO

