

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEntityExtractionRulesGet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEntityExtractionRulesGet.sp,v $ $Id: AppEntityExtractionRulesGet.sp,v 1.1.4.13 2020/11/17 15:27:18 csingh Exp $";
--	+===================================================================+
--	| APPGetDevicesList - Get Entity Extraction Rules				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppEntityExtractionRulesGet')
BEGIN
	print '>>> Drop Stored Procedure: AppEntityExtractionRulesGet <<<'
	drop procedure AppEntityExtractionRulesGet
END
IF EXISTS (select * from GxQscripts where name='AppEntityExtractionRulesGet')
	delete from GxQscripts where name = 'AppEntityExtractionRulesGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEntityExtractionRulesGet')
	delete from GXDBVersions where aliasname = 'AppEntityExtractionRulesGet'
GO
print '... Creating Procedure: AppEntityExtractionRulesGet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppEntityExtractionRulesGet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT,
  @i_localeId INT,
  @i_propertyLevel INT,
  @i_getDisabled INT,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
BEGIN TRY
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @function		VARCHAR(80) = 'AppEntityExtractionRulesGet'
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	DECLARE @CLASSIFIERS_PARENT_CONTAINER_GUID VARCHAR(1024) = 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27'
	-- get data classfication containers for the user
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- adding tenant security
-- check if user belongs to a company
DECLARE @organizationId int = 0
DECLARE @DEFAULT_CUSTOM_CONTAINER_GUID nvarchar(40) = '22CD8879-B2FD-4A63-8096-B515FC13502D' -- default custom entity
DECLARE @custom_container_guid nvarchar(40) = @DEFAULT_CUSTOM_CONTAINER_GUID
DECLARE @dm2container_temp table(
    comment nvarchar(max),
    containerGuid nvarchar(40),
    containerId int,
    containerName nvarchar(max),
    containerType   int
)
SELECT @organizationId = dbo.AppGetOrganizationForUser(@i_userId)
IF @organizationId <> 0 AND EXISTS(SELECT 1 FROM UMDSProviders WHERE serviceType = 5) -- UMDS_PROVIDER_ORGANIZATIONS
BEGIN
	IF OBJECT_ID('tempdb.dbo.#UserHasPermissionOnEntity_temp') IS NOT NULL
        DROP TABLE #UserHasPermissionOnEntity_temp
    CREATE TABLE #UserHasPermissionOnEntity_temp(entityId int)
EXEC dbo.sec_getNonIdaObjectsForThisUser @i_userId, 9517, 0, '#UserHasPermissionOnEntity_temp'
    SELECT TOP 1 @custom_container_guid = containerGuid FROM DM2Container DC INNER JOIN #UserHasPermissionOnEntity_temp UTEMP ON DC.containerId = UTEMP.entityId
    IF @custom_container_guid = @DEFAULT_CUSTOM_CONTAINER_GUID -- in case no custom container exists for the tenant yet, avoid showing global custom container entities
        SET @custom_container_guid = ''
END
-- get containers where user have permissions
INSERT INTO @dm2container_temp
SELECT comment, containerGuid, containerId, containerName, containerType
FROM DM2Container
WHERE containerType IN (9516, 9520) OR (containerType = 9517 and @custom_container_guid = CAST(containerGuid AS NVARCHAR(256)))
-- drop the custom parent container if no custom entity exists for the user
IF @custom_container_guid = ''
DELETE FROM @dm2container_temp WHERE containerGuid = 'B05D1D67-FCE2-493B-A7F4-5400938EAF70' AND containerType=9520
	-- No Security for fetching Extraction Rules. We are entertaining both pre-defined and custome rules now without any security.
	-- Once custom rules will come into picture (implemented from gui), we already have user id which can be used to fetch all rules with security implemented.
	-- For now, both custom entity 9516 and 9517 will be returned.
	-- Also property level is passed but not honored. In case this same API needs to return more information, then we can add more .X variables mapping and return data as per requirement
	SET @o_xmlText = (SELECT
						(SELECT
							(SELECT parentContainer.comment AS '@containerFullName', parentContainer.containerType AS '@containerType',
											parentContainer.containerName AS '@containerName', parentContainer.containerId AS '@containerId', parentContainer.containerGuid AS '@containerGuid'
									FOR XML PATH('container'), TYPE),
							(SELECT
								(SELECT D2continaer.comment AS '@containerFullName', D2continaer.containerType AS '@containerType',
										D2continaer.containerName AS '@containerName', D2continaer.containerId AS '@containerId', D2continaer.containerGuid AS '@containerGuid'
								FOR XML PATH('container'), TYPE),
								(SELECT D2Tags.TagID AS '@id', D2Tags.id AS '@tagId', D2Tags.TagDesc AS '@description',
										(SELECT EA.EntityID AS '@entityId',
												EA.Name AS '@entityName',
												EA.Flags AS '@flags',
												EA.EntityType As '@entityType',
												EA.EntityKey As '@entityKey',
												EA.Enabled As '@enabled',
												DATEDIFF(SECOND,{d '1970-01-01'},EA.CreateTime) AS '@createdTime'
											FROM EntityAnnotator EA WHERE CAST(EA.EntityID as nvarchar(64)) = D2Tags.TagValue
											FOR XML PATH('entityDetail'), TYPE)
								FROM DM2DocTags D2Tags, EntityAnnotator ET
								WHERE (
									D2Tags.containerGuid=D2continaer.containerGuid AND
									CAST(ET.EntityID as nvarchar(64)) = D2Tags.TagValue AND
									(ET.Enabled = 1 OR @i_getDisabled = 1) AND
									(
										(
											parentContainer.containerGuid=@CLASSIFIERS_PARENT_CONTAINER_GUID AND
ET.EntityType=4
										) OR
										(
											parentContainer.containerGuid <> @CLASSIFIERS_PARENT_CONTAINER_GUID AND
ET.EntityType <> 4
										)
									) AND
									(
ET.EntityType <> 4 OR
										(
ET.EntityType = 4 AND
											(ET.Attribute & 2) = 2 -- system defined classifier
										) OR
										(
											ET.AnnotatorXML.exist('/entityXML/classifierDetails/@trainingStatus') = 1 AND
											ET.AnnotatorXML.query('.').value('(/entityXML/classifierDetails/@trainingStatus)[1]', 'nvarchar(10)') = '4' -- ModelTrainingStatus.TRAINING_COMPLETED
										)
									)
								)
								FOR XML PATH('tags'), TYPE)
							FROM @dm2container_temp D2continaer, DM2DocTags parentD2Tags WHERE parentD2Tags.containerGuid = parentContainer.containerGuid AND CAST(D2continaer.containerGuid as nvarchar(512)) = parentD2Tags.TagValue
							FOR XML PATH('tagSetsAndItems'), TYPE)
FROM @dm2container_temp parentContainer WHERE parentContainer.containertype = 9520
						FOR XML PATH('containerTypesList'), TYPE)
					FOR XML PATH('DM2ContentIndexing_ContainerTypes'), TYPE)
	END TRY
	----=====================================================================
	----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
	----=====================================================================
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errCode    = ERROR_NUMBER()
		SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		SET @o_xmlText = (SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'
				FOR XML PATH('Api_GenericResp'),TYPE)
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'AppEntityExtractionRulesGet')
	delete from GxQscripts where name = 'AppEntityExtractionRulesGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEntityExtractionRulesGet')
	delete from GXDBVersions where aliasname = 'AppEntityExtractionRulesGet'
GO

insert into GXDBVersions values(2, 'AppEntityExtractionRulesGet',  '00010001000400130000', 'AppEntityExtractionRulesGet', '00010001000400130000')
GO

