

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEntityCompanySet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEntityCompanySet.sp,v $ $Id: AppEntityCompanySet.sp,v 1.1.2.21 2020/12/21 16:00:22 nshah Exp $";
--	+===============================================================================+
--	|  			             AppEntityCompanySet									|
--	|																				|
--  |  PARAMETERS			  														|
--  |    x_xmlData	  = Api_AssociateCompanyReq	request xml							|
--	+===============================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppEntityCompanySet')
BEGIN
	print '>>> Drop Stored Procedure: AppEntityCompanySet <<<'
	drop procedure AppEntityCompanySet
END
IF EXISTS (select * from GxQscripts where name='AppEntityCompanySet')
	delete from GxQscripts where name = 'AppEntityCompanySet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEntityCompanySet')
	delete from GXDBVersions where aliasname = 'AppEntityCompanySet'
GO
print '... Creating Procedure: AppEntityCompanySet'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppEntityCompanySet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @x_xmlData XML OUTPUT 
-----------------------------------------------------------
AS
SET NOCOUNT ON
--
	DECLARE @tranCnt INT = @@TRANCOUNT
	IF @tranCnt > 0
		SAVE TRAN AppEntityCompanySet_Tran
	ELSE
		BEGIN TRAN AppEntityCompanySet_Tran
--
-- At present only MSP admin can move clients between organization. In future we will provide support to tenant admin if required.
	-- and will do necessary security check.
DECLARE @i_companyId	INT = (SELECT ISNULL(ref.value('@providerId', 'INT'), 0) AS name FROM @x_xmlData.nodes('Api_AssociateCompanyReq/company') R ( ref )),
		@i_callerId		INT = ISNULL (( SELECT ref.value('@userId', 'INT') FROM @x_xmlData.nodes ('Api_AssociateCompanyReq/processinginstructioninfo/user') R(ref)), 0),
		@i_localeId		INT = ISNULL (( SELECT ref.value('@localeId', 'INT') FROM @x_xmlData.nodes ('Api_AssociateCompanyReq/processinginstructioninfo/locale') R(ref)), 0),
		@errorCode		INT = 0,
		@errorMsg		NVARCHAR(MAX) = '',
		@isMSPUserComcellAdmin INT = 0
BEGIN TRY
	----- CHECK SECURITY ----------------------------------------------------------------------------------------------------------------------
	IF @i_companyId < 0
	BEGIN
		SET @errorCode = 1
		SET @errorMsg = 'Please provide valid companyId.'
		GOTO ERROR_EXIT
	END
	--
EXEC sec_checkPermissionOnEntity @i_callerId, 1, @isMSPUserComcellAdmin OUT,1,2
	----- CHECK SECURITY ----------------------------------------------------------------------------------------------------------------------
--
	----- PARSE THE XML ------------------------------------------------------------------------------------------------------------------------
	CREATE TABLE #EntitiesToAssociate (entityId INT, entityType INT, scgId INT DEFAULT 0, isVM INT DEFAULT 0, isinValidForMigration INT DEFAULT 0, parentEntity INT DEFAULT 0, oldCompanyId INT DEFAULT 0
		PRIMARY KEY(entityId, entityType))
	CREATE TABLE #EntityPlanAssoc (entityId INT, planId INT DEFAULT 0)
	IF object_id('tempdb.dbo.#AssociatedClients') is not null
		DROP TABLE #AssociatedClients
	CREATE TABLE #AssociatedClients
	(
		id INT
		PRIMARY KEY(id)
	)
	--
	INSERT INTO #EntitiesToAssociate (entityId, entityType)
		SELECT ref.value('@clientId','INT'),
3
		FROM @x_xmlData.nodes('Api_AssociateCompanyReq/entities') AS R(ref)
WHERE ref.value('@_type_','INT') = 3
	-- EXPAND CLIENTGROUP
		UNION
		SELECT CG.clientId,
3
		FROM @x_xmlData.nodes('Api_AssociateCompanyReq/entities') AS R(ref)
		INNER JOIN App_ClientGroupAssoc AS CG WITH(NOLOCK) ON CG.clientGroupId = ref.value('@clientGroupId','INT')
WHERE ref.value('@_type_','INT') = 28
	--
--DELETE FROM #EntitiesToAssociate WHERE entityType = 28
	----- PARSE THE XML ------------------------------------------------------------------------------------------------------------------------
--
--
	----- SECURITY CHECK - NOT MSP ADMIN ON COMMCELL THEN CHECK CLIENT OWNERSHIP PERMISSION ON EACH ENTITY -------------------------------------
	IF @isMSPUserComcellAdmin = 0 /*Not MSP admin*/
	BEGIN
		-- NOT MSP ADMIN ON COMMCELL THEN CHECK CLIENT OWNERSHIP PERMISSION ON EACH ENTITY
		CREATE TABLE #getPermissionsOnEntities_InputTable
		(
			entityId1 INT,
			entityId2 INT DEFAULT 0,
			entityId3 INT DEFAULT 0,
			entityId4 INT DEFAULT 0,
			entityId5 INT DEFAULT 0
		)
		CREATE TABLE #getPermissionsOnEntities_OutputTable
		(
			entityId1 INT,
			entityId2 INT,
			entityId3 INT,
			entityId4 INT,
			entityId5 INT,
			permissionsString VARCHAR(512),
			isChildRow BIT DEFAULT 0
		)
		INSERT into #getPermissionsOnEntities_InputTable (entityId1)
(SELECT entityId FROM #EntitiesToAssociate WHERE entityType = 3)
EXEC sec_getPermissionsOnEntities @i_callerId, 3/*CLIENT_ENTITY*/
		--
		UPDATE E
			SET E.isinValidForMigration = 1
		FROM #EntitiesToAssociate E
INNER JOIN #getPermissionsOnEntities_OutputTable ON entityId1 = entityId AND E.entityType = 3
WHERE SUBSTRING(permissionsString, 1, 1) != N'1'
	END
	----- SECURITY CHECK - NOT MSP ADMIN ON COMMCELL THEN CHECK CLIENT OWNERSHIP PERMISSION ON EACH ENTITY --------------------------------------
--
--
--
--
	------ Associate all the VM clients of hyperV client as well
	  -------------------------------------------------------------------------------------------------------
	MERGE #EntitiesToAssociate AS TARGET
USING (SELECT componentNameId as entityId, 3 as entityType, E.entityId as parentEntity
	FROM #EntitiesToAssociate E
	INNER JOIN APP_Application Appl WITH(NOLOCK)
On E.entityId = Appl.clientId AND E.entityType = 3
	INNER JOIN APP_ClientProp ACP WITH(NOLOCK)
ON ACP.attrName = 'Last Backup Subclient' AND ACP.attrVal = CAST(Appl.id AS NVARCHAR(10)) AND ACP.modified=0
	WHERE E.isinValidForMigration = 0
	) AS SOURCE ON
	(TARGET.entityId = SOURCE.entityId AND SOURCE.entityType = TARGET.entityType)
	WHEN MATCHED THEN UPDATE SET TARGET.parentEntity = SOURCE.parentEntity
	WHEN NOT MATCHED BY TARGET THEN
	INSERT (entityId, entityType, isVM, isinValidForMigration, parentEntity)
	VALUES (SOURCE.entityId, SOURCE.entityType, 1, 0, SOURCE.parentEntity);
	----- GET OLD COMPANY ID -------------------------------------------------------------------------------------------------------------------------
	UPDATE EA
		SET EA.oldCompanyId = ACE.companyId
	FROM #EntitiesToAssociate EA
		INNER JOIN APP_CompanyEntities ACE (NOLOCK)
			ON EA.entityType = ACE.entityType AND EA.entityId = ACE.entityId
	WHERE
		EA.isinValidForMigration = 0
	----- GET OLD COMPANY ID -------------------------------------------------------------------------------------------------------------------------
	----- Verify subclients, backupsets, instances have either same company as client itself or same company as target company --------------------------------------------------------------------------------------------------------
	-- A. Verify associated clients of given client either have same company as client or same company as target company
	DECLARE @targetCompanyId INT = @i_companyId
	UPDATE E
	SET E.isinValidForMigration = 1
	FROM #EntitiesToAssociate E
	INNER JOIN #EntitiesToAssociate E2
		ON E2.parentEntity = E.entityId
	WHERE E.oldCompanyId <> E2.oldCompanyId
		AND E.oldCompanyId <> @targetCompanyId
		AND E2.oldCompanyId <> @targetCompanyId
		AND E.parentEntity = 0 AND E2.parentEntity <> 0 AND E.isinValidForMigration = 0 AND E2.isinValidForMigration = 0
	-- B. Verify subclients, backupsets, instances of given client & it's associated clients either have same company as client or same company as target company
	UPDATE E
	SET isinValidForMigration = 1
	FROM APP_Application Appl WITH(NOLOCK)
	INNER JOIN App_CompanyEntities App WITH(NOLOCK)
On App.entityId = Appl.id AND App.entityType = 7
	INNER JOIN #EntitiesToAssociate E
On E.entityId = Appl.clientId AND E.entityType = 3
	WHERE E.oldCompanyId <> App.companyId
		AND E.oldCompanyId <> @targetCompanyId AND App.companyId <> @targetCompanyId
		AND E.isinValidForMigration = 0
	UPDATE E
	SET isinValidForMigration = 1
	FROM APP_BackupSetName Bkp WITH(NOLOCK)
	INNER JOIN App_CompanyEntities App WITH(NOLOCK)
On App.entityId = Bkp.id AND App.entityType = 6
	INNER JOIN APP_Application Appl WITH(NOLOCK)
		On Appl.backupSet = Bkp.id
	INNER JOIN #EntitiesToAssociate E
On E.entityId = Appl.clientId AND E.entityType = 3
	WHERE E.oldCompanyId <> App.companyId
		AND E.oldCompanyId <> @targetCompanyId AND App.companyId <> @targetCompanyId
		AND E.isinValidForMigration = 0
	UPDATE E
	SET isinValidForMigration = 1
	FROM APP_InstanceName AI WITH(NOLOCK)
	INNER JOIN App_CompanyEntities App WITH(NOLOCK)
On App.entityId = AI.id AND App.entityType = 5
	INNER JOIN APP_Application Appl WITH(NOLOCK)
		On Appl.instance = AI.id
	INNER JOIN #EntitiesToAssociate E
On E.entityId = Appl.clientId AND E.entityType = 3
	WHERE E.oldCompanyId <> App.companyId
		AND E.oldCompanyId <> @targetCompanyId AND App.companyId <> @targetCompanyId
		AND E.isinValidForMigration = 0
		AND AI.id <> 1
		AND AI.id NOT IN (SELECT componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1')   /*default VM instance*/
	-- C. If client is MA, verify that all the SP/Plan/Pool created using MA are target company entities. Note: SP/Plan/Pool cannot even be MSP entities since those are not migrated along with MA to target company. -----
	UPDATE E
	SET E.isinValidForMigration = 1
	FROM #EntitiesToAssociate E
	INNER JOIN MMHost MMH WITH(NOLOCK)
		ON MMH.ClientId = E.entityId
AND E.entityType = 3
	INNER JOIN MMDataPath MMD WITH(NOLOCK)
		ON MMH.ClientId = MMD.HostClientId
	INNER JOIN archGroupCopy AGC WITH(NOLOCK)
		ON AGC.id = MMD.CopyId
	LEFT JOIN App_CompanyEntities ACE WITH(NOLOCK)
		ON ACE.entityId = AGC.archGroupId
AND ACE.entityType = 17
	WHERE (ACE.entityId is NULL
			OR ACE.companyId <> @targetCompanyId)
			AND E.isinValidForMigration = 0
	-- D. Verify that subclients of client either have security association with same company as client or same company as target company
	UPDATE E
	SET E.isinValidForMigration = 1
	FROM #EntitiesToAssociate E
	INNER JOIN App_Application Appl WITH(NOLOCK)
ON E.entityType = 3
			AND E.entityId = Appl.clientId
	INNER JOIN UMSecurityAssociations UM WITH(NOLOCK)
ON UM.entityType1 = 3
			AND UM.entityId1 = E.entityId
AND UM.entityType5 = 7
			AND UM.entityId5 = Appl.id
	WHERE E.oldCompanyId <> UM.companyId
		AND E.oldCompanyId <> @targetCompanyId
		AND UM.companyId <> @targetCompanyId
		AND E.parentEntity = 0
		AND E.isinValidForMigration = 0
	UPDATE E
	SET E.isinValidForMigration = 1
	FROM #EntitiesToAssociate E
	INNER JOIN #EntitiesToAssociate E2
		ON E2.parentEntity = E.entityId
	WHERE E.parentEntity = 0 AND E2.parentEntity <> 0 AND E2.isinValidForMigration = 1 AND E.isinValidForMigration = 0
	UPDATE E2
	SET E2.isinValidForMigration = 1
	FROM #EntitiesToAssociate E
	INNER JOIN #EntitiesToAssociate E2
		ON E2.parentEntity = E.entityId
	WHERE E.parentEntity = 0 AND E2.parentEntity <> 0 AND E2.isinValidForMigration = 0 AND E.isinValidForMigration = 1
	----- SET VM FLAG FOR THE ENTITIES --------------------------------------------------------------------------------------------------------
	UPDATE E
		SET E.isVM = 1
	FROM #EntitiesToAssociate E
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON E.entityType = 3 AND E.entityId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.modified=0 AND CP.attrVal='1'
--
	----- GET PLAN ids FOR THE VM -------------------------------------------------------------------------------------------------------------
	INSERT INTO #EntityPlanAssoc
		SELECT E.entityid, CAST(SP.attrVal AS INT)
		FROM #EntitiesToAssociate E
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.componentNameId = E.entityId AND CP.attrName = 'Last Backup Subclient' AND CP.modified=0
INNER JOIN App_SubclientProp SP WITH(NOLOCK) ON SP.componentNameId = CAST(CP.attrVal AS INT) AND SP.attrName = 'Associated Plan' AND sP.modified = 0 AND SP.attrVal<>'0'
WHERE E.isVM = 1 AND E.isinValidForMigration = 0 AND E.entityType = 3
	----- SET VM FLAG FOR THE ENTITIES --------------------------------------------------------------------------------------------------------
--
--
	----- GET PLAN ids ASSOCIATED THRU CLIENT -------------------------------------------------------------------------------------------------
	INSERT INTO #EntityPlanAssoc
		SELECT E.entityid, CAST(CP.attrVal AS INT)
			FROM #EntitiesToAssociate E
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON E.entityType = 3 AND CP.componentNameId = E.entityId AND CP.attrName = 'Associated Plan' AND CP.modified=0 AND CP.attrVal<>'0'
		WHERE E.isVM <> 1 AND E.isinValidForMigration = 0
--
--
	----- GET PLAN ids ASSOCIATED THRU BACKUPSET ----------------------------------------------------------------------------------------------
	INSERT INTO #EntityPlanAssoc
		SELECT E.entityid, CAST(BP.attrVal AS INT)
			FROM #EntitiesToAssociate E
			INNER JOIN APP_Application A WITH(NOLOCK) on A.clientId = E.entityId
INNER JOIN APP_BackupSetProp BP WITH(NOLOCK) ON BP.componentNameId = A.backupSet AND BP.attrName = 'Associated Plan' AND BP.modified = 0 AND BP.attrVal<>'0'
		WHERE E.isVM <> 1 AND E.isinValidForMigration = 0
--
--
	----- GET PLAN ids ASSOCIATED THRU SUBCLIENT ----------------------------------------------------------------------------------------------
	INSERT INTO #EntityPlanAssoc
		SELECT E.entityid, CAST(SP.attrVal AS INT)
			FROM #EntitiesToAssociate E
INNER JOIN APP_Application A WITH(NOLOCK) on A.clientId = E.entityId AND E.entityType = 3
INNER JOIN APP_SubClientProp SP WITH(NOLOCK) ON SP.componentNameId = A.id AND SP.cs_attrName = CHECKSUM(N'Associated Plan') AND SP.attrVal<>'0'
AND SP.attrName = 'Associated Plan' AND SP.modified = 0
		WHERE E.isVM <> 1 AND E.isinValidForMigration = 0
--
--
	----- CHECK iF THE TENANT ADMIN HAS PERMISSION ON THE ASSOCIATED PLANS OF EACH CLIENT --------------------------------------------------------
IF EXISTS (SELECT 1 FROM #EntityPlanAssoc EA INNER JOIN #EntitiesToAssociate E ON E.entityType = 3 AND E.entityId = EA.entityId WHERE E.isinValidForMigration = 0)
	BEGIN
		----- GET plans OF THE COMPANY -----------------------------------------------------------------------------------------------------
			CREATE TABLE #getPlans (planId INT)
EXEC AppGetCompanyPlanList @i_companyId,159,'#getPlans'
			UPDATE E
				SET E.isinValidForMigration = 1
			FROM #EntitiesToAssociate E
INNER JOIN #EntityPlanAssoc EA ON E.entityType = 3 AND EA.entityid = E.entityId and E.isinValidForMigration = 0
			LEFT OUTER JOIN #getPlans P ON P.planid = EA.planId
			WHERE P.planId IS NULL
		END
	----- CHECK iF THE TENANT ADMIN HAS PERMISSION ON THE ASSOCIATED PLANS OF EACH CLIENT -----------------------------------------------------
--
--
	----- CHECK LOCKED CLIENTS. THEY SHOULD NOT BE ALLOWED TO MIGRATE FROM COMPANY C1 TO COMPANY C2. ------------------------------------------
	BEGIN
		UPDATE E
			SET E.isinValidForMigration = 1
		FROM #EntitiesToAssociate E
			INNER JOIN APP_ClientProp CP (NOLOCK)
ON E.entityType = 3 AND CP.componentNameId = E.entityId AND CP.attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND CP.attrVal = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' AND CP.modified = 0
		WHERE
			E.isinValidForMigration = 0
	END
	----- CHECK LOCKED CLIENTS. THEY SHOULD NOT BE ALLOWED TO MIGRATE FROM COMPANY C1 TO COMPANY C2. ------------------------------------------
--
--
	----- GET SCG IDs -------------------------------------------------------------------------------------------------------------------------
	UPDATE EA
		SET EA.scgId = CG.id
	FROM #EntitiesToAssociate EA
JOIN App_CompanyProp CP WITH(NOLOCK) ON CP.componentNameId = @i_companyId AND CP.attrName = 'Associated Smart Client Group' AND CP.modified = 0
AND CP.cs_attrName = CHECKSUM('Associated Smart Client Group')
JOIN APP_ClientGroup CG WITH(NOLOCK) ON CP.attrValInt = CG.id AND CG.flag & 0x1000 = 0x1000
WHERE EA.entityType = 3 AND EA.isinValidForMigration = 0
	----- GET SCG IDs -------------------------------------------------------------------------------------------------------------------------
--
	----- UPDATE COMPANY PROP FOR THE ENTITIES ------------------------------------------------------------------------------------------------
	MERGE App_clientProp AS TARGET
USING (SELECT entityId, entityType, isinValidForMigration FROM #EntitiesToAssociate WHERE entityType = 3 AND isinValidForMigration = 0) AS SOURCE ON
(TARGET.componentNameId = SOURCE.entityId AND SOURCE.entityType = 3	AND TARGET.modified = 0
AND TARGET.attrName = 'Installation Company ID')
	WHEN MATCHED THEN UPDATE SET TARGET.attrVal = @i_companyId
	WHEN NOT MATCHED BY TARGET THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpid)
VALUES (SOURCE.entityId, 'Installation Company ID', 7, @i_companyId, dbo.GetUnixTime(GetUTCdate()), 0, 0);
--
	-- UPDATE CLIENT PROP FOR CLIENTS
	DECLARE @numberOfDays INT;
	IF @i_companyId > 0
		BEGIN
SET @numberOfDays = ISNULL( (SELECT attrVal FROM App_CompanyProp(NOLOCK) WHERE componentNameId = @i_companyId AND attrName = 'Force delete devices after days'  AND modified = 0) ,365)
		END
	ELSE
		BEGIN
SET @numberOfDays = ISNULL( (SELECT value FROM GXGlobalParam(NOLOCK) WHERE  name = 'Force delete devices after days' AND modified = 0) ,365 )
		END
	UPDATE CP
	SET attrVal = @numberOfDays
	FROM  App_ClientProp CP (NOLOCK)
	INNER JOIN #EntitiesToAssociate CC (NOLOCK)
ON CC.entityId = CP.componentNameId AND (CP.attrName =  'Number of days to keep data of de-configured clients' AND CP.attrVal <> CAST(@numberOfDays AS NVARCHAR(12)) AND  CP.modified = 0)
	INNER JOIN APP_Client C (NOLOCK)
ON CC.entityId = C.id AND C.status & 0x1000 = 0x1000
	LEFT JOIN APP_ClientProp CP1 (NOLOCK)
ON CC.entityId = CP1.componentNameId AND CP1.attrName = 'Associated Plan' AND CP1.modified = 0
WHERE (CC.entityType = 3 AND CC.isinValidForMigration = 0) AND (CP1.attrVal IS NULL OR CP1.attrVal = N'0' )
	-- INSERT INTO COMPANY TAG TABLE 'App_CompanyEntities'
	IF OBJECT_ID('tempdb.dbo.#EntitiesToTagWithCompany') IS NOT NULL
             DROP TABLE #EntitiesToTagWithCompany
        CREATE TABLE #EntitiesToTagWithCompany
        (
	     entityId INT,
	     entityType INT
        )
	INSERT INTO #EntitiesToTagWithCompany (entityId, entityType)
	SELECT DISTINCT entityId, entityType
FROM #EntitiesToAssociate WHERE isinValidForMigration = 0 AND entityType = 3
	INSERT INTO #EntitiesToTagWithCompany (entityId, entityType)
SELECT DISTINCT E.entityId, 11
	FROM #EntitiesToAssociate E
	INNER JOIN MMHost MMH WITH(NOLOCK)
		On MMH.ClientId = E.entityId
AND E.entityType = 3
	WHERE isinValidForMigration = 0
	INSERT INTO #EntitiesToTagWithCompany (entityId, entityType)
SELECT DISTINCT Appl.id, 7
	FROM  #EntitiesToAssociate E
	INNER JOIN App_application Appl WITH(NOLOCK)
On Appl.clientId = E.entityId AND E.entityType = 3
	WHERE E.isinValidForMigration = 0
	INSERT INTO #EntitiesToTagWithCompany (entityId, entityType)
SELECT DISTINCT Bkp.id, 6
	FROM  #EntitiesToAssociate E
	INNER JOIN App_application Appl WITH(NOLOCK)
On Appl.clientId = E.entityId AND E.entityType = 3
	INNER JOIN App_BackupsetName Bkp WITH(NOLOCK)
		On Bkp.id = Appl.backupset
	WHERE E.isinValidForMigration = 0
	INSERT INTO #EntitiesToTagWithCompany (entityId, entityType)
SELECT DISTINCT AI.id, 5
	FROM  #EntitiesToAssociate E
	INNER JOIN App_application Appl WITH(NOLOCK)
On Appl.clientId = E.entityId AND E.entityType = 3
	INNER JOIN App_InstanceName AI WITH(NOLOCK)
		On AI.id = Appl.instance
	WHERE E.isinValidForMigration = 0
		AND AI.id <> 1
		AND AI.id NOT IN (SELECT componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1')   /*default VM instance*/
	EXEC sec_setCompanyIdForEntity 0, 0, @i_companyId
	----- REMOVE FROM SECURITY ASSOCIATIONS TABLE AND OWNERS TABLE ----------------------------------------------------------------------------
	DELETE Sec
	FROM UMSecurityAssociations Sec
		INNER JOIN #EntitiesToAssociate E
			ON Sec.entityType1 = E.entityType AND Sec.entityId1 = E.entityId AND Sec.companyId = E.oldCompanyId AND E.oldCompanyId <> 0
	WHERE
(E.isinValidForMigration = 0 AND E.entityType = 3)			-- Expand to other entities later.. Removing from Security associations needs to be checked for others.
	DELETE Sec
	FROM UMOwners Sec
		INNER JOIN #EntitiesToAssociate E
			ON Sec.entityType = E.entityType AND Sec.entityId = E.entityId AND Sec.companyId = E.oldCompanyId AND E.oldCompanyId <> 0
	WHERE
		E.isinValidForMigration = 0
	----- REMOVE FROM SECURITY ASSOCIATIONS TABLE AND OWNERS TABLE ----------------------------------------------------------------------------
--
--
	----- FORCE-DELETE THEM FROM OLD COMPANY'S CG. --------------------------------------------------------------------------------------------
	DELETE CGA
	FROM APP_ClientGroupAssoc CGA
		INNER JOIN #EntitiesToAssociate E
ON CGA.clientId = E.entityId AND E.entityType = 3
		INNER JOIN APP_CompanyEntities ACE
ON CGA.clientGroupId = ACE.entityId AND ACE.entityType = 28 AND ACE.companyId = E.oldCompanyId AND E.oldCompanyId <> 0
	WHERE
		E.isinValidForMigration = 0
	----- FORCE-DELETE THEM FROM OLD COMPANY'S CG. --------------------------------------------------------------------------------------------
	--
	--	AUDIT
	IF EXISTS (SELECT 1 FROM #EntitiesToAssociate WHERE isinValidForMigration = 0)
	BEGIN
DECLARE @opMsgId    INT = (695 | (CAST(POWER(2, 24) AS BIGINT) * 84)) -- 'Change company for client(s)'
		DECLARE @opEvMsgId  INT -- dummy not used.
		DECLARE @paramMsgId INT = 0
		DECLARE @opId       INT = 0
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_callerId, 61, @i_companyId, @opEvMsgId OUTPUT, @opId OUTPUT
		--
		DECLARE @companyName NVARCHAR(255) = (SELECT IIF((hostName IS NOT NULL AND hostName<>''), hostName, domainName) FROM UMDSProviders WITH(NOLOCK) WHERE id = @i_companyId)
SET @paramMsgId = (1655 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @companyName, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_callerId
		--
		DECLARE @listOfClients NVARCHAR(MAX)
		SELECT @listOfClients= COALESCE(@listOfClients + ',','') + name FROM #EntitiesToAssociate INNER JOIN App_client C ON C.id = entityId
WHERE isinValidForMigration = 0 AND entityType = 3
SET @paramMsgId = (975 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @listOfClients, 0
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_callerId
	END
	----- UPDATE COMPANY PROP FOR THE ENTITIES ------------------------------------------------------------------------------------------------
--
--
	----- REFRESH SCG -------------------------------------------------------------------------------------------------------------------------
	DECLARE @entityId INT = 0, @scgId VARCHAR(512), @groupIdStr VARCHAR(512), @rows INT = 0
SELECT @rows = COUNT(1) FROM #EntitiesToAssociate WHERE isinValidForMigration = 0 AND entityType = 3
	SELECT TOP 1 @entityId = entityId, @scgId = CAST(scgId AS VARCHAR(30))
		FROM #EntitiesToAssociate
WHERE entityType = 3 AND entityId > @entityId AND scgId > 0 and isinValidForMigration = 0
		ORDER BY entityId
	--
	WHILE(@entityId > 0 AND @rows > 0)
	BEGIN
		-- IF CLIENT IS ASSOCIATED WITH SOME OTHER COMPANY THEN NEED TO REFRESH OLD COMPANY'S SCG
		SET @groupIdStr = NULL --Reset it
		SELECT @groupIdStr = COALESCE(@groupIdStr+',','') + CAST(ACGA.clientGroupId AS VARCHAR(30))
			FROM APP_ClientGroupAssoc ACGA WITH(NOLOCK)
JOIN App_CompanyProp CP WITH(NOLOCK) ON CP.cs_attrName = checksum('Associated Smart Client Group') AND CP.attrName='Associated Smart Client Group'
			AND CP.modified = 0 AND CP.attrValInt = ACGA.clientGroupId
		WHERE ACGA.clientid = @entityId
	--
		SET @scgId = IIF((@groupIdStr IS NULL) OR (@groupIdStr = ''), @scgId, @scgId + ',' + @groupIdStr)
		EXEC AppSCGUpdateClient @i_callerId, @entityId, @scgId
		--
		SELECT TOP 1 @entityId = entityId, @scgId = CAST(scgId AS VARCHAR(30))
		FROM #EntitiesToAssociate
WHERE entityType = 3 AND entityId > @entityId AND scgId > 0 AND isinValidForMigration = 0
		ORDER BY entityId
		SET @rows = @rows - 1
	END
	----- REFRESH SCG -------------------------------------------------------------------------------------------------------------------------
	--------------------------- START  - Change Ediscovery property for Company if applicable  ------------------------------------------------
	DECLARE @clientIds NVARCHAR(MAX)
SELECT @clientIds = COALESCE(@clientIds + ',', '') + CAST(entityId AS NVARCHAR(16)) FROM #EntitiesToAssociate WHERE entityType = 3 AND isinValidForMigration = 0
	EXEC dbo.AppSetEDiscoveryForCompany -1, @clientIds, '' , @errorCode OUTPUT, @errorMsg OUTPUT
	-- Better to keep this code as absence of it might cause issue in failure (especially if any code is added after our block and there was some error in our block. We might miss error handling)
	IF @errorCode <>0
	BEGIN
		GOTO ERROR_EXIT
	END
	--------------------------- END  - Change Ediscovery property for Company if applicable  --------------------------------------------------
--
--
--
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorMsg = ERROR_MESSAGE()
END CATCH
--
ERROR_EXIT:
	IF @errorCode = 0 AND XACT_STATE() = 1
		COMMIT TRAN AppEntityCompanySet_Tran
	ELSE
		ROLLBACK TRAN AppEntityCompanySet_Tran
--
SET @x_xmlData =
    (
		SELECT
			@errorCode '@errorCode',
			@errorMsg '@errorMessage'
		FOR XML PATH('App_GenericResp')
    )
SELECT @x_xmlData AS x_xmlData
RETURN @errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'AppEntityCompanySet')
	delete from GxQscripts where name = 'AppEntityCompanySet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEntityCompanySet')
	delete from GXDBVersions where aliasname = 'AppEntityCompanySet'
GO

insert into GXDBVersions values(2, 'AppEntityCompanySet',  '00010001000200210000', 'AppEntityCompanySet', '00010001000200210000')
GO

