

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEnableCloudLaptopMode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppEnableCloudLaptopMode()
--  |
--  | Description:  SP for pushing the media agent package onto the clients in the client group when
--	|	Retrieve all clients belonging to the client group and that does not ahve the MA package installed
--	|	if all the Clients have package installed (SIM_INSTALLEDPACKAGES) then return
--	|	else push the work token (Execute Rohith SP) to the clients.
--	|
--	|	Check if registry is set - EnableCloudLaptopMode - set to 1
--	|
--  |
--  |       Input:  Client Group ID
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  arangan  	To push packages onto client group
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppEnableCloudLaptopMode')
BEGIN
	print '>>> Drop Stored Procedure: AppEnableCloudLaptopMode <<<'
	drop procedure AppEnableCloudLaptopMode
END
IF EXISTS (select * from GxQscripts where name='AppEnableCloudLaptopMode')
	delete from GxQscripts where name = 'AppEnableCloudLaptopMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEnableCloudLaptopMode')
	delete from GXDBVersions where aliasname = 'AppEnableCloudLaptopMode'
GO
print '... Creating Procedure: AppEnableCloudLaptopMode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEnableCloudLaptopMode
  @entityId INTEGER,
  @entityType INTEGER,
  @i_uid INTEGER
AS
  DECLARE @errorCode INT
  DECLARE @errorString nvarchar(MAX)
--new
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
BEGIN TRY
	DECLARE @tempClient TABLE ( clientId INT PRIMARY KEY)
IF @entityType = 28
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM app_clientgroup WHERE id = @entityId)
		BEGIN
SET @errorCode = 1
			SET @errorString = 'Client Group ID [' + CAST(@entityId as nvarchar) + '] is invalid. Please give correct Client Group Id.'
			PRINT @errorString
			GOTO PROC_EXIT
		END
		INSERT INTO @tempClient
		SELECT DISTINCT clientId FROM APP_ClientGroupAssoc P WITH (NOLOCK) JOIN APP_AdvanceSettings S WITH (NOLOCK)
ON S.entityId = P.clientGroupId AND	S.keyName = 'EnableCloudLaptopMode' AND S.entityType = 28 AND P.clientGroupId = @entityId AND CAST(S.value AS VARCHAR(MAX)) = '1'
		INNER JOIN APP_Client AC WITH (NOLOCK) on AC.id = P.clientId
INNER JOIN simOperatingSystem simOS WITH (NOLOCK) ON AC.simOperatingSystemId = simOS.id AND simOS.Type in ('Windows')
	END
ELSE IF @entityType = 27
	BEGIN
		INSERT INTO @tempClient
		SELECT DISTINCT clientId FROM APP_ClientGroupAssoc P WITH (NOLOCK) JOIN APP_AdvanceSettings S WITH (NOLOCK)
ON S.entityId = P.clientGroupId AND	S.keyName = 'EnableCloudLaptopMode' AND S.entityType = 28 AND CAST(S.value AS VARCHAR(MAX)) = '1'
		INNER JOIN APP_Client AC WITH (NOLOCK) on AC.id = P.clientId
INNER JOIN simOperatingSystem simOS WITH (NOLOCK) ON AC.simOperatingSystemId = simOS.id AND simOS.Type in ('Windows')
	END
	ELSE
	BEGIN
		--Client ID sanity check
		IF NOT EXISTS (SELECT 1 FROM app_client WHERE id = @entityId)
		BEGIN
SET @errorCode = 1
			SET @errorString = 'Client ID [' + CAST(@entityId as nvarchar) + '] is invalid. Please give correct Client Id.'
			PRINT @errorString
			GOTO PROC_EXIT
		END
		-- Given client ID, If it belong to a clientgroup which has the Addtional setting set and does not have a media agent package installed, then insert
		IF EXISTS(SELECT clientGroupId FROM APP_ClientGroupAssoc P WITH (NOLOCK) JOIN APP_AdvanceSettings S WITH (NOLOCK)
ON S.entityId = P.clientGroupId and S.entityType =  28  AND  S.keyName =  'EnableCloudLaptopMode' and P.clientId = @entityId AND CAST(S.value AS VARCHAR(MAX)) = '1'
		INNER JOIN APP_Client AC WITH (NOLOCK) on AC.id = P.clientId
INNER JOIN simOperatingSystem simOS WITH (NOLOCK) ON AC.simOperatingSystemId = simOS.id AND simOS.Type in ('Windows'))
		BEGIN
			INSERT INTO @tempClient(clientId)
			VALUES(@entityId)
		END
	END
	DECLARE @tempClientPkgId TABLE ( clientId INT PRIMARY KEY, packageId INT)
	INSERT INTO @tempClientPkgId
	SELECT clientId, (	CASE S.type
When 'Windows' then 54
else 1305
						end
					)
	FROM @tempClient  T JOIN APP_CLIENT C ON C.id = T.clientId
JOIN simOperatingSystem S ON S.id = C.simoperatingSystemId AND S.Type in ('Windows')
	AND clientId NOT IN (SELECT clientId FROM simInstalledPackages  WITH (NOLOCK) WHERE simPackageID IN
(54, 54))
	IF OBJECT_ID('tempdb.dbo.#pushWorkTokenToClient') IS NOT NULL
		DROP TABLE #pushWorkTokenToClient
	CREATE TABLE #pushWorkTokenToClient (subclientId INT PRIMARY KEY, clientId INT)
	DECLARE @cloudModeEnabled NVARCHAR(64) = N'Cloud Mode Enabled'
	DECLARE @nowTime INT = dbo.GetUnixTime(GetUTCdate())
	MERGE APP_SubClientProp T
	USING (SELECT subclient.id FROM App_Application subclient
			INNER JOIN @tempClient client ON client.clientId = subclient.clientid
			INNER JOIN App_BackupsetName backupSet ON backupSet.id = subclient.backupset
			INNER JOIN APP_AppTypeGroupAssoc appType ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22) AND appType.typeOfGroup = 0 --22:WinFS only windows laptops
			WHERE subclient.subclientStatus = 8
			AND backupSet.status = 8
			AND NOT EXISTS(SELECT 1 FROM App_Application sSubclient
								INNER JOIN APP_SubClientProp sProp ON sSubclient.id = sProp.componentnameId
								WHERE sSubclient.clientid = client.clientId
								AND sProp.attrName = @cloudModeEnabled AND sProp.modified = 0 AND sProp.cs_attrName = CHECKSUM(@cloudModeEnabled))
			) S
	ON T.componentnameId = S.id AND T.attrName = @cloudModeEnabled AND T.modified = 0 AND T.cs_attrName = CHECKSUM(@cloudModeEnabled)
	WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES(S.id, @cloudModeEnabled, 2, N'1', @nowTime, 0, 0)
		OUTPUT INSERTED.componentNameId
		INTO #pushWorkTokenToClient (subclientId);
	--push work token
	UPDATE T
		SET T.clientId = subclient.clientId
	FROM #pushWorkTokenToClient T
	INNER JOIN APP_Application subclient ON subclient.id = T.subclientId
	DECLARE @xmlForSyncRestoreWQ XML
	SET @xmlForSyncRestoreWQ = (SELECT 17 '@workToken',  -- WORK_TOKEN_SYNC_RESTORE_CONFIG
										'<TMMsg_SyncConfigWorkQueueReq/>' AS '@workTokenParams',
										(
											SELECT DISTINCT clientId '@clientId'
											FROM #pushWorkTokenToClient
												FOR XML PATH('entityList'),TYPE)
								FOR XML PATH('App_SubmitWorkQueueReq'))
	IF @xmlForSyncRestoreWQ IS NOT NULL
	BEGIN
		DECLARE @workQueueOutput XML
		EXEC AppWorkQueueSubmitRequestXMLOUTPUT @xmlForSyncRestoreWQ, @workQueueOutput output
	END
	--disable backup jobs
	MERGE JMJobAction as Dest
	USING (select clientId from @tempClientPkgId) as Src
	on Dest.clientId = Src.clientId
		AND Dest.mediaAgentID = 1 AND Dest.appType = 0 AND Dest.opType = 4
	WHEN MATCHED
		THEN UPDATE SET action = 1  -- enable backup (action = 2 ), disable backup (action = 1)
	WHEN NOT MATCHED THEN
	INSERT (clientId, mediaAgentID, appType, opType, action, appId, clientGroupId, enableTimeZone, enableTime, UNCenableTime, instanceId, reason)
	Values(Src.clientId, 1, 0, 4, 1, 1, 0, 0, 0, 0, 1, 'Disabling backup activity till laptop cloud mode sync is done.');
	DECLARE @clientId INT
	DECLARE @clientInstallPkgReq XML
	DECLARE @clientInstallPkgResp XML
	SET @errorCode = 0
	SET @errorString = N''
	IF (SELECT count(clientId) FROM @tempClientPkgId) >=1
	BEGIN
		SET @clientInstallPkgReq = (SELECT 0 AS'@checkAndRemoveInstalledPackage',(
											SELECT clientId AS 'client/@clientId',
											packageId AS 'packageInfoList/@packageId'FROM @tempClientPkgId
											FOR XML PATH('reqList'),TYPE)
											FOR XML PATH('JobManager_ClientPackageReqList'), TYPE)
		BEGIN
			if object_id('tempdb.dbo.#pushPkgResp') is not null DROP TABLE #pushPkgResp
			CREATE TABLE #pushPkgResp (
			val XML
			)
			EXEC JMPushPackagesWithOutputArg @clientInstallPkgReq, @clientInstallPkgResp output
		END
		DECLARE @responseTable TABLE (clientId INT,stat INT)
		INSERT INTO @responseTable
		SELECT  params.value('(client/ClientEntity/@clientId)[1]', 'int'),  params.value('(status)[1]','int')
			FROM  @clientInstallPkgResp.nodes ('JobManager_ClientPackageStatusResp/clientPackageStatusList
			/ClientPackageStatus') as R(params)
		IF (SELECT count(clientId) FROM @responseTable WHERE stat <> 0) >=1
		BEGIN
			SELECT @errorString = COALESCE(@errorString+',','') + CAST(clientId AS nvarchar) + ':' + CAST(stat AS nvarchar)  FROM @responseTable WHERE stat <> 0
			PRINT @errorString
		END
		ELSE
		BEGIN
SET @errorCode = 0
			SET @errorString = N'Package Install Request SUCCESS'
			PRINT @errorString
		END
		DECLARE @tblRsp TABLE(requestId INTEGER, rqGUID VARCHAR(1024))
		DECLARE @killXML XML
		DECLARE @wqXML XML
		SET @killXML = (SELECT
		1 as '@message',
		'Converting the client to Cloud laptop mode' as '@operationDescription',
		3 as 'jobOpReq/@operationType',
		jInfo.jobId as 'jobOpReq/jobs/@jobId'
		FROM JMJobInfo jInfo WITH(NOLOCK) INNER JOIN JMBkpJobInfo bkpInfo WITH(NOLOCK) ON jInfo.jobId = bkpInfo.jobId AND jInfo.commCellId = bkpInfo.commcellId AND jInfo.opType <> 116
				INNER JOIN APP_Application app WITH(NOLOCK) ON bkpInfo.applicationId = app.id
				INNER JOIN @responseTable resp ON resp.clientId = app.clientId AND resp.stat = 0 --Only request submitted clients
		FOR XML PATH('JobManager_PerformMultiCellJobOpReq'))
		IF @killXML IS NOT NULL -- there jobs to be killed
		BEGIN
			INSERT INTO @tblRsp
			exec AppSubmitXMLRequestForWQ @killXML,@i_uid,-1
			SET @wqXML = (SELECT requestId as '@requestId',
					rqGUID as '@GUID'
			FROM @tblRsp
			FOR XML PATH('App_AsyncXMLRequestInfo'))
			IF @wqXML IS NOT NULL
			BEGIN
				INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
				SELECT 2, 27,CONVERT(NVARCHAR(MAX),@wqXML),dbo.GetUnixTime(GETUTCDATE()),0,0,0,-1-- WORK_TOKEN_EXECUTE_XML_REQUEST
			END
		END
	END
	ELSE
	BEGIN
SET @errorCode = 2
		SET @errorString = 'Media agent setting not enabled OR all the client have the Media agent package installed'
		PRINT @errorString
	END
PROC_EXIT:
IF object_id('tempdb.dbo.#pushPkgResp') IS NOT NULL
    DROP TABLE #pushPkgResp
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   ;THROW;
END CATCH
END TRY
BEGIN CATCH
	SET @errorCode= ERROR_NUMBER()
	SET @errorString = N'DB Error : ' + ERROR_MESSAGE()
END CATCH
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppEnableCloudLaptopMode')
	delete from GxQscripts where name = 'AppEnableCloudLaptopMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEnableCloudLaptopMode')
	delete from GXDBVersions where aliasname = 'AppEnableCloudLaptopMode'
GO

insert into GXDBVersions values(2, 'AppEnableCloudLaptopMode',  '00000000000000000000', 'AppEnableCloudLaptopMode', '00000000000000000000')
GO

