

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEmailConfigPolicyAssocUpdateInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEmailConfigPolicyAssocUpdateInfo.sp,v $ $Id: AppEmailConfigPolicyAssocUpdateInfo.sp,v 1.1.4.49 2020/09/13 04:29:17 sgoel Exp $";
--	+===================================================================+
--	|  				AppEmailConfigPolicyAssocUpdateInfo					|
--	| Procedure for create/update a APP_EmailConfigPolicyAssoc table	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppEmailConfigPolicyAssocUpdateInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppEmailConfigPolicyAssocUpdateInfo <<<'
	drop procedure AppEmailConfigPolicyAssocUpdateInfo
END
IF EXISTS (select * from GxQscripts where name='AppEmailConfigPolicyAssocUpdateInfo')
	delete from GxQscripts where name = 'AppEmailConfigPolicyAssocUpdateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEmailConfigPolicyAssocUpdateInfo')
	delete from GXDBVersions where aliasname = 'AppEmailConfigPolicyAssocUpdateInfo'
GO
print '... Creating Procedure: AppEmailConfigPolicyAssocUpdateInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEmailConfigPolicyAssocUpdateInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			DATETIME = GETDATE()
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix		INT = DATEDIFF(second, '01/01/1970', @nowTime)
	DECLARE @origCCId			INT = 2
	DECLARE @subClientId		INT = 0
	DECLARE @dupSubClientId		INT
	DECLARE @backupSetId		INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @dupClientId		INT
	DECLARE @autoDiscover		INT
	DECLARE @userId				INT = 0
	DECLARE @discovered			INT = 0
	DECLARE @failedPolicyId		INT = 0
	DECLARE @localeId			INT = 0
	DECLARE @hasPermission		INT = 0
	DECLARE @isAdminUser		INT = 0
	DECLARE @emailStatus		INT = 0
	DECLARE @policyId			INT = 0
	DECLARE @policyType			INT = 0
	DECLARE @discoverByType		INT = 0
	DECLARE @planId				INT = -1
	DECLARE @planType			INT = 0
DECLARE @clientName			NVARCHAR(255)
DECLARE @smtpAddress		NVARCHAR(255)
DECLARE @dupSmtpAddress		NVARCHAR(255)
	DECLARE @brAlertTrace		AS varchar(256) = (select value from gxglobalParam Where name = 'bralertTrace')
	DECLARE @DISCOVERTYPE_USER				INT = 1
	DECLARE @DISCOVERTYPE_DATABASE			INT = 2
	DECLARE @DISCOVERTYPE_ADGROUPS			INT = 3
	DECLARE @DISCOVERTYPE_AUTO_DISCOVERED	INT = 4
	DECLARE @DISCOVERTYPE_MS_JOURNAL		INT = 5
	DECLARE @DISCOVERTYPE_CONTENTSTORE		INT = 6
	DECLARE @DISCOVERTYPE_ALL_JOURNAL		INT = 7
	DECLARE @POLICY_TYPE_ARCHIVE			INT = 1
	DECLARE @POLICY_TYPE_CLEANUP			INT = 2
	DECLARE @POLICY_TYPE_RETENTION			INT = 3
	DECLARE @POLICY_TYPE_JOURNAL			INT = 4
	DECLARE @POLICY_TYPE_CONTAINERS			INT = 6
DECLARE @PLAN_PROP_ARCHIVE				VARCHAR(255) = 'Exchange mailbox archiving policy'
DECLARE @PLAN_PROP_CLEANUP				VARCHAR(255) = 'Exchange mailbox cleanup policy'
DECLARE @PLAN_PROP_RETENTION			VARCHAR(255) = 'Exchange mailbox retention policy'
DECLARE @PLAN_PROP_JOURNAL				VARCHAR(255) = 'Exchange mailbox journal policy'
DECLARE @PLAN_PROP_CONTAINER            VARCHAR(255) = 'Data classification policy'
DECLARE @PLAN_PROP_ARCHIVE_O365			VARCHAR(255) = 'Office 365 Mailbox archive policy'
DECLARE @PLAN_PROP_CLEANUP_O365			VARCHAR(255) = 'Office 365 Mailbox cleanup policy'
DECLARE @PLAN_PROP_RETENTION_O365		VARCHAR(255) = 'Office 365 Mailbox retention policy'
	DECLARE @discoveryVersion				INT = 2 --sp12 onwards
	DECLARE @DELETED						INT = 1
	DECLARE @DISABLED						INT = 2
	DECLARE @DONOTARCHIVE					INT = 3
DECLARE @CONTENTSTORE_PROP_AUTOIPDETECTION_ATTRNAME			VARCHAR(255) = 'enableAutoIPDetection'
DECLARE @CONTENTSTORE_PROP_WHITELISTIPS_ATTRNAME			VARCHAR(255) = 'whiteListIPs'
DECLARE @CONTENTSTORE_PROP_CERTIFICATEFILE_ATTRNAME			VARCHAR(255) = 'certificateFile'
DECLARE @CONTENTSTORE_PROP_CERTIFICATENAME_ATTRNAME			VARCHAR(255) = 'certificateName'
DECLARE @CONTENTSTORE_PROP_PASSWORD_ATTRNAME				VARCHAR(255) = 'passwordSMTPProp'
DECLARE @CONTENTSTORE_PROP_AUTOIPDETECTION_ATTRTYPE			INT = 1
DECLARE @CONTENTSTORE_PROP_WHITELISTIPS_ATTRTYPE			INT = 2
DECLARE @CONTENTSTORE_PROP_CERTIFICATEFILE_ATTRTYPE			INT = 3
DECLARE @CONTENTSTORE_PROP_CERTIFICATENAME_ATTRTYPE			INT = 4
DECLARE @CONTENTSTORE_PROP_PASSWORD_ATTRTYPE				INT = 5
DECLARE @MailboxPropertiesset				INT = NULL
DECLARE @enableAutoIPDetection				INT = NULL
DECLARE @whiteListIPs						NVARCHAR(255) = NULL
DECLARE @certificateFile					NVARCHAR(255) = NULL
DECLARE @passwordSMTPProp					NVARCHAR(255) = NULL
DECLARE @certificateName					NVARCHAR(255) = NULL
	DECLARE @PLANTYPE_OFFICE365				INT = 100859937
	IF @brAlertTrace <> 0									-- Put a copy of input data to table TrackNotificationProcs
	BEGIN
		DECLARE @inputString		NVARCHAR(MAX) = CAST(@i_xmlString AS NVARCHAR(MAX))
		EXEC br_ntTrace '.. AppEmailConfigPolicyAssocUpdateInfo', 0, @nowTime, 0, 0, @inputString
	END
	DECLARE @policyTable		TABLE (policyId INT, policyType INT)
	SELECT
		 @userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'INT'),@userId),
		 @localeId = ISNULL(ref.value('(processinginstructioninfo/locale/@localeId)[1]', 'INT'),@localeId),
		 @subClientId = ISNULL(ref.value('(emailAssociation/subclientEntity/@subclientId)[1]', 'INT'),0),
		 @autoDiscover = ISNULL(ref.value('(emailAssociation/advanceOptions/@enableAutoDiscovery)[1]', 'INT'),@autoDiscover),
		 @discoverByType = ISNULL(ref.value('(emailAssociation/emailDiscoverinfo/@discoverByType)[1]', 'INT'),@discoverByType),
		 @discovered = ISNULL(ref.value('(@discovered)[1]', 'INT'),0),
		 @emailStatus = ISNULL(ref.value('(emailAssociation/@emailStatus)[1]', 'INT'),@emailStatus),
		 @planId = ISNULL(ref.value('(emailAssociation/plan/@planId)[1]', 'INT'),@planId)
    FROM @i_xmlString.nodes('Ida_UpdateEmailPolicyAssociationReq') R(ref)
	--Check for Agent Management permission
DECLARE @hasAgentManagementRole			INT = 0
DECLARE @agentManagementCapability      BIGINT = CAST(POWER(2.0, 2 - 1) AS BIGINT)
--Check for Agent Management permission
IF object_id('tempdb.dbo.#tempSecurityObjects') IS NOT null DROP TABLE #clientListTmp
create table  #tempSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
CREATE CLUSTERED INDEX #tempSecurityObjectsTable_clientId_subclientId_Index1 ON #tempSecurityObjects (clientId, subClientId)
EXEC sec_getUserObjects @userId, 2013, @subClientId, '#tempSecurityObjects'
SELECT @hasAgentManagementRole = 1 FROM #tempSecurityObjects sec WHERE ( sec.capabilities & @agentManagementCapability <> 0  )
IF object_id('tempdb.dbo.#tempSecurityObjects') IS NOT NULL
	DROP TABLE #tempSecurityObjects
	IF @hasAgentManagementRole = 0
	BEGIN
SET @errorCode = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	CREATE TABLE #output_PolicyAssocTable
				(assocId INT, userGuid VARCHAR(40), mailBoxType INT, subclientId INT)
	CREATE CLUSTERED INDEX #output_PolicyAssocTable_assocId_userGuid_Index1 ON #output_PolicyAssocTable ([assocId], [userGuid])
	-- Create table for storeing and processing the ContentStoreMailBox Properties
	IF object_id('tempdb.dbo.#contentStore_mailbox_properties') is not null
		DROP TABLE #contentStore_mailbox_properties
	CREATE TABLE #contentStore_mailbox_properties
(componenetNameId_t INT, attrName_t NVARCHAR(255), attrType_t INT, attrVal_t NVARCHAR(255))
	CREATE CLUSTERED INDEX #contentStoreMailboxProperties_componenetNameId_t_attrType_t_Index1 ON #contentStore_mailbox_properties ([componenetNameId_t], [attrType_t])
	--CREATE TEMP TABLE TO INSERT XML INPUT
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocXMLTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocXMLTable
	CREATE TABLE #emailConfiguration_PolicyAssocXMLTable
(assocId INT, userGuid VARCHAR(40) NULL, csUserGuid VARCHAR(40) NULL, displayName NVARCHAR(255) NULL DEFAULT '', csDisplayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', csAliasName NVARCHAR(255) NULL DEFAULT '',
smtpAdrress NVARCHAR(255) NULL DEFAULT '', csSmtpAdrress NVARCHAR(255) NULL DEFAULT '', databaseName NVARCHAR(1024) NULL DEFAULT '', dbDatabaseName NVARCHAR(1024) NULL DEFAULT '',
exchangeServer NVARCHAR(1024) NULL DEFAULT '', dbExchangeServer NVARCHAR(1024) NULL DEFAULT '', adGroupName NVARCHAR(1024) NULL DEFAULT '', discoverByType INT NULL, isAutoDiscovered INT NULL,
mailBoxType INT NULL, csMailBoxType INT NULL, emailStatus INT NULL, deleted INT, autoDiscover INT, associated INT, attrVal NVARCHAR(MAX), password NVARCHAR(400), mailBoxSize BIGINT, description NVARCHAR(MAX),
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT,backupRefTime BIGINT, indexCollectionTime BIGINT, nEmails BIGINT)
	CREATE CLUSTERED INDEX #emailConfiguration_PolicyAssocXMLTable_userGuid_discoverByType_assocId_Index1 ON #emailConfiguration_PolicyAssocXMLTable ([userGuid], [csUserGuid], [discoverByType], [assocId])
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocTable
	CREATE TABLE #emailConfiguration_PolicyAssocTable
(assocId INT, userGuid VARCHAR(40) DEFAULT NEWID(), displayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', smtpAdrress NVARCHAR(255) NULL DEFAULT '', databaseName NVARCHAR(1024) NULL DEFAULT '',
exchangeServer NVARCHAR(1024) NULL DEFAULT '', adGroupName NVARCHAR(1024) NULL DEFAULT '', discoverByType INT NULL DEFAULT 0, isAutoDiscovered INT NULL DEFAULT 0, mailBoxType INT,
emailStatus INT NULL DEFAULT 0, deleted INT, autoDiscover INT, associated INT DEFAULT 0, attrVal NVARCHAR(MAX), password NVARCHAR(400), mailBoxSize BIGINT, description NVARCHAR(MAX),
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT,backupRefTime BIGINT, indexCollectionTime BIGINT, nEmails BIGINT)
	CREATE CLUSTERED INDEX #emailConfiguration_PolicyAssocTable_userGuid_discoverByType_assocId_Index1 ON #emailConfiguration_PolicyAssocTable ([userGuid], [discoverByType], [assocId])
	--CREATE TEMP TABLE TO INSERT VALUES IN DB
	IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
		DROP TABLE #emailConfiguration_CompareTable
	CREATE TABLE #emailConfiguration_CompareTable
(assocId INT, userGuid VARCHAR(40), displayName NVARCHAR(255), aliasName NVARCHAR(255), smtpAdrress NVARCHAR(255), databaseName NVARCHAR(1024) NULL,
exchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, deleteIt INT DEFAULT 0, mailboxType INT, discoverByType INT, emailStatus INT, deleted INT, clientId INT, backupsetId INT,
subclientId INT, autoDiscover INT, coreId INT DEFAULT 0, password NVARCHAR(400), mailBoxSize BIGINT, description NVARCHAR(MAX), planId INT DEFAULT 0,
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT,backupRefTime BIGINT, indexCollectionTime BIGINT, nEmails BIGINT)
	CREATE CLUSTERED INDEX #emailConfiguration_CompareTable_userGuid_assocId_subclientId_Index1 ON #emailConfiguration_CompareTable ([userGuid], [assocId], [subclientId])
	IF @planId > 0
	BEGIN
		Select @planType = subType from App_Plan(NOLOCK) where id = @planId and modified = 0
		IF @planType = @PLANTYPE_OFFICE365
		BEGIN
			INSERT INTO @policyTable
			SELECT CAST(attrVal AS INT) policyId,
				CASE attrName
					WHEN @PLAN_PROP_ARCHIVE_O365 THEN @POLICY_TYPE_ARCHIVE
					WHEN @PLAN_PROP_CLEANUP_O365 THEN @POLICY_TYPE_CLEANUP
					WHEN @PLAN_PROP_RETENTION_O365 THEN @POLICY_TYPE_RETENTION
					WHEN @PLAN_PROP_CONTAINER THEN @POLICY_TYPE_CONTAINERS
				END policyType
			FROM App_PlanProp (NOLOCK)
			WHERE attrName IN (@PLAN_PROP_ARCHIVE_O365, @PLAN_PROP_CLEANUP_O365, @PLAN_PROP_RETENTION_O365, @PLAN_PROP_CONTAINER)
			AND componentNameId = @planId
AND attrType = 7
			AND modified = 0
		END
		ELSE
		BEGIN
			INSERT INTO @policyTable
			SELECT CAST(attrVal AS INT) policyId,
				CASE attrName
					WHEN @PLAN_PROP_ARCHIVE THEN @POLICY_TYPE_ARCHIVE
					WHEN @PLAN_PROP_CLEANUP THEN @POLICY_TYPE_CLEANUP
					WHEN @PLAN_PROP_RETENTION THEN @POLICY_TYPE_RETENTION
					WHEN @PLAN_PROP_JOURNAL THEN @POLICY_TYPE_JOURNAL
					WHEN @PLAN_PROP_CONTAINER THEN @POLICY_TYPE_CONTAINERS
				END policyType
			FROM App_PlanProp (NOLOCK)
			WHERE attrName IN (@PLAN_PROP_ARCHIVE, @PLAN_PROP_CLEANUP, @PLAN_PROP_RETENTION, @PLAN_PROP_JOURNAL, @PLAN_PROP_CONTAINER)
			AND componentNameId = @planId
AND attrType = 7
			AND modified = 0
		END
	END
	ELSE IF @planId = 0
	BEGIN
		--This will reset policies assigned to mailbox as planId in request is 0
		INSERT INTO @policyTable VALUES
			(0 , @POLICY_TYPE_ARCHIVE),
			(0 , @POLICY_TYPE_CLEANUP),
			(0 , @POLICY_TYPE_RETENTION),
			(0 , @POLICY_TYPE_JOURNAL),
			(0 , @POLICY_TYPE_CONTAINERS)
	END
	ELSE
	BEGIN
		SET @planId = 0	--reset planId to 0
		INSERT INTO @policyTable
		SELECT pe.value('@policyId', 'INT') policyId, dt.value('@emailPolicyType', 'INT') policyType
		FROM    @i_xmlString.nodes('Ida_UpdateEmailPolicyAssociationReq/emailAssociation/policies/emailPolicies') R(ref)
		CROSS APPLY ref.nodes('./detail/emailPolicy') D(dt)
		CROSS APPLY ref.nodes('./policyEntity') P(pe)
	END
	SELECT @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupSetId=backupSet, @origCCId=origCCId
	FROM APP_Application (READUNCOMMITTED) WHERE id = @subClientId
	IF @discoverByType = @DISCOVERTYPE_USER  --EmailDiscoverByType_USER
	BEGIN
	INSERT #emailConfiguration_PolicyAssocXMLTable (assocId, userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, discoverByType, isAutoDiscovered,
	mailBoxType, emailStatus, deleted, autoDiscover, associated, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails)
		SELECT	0,
			mb.value('user[1]/@userGUID', 'NVARCHAR(MAX)') userGuid,
			mb.value('@displayName', 'NVARCHAR(MAX)') displayName,
			mb.value('@aliasName', 'NVARCHAR(MAX)') aliasName,
			mb.value('@smtpAdrress', 'NVARCHAR(MAX)') smtpAdrress,
			NULLIF(mb.value('@databaseName', 'NVARCHAR(MAX)'),'')databaseName,
			NULLIF(mb.value('@exchangeServer', 'NVARCHAR(MAX)'),'') exchangeServer,
			@discoverByType,
			mb.value('@isAutoDiscoveredUser', 'INT') isAutoDiscoveredUser,
			mb.value('@mailBoxType', 'NVARCHAR(MAX)') mailBoxType,
			--mp.query('./emailPolicies') policies,
			@emailStatus,
			CASE WHEN @emailStatus = 1 THEN 1 ELSE 0 END deleted,
			@autoDiscover,
			mb.value('@associated', 'INT') associated,
			mb.value('@objectGuid', 'NVARCHAR(MAX)') objectGuid,
			mb.value('@azureGuid', 'NVARCHAR(MAX)') azureGuid,
			mb.value('@immutableId', 'NVARCHAR(MAX)') immutableId,
			ISNULL(mb.value('@exchangeVersion', 'INT'),0) exchangeVersion,
			ISNULL(mb.value('@msExchRecipientTypeDetails','INT'),0) msExchRecipientTypeDetails
		FROM @i_xmlString.nodes ('Ida_UpdateEmailPolicyAssociationReq/emailAssociation/emailDiscoverinfo/mailBoxes') M(mb)
	END
	ELSE
	BEGIN
		INSERT #emailConfiguration_PolicyAssocXMLTable (assocId, userGuid, csUserGuid, displayName, csDisplayName, aliasName, csAliasName, smtpAdrress, csSmtpAdrress, databaseName, dbDatabaseName,
            exchangeServer, dbExchangeServer,adGroupName, discoverByType, isAutoDiscovered, mailBoxType, csMailBoxType, emailStatus, deleted, autoDiscover, associated, exchangeVersion, attrVal)
		SELECT  0,
			mb.value('user[1]/@userGUID', 'NVARCHAR(MAX)') userGuid,
			cs.value('user[1]/@userGUID', 'NVARCHAR(MAX)') csUserGuid,
			mb.value('@displayName', 'NVARCHAR(MAX)') displayName,
			cs.value('@displayName', 'NVARCHAR(MAX)') csDisplayName,
			mb.value('@aliasName', 'NVARCHAR(MAX)') aliasName,
			cs.value('@aliasName', 'NVARCHAR(MAX)') csAliasName,
			mb.value('@smtpAdrress', 'NVARCHAR(MAX)') smtpAdrress,
			cs.value('@smtpAdrress', 'NVARCHAR(MAX)') csSmtpAdrress,
			mb.value('@databaseName', 'NVARCHAR(MAX)') databaseName,
			db.value('@databaseName', 'NVARCHAR(MAX)') dbDatabaseName,
			mb.value('@exchangeServer', 'NVARCHAR(MAX)') exchangeServer,
			db.value('@exchangeServer', 'NVARCHAR(MAX)') dbExchangeServer,
			ag.value('@adGroupName', 'NVARCHAR(MAX)') adGroupName,
			ed.value('@discoverByType', 'INT') discoverByType,
			mb.value('@isAutoDiscoveredUser', 'INT') isAutoDiscoveredUser,
			mb.value('@mailBoxType', 'NVARCHAR(MAX)') mailBoxType,
			cs.value('@mailBoxType', 'NVARCHAR(MAX)') csMailBoxType,
			--mp.query('./emailPolicies') policies,
			ref.value('@emailStatus', 'INT') emailStatus,
			CASE WHEN ref.value('@emailStatus', 'INT') = 1 THEN 1 ELSE 0 END deleted,
			op.value('@enableAutoDiscovery', 'INT') autoDiscover,
			mb.value('@associated', 'INT') associated,
			ISNULL(mb.value('@exchangeVersion', 'INT'),0) exchangeVersion,
			CAST(cs.query('./contentStoreClients') AS NVARCHAR(MAX)) attrVal
		FROM @i_xmlString.nodes ('Ida_UpdateEmailPolicyAssociationReq/emailAssociation') R(ref)
		OUTER APPLY ref.nodes('./emailDiscoverinfo') I(ed)
		OUTER APPLY ed.nodes('./mailBoxes') M(mb)
		OUTER APPLY ed.nodes('./databases') D(db)
		OUTER APPLY ed.nodes('./adGroups') G(ag)
		OUTER APPLY ed.nodes('./contentStoreMailboxes') S(cs)
		OUTER APPLY ref.nodes('./advanceOptions') O(op)
		--SELECT
		--@MailboxPropertiesset = ISNULL(ref.value('(contentStoreMailboxes/@isMailboxPropertiesset)[1]', 'INT'),@MailboxPropertiesset)
		--FROM    @i_xmlString.nodes('Ida_UpdateEmailPolicyAssociationReq/emailAssociation/emailDiscoverinfo/') R(ref)
		--IF @MailboxPropertiesset = 1  -- Email Content StoreMailBox Properties
		BEGIN
			SELECT
				@enableAutoIPDetection	= ISNULL(ref.value('(@enableAutoIPDetection)[1]', 'INT'),@enableAutoIPDetection),
				@whiteListIPs = ISNULL(ref.value('(@whiteListIPs)[1]', 'NVARCHAR(MAX)'),@whiteListIPs),
				@certificateFile = ISNULL(ref.value('(@certificateFile)[1]', 'NVARCHAR(MAX)'),@certificateFile),
				@passwordSMTPProp = ISNULL(ref.value('(@passwordSMTPProp)[1]', 'NVARCHAR(MAX)'),@passwordSMTPProp),
				@certificateName = ISNULL(ref.value('(@certificateName)[1]', 'NVARCHAR(MAX)'),@certificateName)
			FROM @i_xmlString.nodes('Ida_UpdateEmailPolicyAssociationReq/emailAssociation/emailDiscoverinfo/contentStoreMailboxes') R(ref)
			IF @enableAutoIPDetection IS NOT NULL
				INSERT INTO #contentStore_mailbox_properties (componenetNameId_t,attrName_t,attrType_t,attrVal_t) values(0,@CONTENTSTORE_PROP_AUTOIPDETECTION_ATTRNAME,@CONTENTSTORE_PROP_AUTOIPDETECTION_ATTRTYPE,@enableAutoIPDetection)
			IF @whiteListIPs IS NOT NULL
				INSERT INTO #contentStore_mailbox_properties (componenetNameId_t,attrName_t,attrType_t,attrVal_t) values(0,@CONTENTSTORE_PROP_WHITELISTIPS_ATTRNAME, @CONTENTSTORE_PROP_WHITELISTIPS_ATTRTYPE, @whiteListIPs)
			IF @certificateFile IS NOT NULL
				INSERT INTO #contentStore_mailbox_properties (componenetNameId_t,attrName_t,attrType_t,attrVal_t) values(0,@CONTENTSTORE_PROP_CERTIFICATEFILE_ATTRNAME,@CONTENTSTORE_PROP_CERTIFICATEFILE_ATTRTYPE,@certificateFile)
			IF @certificateName IS NOT NULL
				INSERT INTO #contentStore_mailbox_properties (componenetNameId_t,attrName_t,attrType_t,attrVal_t) values(0,@CONTENTSTORE_PROP_CERTIFICATENAME_ATTRNAME,@CONTENTSTORE_PROP_CERTIFICATENAME_ATTRTYPE,@certificateName)
			IF @passwordSMTPProp IS NOT NULL
				INSERT INTO #contentStore_mailbox_properties (componenetNameId_t,attrName_t,attrType_t,attrVal_t) values(0,@CONTENTSTORE_PROP_PASSWORD_ATTRNAME,@CONTENTSTORE_PROP_PASSWORD_ATTRTYPE,@passwordSMTPProp)
		END
	END
	INSERT #emailConfiguration_PolicyAssocTable (assocId, userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
			emailStatus, deleted, autoDiscover, associated, attrVal, password, mailBoxSize, description, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails)
	SELECT	0, ISNULL(CASE WHEN userGuid IS NULL THEN csUserGuid
			ELSE userGuid END, '') userGuid,
		CASE WHEN displayName IS NULL THEN csDisplayName
			ELSE displayName END displayName,
		CASE WHEN aliasName IS NULL THEN csAliasName
			ELSE aliasName END aliasName,
		CASE WHEN smtpAdrress IS NULL THEN csSmtpAdrress
			ELSE smtpAdrress END smtpAdrress,
		CASE WHEN databaseName IS NULL THEN dbDatabaseName
			ELSE databaseName END databaseName,
		CASE WHEN exchangeServer IS NULL THEN dbExchangeServer
			ELSE exchangeServer END exchangeServer,
		adGroupName,
		discoverByType,
		isAutoDiscovered,
		CASE WHEN mailBoxType IS NULL THEN csMailBoxType
			ELSE mailBoxType END mailBoxType,
		--mp.query('./emailPolicies') policies,
		ISNULL(emailStatus, 0),
		deleted,
		autoDiscover,
		associated,
		attrVal,
		password,
		mailBoxSize,
		description,
		objectGuid,
		azureGuid,
		immutableId,
		exchangeVersion,
		msExchRecipientTypeDetails
	FROM #emailConfiguration_PolicyAssocXMLTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocXMLTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocXMLTable
	--CHANGE DISCOVER TO MANUAL WHEN ADDING POLICIES WHERE THERE ARE NONE
	UPDATE #emailConfiguration_PolicyAssocTable
	SET autoDiscover = 0,
	@autoDiscover = 0
	WHERE  @autoDiscover IS NULL	--MAYBE WE ONLY NEED TO DO THIS CHECK
	--AND EXISTS(SELECT 1 FROM @policyTable)
	--AND NOT EXISTS (SELECT 1 FROM APP_EmailConfigPolicies WHERE componentNameId = assocId)
	IF @emailStatus = 1		--EmailStatusType.DELETED
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
										mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, password, mailBoxSize, description,
										objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails, backupRefTime, indexCollectionTime, nEmails)
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, ISNULL(EA.exchangeServer,''), ISNULL(EA.databaseName,''), EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, EA.status, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.backupReferenceTime, EA.IdxCollectionTime, EA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON CP.userGuid = EA.userGuid AND EA.modified = 0 AND EA.subClientId = @subClientId AND EA.displayName = CP.displayName
		AND (EA.discoverByType = @DISCOVERTYPE_USER OR EA.discoverByType =  @DISCOVERTYPE_MS_JOURNAL ) AND LEN(EA.userGuid) > 0
		UNION
		SELECT DISTINCT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, ISNULL(EA.exchangeServer,''), ISNULL(EA.databaseName,''), EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, EA.status, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.backupReferenceTime, EA.IdxCollectionTime, EA.numberOfEmails
			FROM #emailConfiguration_PolicyAssocTable CP
			JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON CP.userGuid = EA.userGuid AND EA.subClientId = @subClientId
			INNER JOIN ( SELECT max(modified)as modified, min(modified)as activeAssociation, aliasName from APP_EmailConfigPolicyAssoc(READUNCOMMITTED)
			WHERE subClientId=@subClientId and (discoverByType= @DISCOVERTYPE_USER OR discoverByType =  @DISCOVERTYPE_MS_JOURNAL) GROUP BY aliasName) AS DS
			ON DS.activeAssociation != 0 AND DS.aliasName =  EA.aliasName AND DS.Modified=EA.modified
		UNION
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, EA.status, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.backupReferenceTime, EA.IdxCollectionTime, EA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON CP.databaseName = EA.databaseName AND CP.exchangeServer = EA.exchangeServer AND EA.subClientId = @subClientId
		 AND EA.modified = 0 AND EA.discoverByType = @DISCOVERTYPE_DATABASE AND LEN(EA.databaseName) > 0
		UNION
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, EA.status, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.backupReferenceTime, EA.IdxCollectionTime, EA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON CP.adGroupName = EA.adGroupName AND EA.modified = 0 AND EA.subClientId = @subClientId
		AND EA.discoverByType = @DISCOVERTYPE_ADGROUPS AND LEN(EA.adGroupName) > 0
	END
	ELSE
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
										mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, password, mailBoxSize,
										description, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails, planId, backupRefTime,indexCollectionTime,nEmails)
		--ADD EXISTING ENTRIES FOR THE INPUT SUBLCIENT
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, EA.status, EA.deleted, EA.clientId, EA.backupsetId, EA.subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.planId, EA.backupReferenceTime, EA.IdxCollectionTime, EA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON CP.userGuid = EA.userGuid AND EA.modified = 0 AND EA.subClientId = @subClientId
		AND LEN(EA.userGuid) > 0
		UNION
		--ADD NEW ENTRIES
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, 0, EA.deleted, 0, 0, @subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, @planId,EA.backupRefTime, EA.indexCollectionTime, EA.nEmails
		FROM #emailConfiguration_PolicyAssocTable EA
		WHERE @discoverByType IN ( @DISCOVERTYPE_CONTENTSTORE, @DISCOVERTYPE_USER)
		AND NOT EXISTS(SELECT 1 FROM APP_EmailConfigPolicyAssoc (READUNCOMMITTED) PA WHERE PA.modified = 0 AND PA.userGuid = EA.userGuid AND PA.subClientId = @subClientId AND EA.discoverByType IN ( @DISCOVERTYPE_CONTENTSTORE, @DISCOVERTYPE_USER))
		AND LEN(EA.userGuid) > 0
		UNION
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		EA.mailBoxType, EA.discoverByType, EA.status, EA.deleted, EA.clientId, EA.backupsetId, EA.subClientId, EA.autoDiscover, EA.password, EA.mailBoxSize, EA.description,
		EA.objectGuid, EA.azureGuid, EA.immutableId, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.planId, EA.backupReferenceTime, EA.IdxCollectionTime, EA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON @discoverByType = @DISCOVERTYPE_CONTENTSTORE AND CP.userGuid = EA.userGuid AND EA.modified = 0 AND EA.subClientId <> @subClientId
		AND LEN(EA.userGuid) > 0
	END
	UPDATE #emailConfiguration_PolicyAssocTable SET userGuid = REPLACE(NEWID(), '-', '')
	WHERE mailBoxType = 3	--MailboxType.SMTP_MAILBOXES
	AND LEN(userGuid) = 0
    --UPDATE MAILBOX STATS FROM LAST SEEN
	Update #emailConfiguration_CompareTable
	SET mailBoxSize = T.mailboxSize,
	backupRefTime = T.backupReferenceTime,
	nEmails = T.numberofEmails,
	indexCollectionTime = T.IdxCollectionTime
	FROM (
		SELECT userGuid, max(mailboxSize) as mailboxSize, max(backupReferenceTime) as backupReferenceTime ,
		max(numberofEmails) as numberofEmails, max(IdxCollectionTime) as IdxCollectionTime FROM APP_EmailConfigPolicyAssoc (NOLOCK)
		WHERE mailBoxType = 1 AND subclientId = @subclientId
		AND userGuid IN (SELECT userGuid FROM  #emailConfiguration_PolicyAssocTable)
		GROUP by userGuid
	)T
	WHERE #emailConfiguration_CompareTable.userGuid = T.userGuid
	--POPULATE INFO NOT FOUND IN DB SINCE THIS TABLE SINCE IT IS THE ONE USED ON MERGE STATEMENT.
	IF @emailStatus = 1		--EmailStatusType.DELETED
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
												mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, password, mailBoxSize, description, backupRefTime, indexCollectionTime,nEmails)
		SELECT ISNULL(PA.assocId, 0), PT.userGuid, PT.displayName, PT.aliasName, PT.smtpAdrress, PT.exchangeServer, PT.databaseName, PT.adGroupName,
						PT.mailBoxType, PT.discoverByType, status, ISNULL(PA.deleted, 0), 0, 0, PA.subClientId, PA.autoDiscover, PA.password, PA.mailBoxSize, PA.description, PA.backupReferenceTime, PA.IdxCollectionTime, PA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable PT
		JOIN APP_EmailConfigPolicyAssoc PA (READUNCOMMITTED) ON PA.userGuid = PT.userGuid AND PA.subClientId = @subClientId
		WHERE PT.discoverByType = @DISCOVERTYPE_CONTENTSTORE
		AND PT.mailBoxType = 3				--MailboxType_SMTP_MAILBOXES
		AND NOT EXISTS (SELECT 1 FROM #emailConfiguration_CompareTable CP WHERE CP.userGuid = PT.userGuid)
	END
	ELSE
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
												mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, password, mailBoxSize, description, planId, backupRefTime, indexCollectionTime, nEmails)
		SELECT ISNULL(PA.assocId, 0), PT.userGuid, PT.displayName, PT.aliasName, PT.smtpAdrress, PT.exchangeServer, PT.databaseName, PT.adGroupName,
						PT.mailBoxType, PT.discoverByType, status, ISNULL(PA.deleted, 0), 0, 0, PA.subClientId, PA.autoDiscover, PA.password, PA.mailBoxSize, PA.description, PA.planId, PA.backupReferenceTime, PA.IdxCollectionTime, PA.numberOfEmails
		FROM #emailConfiguration_PolicyAssocTable PT
		LEFT OUTER JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) PA ON PA.userGuid = PT.userGuid --AND PA.subClientId = @subClientId
		WHERE PT.discoverByType = @DISCOVERTYPE_CONTENTSTORE
		AND PT.mailBoxType = 3				--MailboxType_SMTP_MAILBOXES
		AND NOT EXISTS (SELECT 1 FROM #emailConfiguration_CompareTable CP WHERE CP.userGuid = PT.userGuid)
	END
	--CHECK IF SUBCLIENT HAS THE ASSOCIATION. DO NOT UPDATE FOR DISCOVERED CONTENT STORED SINCE IT WILL NOT HAVE AN ENTRY BUT INFO WILL BE IN TABLE
	IF EXISTS(SELECT * FROM #emailConfiguration_CompareTable WHERE subclientId = @subClientId)
	BEGIN
		--REMOVE ENTRIES WHICH ARE ALREADY IN TABLE AND POLICY MATCH INPUT
		IF @discoverByType = @DISCOVERTYPE_CONTENTSTORE
		BEGIN
			UPDATE #emailConfiguration_CompareTable
			SET deleteIt = 1
			FROM #emailConfiguration_CompareTable CP
			JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
			AND CP.displayName = CT.displayName
			AND CP.smtpAdrress = CT.smtpAdrress
			AND CP.emailStatus = CT.emailStatus
			AND CP.mailboxType = CT.mailBoxType
			AND CP.discoverByType = CT.discoverByType
			AND CP.discoverByType = @DISCOVERTYPE_CONTENTSTORE
			AND CP.assocId <> 0
			AND CP.planId = @planId
		END
		ELSE
		BEGIN
			UPDATE #emailConfiguration_CompareTable
			SET deleteIt = 1
			FROM #emailConfiguration_CompareTable CP
			JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
			AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress
			AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
			AND (CP.autoDiscover = @autoDiscover OR @autoDiscover IS NULL)
			AND CP.emailStatus = CT.emailStatus
			AND CP.mailboxType = CT.mailBoxType
			AND CP.discoverByType = CT.discoverByType
			AND CP.discoverByType <> @DISCOVERTYPE_CONTENTSTORE
			AND CP.assocId <> 0
			AND CP.planId = @planId
			AND CP.exchangeVersion = CT.exchangeVersion
			AND CP.msExchRecipientTypeDetails = CT.msExchRecipientTypeDetails
			AND NOT EXISTS( SELECT 1 FROM @policyTable PT
					JOIN APP_EmailConfigPolicies (READUNCOMMITTED) EP ON EP.componentNameId = CP.assocId AND EP.modified = 0 AND PT.policyId <> EP.policyId AND PT.policyType = EP.policyType
			)
		END
		--DELETE THE ENTRIES MARKED FOR DELETION
		DELETE #emailConfiguration_PolicyAssocTable
		FROM #emailConfiguration_PolicyAssocTable CT
		WHERE NOT EXISTS(
			SELECT 1 FROM #emailConfiguration_CompareTable CP
			WHERE CT.userGuid = CP.userGuid
			AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress
			AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
			AND deleteIt = 0
		)
		AND EXISTS(
			SELECT 1 FROM #emailConfiguration_CompareTable CP
			WHERE CT.userGuid = CP.userGuid
			AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName --AND CP.smtpAdrress = CT.smtpAdrress
			AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
		)
		AND NOT EXISTS(SELECT 1 FROM @policyTable)	--IF POLICY CHANGED THEN WE NEED TO AGE EXISTING ENTRY AND CREATE NEW ONE
		AND discoverByType = @DISCOVERTYPE_USER
		--UPDATE WITH EXISTING POLICY VALUES
		IF @discoverByType = @DISCOVERTYPE_CONTENTSTORE
		BEGIN
			UPDATE #emailConfiguration_CompareTable
			SET emailStatus = CT.emailStatus,
			displayName = CT.displayName,
			smtpAdrress = CT.smtpAdrress,
			deleted = CASE WHEN CT.emailStatus <> 1 OR CT.emailStatus IS NULL THEN 0 ELSE 1 END,
			password = CT.password,
			--mailBoxSize = CT.mailBoxSize,
			description = CT.description
			FROM #emailConfiguration_CompareTable CP
			JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
			AND CT.discoverByType = @DISCOVERTYPE_CONTENTSTORE
			AND CT.mailBoxType = 3			--MailboxType_SMTP_MAILBOXES
			AND CP.subclientId = @subclientId
		END
		ELSE
		BEGIN
			UPDATE #emailConfiguration_CompareTable
			SET emailStatus = CT.emailStatus,
			aliasName = CT.aliasName,
			displayName = CT.displayName,
			smtpAdrress = CT.smtpAdrress,
			deleted = CASE WHEN CT.emailStatus <> 1 OR CT.emailStatus IS NULL THEN 0 ELSE 1 END,
			password = CT.password,
			--mailBoxSize = CT.mailBoxSize,
			exchangeVersion = CT.exchangeVersion,
			msExchRecipientTypeDetails = CT.msExchRecipientTypeDetails,
			description = CT.description,
			exchangeServer = CT.exchangeServer,
			databaseName = CT.databaseName
			FROM #emailConfiguration_CompareTable CP
			JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
			--AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress
			--AND (CP.exchangeServer = CT.exchangeServer OR (CP.exchangeServer IS NULL AND CT.exchangeServer IS NULL))
			--AND (CP.databaseName = CT.databaseName OR (CP.databaseName IS NULL AND  CT.databaseName IS NULL))
			AND CT.discoverByType <> @DISCOVERTYPE_CONTENTSTORE
			AND CT.mailBoxType <> 3			--MailboxType_SMTP_MAILBOXES
		END
		--UPDATE WITH EXISTING POLICY VALUES FOR CONTENT STORE IN OTHER SUBCLIENTS
		IF @discoverByType = @DISCOVERTYPE_CONTENTSTORE
		BEGIN
			UPDATE #emailConfiguration_CompareTable
			SET displayName = CT.displayName,
			smtpAdrress = CT.smtpAdrress,
			password = CT.password,
			mailBoxSize = CT.mailBoxSize,
			description = CT.description
			FROM #emailConfiguration_CompareTable CP
			JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
			AND CT.discoverByType = @DISCOVERTYPE_CONTENTSTORE
			AND CT.mailBoxType = 3			--MailboxType_SMTP_MAILBOXES
			AND CP.subclientId <> @subclientId
		END
		UPDATE #emailConfiguration_CompareTable
		SET clientId = T.clientId,
		backupsetId = T.backupSet
		FROM
		(
			SELECT AP.clientId, AP.backupSet
			FROM #emailConfiguration_CompareTable CT
			JOIN APP_Application AP (READUNCOMMITTED) ON AP.id = CT.subclientId AND CT.clientId = 0
		) T
		IF @discoverByType = @DISCOVERTYPE_CONTENTSTORE
		BEGIN
			-- fetch the old data for contentstore mail box properties like (Certificate file & Password) in case of updating the mailbox
			UPDATE APP_EmailContentStoreMailBoxProperties
			SET modified = @nowUtcUnix
			FROM #emailConfiguration_CompareTable ECCT, #contentStore_mailbox_properties CMPT
			WHERE ECCT.assocId = componentNameId AND CMPT.attrType_t = attrType AND CMPT.attrVal_t IS NOT NULL AND attrVal <> CMPT.attrVal_t AND modified = 0
			INSERT INTO #contentStore_mailbox_properties (componenetNameId_t,attrName_t,attrType_t,attrVal_t)
			SELECT 0,T.attrName,T.attrType,T.attrVal
			FROM
			(
				SELECT CMP.attrName, CMP.attrType, CMP.attrVal
				FROM APP_EmailContentStoreMailBoxProperties CMP  (READUNCOMMITTED)
				JOIN #emailConfiguration_CompareTable ECT ON ECT.assocId = CMP.componentNameId AND CMP.attrVal IS NOT NULL AND CMP.modified = 0
			)T
			WHERE T.attrType NOT IN (SELECT attrType_t from #contentStore_mailbox_properties) AND T.attrVal IS NOT NULL;
		END
	END
	--ADD MISSING INFORMATION FOR NEW ENTRY ADDED BY DISCOVERY REQUEST
	UPDATE #emailConfiguration_CompareTable
	SET clientId = @clientId,
	backupsetId = @backupSetId,
	subclientId = @subClientId
	FROM
	(
		SELECT assocId assId
		FROM #emailConfiguration_CompareTable PT
		WHERE NOT EXISTS (SELECT 1 FROM #emailConfiguration_CompareTable CP WHERE CP.userGuid = PT.userGuid AND CP.subclientId = @subClientId AND CP.deleteIt = 0)
	) T
	WHERE assocId = T.assId
	AND clientId = 0
--
	SELECT TOP 1 @dupSubClientId = PA.subClientId, @dupClientId = PA.clientId, @dupSmtpAddress = PA.smtpAdrress
		FROM #emailConfiguration_CompareTable CT
		JOIN APP_EmailConfigPolicyAssoc PA (READUNCOMMITTED) ON PA.subClientId = CT.subclientId AND PA.smtpAdrress = CT.smtpAdrress AND modified = 0 AND PA.discoverByType = CT.discoverByType AND PA.mailBoxType = CT.mailboxType
		WHERE CT.userGuid <> PA.userGuid AND PA.mailBoxType = 3
	IF @dupSubClientId IS NOT NULL
	BEGIN
		SELECT @clientName = name
		FROM APP_Client (READUNCOMMITTED)
		WHERE id = @dupClientId
SET @errorCode = (2930 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT message FROM EvLocaleMsgs (READUNCOMMITTED) WHERE messageId = @errorCode AND localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @dupSmtpAddress)
		SET @errorString = REPLACE(@errorString, '^2%s', @clientName)
		GOTO ERROR_EXIT
	END
	BEGIN TRAN
		--FOR CONTENT STORED MAILBOXES UPDATE THE DISPLAY NAME/SMTP/MAILSERVER FOR ALL ENTRIES FOUND WITH THE SAME USER GUID
		--THE CONFIGURATION POLICY SHOULD ONLY BE CHANGED FOR THE ENTRY WHICH MATCHES THE SUBCLIENT IN THE REQUEST
		--AGE ASSOCIATIONS WHICH HAVE BEEN CHANGED OR MARKED DELETED
		--EmailDiscoverByType_USER
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT deleted, emailStatus, userGuid, subclientId, discoverByType, assocId
			FROM #emailConfiguration_CompareTable WHERE deleteIt = 0 --AND deleted = 0
		) EC
		WHERE EC.userGuid = APP_EmailConfigPolicyAssoc.userGuid
		AND APP_EmailConfigPolicyAssoc.subClientId = EC.subclientId
		AND APP_EmailConfigPolicyAssoc.discoverByType IN (@DISCOVERTYPE_USER, @DISCOVERTYPE_MS_JOURNAL, @DISCOVERTYPE_CONTENTSTORE)
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND APP_EmailConfigPolicyAssoc.assocId = EC.assocId
		--EmailDiscoverByType_DATABASE
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT databaseName, exchangeServer, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			WHERE discoverByType = @DISCOVERTYPE_DATABASE
		) EC
		WHERE EC.databaseName = APP_EmailConfigPolicyAssoc.databaseName
		AND EC.exchangeServer = APP_EmailConfigPolicyAssoc.exchangeServer
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_DATABASE
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		--EmailDiscoverByType_ADGROUPS
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT adGroupName, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			 WHERE discoverByType = @DISCOVERTYPE_ADGROUPS
		) EC
		WHERE EC.adGroupName = APP_EmailConfigPolicyAssoc.adGroupName
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_ADGROUPS
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		UPDATE #emailConfiguration_CompareTable
		SET coreId = ISNULL(ASCII(substring(userGuid, 1, 1)) +ASCII(substring(userGuid, 2, 1)) + ASCII(substring(userGuid, 3, 1)) +ASCII(substring(userGuid, 4, 1)) +
							ASCII(substring(userGuid, 5, 1)) +ASCII(substring(userGuid, 6, 1)) + ASCII(substring(userGuid, 7, 1)) +ASCII(substring(userGuid, 8, 1)) +
							ASCII(substring(userGuid, 9, 1)) +ASCII(substring(userGuid, 10, 1)) + ASCII(substring(userGuid, 11, 1)) +ASCII(substring(userGuid, 12, 1)) +
							ASCII(substring(userGuid, 13, 1)) +ASCII(substring(userGuid, 14, 1)) + ASCII(substring(userGuid, 15, 1)) +ASCII(substring(userGuid, 16, 1)) +
							ASCII(substring(userGuid, 17, 1)) +ASCII(substring(userGuid, 18, 1)) + ASCII(substring(userGuid, 19, 1)) +ASCII(substring(userGuid, 20, 1)) +
							ASCII(substring(userGuid, 21, 1)) +ASCII(substring(userGuid, 22, 1)) + ASCII(substring(userGuid, 23, 1)) +ASCII(substring(userGuid, 24, 1)) +
							ASCII(substring(userGuid, 25, 1)) +ASCII(substring(userGuid, 26, 1)) + ASCII(substring(userGuid, 27, 1)) +ASCII(substring(userGuid, 28, 1)) +
							ASCII(substring(userGuid, 29, 1)) +ASCII(substring(userGuid, 30, 1)) + ASCII(substring(userGuid, 31, 1)) +ASCII(substring(userGuid, 32, 1)) +
							ASCII(substring(userGuid, 33, 1)) +ASCII(substring(userGuid, 34, 1)) + ASCII(substring(userGuid, 35, 1)) +ASCII(substring(userGuid, 36, 1)), 0)%8
		--CONTENT STORE EMAILS ARE HANDLED DIFFERENTLY THANT OTHER EMAILS.  WHEN INFORMATION CHANGES ON ONE SUBCLIENT IT MUST BE UPDATED ON ALL ENTRIES FOR SUBCLIENTS
		--ONLY POLICY INFOMATION IS SUBCLIENT SPECIFIC
		IF @discoverByType = @DISCOVERTYPE_CONTENTSTORE
		BEGIN
			--INSERT NEW ASSOCIATIONS FOR ALL EXISTING SUBCLIENTS ALREADY PRESENT IN TABLE
			MERGE APP_EmailConfigPolicyAssoc EC
			USING
			(
				SELECT * FROM #emailConfiguration_CompareTable
				WHERE deleteIt = 0
				AND deleted = 0
				AND discoverByType = @DISCOVERTYPE_CONTENTSTORE
				AND mailBoxType = 3
			) AS PA ON PA.userGuid = EC.userGuid AND EC.subClientId = PA.subClientId AND EC.modified = 0
			WHEN NOT MATCHED THEN
				INSERT (userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
						clientId, backupsetId, subClientId, ownerId, created, modified, flags, status, deleted, autoDiscover, coreId, password, mailBoxSize, description, planId, discoveryVersion, backupReferenceTime,idxCollectionTime,numberOfEmails)
				VALUES(ISNULL(PA.userGuid, ''), PA.displayName, PA.aliasName, PA.smtpAdrress, PA.databaseName, PA.exchangeServer, PA.adGroupName, PA.discoverByType, @autoDiscover, PA.mailBoxType,
						PA.clientId, PA.backupsetId, PA.subClientId, @userId, @nowUtcUnix, 0, 0, ISNULL(PA.emailStatus, 0), PA.deleted, @autoDiscover, PA.coreId, PA.password, PA.mailBoxSize, PA.description, @planId, @discoveryVersion, PA.backupRefTime, PA.indexCollectionTime, PA.nEmails)
				OUTPUT INSERTED.assocId, INSERTED.userGuid, INSERTED.mailBoxType, INSERTED.subclientId INTO #output_PolicyAssocTable;
			SET @errorCode = @@ERROR
			IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
			--COPY THE POLICIES FOR THE NEW ASSOCIATIONS OF THE SUBCLIENTS NOT IN REQUEST
			INSERT INTO APP_EmailConfigPolicies
			(componentNameId, policyType, policyId, created, modified)
			SELECT OT.assocId, EP.policyType, EP.policyId, EP.created, 0
			FROM #emailConfiguration_CompareTable CP
			JOIN #output_PolicyAssocTable OT ON OT.userGuid = CP.userGuid AND OT.subclientId = CP.subclientId
			JOIN APP_EmailConfigPolicies EP ON EP.componentNameId = CP.assocId AND modified = 0
			--INSERT NEW CONTENT STORE CLIENTS FOR ALL EXISTING SUBCLIENTS ALREADY PRESENT IN TABLE
			INSERT INTO APP_ComponentProp
			(componentType, componentId, propertyTypeId, dataType, stringVal, longVal, longlongVal, created, modified)
			--ADD NEW ENTRIES THAT WERE ADDED TO APP_EmailConfigPolicyAssoc BECAUSE SOMETHING CHANGED
SELECT 12, --_CV_COMPONENT_TYPE_CONENTSTORE_PROP
			OT.assocId,
1160, --_CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
			1, --PROPERTY_STRING
			CT.stringVal, 0, 0, @nowUtcUnix, 0
			FROM #emailConfiguration_CompareTable CP
			JOIN #output_PolicyAssocTable OT ON OT.userGuid = CP.userGuid
			JOIN APP_ComponentProp CT ON CT.componentId = CP.assocId AND CT.modified = 0
AND CT.componentType = 1160		--_CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
AND CT.propertyTypeId = 1160		--_CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
			WHERE CP.mailBoxType = 3
			--AGE THE OLD POLICIES OF THE SUBCLIENTS
			UPDATE APP_EmailConfigPolicies
			SET modified = @nowUtcUnix
			FROM
			(
				SELECT CP.assocId
				FROM @policyTable PT, #emailConfiguration_CompareTable CP
				JOIN #output_PolicyAssocTable OT ON OT.userGuid = CP.userGuid AND OT.subclientId = CP.subclientId
			) EP
			WHERE modified = 0
			AND EP.assocId = componentNameId
			--Age the Old information for the ContentStoreMailbox Properties
			UPDATE APP_EmailContentStoreMailBoxProperties
			SET modified = @nowUtcUnix
			FROM
			(
				SELECT CP.assocId
				FROM #emailConfiguration_CompareTable CP
				JOIN #output_PolicyAssocTable OT ON OT.userGuid = CP.userGuid AND OT.subclientId = CP.subclientId
			) EP
			WHERE modified = 0
			AND  EP.assocId = componentNameId
			--AGE THE OLD CONTENT STORE CLIENTS OF THE SUBCLIENTS
			UPDATE APP_ComponentProp
			SET modified = @nowUtcUnix
			FROM
			(
				SELECT CT.assocId
				FROM #emailConfiguration_PolicyAssocTable PA
				JOIN #emailConfiguration_CompareTable CT ON CT.userGuid = PA.userGuid
				JOIN #output_PolicyAssocTable OT ON OT.subclientId = CT.subclientId AND OT.userGuid = CT.userGuid
			) T
			WHERE T.assocId = componentId
AND propertyTypeId = 1160	--_CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
AND componentType = 12				--_CV_COMPONENT_TYPE_CONENTSTORE_PROP
			AND modified = 0
		END
		ELSE
		BEGIN
			--INSERT NEW ASSOCIATIONS
			MERGE APP_EmailConfigPolicyAssoc EC
			USING
			(
				SELECT C.* FROM #emailConfiguration_CompareTable C
				WHERE deleteIt = 0
				AND deleted = 0
				AND discoverByType <> @DISCOVERTYPE_CONTENTSTORE
				AND mailBoxType <> 3
			) AS PA ON PA.userGuid = EC.userGuid AND EC.subClientId = @subClientId AND EC.modified = 0 AND PA.databaseName = EC.databaseName
			WHEN NOT MATCHED THEN
				INSERT (userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
							clientId, backupsetId, subClientId, ownerId, created, modified, flags, status, deleted, autoDiscover, coreId, password, mailBoxSize, description, planId, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails, discoveryVersion, backupReferenceTime,idxCollectionTime,numberOfEmails)
				VALUES(ISNULL(PA.userGuid, ''), PA.displayName, PA.aliasName, PA.smtpAdrress, PA.databaseName, PA.exchangeServer, PA.adGroupName, PA.discoverByType, @autoDiscover, PA.mailBoxType,
							@clientId, @backupsetId, @subClientId, @userId, @nowUtcUnix, 0, 0,  PA.emailStatus, PA.deleted, @autoDiscover, PA.coreId, PA.password, PA.mailBoxSize, PA.description, @planId,  PA.objectGuid, PA.azureGuid, PA.immutableId, PA.exchangeVersion, PA.msExchRecipientTypeDetails, @discoveryVersion, PA.backupRefTime, PA.indexCollectionTime, PA.nEmails)
				OUTPUT INSERTED.assocId, INSERTED.userGuid, INSERTED.mailBoxType, INSERTED.subclientId INTO #output_PolicyAssocTable;
			SET @errorCode = @@ERROR
			IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
			--COPY THE POLICIES FOR THE NEW ASSOCIATIONS
			INSERT INTO APP_EmailConfigPolicies
			(componentNameId, policyType, policyId, created, modified)
			SELECT OT.assocId, EP.policyType, EP.policyId, EP.created, 0
			FROM #emailConfiguration_CompareTable CP
			JOIN #output_PolicyAssocTable OT ON OT.userGuid = CP.userGuid AND OT.subclientId = CP.subclientId
			JOIN APP_EmailConfigPolicies EP ON EP.componentNameId = CP.assocId AND modified = 0
			--AGE THE OLD POLICIES OF THE SUBCLIENTS
			UPDATE APP_EmailConfigPolicies
			SET modified = @nowUtcUnix
			FROM
			(
				SELECT CP.assocId, PT.policyType pType, PT.policyId pId
				FROM  @policyTable PT, #emailConfiguration_CompareTable CP
			) EP
			WHERE modified = 0
			AND policyType = EP.pType
			AND policyId <> EP.pId
			AND EP.assocId = componentNameId
		END
		--UPDATE ASSOCID IN TEMP TABLE TO HAVE CORRECT VALUE
		UPDATE #emailConfiguration_CompareTable
		SET assocId = T.assocId
		FROM
		(
			SELECT assocId, userGuid uGuid, subclientId subId
			FROM #emailConfiguration_CompareTable CT
			WHERE assocId > 0
			AND NOT EXISTS (SELECT 1 FROM #output_PolicyAssocTable OT WHERE OT.userGuid = CT.userGuid)
		) T
		WHERE T.uGuid = userGuid
		AND subclientId = T.subId
		--If we added new row for update then age old policies
		IF EXISTS (SELECT assocId FROM #output_PolicyAssocTable)
		BEGIN
			-- Age the old Information of ContentStoreMailBox Properties
			UPDATE APP_EmailContentStoreMailBoxProperties
			SET modified = @nowUtcUnix
			FROM #emailConfiguration_CompareTable EP
			WHERE modified = 0 AND EP.assocId = componentNameId AND EP.subclientId = @subClientId
		END
		--UPDATE ASSOCID WITH VALUE FROM NEW ENTRY.  IF NO NEW ENTRY VALUE WILL NOT BE UPDATED
		UPDATE #emailConfiguration_CompareTable
		SET assocId = T.aId
		FROM
		(
			SELECT assocId aId, userGuid uGuid, subclientId subId
			FROM #output_PolicyAssocTable
		) T
		WHERE T.uGuid = userGuid AND T.subId = subclientId
		AND subclientId = T.subId
		--AGE THE OLD POLICIES ON THIS SUBCLIENT
		UPDATE APP_EmailConfigPolicies
		SET modified = @nowUtcUnix
		FROM
		(
	        SELECT CP.assocId, PT.policyType pType, PT.policyId pId
			FROM @policyTable PT, #emailConfiguration_CompareTable CP
			WHERE CP.subclientId = @subClientId
		) EP
		WHERE modified = 0 AND EP.assocId = componentNameId AND policyType = EP.pType
		AND policyId <> EP.pId
		-- Insert the New data in App_emailContentStoreMailBoxProperty table
		MERGE APP_EmailContentStoreMailBoxProperties ECMP
		USING
		(
			SELECT CP.assocId, CMP.attrName_t, CMP.attrType_t, CMP.attrVal_t
			FROM #contentStore_mailbox_properties CMP, #emailConfiguration_CompareTable CP
			WHERE CMP.attrVal_t IS NOT NULL AND CP.subclientId = @subClientId
		) AS DT ON ECMP.modified = 0 AND DT.assocId = ECMP.componentNameId AND DT.attrName_t = ECMP.attrName AND DT.attrType_t = ECMP.attrType AND DT.attrVal_t = ECMP.attrVal
		WHEN NOT MATCHED THEN
			INSERT(componentNameId, attrName,attrType,attrVal,created,modified)
			VALUES(assocId,attrName_t,attrType_t,attrVal_t,@nowUtcUnix, 0);
		--INSERT NEW POLICIES FOR THIS SUBCLIENT
		MERGE APP_EmailConfigPolicies CP
		USING
		(
			SELECT CP.assocId, PT.policyType, PT.policyId
			FROM @policyTable PT, #emailConfiguration_CompareTable CP
			WHERE policyId > 0
			AND CP.subclientId = @subClientId
		) AS PT ON CP.modified = 0 AND PT.assocId = CP.componentNameId AND PT.policyType = CP.policyType AND PT.policyId = CP.policyId
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, policyType, policyId, created, modified)
			VALUES(assocId, policyType, policyId, @nowUtcUnix, 0);
		--DONT CONTINUE IF THERE ARE NO CONTENT STORE MAILBOXES
		IF NOT EXISTS(SELECT 1 FROM #emailConfiguration_CompareTable WHERE discoverByType = @DISCOVERTYPE_CONTENTSTORE)
		BEGIN
			GOTO DONE
		END
		--REMOVE ENTRIES WHICH DO NOT NEED TO MODIFY THE APP_ComponentProp TABLE
		DELETE #emailConfiguration_PolicyAssocTable
		FROM #emailConfiguration_PolicyAssocTable AT
		JOIN #emailConfiguration_CompareTable CT ON CT.userGuid = AT.userGuid
		--CONTENT STORE CLIENT XML IS DIFFERENT
JOIN APP_ComponentProp CP (READUNCOMMITTED) ON CP.componentId = CT.assocId AND CP.propertyTypeId = 1160	--_CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
AND CP.stringVal = AT.attrVal AND CP.componentType = 12		--_CV_COMPONENT_TYPE_CONENTSTORE_PROP
		JOIN #output_PolicyAssocTable OT ON OT.assocId = CP.componentId		--EMAIL ASSOCIATION HAS CHANGED
		UPDATE APP_ComponentProp
		SET modified = @nowUtcUnix
		FROM
		(
			SELECT CT.assocId, PA.attrVal
			FROM #emailConfiguration_PolicyAssocTable PA
			JOIN #emailConfiguration_CompareTable CT ON CT.userGuid = PA.userGuid
		) T
		WHERE T.assocId = componentId
AND propertyTypeId = 1160	--_CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
AND componentType = 12				--_CV_COMPONENT_TYPE_CONENTSTORE_PROP
		AND modified = 0
		AND stringVal <> T.attrVal
		SET @errorCode = @@ERROR
		IF @errorCode != 0
		BEGIN
			GOTO ERROR
		END
		MERGE APP_ComponentProp CP
		USING
		(
			SELECT OT.assocId, AT.attrVal
		FROM #emailConfiguration_PolicyAssocTable AT
		JOIN #output_PolicyAssocTable OT ON OT.userGuid = AT.userGuid
		WHERE AT.mailBoxType = 3
		AND LEN(AT.attrVal) > 0
		UNION
		--ADD ENTRIES WHICH WERE NOT ADDED BECAUSE NOTHING CHANGED IN TABBLE APP_EmailConfigPolicyAssoc
			SELECT OT.assocId, AT.attrVal
		FROM #emailConfiguration_PolicyAssocTable AT
		JOIN #emailConfiguration_CompareTable OT ON OT.userGuid = AT.userGuid AND deleteIt = 1
		WHERE AT.mailBoxType = 3
		AND LEN(AT.attrVal) > 0
		) T ON T.assocId = CP.componentId AND T.attrVal = CP.stringVal AND CP.modified = 0
		WHEN NOT MATCHED THEN
			INSERT (componentType, componentId, propertyTypeId, dataType, stringVal, longVal, longlongVal, created, modified)
VALUES(12, T.assocId, 1160, 1, T.attrVal, 0, 0,  @nowUtcUnix, 0);		--_CV_COMPONENT_TYPE_CONENTSTORE_PROP, _CV_COMPONENT_EXONEPASS_CONTENTSTORE_CLIENTS
		SET @errorCode = @@ERROR
DONE:
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('Ida_EmailAssociationsResp')
    )
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#SecurityTbl') IS NOT NULL
		DROP TABLE #SecurityTbl
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocTable
	IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
		DROP TABLE #emailConfiguration_CompareTable
	IF object_id('tempdb.dbo.#contentStore_mailbox_properties') is not null
		DROP TABLE #contentStore_mailbox_properties
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppEmailConfigPolicyAssocUpdateInfo')
	delete from GxQscripts where name = 'AppEmailConfigPolicyAssocUpdateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEmailConfigPolicyAssocUpdateInfo')
	delete from GXDBVersions where aliasname = 'AppEmailConfigPolicyAssocUpdateInfo'
GO

insert into GXDBVersions values(2, 'AppEmailConfigPolicyAssocUpdateInfo',  '00010001000400490000', 'AppEmailConfigPolicyAssocUpdateInfo', '00010001000400490000')
GO

