

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEmailConfigPolicyAssocSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEmailConfigPolicyAssocSetInfo.sp,v $ $Id: AppEmailConfigPolicyAssocSetInfo.sp,v 1.1.4.36 2020/09/13 04:29:13 sgoel Exp $";
--	+===================================================================+
--	|  				AppEmailConfigPolicyAssocSetInfo					|
--	| Procedure for create/update a APP_EmailConfigPolicyAssoc table	|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppEmailConfigPolicyAssocSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppEmailConfigPolicyAssocSetInfo <<<'
	drop procedure AppEmailConfigPolicyAssocSetInfo
END
IF EXISTS (select * from GxQscripts where name='AppEmailConfigPolicyAssocSetInfo')
	delete from GxQscripts where name = 'AppEmailConfigPolicyAssocSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEmailConfigPolicyAssocSetInfo')
	delete from GXDBVersions where aliasname = 'AppEmailConfigPolicyAssocSetInfo'
GO
print '... Creating Procedure: AppEmailConfigPolicyAssocSetInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEmailConfigPolicyAssocSetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			DATETIME = GETDATE()
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix		INT = DATEDIFF(second, '01/01/1970', @nowTime)
	DECLARE @origCCId			INT = 2
	DECLARE @subClientId		INT = 0
	DECLARE @backupSetId		INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @autoDiscover		INT = 0
	DECLARE @userId				INT = 0
	DECLARE @discovered			INT = 0
	DECLARE @policyId			INT = 0
	DECLARE @policyType			INT = 0
	DECLARE @hasPermission		INT = 0
	DECLARE @failedPolicyId		INT = 0
	DECLARE @emailStatus		INT = 0
	DECLARE @discoverByType		INT = 0
	DECLARE @localeId			INT = 0
	DECLARE @planId				INT = -1
	DECLARE @planType           INT = 0
	DECLARE @brAlertTrace		AS varchar(256) = (select value from gxglobalParam Where name = 'bralertTrace')
	DECLARE @DISCOVERTYPE_USER				INT = 1
	DECLARE @DISCOVERTYPE_DATABASE			INT = 2
	DECLARE @DISCOVERTYPE_ADGROUPS			INT = 3
	DECLARE @DISCOVERTYPE_AUTO_DISCOVERED	INT = 4
	DECLARE @DISCOVERTYPE_MS_JOURNAL		INT = 5
	DECLARE @DISCOVERTYPE_CONTENTSTORE		INT = 6
	DECLARE @DISCOVERTYPE_ALL_JOURNAL		INT = 7
	DECLARE @DISCOVERTYPE_ALL_USERS			INT = 8
	DECLARE @DISCOVERTYPE_ALL_OFFICE365_GROUPS			INT = 11
	DECLARE @DISCOVERTYPE_ALL_PUBLIC_FOLDERS			INT = 12
	DECLARE @fromClassicAgent				BIT = 0		-- set to 1 for migrating mailboxes from old agent
	DECLARE @isOverwriteIfExists			BIT = 1		-- by default overwrite policies for existing associations
	DECLARE @flags							INT = 0
	DECLARE @POLICY_TYPE_ARCHIVE			INT = 1
	DECLARE @POLICY_TYPE_CLEANUP			INT = 2
	DECLARE @POLICY_TYPE_RETENTION			INT = 3
	DECLARE @POLICY_TYPE_JOURNAL			INT = 4
	DECLARE @POLICY_TYPE_CONTAINERS			INT = 6
DECLARE @PLAN_PROP_ARCHIVE				VARCHAR(255) = 'Exchange mailbox archiving policy'
DECLARE @PLAN_PROP_CLEANUP				VARCHAR(255) = 'Exchange mailbox cleanup policy'
DECLARE @PLAN_PROP_RETENTION			VARCHAR(255) = 'Exchange mailbox retention policy'
DECLARE @PLAN_PROP_JOURNAL				VARCHAR(255) = 'Exchange mailbox journal policy'
DECLARE @PLAN_PROP_CONTAINER            VARCHAR(255) = 'Data classification policy'
DECLARE @PLAN_PROP_ARCHIVE_O365         VARCHAR(255) = 'Office 365 Mailbox archive policy'
DECLARE @PLAN_PROP_CLEANUP_O365         VARCHAR(255) = 'Office 365 Mailbox cleanup policy'
DECLARE @PLAN_PROP_RETENTION_O365       VARCHAR(255) = 'Office 365 Mailbox retention policy'
	DECLARE @PLANTYPE_OFFICE365             INT = 100859937
	DECLARE @discoveryVersion				INT = 2 --sp12 onwards
	IF @brAlertTrace <> 0									-- Put a copy of input data to table TrackNotificationProcs
	BEGIN
		DECLARE @inputString		NVARCHAR(MAX) = CAST(@i_xmlString AS NVARCHAR(MAX))
		EXEC br_ntTrace '.. AppEmailConfigPolicyAssocSetInfo', 0, @nowTime, 0, 0, @inputString
	END
	DECLARE @policyTable		TABLE (policyId INT, policyType INT)
	 SELECT
		 @userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'INT'),@userId),
		 @localeId = ISNULL(ref.value('(processinginstructioninfo/locale/@localeId)[1]', 'INT'),@localeId),
		 @subClientId = ISNULL(ref.value('(emailAssociation/subclientEntity/@subclientId)[1]', 'INT'),0),
		 @autoDiscover = ISNULL(ref.value('(emailAssociation/advanceOptions/@enableAutoDiscovery)[1]', 'INT'),@autoDiscover),
		 @discoverByType = ISNULL(ref.value('(emailAssociation/emailDiscoverinfo/@discoverByType)[1]', 'INT'),@discoverByType),
		 @discovered = ISNULL(ref.value('(@discovered)[1]', 'INT'),0),
		 @emailStatus = ISNULL(ref.value('(emailAssociation/@emailStatus)[1]', 'INT'),@emailStatus),
		 @fromClassicAgent = ISNULL(ref.value('(emailAssociation/emailDiscoverinfo/@fromClassicAgent)[1]', 'BIT'),@fromClassicAgent),
		 @isOverwriteIfExists = ISNULL(ref.value('(emailAssociation/emailDiscoverinfo/@isOverWriteIfExists)[1]', 'BIT'), CASE WHEN @fromClassicAgent = 1 THEN 0 ELSE @isOverwriteIfExists END),	/*For import job from classic agent isOverWriteIfExists is false by default*/
		 @planId = ISNULL(ref.value('(emailAssociation/plan/@planId)[1]', 'INT'),@planId)
     FROM @i_xmlString.nodes('Ida_SetEmailPolicyAssociationReq') R(ref)
	--Check for Agent Management permission
DECLARE @hasAgentManagementRole			INT = 0
DECLARE @agentManagementCapability      BIGINT = CAST(POWER(2.0, 2 - 1) AS BIGINT)
--Check for Agent Management permission
IF object_id('tempdb.dbo.#tempSecurityObjects') IS NOT null DROP TABLE #clientListTmp
create table  #tempSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
CREATE CLUSTERED INDEX #tempSecurityObjectsTable_clientId_subclientId_Index1 ON #tempSecurityObjects (clientId, subClientId)
EXEC sec_getUserObjects @userId, 2013, @subClientId, '#tempSecurityObjects'
SELECT @hasAgentManagementRole = 1 FROM #tempSecurityObjects sec WHERE ( sec.capabilities & @agentManagementCapability <> 0  )
IF object_id('tempdb.dbo.#tempSecurityObjects') IS NOT NULL
	DROP TABLE #tempSecurityObjects
	IF @hasAgentManagementRole = 0
	BEGIN
SET @errorCode = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	--CREATE TEMP TABLE TO INSERT XML INPUT
    IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocXMLTable') is not null
        DROP TABLE #emailConfiguration_PolicyAssocXMLTable
    CREATE TABLE #emailConfiguration_PolicyAssocXMLTable
(assocId INT, userGuid VARCHAR(40) NULL, csUserGuid VARCHAR(40) NULL, displayName NVARCHAR(255) NULL, csDisplayName NVARCHAR(255) NULL, aliasName NVARCHAR(255) NULL, csAliasName NVARCHAR(255) NULL,
smtpAdrress NVARCHAR(255) NULL, csSmtpAdrress NVARCHAR(255) NULL, databaseName NVARCHAR(1024) NULL, dbDatabaseName NVARCHAR(1024) NULL,
exchangeServer NVARCHAR(1024) NULL, dbExchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, discoverByType INT NULL, isAutoDiscovered INT NULL,
                mailBoxType INT NULL, csMailBoxType INT NULL, emailStatus INT NULL, deleted INT, autoDiscover INT, associated INT, attrVal NVARCHAR(MAX),
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT)
    CREATE CLUSTERED INDEX #emailConfiguration_PolicyAssocXMLTable_userGuid_discoverByType_assocId_Index1 ON #emailConfiguration_PolicyAssocXMLTable ([userGuid], [csUserGuid], [discoverByType], [assocId])
	IF @planId > 0
	BEGIN
		Select @planType = subType from App_Plan(NOLOCK) where id = @planId and modified = 0
		IF @planType = @PLANTYPE_OFFICE365
		BEGIN
			INSERT INTO @policyTable
			SELECT CAST(attrVal AS INT) policyId,
	            CASE attrName
	                    WHEN @PLAN_PROP_ARCHIVE_O365 THEN @POLICY_TYPE_ARCHIVE
	                    WHEN @PLAN_PROP_CLEANUP_O365 THEN @POLICY_TYPE_CLEANUP
	                    WHEN @PLAN_PROP_RETENTION_O365 THEN @POLICY_TYPE_RETENTION
						WHEN @PLAN_PROP_CONTAINER THEN @POLICY_TYPE_CONTAINERS
	            END policyType
				FROM App_PlanProp (NOLOCK)
	            WHERE attrName IN (@PLAN_PROP_ARCHIVE_O365, @PLAN_PROP_CLEANUP_O365, @PLAN_PROP_RETENTION_O365, @PLAN_PROP_CONTAINER)
	            AND componentNameId = @planId
AND attrType = 7
	            AND modified = 0
		END
		ELSE
			BEGIN
				INSERT INTO @policyTable
				SELECT CAST(attrVal AS INT) policyId,
					CASE attrName
						WHEN @PLAN_PROP_ARCHIVE THEN @POLICY_TYPE_ARCHIVE
						WHEN @PLAN_PROP_CLEANUP THEN @POLICY_TYPE_CLEANUP
						WHEN @PLAN_PROP_RETENTION THEN @POLICY_TYPE_RETENTION
						WHEN @PLAN_PROP_JOURNAL THEN @POLICY_TYPE_JOURNAL
						WHEN @PLAN_PROP_CONTAINER THEN @POLICY_TYPE_CONTAINERS
					END policyType
				FROM App_PlanProp (NOLOCK)
					WHERE attrName IN (@PLAN_PROP_ARCHIVE, @PLAN_PROP_CLEANUP, @PLAN_PROP_RETENTION, @PLAN_PROP_JOURNAL, @PLAN_PROP_CONTAINER)
				AND componentNameId = @planId
AND attrType = 7
				AND modified = 0
			END
	END
	ELSE IF @planId = 0
	BEGIN
		--This will reset policies assigned to mailbox as planId in request is 0
		INSERT INTO @policyTable VALUES
			(0 , @POLICY_TYPE_ARCHIVE),
			(0 , @POLICY_TYPE_CLEANUP),
			(0 , @POLICY_TYPE_RETENTION),
			(0 , @POLICY_TYPE_JOURNAL),
			(0 , @POLICY_TYPE_CONTAINERS)
	END
	ELSE
	BEGIN
		SET @planId = 0	--reset planId to 0
		INSERT INTO @policyTable
		SELECT pe.value('@policyId', 'INT') policyId, dt.value('@emailPolicyType', 'INT') policyType
		FROM    @i_xmlString.nodes('Ida_SetEmailPolicyAssociationReq/emailAssociation/policies/emailPolicies') R(ref)
		CROSS APPLY ref.nodes('./detail/emailPolicy') D(dt)
		CROSS APPLY ref.nodes('./policyEntity') P(pe)
	END
	SELECT @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupSetId=backupSet, @origCCId=origCCId
	FROM APP_Application (NOLOCK) WHERE id = @subClientId
	IF @discoverByType = @DISCOVERTYPE_USER	--EmailDiscoverByType_USER
	BEGIN
		INSERT INTO #emailConfiguration_PolicyAssocXMLTable (userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer,
				 discoverByType, isAutoDiscovered, mailBoxType, emailStatus, deleted, autoDiscover, associated, objectGuid, azureGuid,
				 immutableId, exchangeVersion, msExchRecipientTypeDetails)
		SELECT
			mb.value('user[1]/@userGUID', 'NVARCHAR(MAX)') userGuid,
			mb.value('@displayName', 'NVARCHAR(MAX)') displayName,
			mb.value('@aliasName', 'NVARCHAR(MAX)') aliasName,
			mb.value('@smtpAdrress', 'NVARCHAR(MAX)') smtpAdrress,
			mb.value('@databaseName', 'NVARCHAR(MAX)') databaseName,
			mb.value('@exchangeServer', 'NVARCHAR(MAX)') exchangeServer,
			@discoverByType,
			mb.value('@isAutoDiscoveredUser', 'INT') isAutoDiscoveredUser,
			mb.value('@mailBoxType', 'NVARCHAR(MAX)') mailBoxType,
			--mp.query('./emailPolicies') policies,
			@emailStatus,
			CASE WHEN @emailStatus= 1 THEN 1 ELSE 0 END deleted,
			@autoDiscover,
			mb.value('@associated', 'INT') associated,
			mb.value('@objectGuid', 'NVARCHAR(MAX)') objectGuid,
			mb.value('@azureGuid', 'NVARCHAR(MAX)') azureGuid,
			mb.value('@immutableId', 'NVARCHAR(MAX)') immutableId,
			ISNULL(mb.value('@exchangeVersion', 'INT'),0) exchangeVersion,
			ISNULL(mb.value('@msExchRecipientTypeDetails','INT'),0) msExchRecipientTypeDetails
		FROM @i_xmlString.nodes ('Ida_SetEmailPolicyAssociationReq/emailAssociation/emailDiscoverinfo/mailBoxes') M(mb)
	END
	ELSE IF @discoverByType IN (@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ALL_OFFICE365_GROUPS,@DISCOVERTYPE_ALL_PUBLIC_FOLDERS)
	BEGIN
	--EmailDiscoverByType_ALL_USERS
	INSERT #emailConfiguration_PolicyAssocXMLTable (displayName, discoverByType, emailStatus, deleted, autoDiscover, associated)
			SELECT
				ge.value('@associationName', 'NVARCHAR(MAX)') displayName,
				ge.value('@associationType', 'INT') discoverByType,
				ref.value('@emailStatus', 'INT') emailStatus,
				CASE WHEN ref.value('@emailStatus', 'INT') = 1 THEN 1 ELSE 0 END deleted,
				op.value('@enableAutoDiscovery', 'INT') autoDiscover,
				ge.value('@associated', 'INT') associated
			FROM @i_xmlString.nodes ('Ida_SetEmailPolicyAssociationReq/emailAssociation') R(ref)
			OUTER APPLY ref.nodes('./emailDiscoverinfo') I(ed)
			OUTER APPLY ed.nodes('./genericAssociations') G(ge)
			OUTER APPLY ref.nodes('./advanceOptions') O(op)
	END
	ELSE --EmailDiscoverByType_DATABASE | --EmailDiscoverByType_ADGROUP
	BEGIN
		INSERT #emailConfiguration_PolicyAssocXMLTable (userGuid, displayName, aliasName, smtpAdrress, databaseName, dbDatabaseName, exchangeServer, dbExchangeServer,
			adGroupName, discoverByType, isAutoDiscovered, mailBoxType, exchangeVersion, msExchRecipientTypeDetails, emailStatus, deleted, autoDiscover, associated)
		SELECT
			mb.value('user[1]/@userGUID', 'NVARCHAR(MAX)') userGuid,
			mb.value('@displayName', 'NVARCHAR(MAX)') displayName,
			mb.value('@aliasName', 'NVARCHAR(MAX)') aliasName,
			mb.value('@smtpAdrress', 'NVARCHAR(MAX)') smtpAdrress,
			mb.value('@databaseName', 'NVARCHAR(MAX)') databaseName,
			db.value('@databaseName', 'NVARCHAR(MAX)') dbDatabaseName,
			mb.value('@exchangeServer', 'NVARCHAR(MAX)') exchangeServer,
			db.value('@exchangeServer', 'NVARCHAR(MAX)') dbExchangeServer,
			ag.value('@adGroupName', 'NVARCHAR(MAX)') adGroupName,
			ed.value('@discoverByType', 'INT') discoverByType,
			mb.value('@isAutoDiscoveredUser', 'INT') isAutoDiscoveredUser,
			mb.value('@mailBoxType', 'NVARCHAR(MAX)') mailBoxType,
			ISNULL(mb.value('@exchangeVersion', 'INT'),0) exchangeVersion,
			ISNULL(mb.value('@msExchRecipientTypeDetails','INT'),0) msExchRecipientTypeDetails,
			--mp.query('./emailPolicies') policies,
			ref.value('@emailStatus', 'INT') emailStatus,
			CASE WHEN ref.value('@emailStatus', 'INT') = 1 THEN 1 ELSE 0 END deleted,
			op.value('@enableAutoDiscovery', 'INT') autoDiscover,
			mb.value('@associated', 'INT') associated
		FROM @i_xmlString.nodes ('Ida_SetEmailPolicyAssociationReq/emailAssociation') R(ref)
		OUTER APPLY ref.nodes('./emailDiscoverinfo') I(ed)
		OUTER APPLY ed.nodes('./mailBoxes') M(mb)
		OUTER APPLY ed.nodes('./databases') D(db)
		OUTER APPLY ed.nodes('./adGroups') G(ag)
		OUTER APPLY ref.nodes('./advanceOptions') O(op)
	END
--- CODE BELOW HERE IS FROM AppEmailConfigPolicyAssocSetInfo.spb  ----------
	DECLARE @DELETED						INT = 1
	DECLARE @DISABLED						INT = 2
	DECLARE @DONOTARCHIVE					INT = 3
	IF @fromClassicAgent = 1
	BEGIN
set @flags = @flags | 64
	End
	--CREATE TEMP TABLE FOR SECURITY
	IF object_id('tempdb.dbo.#SecurityTbl') IS NOT NULL
		DROP TABLE #SecurityTbl
	CREATE TABLE #SecurityTbl
				(id INT IDENTITY(1,1), returnedUserId INT, nodeCapability BIGINT, childCapability BIGINT)
	CREATE UNIQUE CLUSTERED INDEX SecurityTbl_id_Index1 ON #SecurityTbl (id DESC)
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	CREATE TABLE #output_PolicyAssocTable
(assocId INT, userGuid VARCHAR(40), mailBoxType INT, databaseName NVARCHAR(1024) NULL, exchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, displayName NVARCHAR(1024) NULL,
				subclientId INT)
	CREATE CLUSTERED INDEX #output_PolicyAssocTable_assocId_userGuid_Index1 ON #output_PolicyAssocTable ([assocId], [userGuid])
      IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
        DROP TABLE #emailConfiguration_PolicyAssocTable
    CREATE TABLE #emailConfiguration_PolicyAssocTable
(assocId INT, userGuid VARCHAR(40) DEFAULT NEWID(), displayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', smtpAdrress NVARCHAR(255) NULL DEFAULT '', databaseName NVARCHAR(1024) NULL DEFAULT '',
exchangeServer NVARCHAR(1024) NULL DEFAULT '', adGroupName NVARCHAR(1024) NULL DEFAULT '', discoverByType INT NULL DEFAULT 0, isAutoDiscovered INT NULL DEFAULT 0, mailBoxType INT,
                emailStatus INT NULL DEFAULT 0, deleted INT, autoDiscover INT, associated INT DEFAULT 0, coreId INT DEFAULT 0, attrVal NVARCHAR(MAX),
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT DEFAULT 1,
				mailBoxSize BIGINT, backupReferenceTime BIGINT, idxCollectionTime BIGINT, numberOfEmails BIGINT)
    CREATE CLUSTERED INDEX #emailConfiguration_PolicyAssocTable_userGuid_discoverByType_assocId_Index1 ON #emailConfiguration_PolicyAssocTable ([userGuid], [discoverByType], [assocId])
    --CREATE TEMP TABLE TO INSERT VALUES IN DB
    IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
        DROP TABLE #emailConfiguration_CompareTable
    CREATE TABLE #emailConfiguration_CompareTable
(assocId INT, userGuid VARCHAR(40), displayName NVARCHAR(255), aliasName NVARCHAR(255), smtpAdrress NVARCHAR(255), databaseName NVARCHAR(1024) NULL,
exchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, deleteIt INT, mailboxType INT, discoverByType INT, emailStatus INT, deleted INT, clientId INT, backupsetId INT, subclientId INT, autoDiscover INT, exchangeVersion INT, msExchRecipientTypeDetails INT DEFAULT 1, planId INT)
    CREATE CLUSTERED INDEX #emailConfiguration_CompareTable_userGuid_Index1 ON #emailConfiguration_CompareTable ([userGuid])
	INSERT #emailConfiguration_PolicyAssocTable (assocId, userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
			emailStatus, deleted, autoDiscover, associated, attrVal, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails)
	SELECT	0, ISNULL(CASE WHEN userGuid IS NULL THEN csUserGuid
			ELSE userGuid END, '') userGuid,
		CASE WHEN displayName IS NULL THEN csDisplayName
			ELSE displayName END displayName,
		CASE WHEN aliasName IS NULL THEN csAliasName
			ELSE aliasName END aliasName,
		CASE WHEN smtpAdrress IS NULL THEN csSmtpAdrress
			ELSE smtpAdrress END smtpAdrress,
		CASE WHEN databaseName IS NULL THEN dbDatabaseName
			ELSE databaseName END databaseName,
		CASE WHEN exchangeServer IS NULL THEN dbExchangeServer
			ELSE exchangeServer END exchangeServer,
		adGroupName,
		discoverByType,
		isAutoDiscovered,
		CASE WHEN mailBoxType IS NULL THEN csMailBoxType
			ELSE mailBoxType END mailBoxType,
		--mp.query('./emailPolicies') policies,
		ISNULL(emailStatus, 0),
		deleted,
		ISNULL(autoDiscover, 0),
		associated,
		attrVal,
		objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails
	FROM #emailConfiguration_PolicyAssocXMLTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocXMLTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocXMLTable
	--UPDATE MAILBOX STATS FROM LAST SEEN
	Update #emailConfiguration_PolicyAssocTable
	SET mailBoxSize = T.mailboxSize,
	backupReferenceTime = T.backupReferenceTime,
	numberofEmails = T.numberofEmails,
	IdxCollectionTime = T.IdxCollectionTime
	FROM (
		SELECT userGuid, max(mailboxSize) as mailboxSize, max(backupReferenceTime) as backupReferenceTime ,
		max(numberofEmails) as numberofEmails, max(IdxCollectionTime) as IdxCollectionTime FROM APP_EmailConfigPolicyAssoc (NOLOCK)
		WHERE mailBoxType IN (1, 2) AND subclientId = @subclientId
		AND userGuid IN (SELECT userGuid FROM  #emailConfiguration_PolicyAssocTable)
		GROUP by userGuid
	)T
	WHERE #emailConfiguration_PolicyAssocTable.userGuid = T.userGuid
	IF @emailStatus = 1		--EmailStatusType.DELETED
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
										deleteIt, mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, exchangeVersion, msExchRecipientTypeDetails, planId)
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		0 deleteIt, EA.mailBoxType, EA.discoverByType, CP.emailStatus, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.planId
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON EA.modified = 0 AND EA.subClientId = @subClientId
			AND CP.discoverByType = EA.discoverByType AND
			((CP.discoverByType = @DISCOVERTYPE_USER AND LEN(EA.userGuid) > 0 AND CP.userGuid = EA.userGuid)
				OR (CP.discoverByType = @DISCOVERTYPE_DATABASE AND CP.databaseName = EA.databaseName)
				OR (CP.discoverByType = @DISCOVERTYPE_ADGROUPS AND CP.adGroupName = EA.adGroupName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_USERS AND CP.displayName = Cp.displayName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS AND CP.displayName = Cp.displayName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS AND CP.displayName = Cp.displayName))
	END
	ELSE
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
										deleteIt, mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, exchangeVersion, msExchRecipientTypeDetails, planId)
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		0 deleteIt, EA.mailBoxType, EA.discoverByType, CP.emailStatus, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.exchangeVersion, EA.msExchRecipientTypeDetails, EA.planId
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON  EA.modified = 0 AND EA.subClientId = @subClientId
		AND CP.discoverByType = EA.discoverByType AND
		((CP.discoverByType = @DISCOVERTYPE_USER AND LEN(EA.userGuid) > 0 AND CP.userGuid = EA.userGuid)
				OR (CP.discoverByType = @DISCOVERTYPE_DATABASE AND CP.databaseName = EA.databaseName)
				OR (CP.discoverByType = @DISCOVERTYPE_ADGROUPS AND CP.adGroupName = EA.adGroupName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_USERS AND CP.displayName = Cp.displayName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS AND CP.displayName = Cp.displayName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS AND CP.displayName = Cp.displayName))
	END
	IF EXISTS(SELECT * FROM #emailConfiguration_CompareTable)
	BEGIN
		--REMOVE EXISTING ENTRIES IF REQUEST IS MARKED FOR isOverWriteIfExists=false
		IF @isOverwriteIfExists = 0
		BEGIN
			UPDATE #emailConfiguration_CompareTable
			SET deleteIt = 1
			FROM #emailConfiguration_CompareTable CP
			JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
		END
		--REMOVE ENTRIES WHICH ARE DIFFERENT AUTO DISCOVERED FLAGS
		DELETE #emailConfiguration_PolicyAssocTable
		FROM #emailConfiguration_CompareTable CP
		JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
		AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress AND CP.databaseName = CT.databaseName
		AND CP.autoDiscover <> CT.isAutoDiscovered
		DELETE #emailConfiguration_PolicyAssocTable
		FROM #emailConfiguration_CompareTable CP
		JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
		AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress AND CP.databaseName = CT.databaseName
		AND @discovered <> CT.autoDiscover
		--REMOVE ENTRIES WHICH ARE ALREADY IN TABLE
		UPDATE #emailConfiguration_CompareTable
		SET deleteIt = 1
		FROM #emailConfiguration_CompareTable CP
		JOIN #emailConfiguration_PolicyAssocTable CT ON CT.userGuid = CP.userGuid
		AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress
		AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
		AND (CP.autoDiscover = @autoDiscover OR @autoDiscover IS NULL)
		AND CP.emailStatus = CT.emailStatus
		AND CP.mailboxType = CT.mailBoxType
		AND CP.discoverByType = CT.discoverByType
		AND CP.discoverByType <> @DISCOVERTYPE_CONTENTSTORE
		AND CP.assocId <> 0
		AND CT.deleted = 0	--DON'T REMOVE IF WE ARE DELETING THE ENTRY
		AND CP.exchangeVersion = CT.exchangeVersion
		AND CP.msExchRecipientTypeDetails = CP.msExchRecipientTypeDetails
		AND CP.planId = @planId
		--DELETE THE ENTRIES MARKED FOR DELETION
		DELETE #emailConfiguration_PolicyAssocTable
		FROM #emailConfiguration_PolicyAssocTable CT
		WHERE NOT EXISTS(
			SELECT 1 FROM #emailConfiguration_CompareTable CP
			WHERE CT.userGuid = CP.userGuid
			AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress
			AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
			AND deleteIt = 0
		)
		AND EXISTS(
			SELECT 1 FROM #emailConfiguration_CompareTable CP
			WHERE CT.userGuid = CP.userGuid
			AND CP.displayName = CT.displayName AND CP.aliasName = CT.aliasName AND CP.smtpAdrress = CT.smtpAdrress
			AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
		)
		AND EXISTS(	--CHECK FOR POLICY CHANGE
			SELECT 1 FROM @policyTable P
			JOIN APP_EmailConfigPolicies (NOLOCK) E ON E.policyId = P.policyId AND E.policyType = P.policyType
			WHERE componentNameId = assocId
			AND autoDiscover = @autoDiscover
		)
		AND discoverByType IN (@DISCOVERTYPE_USER, @DISCOVERTYPE_MS_JOURNAL)
		IF @isOverwriteIfExists = 0		--RELAX POLICY CHECK HERE. USED IN MIGRATION FROM CLASSIC AGENT
			BEGIN
				DELETE #emailConfiguration_PolicyAssocTable
				FROM #emailConfiguration_PolicyAssocTable CT
				WHERE EXISTS(
					SELECT 1 FROM #emailConfiguration_CompareTable CP
					WHERE CT.userGuid = CP.userGuid AND deleteIt = 1
					-- Removing these checks following mailboxes attributes can be changed and import job might have old values.
					-- AND CP.aliasName = CT.aliasName Import from PST might not have alias info
					-- AND CP.displayName = CT.displayName  AND CP.smtpAdrress = CT.smtpAdrress
					-- AND CP.exchangeServer = CT.exchangeServer AND CP.exchangeServer = CT.exchangeServer AND CP.databaseName = CT.databaseName
				)
				DELETE #emailConfiguration_CompareTable where deleteIt=1
			END
		END
	IF @discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS
	BEGIN
		DECLARE @SubClientGUIDHashed VARCHAR(40) = ''
		SET @SubClientGUIDHashed = ISNULL((SELECT TOP 1 userGuid FROM #emailConfiguration_CompareTable),'')
		IF @SubClientGUIDHashed != ''
			UPDATE #emailConfiguration_PolicyAssocTable SET userGuid = @SubClientGUIDHashed
		ELSE
		BEGIN
			DECLARE @DefaultAppendHashKey VARCHAR(40) = '00000000000000000000000000000003'
			SET @SubClientGUIDHashed =
				(
					SELECT REPLACE(CONVERT(UNIQUEIDENTIFIER, HashBytes('MD5',@DefaultAppendHashKey+ CONVERT(VARCHAR(40),AA.GUID))),'-','X')
					FROM APP_Application (NOLOCK) AA
WHERE AA.id = @subClientId AND AA.subclientName = 'usermailbox' AND AA.appTypeId = 137
				)
			UPDATE #emailConfiguration_PolicyAssocTable SET userGuid = @SubClientGUIDHashed
		END
	END
	BEGIN TRAN
		--EmailDiscoverByType_USER
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT userGuid, emailStatus, deleted, discoverByType
			FROM #emailConfiguration_PolicyAssocTable
			WHERE discoverByType IN (@DISCOVERTYPE_USER, @DISCOVERTYPE_MS_JOURNAL)
		) EC
		WHERE EC.userGuid = APP_EmailConfigPolicyAssoc.userGuid
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType IN (@DISCOVERTYPE_USER, @DISCOVERTYPE_MS_JOURNAL)
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		--EmailDiscoverByType_DATABASE
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT databaseName, exchangeServer, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			WHERE discoverByType = @DISCOVERTYPE_DATABASE
		) EC
		WHERE EC.databaseName = APP_EmailConfigPolicyAssoc.databaseName
		AND EC.exchangeServer = APP_EmailConfigPolicyAssoc.exchangeServer
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_DATABASE
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		--EmailDiscoverByType_ADGROUPS
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT adGroupName, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			 WHERE discoverByType = @DISCOVERTYPE_ADGROUPS
		) EC
		WHERE EC.adGroupName = APP_EmailConfigPolicyAssoc.adGroupName
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_ADGROUPS
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		--EmailDiscoverByType_ALL_USERS
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT displayName, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			 WHERE discoverByType = @DISCOVERTYPE_ALL_USERS
		) EC
		WHERE EC.displayName = APP_EmailConfigPolicyAssoc.displayName
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_ALL_USERS
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		--EmailDiscoverByType_ALL_OFFICE365_GROUPS
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT displayName, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			 WHERE discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS
		) EC
		WHERE EC.displayName = APP_EmailConfigPolicyAssoc.displayName
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		--EmailDiscoverByType_ALL_PUBLIC_FOLDERS
		UPDATE APP_EmailConfigPolicyAssoc
		SET deleted = EC.deleted,
		modified = @nowUtcUnix
		FROM
		(
			SELECT displayName, deleted, discoverByType, emailStatus
			FROM #emailConfiguration_PolicyAssocTable
			 WHERE discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS
		) EC
		WHERE EC.displayName = APP_EmailConfigPolicyAssoc.displayName
		AND APP_EmailConfigPolicyAssoc.subClientId = @subClientId
		AND APP_EmailConfigPolicyAssoc.discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS
		AND APP_EmailConfigPolicyAssoc.discoverByType = EC.discoverByType
		AND modified = 0
		UPDATE #emailConfiguration_PolicyAssocTable
		SET coreId = ISNULL(ASCII(substring(userGuid, 1, 1)) +ASCII(substring(userGuid, 2, 1)) + ASCII(substring(userGuid, 3, 1)) +ASCII(substring(userGuid, 4, 1)) +
							ASCII(substring(userGuid, 5, 1)) +ASCII(substring(userGuid, 6, 1)) + ASCII(substring(userGuid, 7, 1)) +ASCII(substring(userGuid, 8, 1)) +
							ASCII(substring(userGuid, 9, 1)) +ASCII(substring(userGuid, 10, 1)) + ASCII(substring(userGuid, 11, 1)) +ASCII(substring(userGuid, 12, 1)) +
							ASCII(substring(userGuid, 13, 1)) +ASCII(substring(userGuid, 14, 1)) + ASCII(substring(userGuid, 15, 1)) +ASCII(substring(userGuid, 16, 1)) +
							ASCII(substring(userGuid, 17, 1)) +ASCII(substring(userGuid, 18, 1)) + ASCII(substring(userGuid, 19, 1)) +ASCII(substring(userGuid, 20, 1)) +
							ASCII(substring(userGuid, 21, 1)) +ASCII(substring(userGuid, 22, 1)) + ASCII(substring(userGuid, 23, 1)) +ASCII(substring(userGuid, 24, 1)) +
							ASCII(substring(userGuid, 25, 1)) +ASCII(substring(userGuid, 26, 1)) + ASCII(substring(userGuid, 27, 1)) +ASCII(substring(userGuid, 28, 1)) +
							ASCII(substring(userGuid, 29, 1)) +ASCII(substring(userGuid, 30, 1)) + ASCII(substring(userGuid, 31, 1)) +ASCII(substring(userGuid, 32, 1)) +
							ASCII(substring(userGuid, 33, 1)) +ASCII(substring(userGuid, 34, 1)) + ASCII(substring(userGuid, 35, 1)) +ASCII(substring(userGuid, 36, 1)), 0)%8
		WHERE deleted = 0
		MERGE APP_EmailConfigPolicyAssoc EC
		USING
		(
			SELECT C.* FROM #emailConfiguration_PolicyAssocTable C
			WHERE deleted = 0
		) AS PA ON PA.userGuid = EC.userGuid AND EC.subClientId = @subClientId AND EC.modified = 0 AND PA.discoverByType = EC.discoverByType AND PA.databaseName = EC.databaseName
		WHEN NOT MATCHED THEN
			INSERT (userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
						clientId, backupsetId, subClientId, ownerId, created, modified, flags, status, deleted, autoDiscover, coreId, password, mailBoxSize, description, planId, objectGuid, azureGuid, immutableId, exchangeVersion, discoveryVersion, msExchRecipientTypeDetails,
						backupreferenceTime, idxCollectionTime, numberOfEmails)
			VALUES(ISNULL(PA.userGuid, ''), PA.displayName, PA.aliasName, PA.smtpAdrress, PA.databaseName, PA.exchangeServer, PA.adGroupName, PA.discoverByType, @autoDiscover, PA.mailBoxType,
						@clientId, @backupsetId, @subClientId, @userId, @nowUtcUnix, 0, @flags, PA.emailStatus, PA.deleted, @autoDiscover, PA.coreId, NULL, PA.mailboxSize, NULL, @planId, PA.objectGuid, PA.azureGuid, PA.immutableId, PA.exchangeVersion, @discoveryVersion, PA.msExchRecipientTypeDetails,
						PA.backupreferenceTime, PA.idxCollectionTime, PA.numberOfEmails)
			OUTPUT INSERTED.assocId, INSERTED.userGuid, INSERTED.mailBoxType, INSERTED.databaseName, INSERTED.exchangeServer, INSERTED.adGroupName, INSERTED.displayName, INSERTED.subclientId INTO #output_PolicyAssocTable;
		SET @errorCode = @@ERROR
		--If we added new row for update then age old policies
		IF EXISTS (SELECT assocId FROM #output_PolicyAssocTable)
		BEGIN
			--AGE THE OLD POLICIES ON THIS SUBCLIENT
			UPDATE APP_EmailConfigPolicies
			SET modified = @nowUtcUnix
			FROM #emailConfiguration_CompareTable EP
			WHERE modified = 0 AND EP.assocId = componentNameId AND EP.subclientId = @subClientId
		END
		--UPDATE ASSOCID FOR USERS IN TEMP TABLE TO HAVE CORRECT VALUE
		UPDATE #emailConfiguration_CompareTable
		SET assocId = T.assocId
		FROM
		(
			SELECT assocId, userGuid uGuid
			FROM #emailConfiguration_CompareTable CT
			WHERE assocId > 0
			AND NOT EXISTS (SELECT 1 FROM #output_PolicyAssocTable OT WHERE OT.userGuid = CT.userGuid)
		) T
		WHERE T.uGuid = userGuid
		AND LEN(userGuid) > 0
		--UPDATE ASSOCID FOR DB/AD/AllUsers ENTRIES IN TEMP TABLE TO HAVE CORRECT VALUE
		UPDATE #emailConfiguration_CompareTable
		SET assocId = T.assocId
		FROM
		(
			SELECT assocId, userGuid uGuid, databaseName dbName, exchangeServer exName, adGroupName adName, displayName dsName
			FROM #emailConfiguration_CompareTable CT
			WHERE assocId > 0
			AND NOT EXISTS (SELECT 1 FROM #output_PolicyAssocTable OT WHERE OT.databaseName = CT.databaseName AND OT.exchangeServer = CT.exchangeServer)
		) T
		WHERE LEN(userGuid) = 0
		AND ( T.adName = adGroupName OR ( T.dbName = databaseName AND T.exName = exchangeServer	)
		OR (discoverByType IN (@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ALL_OFFICE365_GROUPS,@DISCOVERTYPE_ALL_PUBLIC_FOLDERS) AND T.dsName = displayName))
		--UPDATE ASSOCID WITH VALUE FROM NEW USER ENTRY.  IF NO NEW ENTRY VALUE WILL NOT BE UPDATED
		UPDATE #emailConfiguration_PolicyAssocTable
		SET assocId = T.assocId
		FROM
		(
			SELECT assocId, userGuid uGuid
			FROM #output_PolicyAssocTable
		) T
		WHERE T.uGuid = userGuid
		AND LEN(userGuid) > 0
		--UPDATE ASSOCID WITH VALUE FROM NEW DB/AD/AllUsers ENTRIES.  IF NO NEW ENTRY VALUE WILL NOT BE UPDATED
		UPDATE #emailConfiguration_PolicyAssocTable
		SET assocId = T.assocId
		FROM
		(
			SELECT assocId, userGuid uGuid, databaseName dbName, exchangeServer exName, adGroupName adName, displayName dsName
			FROM #output_PolicyAssocTable
		) T
		WHERE LEN(userGuid) = 0
		AND ( T.adName = adGroupName OR ( T.dbName = databaseName AND T.exName = exchangeServer	)
		OR (discoverByType IN (@DISCOVERTYPE_ALL_USERS, @DISCOVERTYPE_ALL_OFFICE365_GROUPS,@DISCOVERTYPE_ALL_PUBLIC_FOLDERS) AND T.dsName = displayName))
		UPDATE APP_EmailConfigPolicies
		SET modified = @nowUtcUnix
		FROM
		(
			SELECT CP.assocId, PT.policyType pType, PT.policyId pId
			FROM @policyTable PT, #emailConfiguration_CompareTable CP
			WHERE CP.autoDiscover = @autoDiscover
		) EP
		WHERE modified = 0 AND EP.assocId = componentNameId AND policyType = EP.pType
		AND policyId <> EP.pId
		--COPY OLD POLICIES WHICH ARE NOT IN REQUEST
		INSERT INTO APP_EmailConfigPolicies
        (componentNameId, policyType, policyId, created, modified)
        SELECT OT.assocId, EP.policyType, EP.policyId, EP.created, 0
        FROM #emailConfiguration_CompareTable CP
        JOIN #output_PolicyAssocTable OT ON OT.userGuid = CP.userGuid AND OT.subclientId = CP.subclientId
        JOIN APP_EmailConfigPolicies EP ON EP.componentNameId = CP.assocId AND modified = 0
		WHERE Ep.policyType NOT IN (select policyType from @policyTable)
		--ADD NEW POLICIES
		MERGE APP_EmailConfigPolicies CP
		USING
		(
			SELECT CP.assocId, PT.policyType, PT.policyId
			FROM @policyTable PT, #emailConfiguration_PolicyAssocTable CP
			WHERE policyId > 0 AND autoDiscover = @autoDiscover AND CP.emailStatus = 0
		) AS PT ON CP.modified = 0 AND PT.assocId = CP.componentNameId AND PT.policyType = CP.policyType AND PT.policyId = CP.policyId
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, policyType, policyId, created, modified)
			VALUES(assocId, policyType, policyId, @nowUtcUnix, 0);
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('Ida_EmailAssociationsResp')
    )
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#SecurityTbl') IS NOT NULL
		DROP TABLE #SecurityTbl
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocTable
	IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
		DROP TABLE #emailConfiguration_CompareTable
		IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
			DROP TABLE #emailConfiguration_PolicyAssocTable
		IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
			DROP TABLE #emailConfiguration_CompareTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppEmailConfigPolicyAssocSetInfo')
	delete from GxQscripts where name = 'AppEmailConfigPolicyAssocSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEmailConfigPolicyAssocSetInfo')
	delete from GXDBVersions where aliasname = 'AppEmailConfigPolicyAssocSetInfo'
GO

insert into GXDBVersions values(2, 'AppEmailConfigPolicyAssocSetInfo',  '00010001000400360000', 'AppEmailConfigPolicyAssocSetInfo', '00010001000400360000')
GO

