

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEmailAutoDiscoverAssocSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2012  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEmailAutoDiscoverAssocSet.sp,v $ $Id: AppEmailAutoDiscoverAssocSet.sp,v 1.1.2.13 2019/09/29 00:37:26 nlakade Exp $"
--
--  +=============================================================================+
--  | Stored Precedure: AppEmailAutoDiscoverAssocSet
--  | Support the batch processing of Edit/Delete of auto discovered associations
--  +=============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppEmailAutoDiscoverAssocSet')
BEGIN
	print '>>> Drop Stored Procedure: AppEmailAutoDiscoverAssocSet <<<'
	drop procedure AppEmailAutoDiscoverAssocSet
END
IF EXISTS (select * from GxQscripts where name='AppEmailAutoDiscoverAssocSet')
	delete from GxQscripts where name = 'AppEmailAutoDiscoverAssocSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEmailAutoDiscoverAssocSet')
	delete from GXDBVersions where aliasname = 'AppEmailAutoDiscoverAssocSet'
GO
print '... Creating Procedure: AppEmailAutoDiscoverAssocSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEmailAutoDiscoverAssocSet
-------------------------------------------
-----   PARAMETERS
  @i_xmlString XML
-------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML		-- output
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			DATETIME = GETDATE()
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix		INT = DATEDIFF(second, '01/01/1970', @nowTime)
	DECLARE @origCCId			INT = 2
	DECLARE @subClientId		INT = 0
	DECLARE @backupSetId		INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @autoDiscover		INT = 1
	DECLARE @userId				INT = 0
	DECLARE @discovered			INT = 0
	DECLARE @policyId			INT = 0
	DECLARE @policyType			INT = 0
	DECLARE @hasPermission		INT = 0
	DECLARE @failedPolicyId		INT = 0
	DECLARE @emailStatus		INT = 0
	DECLARE @discoverByType		INT = 0
	DECLARE @localeId			INT = 0
	DECLARE @planId				INT = 0
	DECLARE @brAlertTrace		AS varchar(256) = (select value from gxglobalParam Where name = 'bralertTrace')
	DECLARE @DISCOVERTYPE_USER				INT = 1
	DECLARE @DISCOVERTYPE_DATABASE			INT = 2
	DECLARE @DISCOVERTYPE_ADGROUPS			INT = 3
	DECLARE @DISCOVERTYPE_AUTO_DISCOVERED	INT = 4
	DECLARE @DISCOVERTYPE_MS_JOURNAL		INT = 5
	DECLARE @DISCOVERTYPE_CONTENTSTORE		INT = 6
	DECLARE @DISCOVERTYPE_ALL_JOURNAL		INT = 7
	DECLARE @DISCOVERTYPE_ALL_USERS			INT = 8
	DECLARE @DISCOVERTYPE_ALL_OFFICE365_GROUPS	INT = 11
	DECLARE @DISCOVERTYPE_ALL_PUBLIC_FOLDERS	INT = 12
	DECLARE @POLICY_TYPE_ARCHIVE			INT = 1
	DECLARE @POLICY_TYPE_CLEANUP			INT = 2
	DECLARE @fromClassicAgent				BIT = 0		-- set to 1 for migrating mailboxes from old agent
	DECLARE @isOverwriteIfExists			BIT = 1		-- by default overwrite policies for existing associations
	DECLARE @flags							INT = 0
	DECLARE @policyTable		TABLE (policyId INT, policyType INT)
	DECLARE @discoveryVersion				INT = 2 --sp12 onwards
	DECLARE @EMAIL_DISABLED					INT = 2
	IF @brAlertTrace <> 0									-- Put a copy of input data to table TrackNotificationProcs
	BEGIN
		DECLARE @inputString		NVARCHAR(MAX) = CAST(@i_xmlString AS NVARCHAR(MAX))
		EXEC br_ntTrace '.. AppEmailAutoDiscoverAssocSet', 0, @nowTime, 0, 0, @inputString
	END
	 SELECT
		 @userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'INT'),@userId),
		 @localeId = ISNULL(ref.value('(processinginstructioninfo/locale/@localeId)[1]', 'INT'),@localeId),
		 @subClientId = ISNULL(ref.value('(subclientEntity/@subclientId)[1]', 'INT'),0),
		 @autoDiscover = ISNULL(ref.value('(advanceOptions/@enableAutoDiscovery)[1]', 'INT'),@autoDiscover),
		 @emailStatus = ISNULL(ref.value('(@emailStatus)[1]', 'INT'),@emailStatus),
		 @planId = ISNULL(ref.value('(plan/@planId)[1]', 'INT'),@planId)
     FROM @i_xmlString.nodes('Ida_SetEmailAutoDiscoverAssocReq') R(ref)
	--CREATE TEMP TABLE TO INSERT XML INPUT
    IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocXMLTable') is not null
        DROP TABLE #emailConfiguration_PolicyAssocXMLTable
    CREATE TABLE #emailConfiguration_PolicyAssocXMLTable
(assocId INT, userGuid VARCHAR(40) NULL, csUserGuid VARCHAR(40) NULL, displayName NVARCHAR(255) NULL, csDisplayName NVARCHAR(255) NULL, aliasName NVARCHAR(255) NULL, csAliasName NVARCHAR(255) NULL,
smtpAdrress NVARCHAR(255) NULL, csSmtpAdrress NVARCHAR(255) NULL, databaseName NVARCHAR(1024) NULL, dbDatabaseName NVARCHAR(1024) NULL,
exchangeServer NVARCHAR(1024) NULL, dbExchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, discoverByType INT NULL, isAutoDiscovered INT NULL,
                mailBoxType INT NULL, csMailBoxType INT NULL, emailStatus INT NULL, deleted INT, autoDiscover INT, associated INT, attrVal NVARCHAR(MAX),
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT)
    CREATE CLUSTERED INDEX #emailConfiguration_PolicyAssocXMLTable_userGuid_discoverByType_assocId_Index1 ON #emailConfiguration_PolicyAssocXMLTable ([userGuid], [csUserGuid], [discoverByType], [assocId])
	INSERT INTO @policyTable
    SELECT pe.value('@policyId', 'INT') policyId, dt.value('@emailPolicyType', 'INT') policyType
    FROM    @i_xmlString.nodes('Ida_SetEmailAutoDiscoverAssocReq/policies/emailPolicies') R(ref)
    CROSS APPLY ref.nodes('./detail/emailPolicy') D(dt)
    CROSS APPLY ref.nodes('./policyEntity') P(pe)
    SELECT @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupSetId=backupSet, @origCCId=origCCId
    FROM APP_Application (NOLOCK) WHERE id = @subClientId
	INSERT #emailConfiguration_PolicyAssocXMLTable (userGuid, displayName, aliasName, smtpAdrress, databaseName, dbDatabaseName, exchangeServer, dbExchangeServer,
	    adGroupName, discoverByType, isAutoDiscovered, mailBoxType, emailStatus, deleted, autoDiscover, associated, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails)
	SELECT
	    mb.value('user[1]/@userGUID', 'NVARCHAR(MAX)') userGuid,
	    mb.value('@displayName', 'NVARCHAR(MAX)') displayName,
	    mb.value('@aliasName', 'NVARCHAR(MAX)') aliasName,
	    mb.value('@smtpAdrress', 'NVARCHAR(MAX)') smtpAdrress,
	    mb.value('@databaseName', 'NVARCHAR(MAX)') databaseName,
	    db.value('@databaseName', 'NVARCHAR(MAX)') dbDatabaseName,
	    mb.value('@exchangeServer', 'NVARCHAR(MAX)') exchangeServer,
	    db.value('@exchangeServer', 'NVARCHAR(MAX)') dbExchangeServer,
	    ag.value('@adGroupName', 'NVARCHAR(MAX)') adGroupName,
	    ed.value('@discoverByType', 'INT') discoverByType,
	    mb.value('@isAutoDiscoveredUser', 'INT') isAutoDiscoveredUser,
	    mb.value('@mailBoxType', 'NVARCHAR(MAX)') mailBoxType,
	    ref.value('@emailStatus', 'INT') emailStatus,
	    CASE WHEN ref.value('@emailStatus', 'INT') = 1 THEN 1 ELSE 0 END deleted,
	    op.value('@enableAutoDiscovery', 'INT') autoDiscover,
	    mb.value('@associated', 'INT') associated,
		mb.value('@objectGuid', 'NVARCHAR(MAX)') objectGuid,
		mb.value('@azureGuid', 'NVARCHAR(MAX)') azureGuid,
		mb.value('@immutableId', 'NVARCHAR(MAX)') immutableId,
		ISNULL(mb.value('@exchangeVersion', 'INT'),0) exchangeVersion,
		ISNULL(mb.value('@msExchRecipientTypeDetails', 'INT'),0) msExchRecipientTypeDetails
	FROM @i_xmlString.nodes ('Ida_SetEmailAutoDiscoverAssocReq') R(ref)
	OUTER APPLY ref.nodes('./emailDiscoverinfo') I(ed)
	OUTER APPLY ed.nodes('./mailBoxes') M(mb)
	OUTER APPLY ed.nodes('./databases') D(db)
	OUTER APPLY ed.nodes('./adGroups') G(ag)
	OUTER APPLY ref.nodes('./advanceOptions') O(op)
--CREATE TEMP TABLE FOR SECURITY
	IF object_id('tempdb.dbo.#SecurityTbl') IS NOT NULL
		DROP TABLE #SecurityTbl
	CREATE TABLE #SecurityTbl
				(id INT IDENTITY(1,1), returnedUserId INT, nodeCapability BIGINT, childCapability BIGINT)
	CREATE UNIQUE CLUSTERED INDEX SecurityTbl_id_Index1 ON #SecurityTbl (id DESC)
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	CREATE TABLE #output_PolicyAssocTable
(assocId INT, userGuid VARCHAR(40), mailBoxType INT, databaseName NVARCHAR(1024) NULL, exchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, displayName NVARCHAR(1024) NULL)
	CREATE CLUSTERED INDEX #output_PolicyAssocTable_assocId_userGuid_Index1 ON #output_PolicyAssocTable ([assocId], [userGuid])
      IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
        DROP TABLE #emailConfiguration_PolicyAssocTable
    CREATE TABLE #emailConfiguration_PolicyAssocTable
(assocId INT, userGuid VARCHAR(40) DEFAULT NEWID(), displayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', smtpAdrress NVARCHAR(255) NULL DEFAULT '', databaseName NVARCHAR(1024) NULL DEFAULT '',
exchangeServer NVARCHAR(1024) NULL DEFAULT '', adGroupName NVARCHAR(1024) NULL DEFAULT '', discoverByType INT NULL DEFAULT 0, isAutoDiscovered INT NULL DEFAULT 0, mailBoxType INT,
                emailStatus INT NULL DEFAULT 0, deleted INT, autoDiscover INT, associated INT DEFAULT 0, coreId INT DEFAULT 0, attrVal NVARCHAR(MAX),
objectGuid NVARCHAR(40) NULL, azureGuid NVARCHAR(40) NULL, immutableId NVARCHAR(40) NULL, exchangeVersion INT, msExchRecipientTypeDetails INT DEFAULT 1)
    CREATE CLUSTERED INDEX #emailConfiguration_PolicyAssocTable_userGuid_discoverByType_assocId_Index1 ON #emailConfiguration_PolicyAssocTable ([userGuid], [discoverByType], [assocId])
	--Create temp table to insert values in db
    IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
        DROP TABLE #emailConfiguration_CompareTable
    CREATE TABLE #emailConfiguration_CompareTable
(assocId INT, userGuid VARCHAR(40), displayName NVARCHAR(255), aliasName NVARCHAR(255), smtpAdrress NVARCHAR(255), databaseName NVARCHAR(1024) NULL,
exchangeServer NVARCHAR(1024) NULL, adGroupName NVARCHAR(1024) NULL, deleteIt INT, mailboxType INT, discoverByType INT, emailStatus INT, deleted INT,
clientId INT, backupsetId INT, subclientId INT, autoDiscover INT, exchangeVersion INT, msExchRecipientTypeDetails INT DEFAULT 1, newAssocId INT)
    CREATE CLUSTERED INDEX #emailConfiguration_CompareTable_userGuid_Index1 ON #emailConfiguration_CompareTable ([userGuid])
	INSERT #emailConfiguration_PolicyAssocTable (assocId, userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
			emailStatus, deleted, autoDiscover, associated, attrVal, objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails)
	SELECT	0, ISNULL(CASE WHEN userGuid IS NULL THEN csUserGuid
			ELSE userGuid END, '') userGuid,
		CASE WHEN displayName IS NULL THEN csDisplayName
			ELSE displayName END displayName,
		CASE WHEN aliasName IS NULL THEN csAliasName
			ELSE aliasName END aliasName,
		CASE WHEN smtpAdrress IS NULL THEN csSmtpAdrress
			ELSE smtpAdrress END smtpAdrress,
		CASE WHEN databaseName IS NULL THEN dbDatabaseName
			ELSE databaseName END databaseName,
		CASE WHEN exchangeServer IS NULL THEN dbExchangeServer
			ELSE exchangeServer END exchangeServer,
		adGroupName,
		discoverByType,
		isAutoDiscovered,
		CASE WHEN mailBoxType IS NULL THEN csMailBoxType
			ELSE mailBoxType END mailBoxType,
		--mp.query('./emailPolicies') policies,
		ISNULL(emailStatus, 0),
		deleted,
		ISNULL(autoDiscover, 0),
		associated,
		attrVal,
		objectGuid, azureGuid, immutableId, exchangeVersion, msExchRecipientTypeDetails
	FROM #emailConfiguration_PolicyAssocXMLTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocXMLTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocXMLTable
	IF @emailStatus = 1		--EmailStatusType.DELETED
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
										deleteIt, mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, exchangeVersion, msExchRecipientTypeDetails)
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		0 deleteIt, EA.mailBoxType, EA.discoverByType, CP.emailStatus, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.exchangeVersion, EA.msExchRecipientTypeDetails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON EA.modified = 0 AND EA.subClientId = @subClientId
			AND CP.discoverByType = EA.discoverByType AND
			((CP.discoverByType = @DISCOVERTYPE_USER AND LEN(EA.userGuid) > 0 AND CP.userGuid = EA.userGuid)
				OR (CP.discoverByType = @DISCOVERTYPE_DATABASE AND CP.databaseName = EA.databaseName)
				OR (CP.discoverByType = @DISCOVERTYPE_ADGROUPS AND CP.adGroupName = EA.adGroupName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_USERS)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS))
	END
	ELSE
	BEGIN
		INSERT INTO #emailConfiguration_CompareTable (assocId, userGuid, displayName, aliasName, smtpAdrress, exchangeServer, databaseName, adGroupName,
										deleteIt, mailboxType, discoverByType, emailStatus, deleted, clientId, backupsetId, subclientId, autoDiscover, exchangeVersion, msExchRecipientTypeDetails)
		SELECT EA.assocId, EA.userGuid, EA.displayName, EA.aliasName, EA.smtpAdrress, EA.exchangeServer, EA.databaseName, EA.adGroupName,
		0 deleteIt, EA.mailBoxType, EA.discoverByType, CP.emailStatus, EA.deleted, 0, 0, EA.subClientId, EA.autoDiscover, EA.exchangeVersion, EA.msExchRecipientTypeDetails
		FROM #emailConfiguration_PolicyAssocTable CP
		JOIN APP_EmailConfigPolicyAssoc (READUNCOMMITTED) EA ON  EA.modified = 0 AND EA.subClientId = @subClientId
		AND CP.discoverByType = EA.discoverByType AND
		((CP.discoverByType = @DISCOVERTYPE_USER AND LEN(EA.userGuid) > 0 AND CP.userGuid = EA.userGuid)
				OR (CP.discoverByType = @DISCOVERTYPE_DATABASE AND CP.databaseName = EA.databaseName)
				OR (CP.discoverByType = @DISCOVERTYPE_ADGROUPS AND CP.adGroupName = EA.adGroupName)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_USERS)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS)
				OR (cp.discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS))
	END
	IF NOT EXISTS(SELECT TOP 1 assocId FROM #emailConfiguration_CompareTable)
	OR (SELECT count(associd) FROM #emailConfiguration_PolicyAssocTable) !=  (SELECT COUNT(associd) from #emailConfiguration_CompareTable)
	BEGIN
		--Return code Association doesn't exist
SET @errorCode =  (409 | (CAST(POWER(2, 24) AS BIGINT) * 28))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	BEGIN
	BEGIN TRAN
		IF @emailStatus = 1
		BEGIN
			-- Remove policies associated with auto discovered assocations
			UPDATE APP_EmailConfigPolicies
			SET modified = @nowTimeUnix
			FROM(
				SELECT Associd from #emailConfiguration_CompareTable
			) EC
			WHERE APP_EmailConfigPolicies.componentNameId =  EC.assocID
			--Mark deleted for Group and Database associations
			UPDATE APP_EmailConfigPolicyAssoc
			SET modified = @nowTimeUnix,
			status = @emailStatus,
			deleted = 1
			FROM(
				SELECT Associd from #emailConfiguration_CompareTable where discoverByType in (@DISCOVERTYPE_DATABASE, @DISCOVERTYPE_ADGROUPS)
			) EC
			WHERE APP_EmailConfigPolicyAssoc.assocId =  EC.assocID
			AND APP_EmailConfigPolicyAssoc.subclientId = @subClientId
			--Mark other auto discovered associations as disabled, since we don't remove them
			UPDATE APP_EmailConfigPolicyAssoc
			SET status = @EMAIL_DISABLED
			FROM(
				SELECT Associd from #emailConfiguration_CompareTable where discoverByType NOT IN (@DISCOVERTYPE_DATABASE, @DISCOVERTYPE_ADGROUPS)
			) EC
			WHERE APP_EmailConfigPolicyAssoc.assocId =  EC.assocID
			AND APP_EmailConfigPolicyAssoc.subclientId = @subClientId
			GOTO ERROR
		END
		--Age current entries
		UPDATE APP_EmailConfigPolicyAssoc
		SET modified = @nowTimeUnix
		FROM(
			SELECT Associd from #emailConfiguration_CompareTable
		) EC
		WHERE APP_EmailConfigPolicyAssoc.assocId =  EC.assocID
		AND APP_EmailConfigPolicyAssoc.subclientId = @subClientId
		--Insert new entries in table
		MERGE APP_EmailConfigPolicyAssoc EC
		USING
		(
			SELECT C.* FROM #emailConfiguration_CompareTable C
			WHERE deleted = 0
		) AS PA ON PA.associd = EC.associd AND EC.subClientId = @subClientId AND EC.modified = 0 AND PA.discoverByType = EC.discoverByType
		WHEN NOT MATCHED THEN
			INSERT (userGuid, displayName, aliasName, smtpAdrress, databaseName, exchangeServer, adGroupName, discoverByType, isAutoDiscovered, mailBoxType,
						clientId, backupsetId, subClientId, ownerId, created, modified, flags, status, deleted, autoDiscover, coreId, password, mailBoxSize, description,
						planId, objectGuid, azureGuid, immutableId, exchangeVersion, discoveryVersion, msExchRecipientTypeDetails)
			VALUES(ISNULL(PA.userGuid, ''), PA.displayName, PA.aliasName, PA.smtpAdrress, PA.databaseName, PA.exchangeServer, PA.adGroupName, PA.discoverByType, @autoDiscover, PA.mailBoxType,
						@clientId, @backupsetId, @subClientId, @userId, @nowUtcUnix, 0, @flags, PA.emailStatus, PA.deleted, @autoDiscover, 0, NULL, NULL, NULL,
						@planId, NULL, NULL, NULL, PA.exchangeVersion, @discoveryVersion, PA.msExchRecipientTypeDetails)
			OUTPUT INSERTED.assocId, INSERTED.userGuid, INSERTED.mailBoxType, INSERTED.databaseName, INSERTED.exchangeServer, INSERTED.adGroupName, INSERTED.displayName INTO #output_PolicyAssocTable;
		SET @errorCode = @@ERROR
		--If we added new row for update then age old policies
		IF EXISTS (SELECT assocId FROM #output_PolicyAssocTable)
		BEGIN
			--Age old policies for given associations
			UPDATE APP_EmailConfigPolicies
			SET modified = @nowUtcUnix
			FROM
			(
				SELECT CP.assocId
				FROM #emailConfiguration_CompareTable CP
			) EP
			WHERE modified = 0 AND EP.assocId = componentNameId
		END
		--Insert new policy
		MERGE APP_EmailConfigPolicies CP
		USING
		(
			SELECT CP.assocId, PT.policyType, PT.policyId
			FROM @policyTable PT, #output_PolicyAssocTable CP
			WHERE policyId > 0
		) AS PT ON CP.modified = 0 AND PT.assocId = CP.componentNameId AND PT.policyType = CP.policyType AND PT.policyId = CP.policyId
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, policyType, policyId, created, modified)
			VALUES(assocId, policyType, policyId, @nowUtcUnix, 0);
		--Update associd for DB/ADGROUP/ALLUSERS entries in temp table to have new assocId
		UPDATE #emailConfiguration_CompareTable
		SET newAssocId = T.assocId
		FROM
		(
			SELECT assocId, databaseName dbName, exchangeServer serverName,  adGroupName groupName, displayName dsName FROM #output_PolicyAssocTable
		) T
		WHERE (discoverByType = @DISCOVERTYPE_ADGROUPS AND groupName = adGroupName)
				OR (discoverByType = @DISCOVERTYPE_DATABASE AND T.dbName = databaseName AND T.serverName = exchangeServer)
				OR (discoverByType = @DISCOVERTYPE_ALL_USERS AND T.dsName = displayName)
				OR (discoverByType = @DISCOVERTYPE_ALL_OFFICE365_GROUPS AND T.dsName = displayName)
				OR (discoverByType = @DISCOVERTYPE_ALL_PUBLIC_FOLDERS AND T.dsName = displayName)
		--Copy old policies which are not changed
		MERGE APP_EmailConfigPolicies CP
		USING
		(
			SELECT C.newAssocId as newAssocId, C.assocId as oldAssocId, A.policyType, A.policyId
			FROM APP_EmailConfigPolicies A, #emailConfiguration_CompareTable C
			WHERE A.policyId > 0 and A.componentNameId = C.assocId and A.policyType NOT IN(SELECT policyTYpe FROM @policyTable)
		)
		AS PT ON CP.modified = 0 AND PT.newAssocId = CP.componentNameId AND PT.policyType = CP.policyType
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, policyType, policyId, created, modified)
			VALUES(newAssocId, policyType, policyId, @nowUtcUnix, 0);
END
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT @errorCode '@errorCode',
					@errorString '@errorMessage'
			FOR XML PATH ('resp'), TYPE
			)
		FOR XML PATH(''), ROOT('Ida_EmailAssociationsResp')
    )
	SELECT @o_xmlString
	--Delete temp tables
	IF object_id('tempdb.dbo.#SecurityTbl') IS NOT NULL
		DROP TABLE #SecurityTbl
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
		DROP TABLE #emailConfiguration_PolicyAssocTable
	IF object_id('tempdb.dbo.#emailConfiguration_CompareTable') is not null
		DROP TABLE #emailConfiguration_CompareTable
	IF object_id('tempdb.dbo.#emailConfiguration_PolicyAssocTable') is not null
			DROP TABLE #emailConfiguration_PolicyAssocTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppEmailAutoDiscoverAssocSet')
	delete from GxQscripts where name = 'AppEmailAutoDiscoverAssocSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEmailAutoDiscoverAssocSet')
	delete from GXDBVersions where aliasname = 'AppEmailAutoDiscoverAssocSet'
GO

insert into GXDBVersions values(2, 'AppEmailAutoDiscoverAssocSet',  '00010001000200130000', 'AppEmailAutoDiscoverAssocSet', '00010001000200130000')
GO

