

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEdgeSessionGet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppEdgeSessionGet()
--  | Description:  Allows for GET for AppEdgeSession Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEdgeSessionGet.sp,v $ $Id: AppEdgeSessionGet.sp,v 1.1.2.1 2016/03/07 21:24:49 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppEdgeSessionGet <<<'

IF EXISTS (select * from sysobjects where name='AppEdgeSessionGet')
	drop procedure AppEdgeSessionGet
IF EXISTS (select * from GxQscripts where name='AppEdgeSessionGet')
	delete from GxQscripts where name = 'AppEdgeSessionGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgeSessionGet')
	delete from GXDBVersions where aliasname = 'AppEdgeSessionGet'
GO
print '... Creating Procedure: AppEdgeSessionGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEdgeSessionGet
  @i_machinekey nvarchar(512),
  @errCode integer		OUTPUT,
  @errString nvarchar(1024)	OUTPUT
AS
BEGIN TRY
	BEGIN
		IF NOT EXISTS (select top 1 *  from App_EdgeSession where machineKey =  @i_machinekey)
		BEGIN
			SET @errCode = 1003
			SET @errString	=	'No Data to Return'
		END
		ELSE
		BEGIN
			select machineGUID,flag  from App_EdgeSession where machineKey =  @i_machinekey
			SET @errCode = 0
			SET @errString	=	'Request completed Successfully.'
		END
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppEdgeSessionGet')
	delete from GxQscripts where name = 'AppEdgeSessionGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgeSessionGet')
	delete from GXDBVersions where aliasname = 'AppEdgeSessionGet'
GO

insert into GXDBVersions values(2, 'AppEdgeSessionGet',  '00010001000200010000', 'AppEdgeSessionGet', '00010001000200010000')
GO

