

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEdgeSessionAdd.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppEdgeSessionAdd()
--  | Description:  Allows for Add/Edit for AppEdgeSession Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEdgeSessionAdd.sp,v $ $Id: AppEdgeSessionAdd.sp,v 1.1.2.1 2016/03/07 21:24:49 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppEdgeSessionAdd <<<'

IF EXISTS (select * from sysobjects where name='AppEdgeSessionAdd')
	drop procedure AppEdgeSessionAdd
IF EXISTS (select * from GxQscripts where name='AppEdgeSessionAdd')
	delete from GxQscripts where name = 'AppEdgeSessionAdd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgeSessionAdd')
	delete from GXDBVersions where aliasname = 'AppEdgeSessionAdd'
GO
print '... Creating Procedure: AppEdgeSessionAdd'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEdgeSessionAdd
  @i_machinekey nvarchar(512),
  @i_machineGuid nvarchar(512),
  @i_flag integer = 1,
  @errCode integer		OUTPUT,
  @errString nvarchar(1024)	OUTPUT
AS
BEGIN TRY
	-- local variables
	DECLARE @nowTime		AS integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @l_flag			INT = 0
	DECLARE @l_machineGuid nvarchar(512) = ''
	BEGIN
		select @l_flag = flag, @l_machineGuid=machineGUID from App_EdgeSession where machineKey like  @i_machinekey
		IF LEN(@l_machineGuid) <= 0
			BEGIN
				insert into App_EdgeSession(machineKey,machineGUID,created,modified,flag)
							values(@i_machinekey, @i_machineGuid, @nowTime, @nowTime , @i_flag)
			-- Second Delete any older value for this machine .. means for the provided GUID that we might have in the DB
			delete from App_EdgeSession where machineGUID like  @i_machineGuid and  machineKey not like  @i_machinekey
			SET @errCode = 0
			SET @errString	=	'Request completed Successfully.'
			END
		ELSE IF ((@l_flag = 1) and (@i_machineGuid = @l_machineGuid) or ((@l_flag = 0))) AND (@i_flag != @l_flag)
			-- First Update the DB with new Value
			BEGIN
				Update App_EdgeSession SET flag=@i_flag, modified=@nowTime where machineKey like  @i_machinekey
				SET @errCode = 0
				SET @errString	=	'Request completed Successfully.'
			END
		ELSE
			BEGIN
				IF (@i_machineGuid != @l_machineGuid)
				BEGIN
					SET @errCode = 1001
					SET @errString	=	'Machine with this ID is already in active state. Cannot register this machine.'
				END
				ELSE IF (@i_flag = @l_flag)
				BEGIN
					SET @errCode = 1002
					SET @errString	=	'Flag is already in the set in DB with the provided value. DB update Skipped'
				END
			END
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppEdgeSessionAdd')
	delete from GxQscripts where name = 'AppEdgeSessionAdd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgeSessionAdd')
	delete from GXDBVersions where aliasname = 'AppEdgeSessionAdd'
GO

insert into GXDBVersions values(2, 'AppEdgeSessionAdd',  '00010001000200010000', 'AppEdgeSessionAdd', '00010001000200010000')
GO

