

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEdgePendingEditGet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppEdgePendingEditGet()
--  | Description:  Allows for Get for App_EdgePendingEdit Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEdgePendingEditGet.sp,v $ $Id: AppEdgePendingEditGet.sp,v 1.1.2.1 2016/03/07 21:24:49 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppEdgePendingEditGet <<<'

IF EXISTS (select * from sysobjects where name='AppEdgePendingEditGet')
	drop procedure AppEdgePendingEditGet
IF EXISTS (select * from GxQscripts where name='AppEdgePendingEditGet')
	delete from GxQscripts where name = 'AppEdgePendingEditGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgePendingEditGet')
	delete from GXDBVersions where aliasname = 'AppEdgePendingEditGet'
GO
print '... Creating Procedure: AppEdgePendingEditGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEdgePendingEditGet
  @i_machinekey nvarchar(512),
  @o_fileGUID nvarchar(1024)		OUTPUT,
  @errCode integer			OUTPUT,
  @errString nvarchar(1024)		OUTPUT
AS
BEGIN TRY
	-- local variables
	-- Threshold time is 30 mins back. 30*60 = 1800 secs
	DECLARE @thresholdTime		AS integer = dbo.GetUnixTime (GetUTCdate()) - 1800
	BEGIN
		SET @o_fileGUID = ''
		select @o_fileGUID  = fileGUID from App_EdgePendingEdit where machineKey =  @i_machinekey and modified >= @thresholdTime
		IF LEN(@o_fileGUID) > 0
		BEGIN
			delete from App_EdgePendingEdit where machineKey =  @i_machinekey
			SET @errCode = 0
			SET @errString	= 'Pending File Data Added as Output and row updated for Read status.'
		END
		ELSE
		BEGIN
			SET @errCode = 1000
			SET @errString	= 'No Data to Return'
		END
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppEdgePendingEditGet')
	delete from GxQscripts where name = 'AppEdgePendingEditGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgePendingEditGet')
	delete from GXDBVersions where aliasname = 'AppEdgePendingEditGet'
GO

insert into GXDBVersions values(2, 'AppEdgePendingEditGet',  '00010001000200010000', 'AppEdgePendingEditGet', '00010001000200010000')
GO

