

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppEdgePendingEditAdd.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppEdgePendingEditAdd()
--  | Description:  Allows for Add/Edit for App_EdgePendingEdit Table
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppEdgePendingEditAdd.sp,v $ $Id: AppEdgePendingEditAdd.sp,v 1.1.2.1 2016/03/07 21:24:49 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppEdgePendingEditAdd <<<'

IF EXISTS (select * from sysobjects where name='AppEdgePendingEditAdd')
	drop procedure AppEdgePendingEditAdd
IF EXISTS (select * from GxQscripts where name='AppEdgePendingEditAdd')
	delete from GxQscripts where name = 'AppEdgePendingEditAdd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgePendingEditAdd')
	delete from GXDBVersions where aliasname = 'AppEdgePendingEditAdd'
GO
print '... Creating Procedure: AppEdgePendingEditAdd'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppEdgePendingEditAdd
  @i_machinekey nvarchar(512),
  @i_fileGUID nvarchar(1024)  = '',
  @errCode integer		OUTPUT,
  @errString nvarchar(1024)	OUTPUT
AS
BEGIN TRY
	-- local variables
	DECLARE @nowTime		AS integer = dbo.GetUnixTime (GetUTCdate())
	BEGIN
		IF EXISTS (select fileGUID from App_EdgePendingEdit where machineKey =  @i_machinekey)
			BEGIN
				Update App_EdgePendingEdit SET fileGUID=@i_fileGUID, modified=@nowTime where machineKey =  @i_machinekey
				SET @errCode = 0
				SET @errString	=	'Data Updated Successfully.'
			END
		ELSE
			BEGIN
				insert into App_EdgePendingEdit(machineKey,fileGUID,created,modified,flag)
							values(@i_machinekey, @i_fileGUID, @nowTime, @nowTime , 0)
				SET @errCode = 0
				SET @errString	=	'Data Inserted Successfully.'
			END
	END
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppEdgePendingEditAdd')
	delete from GxQscripts where name = 'AppEdgePendingEditAdd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppEdgePendingEditAdd')
	delete from GXDBVersions where aliasname = 'AppEdgePendingEditAdd'
GO

insert into GXDBVersions values(2, 'AppEdgePendingEditAdd',  '00010001000200010000', 'AppEdgePendingEditAdd', '00010001000200010000')
GO

