

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDissocSubClientPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDissocSubClientPolicy.sp,v $ $Id: AppDissocSubClientPolicy.sp,v 1.1.2.16 2020/07/15 21:10:13 jswaminathan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 					Procedure: "AppDissocSubClientPolicy"				|
--	| 					Previously Cursor: "AppDissocSCP"					|
--	|																		|
--  |Dissociate Subclient Policy and underneath subclients from backupset	|
--	|  Converted from Cursor of same name 22-Jun-2017	-Anchal Goyal		|
--  |backupset to be disassociated can be either provided via input bsId or |
--  |through temp table #DissociateBackupsets							    |
-- 	+-----------------------------------------------------------------------+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDissocSubClientPolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppDissocSubClientPolicy <<<'
	drop procedure AppDissocSubClientPolicy
END
IF EXISTS (select * from GxQscripts where name='AppDissocSubClientPolicy')
	delete from GxQscripts where name = 'AppDissocSubClientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDissocSubClientPolicy')
	delete from GXDBVersions where aliasname = 'AppDissocSubClientPolicy'
GO
print '... Creating Procedure: AppDissocSubClientPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDissocSubClientPolicy
  @bsId integer,
  @timeStamp integer
AS
  DECLARE @rc integer
SET NOCOUNT ON
	BEGIN
IF OBJECT_ID('tempdb.dbo.#DecoupledRetentionProperties') IS NOT null
DROP TABLE #DecoupledRetentionProperties
CREATE TABLE #DecoupledRetentionProperties
(
	attrName nvarchar(510)
)
INSERT #DecoupledRetentionProperties(attrName)
VALUES(N'Archived expiration days'),
		(N'Is Turbo Subclient'),
		(N'Is Archive Retention Mode Enabled'),
		(N'Is Backup Retention Mode Enabled'),
		(N'Days to keep items past their expiration'),
		(N'Keep older Synth Full Versions'),
		(N'Keep items past their expiration'),
		(N'Number of Days of Synth Full Versions'),
		(N'Number of Synth Full Versions'),
		(N'User deleted stubs expiration days'),
		(N'Retain daily version period'),
		(N'Retain weekly version period'),
		(N'Retain monthly version period')
	   DECLARE @LocalAttrTable TABLE (attr NVARCHAR(MAX))
		INSERT INTO @LocalAttrTable VALUES ('System State')
		INSERT INTO @LocalAttrTable VALUES ('use cs setting for global filters')
		INSERT INTO @LocalAttrTable VALUES ('use global filters')
IF OBJECT_ID('tempdb.dbo.#decoupledArchivalRules') IS NOT NULL
	DROP TABLE #decoupledArchivalRules
CREATE TABLE #decoupledArchivalRules
(
	attrName VARCHAR(MAX),
	cs_attrName INT
)
INSERT INTO #decoupledArchivalRules
VALUES	('Num of Days Old',							CHECKSUM(N'Num of Days Old')),
('Num of Days Old Modified',					CHECKSUM(N'Num of Days Old Modified')),
('Minimum File Size',							CHECKSUM(N'Minimum File Size')),
('Num of Days Old Created',					CHECKSUM(N'Num of Days Old Created')),
('Maximum File Size',							CHECKSUM(N'Maximum File Size')),
('DiskCleanup File Types',				CHECKSUM(N'DiskCleanup File Types')),
('Low Percent Disk Space Free',			CHECKSUM(N'Low Percent Disk Space Free')),
('Percent Disk Space Free',				CHECKSUM(N'Percent Disk Space Free')),
('Data Migrator Rule Flag',				CHECKSUM(N'Data Migrator Rule Flag')),
('Enable Redundancy For Data Backedup',	CHECKSUM(N'Enable Redundancy For Data Backedup')),
('Stub pruning Options',				CHECKSUM(N'Stub pruning Options')),
('Stub Retention Time',				CHECKSUM(N'Stub Retention Time'))
   	   IF object_id('tempdb.dbo.#scInfo') IS NOT NULL
			DROP TABLE #scInfo
	   CREATE TABLE #scInfo(id INT, clientId INT, appTypeId INT,instance INT,backupSet INT,appNumber INT,dataArchGrpID INT,logArchGrpID INT,refTime INT,modified INT,subclientName nvarchar(128),subclientStatus INT,scpId INT,createdTime INT,isDecoupled INT,useSubclientPolicyRetention INT, isArchiveSubclient INT DEFAULT(0), useLocalArchivalRule INT DEFAULT(0))
	   IF OBJECT_ID('tempdb.dbo.#DissocSCPSubclients') IS NOT NULL
	   BEGIN
			INSERT INTO #scInfo(id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,scpId,isDecoupled,useSubclientPolicyRetention)
			SELECT id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,0,0,0
			FROM APP_Application WITH (NOLOCK) INNER JOIN #DissocSCPSubclients ON id = subclientId
	   END
	   ELSE IF @bsId<>0
		    INSERT INTO #scInfo(id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,scpId,isDecoupled,useSubclientPolicyRetention)
			SELECT id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,0,0,0
			FROM APP_Application WITH (NOLOCK) WHERE backupset = @bsId
	   ELSE
			INSERT INTO #scInfo(id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,scpId,isDecoupled,useSubclientPolicyRetention)
			SELECT App.id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,0,0,0
			FROM APP_Application APP WITH (NOLOCK) INNER JOIN #DissociateBackupsets ON App.backupset = backupsetId
		UPDATE SCI SET SCI.scpId = SCP.attrVal,  SCI.createdTime = SCP.created
		FROM #scInfo  SCI
		INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)  ON SCP.componentnameId = SCI.id and SCP.attrName = N'Associated subclient Policy' and SCP.cs_attrName = CHECKSUM(N'Associated subclient Policy') and SCP.modified = 0
		--Dont process subclients that don't have subclient policy associated
		DELETE FROM #scInfo
		WHERE scpId = 0
		UPDATE SCI SET SCI.isDecoupled = attrVal
		FROM #scInfo SCI
INNER JOIN APP_SubClientProp SCP WITH (NOLOCK) ON SCP.componentNameId = SCI.id AND SCP.attrName IN (N'Decouple SCP Content', N'Use Local Content') AND SCP.cs_attrName IN (CHECKSUM(N'Decouple SCP Content'), CHECKSUM(N'Use Local Content')) AND SCP.modified = 0
		-- Fetch "Use Local Archival Rules" for subclient.
		UPDATE SCI SET SCI.isArchiveSubclient = 1, SCI.useLocalArchivalRule = ISNULL(SCP.attrVal, 0)
		FROM #scInfo SCI
		LEFT JOIN APP_SubClientProp SCP WITH (NOLOCK)
			ON SCI.id = SCP.componentNameId
AND SCP.attrName = 'Use Local Archival Rules'
AND SCP.cs_attrName = CHECKSUM(N'Use Local Archival Rules')
			AND SCP.modified = 0
		LEFT JOIN APP_BackupSetProp ABP WITH (NOLOCK)
			ON SCI.backupSet = ABP.componentNameId
AND ABP.attrName = 'Is Archiving Enabled'
			AND ABP.attrVal = '1'
			AND ABP.modified = 0
		LEFT JOIN APP_SubClientProp ASP WITH (NOLOCK)
			ON SCI.id = ASP.componentNameId
AND ASP.attrName = 'Turbo Mode Enable Stubbing'
AND ASP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
			AND ASP.attrVal = '1'
			AND ASP.modified = 0
		WHERE  ABP.componentNameId IS NOT NULL OR ASP.componentNameId IS NOT NULL
		----Insert the subclient content into the associated subclients
		DECLARE @insertSCfile TABLE (appId INT,type INTEGER, filename NVarChar(1024), created INTEGER, modified integer)
		DELETE @insertSCfile
		------------------------ do this only for SCI.isDecoupled=0-------------
		INSERT INTO @insertSCfile
		SELECT distinct SCI.id, type, filename, created, SCF.modified
		FROM APP_scfilterfile SCF WITH (NOLOCK)
		INNER JOIN #scInfo SCI ON SCI.isDecoupled = 0 AND SCF.componentnameId = SCI.scpId AND ( SCF.modified = 0 OR SCF.created > SCI.createdTime)
		UPDATE ISC SET ISC.created = SCI.createdTime
		FROM @insertSCfile ISC
		INNER JOIN #scInfo SCI ON SCI.id = ISC.appId
		WHERE ISC.modified = 0 and ISC.created < SCI.createdTime
		--Insert the subclient content into the associated subclient
		INSERT into App_scfilterFile (componentNameId,type,fileName,created,modified)
			SELECT distinct appId, type, filename, created, modified from @insertSCfile
		---------------------------------------------------------------------------
		-----------------------useSubclientPolicyRetention-------------------------
		UPDATE SCI SET SCI.useSubclientPolicyRetention = ISNULL(attrVal,0)
		FROM #scInfo SCI
		INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
		ON SCP.componentNameId = SCI.scpId AND SCP.attrName = N'Subclient Policy Has Retention' AND SCP.cs_attrName = CHECKSUM(N'Subclient Policy Has Retention') AND SCP.modified = 0
		---------------------------------------------------------------------------
		DECLARE @insertSCProp TABLE (appId INT,attrName NVarChar(256), attrTYpe integer,  attrVal nvarchar(1024), created INTEGER, modified integer)
		DELETE @insertSCProp
 		----Insert the subclient properties into the associated subclient
 		INSERT into @insertSCProp (appId,attrName, attrType, attrVal, created, modified)
			SELECT distinct  SCI.id, SCP.attrName, attrType, attrVal, created, SCP.modified
			FROM APP_subclientprop SCP WITH (NOLOCK)
			INNER JOIN #scInfo SCI ON SCP.componentnameId = SCI.scpId AND (SCP.modified = 0 OR SCP.created > SCI.createdTime)
			LEFT JOIN #decoupledArchivalRules LATR ON SCP.attrName = LATR.attrName
			WHERE ((SCI.useSubclientPolicyRetention > 0 ) OR ( SCI.useSubclientPolicyRetention = 0 AND SCP.attrName NOT IN ( SELECT attrName FROM #DecoupledRetentionProperties ) ))
			       AND (SCI.isDecoupled = 0 OR SCP.attrName NOT IN (SELECT attr from @LocalAttrTable))
				   AND (SCI.useLocalArchivalRule = 0
				   		OR (SCI.isArchiveSubclient = 1 AND SCI.useLocalArchivalRule = 1 AND LATR.attrName IS NULL))
		UPDATE ISC SET ISC.created = SCI.createdTime
		FROM @insertSCProp ISC INNER JOIN #scInfo SCI ON SCI.id = ISC.appId
		WHERE ISC.modified = 0 and ISC.created < SCI.createdTime
		/*****************************************************************************************************************
		If the properties are transferred to a 9.0 client, check for the property - Use VSS Options and Use VSS Enabled
		Based on these set the value Use Shadow Copy
		******************************************************************************************************************/
		-----------for release < 15----------------
		UPDATE ISC SET ISC.attrName = 'Use Shadow Copy'
		FROM @insertSCProp ISC
		INNER JOIN #scInfo SCI ON ISC.appId = SCI.id AND ISC.attrName = 'Use VSS Enabled' AND ISC.modified = 0
		INNER JOIN App_Client Client WITH(NOLOCK) ON SCI.clientId = Client.id AND Client.releaseId<15
		--If Use VSS Enabled does not exist, then no need to do any change. Use Shadow Copy will be OFF by default.
		DELETE ISC
		FROM @insertSCProp ISC
		INNER JOIN #scInfo SCI ON ISC.appId = SCI.id AND  (ISC.attrName = 'Use VSS Enabled' OR ISC.attrName = 'Use VSS Options')
		INNER JOIN App_Client Client WITH(NOLOCK) ON SCI.clientId = Client.id AND Client.releaseId<15
		----------------------------------------------
		UPDATE SCP SET SCP.modified = @timestamp
		FROM App_SubClientProp SCP
		INNER JOIN @insertSCProp ISC ON ISC.appId = SCP.componentNameId AND SCP.attrName = ISC.attrName AND SCP.cs_attrName = CHECKSUM(ISC.attrName) AND SCP.modified = 0
		INSERT INTO APP_subclientProp(componentNameId,attrName,attrType,attrVal,created,modified)
		SELECT distinct appId, attrName, attrType, attrVal, created, modified from @insertSCProp
		UPDATE SCP SET SCP.modified = @timeStamp
		FROM APP_SubClientProp SCP
		INNER JOIN #scInfo SCI ON SCP.componentNameId = SCI.id
		AND SCP.attrName IN (N'Associated subclient Policy', N'Decouple SCP Content')
		AND SCP.cs_attrName IN (CHECKSUM(N'Associated subclient Policy'), CHECKSUM(N'Decouple SCP Content'))
		AND SCP.modified = 0
		-----------------------------------------------------
		--Remove the association in backupset prop and also remove higher level association properties (if present)
		IF @bsId<>0
			Update APP_BackupSetProp SET modified = @timeStamp
			WHERE componentnameId = @bsId
			AND (attrName = N'Associated subclient Policy' OR attrName = N'Subclient Policy Association Level' OR attrName = N'Client Group For SCP Association') and modified = 0
		ELSE IF OBJECT_ID('tempdb.dbo.#DissocSCPSubclients') IS NOT NULL
		BEGIN
			UPDATE BSProp
				SET BSProp.modified=@timeStamp
				FROM APP_BackupSetProp BSProp
			INNER JOIN #scInfo SC
				ON SC.backupSet=BSProp.componentNameId
			WHERE (BSProp.attrName = N'Associated subclient Policy' OR BSProp.attrName = N'Subclient Policy Association Level' OR BSProp.attrName = N'Client Group For SCP Association') and BSProp.modified = 0
		END
		ELSE IF OBJECT_ID('tempdb.dbo.#DissociateBackupsets') IS NOT NULL
			Update BSProp SET BSProp.modified = @timeStamp
			FROM APP_BackupSetProp BSProp
			INNER JOIN #DissociateBackupsets BDA  ON BSProp.componentnameId = BDA.backupsetId
			AND (attrName = N'Associated subclient Policy' OR attrName = N'Subclient Policy Association Level' OR attrName = N'Client Group For SCP Association') and modified = 0
	END
	select @@rowcount
	DROP TABLE #scInfo
GO

IF EXISTS (select * from GxQscripts where name = 'AppDissocSubClientPolicy')
	delete from GxQscripts where name = 'AppDissocSubClientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDissocSubClientPolicy')
	delete from GXDBVersions where aliasname = 'AppDissocSubClientPolicy'
GO

insert into GXDBVersions values(2, 'AppDissocSubClientPolicy',  '00010001000200160000', 'AppDissocSubClientPolicy', '00010001000200160000')
GO

