

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDissocSCPForSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 					Procedure: "AppDissocSCPForSubclient"				|
--	| 																		|
--	|																		|
--  |Dissociate Subclient Policy from a single subclient					|
-- 	+-----------------------------------------------------------------------+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDissocSCPForSubclient')
BEGIN
	print '>>> Drop Stored Procedure: AppDissocSCPForSubclient <<<'
	drop procedure AppDissocSCPForSubclient
END
IF EXISTS (select * from GxQscripts where name='AppDissocSCPForSubclient')
	delete from GxQscripts where name = 'AppDissocSCPForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDissocSCPForSubclient')
	delete from GXDBVersions where aliasname = 'AppDissocSCPForSubclient'
GO
print '... Creating Procedure: AppDissocSCPForSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDissocSCPForSubclient
  @i_scId integer
AS
DECLARE @nowTime INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @errCode INT = 0
DECLARE @errString NVARCHAR(MAX) = ''
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#DissocSCPSubclients') IS NOT NULL
	DROP TABLE #DissocSCPSubclients
	CREATE TABLE #DissocSCPSubclients(subclientId INT PRIMARY KEY)
	INSERT INTO #DissocSCPSubclients
	SELECT @i_scId
	EXEC AppDissocSubClientPolicy 0, @nowTime
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
IF OBJECT_ID('tempdb.dbo.#DissocSCPSubclients') IS NOT NULL
				DROP TABLE #DissocSCPSubclients
SELECT @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDissocSCPForSubclient')
	delete from GxQscripts where name = 'AppDissocSCPForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDissocSCPForSubclient')
	delete from GXDBVersions where aliasname = 'AppDissocSCPForSubclient'
GO

insert into GXDBVersions values(2, 'AppDissocSCPForSubclient',  '00000000000000000000', 'AppDissocSCPForSubclient', '00000000000000000000')
GO

