

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDissocSCPArchivingRules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDissocSCPArchivingRules.sp,v $ $Id: AppDissocSCPArchivingRules.sp,v 1.1.2.2.16.1 2021/01/26 04:01:05 sghatbale Exp $";
-- 	+-----------------------------------------------------------------------------------------------------+
--	| 					Procedure: "AppDissocSCPArchivingRules"													|
--	|																											|
--  |Copy SCP archiving rules from SCP to subclient. To be called when use local archiving rules is turned to enabled.
--	|Does not age them right away. Because not all rules will be specified locally. So whatever is not specified locally
--	|will have the same value as plan. Whatever is specified locally will be updated later.
-- 	+-----------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppDissocSCPArchivingRules')
BEGIN
	print '>>> Drop Stored Procedure: AppDissocSCPArchivingRules <<<'
	drop procedure AppDissocSCPArchivingRules
END
IF EXISTS (select * from GxQscripts where name='AppDissocSCPArchivingRules')
	delete from GxQscripts where name = 'AppDissocSCPArchivingRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDissocSCPArchivingRules')
	delete from GXDBVersions where aliasname = 'AppDissocSCPArchivingRules'
GO
print '... Creating Procedure: AppDissocSCPArchivingRules'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppDissocSCPArchivingRules
  @i_subclientId INTEGER,
  @i_localArchivalRules INTEGER,
  @timeStamp INTEGER
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
 SET NOCOUNT ON
 BEGIN TRY
	SET @errorCode = 0
	SET @errorString = N''
   DECLARE @createSCPTime				INTEGER
   DECLARE @subclientOfSCPId			INTEGER
DECLARE @oldLocalArchivalRules		INTEGER = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @i_subclientId AND modified = 0 AND attrName = 'Use Local Archival Rules' AND cs_attrname=CHECKSUM(N'Use Local Archival Rules')), 0)
   BEGIN
	   SELECT  @subclientOfSCPId = attrval, @createSCPTime= created FROM APP_SubclientProp WHERE componentNameId=@i_subclientId AND attrName='Associated subclient Policy' and cs_attrName=CHECKSUM(N'Associated subclient Policy') AND modified=0
	   -- User has turned Use local archival rules to 1. Till now he was using rule inherited from plan's SCP.
	   -- So copy the archival rules from plan's SCP and put it inside subclient and age it off.
	   IF (@subclientOfSCPId IS NOT NULL) AND (@subclientOfSCPId > 0)
			AND (@i_localArchivalRules = 1)
			AND (@oldLocalArchivalRules = 0)
	   BEGIN
IF OBJECT_ID('tempdb.dbo.#decoupledArchivalRules') IS NOT NULL
	DROP TABLE #decoupledArchivalRules
CREATE TABLE #decoupledArchivalRules
(
	attrName VARCHAR(MAX),
	cs_attrName INT
)
INSERT INTO #decoupledArchivalRules
VALUES	('Num of Days Old',							CHECKSUM(N'Num of Days Old')),
('Num of Days Old Modified',					CHECKSUM(N'Num of Days Old Modified')),
('Minimum File Size',							CHECKSUM(N'Minimum File Size')),
('Num of Days Old Created',					CHECKSUM(N'Num of Days Old Created')),
('Maximum File Size',							CHECKSUM(N'Maximum File Size')),
('DiskCleanup File Types',				CHECKSUM(N'DiskCleanup File Types')),
('Low Percent Disk Space Free',			CHECKSUM(N'Low Percent Disk Space Free')),
('Percent Disk Space Free',				CHECKSUM(N'Percent Disk Space Free')),
('Data Migrator Rule Flag',				CHECKSUM(N'Data Migrator Rule Flag')),
('Enable Redundancy For Data Backedup',	CHECKSUM(N'Enable Redundancy For Data Backedup')),
('Stub pruning Options',				CHECKSUM(N'Stub pruning Options')),
('Stub Retention Time',				CHECKSUM(N'Stub Retention Time'))
			DECLARE @insertSCProp TABLE (appId INT, attrName VARCHAR(MAX), attrType INT, attrVal VARCHAR(MAX), created INTEGER, modified integer, cs_attrName nvarchar(max))
			INSERT INTO @insertSCProp
				SELECT DISTINCT @i_subclientId, SCP.attrName, SCP.attrType, SCP.attrVal, SCP.created, SCP.modified, DAR.cs_attrName
				FROM APP_SubclientProp SCP (NOLOCK)
					INNER JOIN #decoupledArchivalRules DAR
						ON SCP.attrName = DAR.attrName
				WHERE
					SCP.componentnameId = @subclientOfSCPId AND (SCP.modified = 0 OR SCP.created > @createSCPTime)
			UPDATE ISC SET ISC.created = @createSCPTime
			FROM @insertSCProp ISC
			WHERE ISC.modified = 0 and ISC.created < @createSCPTime
			-- Do not age those properties. Whatever user has specified will be aged later and rest all left as is.
			/*UPDATE ISC SET ISC.modified = @timeStamp
			FROM @insertSCProp ISC
			WHERE ISC.modified = 0*/
			-- Age the properties for which new rows are getting to be added
			UPDATE SCP
			SET SCP.modified = @timeStamp
			FROM App_SubClientProp SCP
			INNER JOIN @insertSCProp ISC
				ON ISC.appId = SCP.componentNameId
					AND SCP.attrName = ISC.attrName
					AND SCP.cs_attrName = ISC.cs_attrName
					AND SCP.modified = 0
			--Insert the subclient content into the associated subclient
			INSERT into App_SubclientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT DISTINCT appId, attrname, attrType, attrVal, created, modified
				FROM @insertSCProp
	   END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode    = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	-- That implies no error else we will get exception
   SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppDissocSCPArchivingRules')
	delete from GxQscripts where name = 'AppDissocSCPArchivingRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDissocSCPArchivingRules')
	delete from GXDBVersions where aliasname = 'AppDissocSCPArchivingRules'
GO

insert into GXDBVersions values(2, 'AppDissocSCPArchivingRules',  'v1.1.2.2.16.1', 'AppDissocSCPArchivingRules', 'v1.1.2.2.16.1')
GO

