

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDisassocSCPContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDisassocSCPContent.sp,v $ $Id: AppDisassocSCPContent.sp,v 1.1.2.1 2020/06/26 08:11:17 alakra Exp $";
-- 	+-------------------------------------------------------------------------------------------+
--	| 					Procedure: "AppDisassocSCPContent"										|
--	|																							|
--  |Age off subclient policy conent matched to subclient. Only when local content is enabled	|
-- 	+-------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDisassocSCPContent')
BEGIN
	print '>>> Drop Stored Procedure: AppDisassocSCPContent <<<'
	drop procedure AppDisassocSCPContent
END
IF EXISTS (select * from GxQscripts where name='AppDisassocSCPContent')
	delete from GxQscripts where name = 'AppDisassocSCPContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDisassocSCPContent')
	delete from GXDBVersions where aliasname = 'AppDisassocSCPContent'
GO
print '... Creating Procedure: AppDisassocSCPContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDisassocSCPContent
  @i_subclientId INTEGER,
  @i_localContent INTEGER,
  @timeStamp INTEGER
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
 SET NOCOUNT ON
 BEGIN TRY
	SET @errorCode = 0
	SET @errorString = N''
   DECLARE @createSCPTime				INTEGER
   DECLARE @useSubclientPolicyRetention INTEGER
   DECLARE @subclientOfSCPId			INTEGER
   BEGIN
	   SELECT  @subclientOfSCPId = attrval, @createSCPTime= created FROM APP_SubclientProp WHERE componentNameId=@i_subclientId AND attrName='Associated subclient Policy' and cs_attrName=CHECKSUM(N'Associated subclient Policy') AND modified=0
	   -- Call this code only before local conetnt flag has been set
	   -- We have valid SCP, input local content is 1 and current value is 0
	   -- So, we have to age off content
	   IF (@subclientOfSCPId IS NOT NULL) AND (@subclientOfSCPId > 0)
			AND (@i_localContent=1)
AND EXISTS (SELECT 1 FROM APP_SubclientProp WHERE componentNameId = @i_subclientId AND modified = 0 AND attrName = 'Use Local Content' AND cs_attrname=CHECKSUM(N'Use Local Content') AND attrVal='0')
	   BEGIN
			-- Get content from subclient of SCP and age it off
			-- We are going to refer to local content now
			----Insert the subclient content into the associated subclients
			DECLARE @insertSCfile TABLE (appId INT,type INTEGER, filename NVarChar(1024), created INTEGER, modified integer)
			------------------------ do this only for SCI.isDecoupled=0 (for our case this is enabling of isdecoupled=0)-------------
			INSERT INTO @insertSCfile
			SELECT distinct @i_subclientId, type, filename, created, SCF.modified
			FROM APP_scfilterfile SCF WITH (NOLOCK)
			WHERE SCF.componentnameId = @subclientOfSCPId AND ( SCF.modified = 0 OR SCF.created > @createSCPTime)
			UPDATE ISC SET ISC.created = @createSCPTime
			FROM @insertSCfile ISC
			WHERE ISC.modified = 0 and ISC.created < @createSCPTime
			UPDATE ISC SET ISC.modified = @timeStamp
			FROM @insertSCfile ISC
			WHERE ISC.modified = 0
			--Insert the subclient content into the associated subclient
			INSERT into App_scfilterFile (componentNameId,type,fileName,created,modified)
				SELECT distinct appId, type, filename, created, modified from @insertSCfile
	   END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode    = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	-- That implies no error else we will get exception
   SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppDisassocSCPContent')
	delete from GxQscripts where name = 'AppDisassocSCPContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDisassocSCPContent')
	delete from GXDBVersions where aliasname = 'AppDisassocSCPContent'
GO

insert into GXDBVersions values(2, 'AppDisassocSCPContent',  '00010001000200010000', 'AppDisassocSCPContent', '00010001000200010000')
GO

