

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteSubclientPolicies.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDeleteSubclientPolicies.sp,v $ $Id: AppDeleteSubclientPolicies.sp,v 1.1.2.5 2018/03/27 08:14:35 jiechen Exp $";
-- Replacement for AppDelSCPcur Cursor File
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteSubclientPolicies')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteSubclientPolicies <<<'
	drop procedure AppDeleteSubclientPolicies
END
IF EXISTS (select * from GxQscripts where name='AppDeleteSubclientPolicies')
	delete from GxQscripts where name = 'AppDeleteSubclientPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteSubclientPolicies')
	delete from GXDBVersions where aliasname = 'AppDeleteSubclientPolicies'
GO
print '... Creating Procedure: AppDeleteSubclientPolicies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteSubclientPolicies
-- Input arguments
-- if greater >0 process this backupSetId, else process the i_backupSetList XML Document which contain a list of BackupSetIds to process
  @i_backupSetId INT,
-- if 0, use now time else use inputted time
  @i_timeStamp INT,
-- <backupSets><backupSet id="1" />...<backupSet id="[N]" /></backupSets>
  @i_backupSetList XML
AS
  DECLARE @exitCode INT
BEGIN
	SET NOCOUNT ON
	DECLARE @timeStamp	INTEGER
	DECLARE @rowCnt		INTEGER = 0
	SET @exitCode = 0
IF OBJECT_ID('tempdb.dbo.#DecoupledRetentionProperties') IS NOT null
DROP TABLE #DecoupledRetentionProperties
CREATE TABLE #DecoupledRetentionProperties
(
	attrName nvarchar(510)
)
INSERT #DecoupledRetentionProperties(attrName)
VALUES(N'Archived expiration days'),
		(N'Is Turbo Subclient'),
		(N'Is Archive Retention Mode Enabled'),
		(N'Is Backup Retention Mode Enabled'),
		(N'Days to keep items past their expiration'),
		(N'Keep older Synth Full Versions'),
		(N'Keep items past their expiration'),
		(N'Number of Days of Synth Full Versions'),
		(N'Number of Synth Full Versions'),
		(N'User deleted stubs expiration days'),
		(N'Retain daily version period'),
		(N'Retain weekly version period'),
		(N'Retain monthly version period')
	IF OBJECT_ID('tempdb.dbo.#backupSets') IS NOT null
		DROP TABLE #backupSets
	CREATE TABLE #backupSets (
		id		INT PRIMARY KEY,
		cId		NVARCHAR(12)
	)
	IF OBJECT_ID('tempdb.dbo.#AppIds') IS NOT null
		DROP TABLE #AppIds
	CREATE TABLE #AppIds  (
		id		INT PRIMARY KEY
	)
	IF OBJECT_ID('tempdb.dbo.#SCList') IS NOT null
		DROP TABLE #SCList
	CREATE TABLE #SCList (
		backupSetId		INT,
		assocAppId		INT,
		appId			INT,
		isDecoupled		INT,
		isRetentionAvailableONPolicy INT,
		PRIMARY KEY (backupSetId, appId, assocAppId)
	)
	-- Determine BackupSet input to use
	IF (@i_backupSetId > 0)
	BEGIN
		INSERT INTO #backupSets (id, cId) VALUES (@i_backupSetId, CAST(@i_backupSetId AS NVARCHAR(12)))
	END
	ELSE
	BEGIN
		IF (CAST(@i_backupSetList AS NVARCHAR(MAX)) <> N'')
		BEGIN
			INSERT INTO #backupSets (id, cId)
				SELECT DISTINCT
					bs.value('@id', 'int'),
					bs.value('@id', 'nvarchar(12)')
				FROM @i_backupSetList.nodes('/backupSets/backupSet') n(bs)
		END
		-- ELSE -- empty table and it does nothing
	END
	IF (@i_timeStamp > 0)
	BEGIN
		SET @timeStamp = @i_timeStamp
	END
	ELSE
	BEGIN
		-- set to now time
		SET @timeStamp = dbo.GetUnixTime(GETUTCDATE())
	END
	-- Get all associated data for the inputted BackupSet(s)
	INSERT INTO #SCList
		SELECT DISTINCT
			bsp.componentnameId,
			assocSC.id,
			ISNULL(a.id, 0),
			ISNULL(d.isDecoupled, 0),
			ISNULL(r.isRetentionAvailableONPolicy, 0)
		FROM #backupSets bs
			INNER JOIN APP_BackupSetProp bsp ON
				bsp.attrVal = bs.cId
				AND bsp.attrName = N'Associated subclient Policy'
				AND bsp.modified = 0
			LEFT OUTER JOIN APP_Application assocSC ON
				assocSC.backupSet = bs.cId
			LEFT OUTER JOIN APP_Application a ON
				a.backupSet = bsp.componentnameId
				AND a.subClientName = assocSC.subClientName
			OUTER APPLY (
				SELECT TOP 1
					CASE
						WHEN scp.attrVal = '1' THEN 1
						ELSE 0
					END isDecoupled
				FROM APP_SubClientProp scp
				WHERE
					scp.attrName = N'Decouple SCP Content'
					AND scp.modified = 0
					AND scp.componentnameId = a.id
			) d
			OUTER APPLY (
                SELECT TOP 1
                    CASE
                        WHEN rscp.attrVal = '1' THEN 1
                        ELSE 0
                    END isRetentionAvailableONPolicy
                FROM APP_SubClientProp rscp
                WHERE
                    rscp.attrName = N'Subclient Policy Has Retention'
                    AND rscp.modified = 0
                    AND rscp.componentnameId = assocSC.id
            ) r
-- do NOT insert SQL HERE!
	SET @rowCnt = @@ROWCOUNT
	IF (@rowCnt > 0)	-- if no rows found, nothing to do!
	BEGIN
		-- update subclient properties to be deleted
		UPDATE scp
			SET modified = @timeStamp
		FROM APP_SubClientProp scp
			INNER JOIN #SCList scl ON
				scl.appId <> 0
				AND scl.isRetentionAvailableONPolicy = 1
				AND scp.componentNameId = scl.appId
				AND scp.modified = 0
		WHERE
			scp.attrName IN (
				SELECT attrName
				FROM APP_SubClientProp
				WHERE componentnameId = scl.assocAppId
					AND modified = 0
				)
		UPDATE scp
			SET modified = @timeStamp
		FROM APP_SubClientProp scp
			INNER JOIN #SCList scl ON
				scl.appId <> 0
				AND scl.isRetentionAvailableONPolicy = 0
				AND scp.componentNameId = scl.appId
				AND scp.modified = 0
		WHERE
			scp.attrName IN (
				SELECT attrName
				FROM APP_SubClientProp
				WHERE componentnameId = scl.assocAppId
					AND modified = 0
				EXCEPT
					SELECT attrName FROM #DecoupledRetentionProperties
				)
		UPDATE scp
			SET modified = @timeStamp
		FROM APP_SubClientProp scp
			INNER JOIN #SCList scl ON
				scl.appId <> 0
				AND scp.componentNameId = scl.appId
				AND scp.modified = 0
				AND scp.attrName = N'Decouple SCP Content'
		-- insert new associated subclient properties
		INSERT INTO APP_SubClientProp (
			componentNameId,
			attrName,
			attrType,
			attrVal,
			created,
			modified
		)
			SELECT DISTINCT
				scl.appId,
				scp.attrName,
				scp.attrType,
				scp.attrVal,
				@timeStamp,
				0
			FROM APP_SubClientProp scp
				INNER JOIN #SCList scl ON
					scl.appId <> 0
					AND scl.isRetentionAvailableONPolicy = 0
					AND scl.isDecoupled = 0
					AND scp.componentNameId = scl.assocAppId
					AND scp.modified = 0
					AND scp.attrName NOT IN ( SELECT attrName FROM #DecoupledRetentionProperties )
			UNION
			SELECT DISTINCT
				scl.appId,
				scp.attrName,
				scp.attrType,
				scp.attrVal,
				@timeStamp,
				0
			FROM APP_SubClientProp scp
				INNER JOIN #SCList scl ON
					scl.appId <> 0
					AND scl.isRetentionAvailableONPolicy = 1
					AND scl.isDecoupled = 0
					AND scp.componentNameId = scl.assocAppId
					AND scp.modified = 0
		-- insert new associated subclient filter files
		INSERT INTO APP_ScFilterFile (
			componentNameId,
			type,
			fileName,
			created,
			modified
		)
			SELECT DISTINCT
				scl.appId,
				sff.type,
				sff.filename,
				@timeStamp,
				0
			FROM APP_ScFilterFile sff
				INNER JOIN #SCList scl ON
					scl.appId <> 0
					AND scl.isDecoupled = 0
					AND sff.componentNameId = scl.assocAppId
					AND sff.modified = 0
	END
	-- Get all the SubClient Ids associated with theses BackupSets
	INSERT INTO #AppIds
		SELECT DISTINCT
			a.id
		FROM APP_Application a
			INNER JOIN #backupSets bs ON
				a.backupset = bs.id
	-- Delete all the old associations
	DELETE APP_SubClientProp
	WHERE
		attrName = N'Associated subclient Policy'
		AND modified = 0
		AND attrVal IN (SELECT CAST(a.id AS NVARCHAR(12)) FROM #AppIds a)
	-- Delete subclient policy related properties from backupset prop table
	DELETE BSProp1
		FROM APP_BackupSetProp BSProp1
			INNER JOIN APP_BackupsetProp BSProp2
				ON BSProp1.componentNameId = BSProp2.componentNameId
				AND (BSProp1.attrName = N'Subclient Policy Association Level' OR BSProp1.attrName = N'Client Group For SCP Association')
				AND BSProp1.modified = 0
				AND BSProp2.attrName = N'Associated subclient Policy'
				AND BSProp2.modified = 0
			INNER JOIN #backupSets bs
				ON BSProp2.attrVal = bs.cId
	DELETE APP_BackupSetProp
	WHERE
		attrName = N'Associated subclient Policy'
		AND modified = 0
		AND attrVal IN (SELECT bs.cId FROM #backupSets bs)
	DELETE APP_SubClientProp
	WHERE componentNameId IN (SELECT a.id FROM #AppIds a)
	DELETE APP_ScFilterFile
	WHERE componentNameId IN (SELECT a.id FROM #AppIds a)
	DELETE APP_Application
	WHERE backupset IN (SELECT bs.cId FROM #backupSets bs)
	DELETE APP_BackupSetProp
	WHERE componentNameId IN (SELECT bs.cId FROM #backupSets bs)
	DELETE APP_BackupSetName
	WHERE id IN (SELECT bs.cId FROM #backupSets bs)
	IF OBJECT_ID('tempdb.dbo.#backupSets') IS NOT null
		DROP TABLE #backupSets
	IF OBJECT_ID('tempdb.dbo.#AppIds') IS NOT null
		DROP TABLE #AppIds
	IF OBJECT_ID('tempdb.dbo.#SCList') IS NOT null
		DROP TABLE #SCList
	SELECT @exitCode exitCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteSubclientPolicies')
	delete from GxQscripts where name = 'AppDeleteSubclientPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteSubclientPolicies')
	delete from GXDBVersions where aliasname = 'AppDeleteSubclientPolicies'
GO

insert into GXDBVersions values(2, 'AppDeleteSubclientPolicies',  '00010001000200050000', 'AppDeleteSubclientPolicies', '00010001000200050000')
GO

