

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteReplicationGroup.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppDeleteReplicationGroup   - delete an exiting replication group and associated entities
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteReplicationGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteReplicationGroup <<<'
	drop procedure AppDeleteReplicationGroup
END
IF EXISTS (select * from GxQscripts where name='AppDeleteReplicationGroup')
	delete from GxQscripts where name = 'AppDeleteReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppDeleteReplicationGroup'
GO
print '... Creating Procedure: AppDeleteReplicationGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteReplicationGroup
  @i_replicationGroupId INT,
  @i_userId INT,
  @i_localeId INT
AS
DECLARE @errorCode    INT = 0
DECLARE @errorString  NVARCHAR(1024) = ''
DECLARE @o_xml		  XML
SET NOCOUNT ON
BEGIN TRY
	-- CHECK IF SUCH REPLICATION GROUP EXISTS
	DECLARE @replicationType INT = (SELECT type FROM App_ReplicationGroup WHERE id = @i_replicationGroupId)
	IF @replicationType IS NULL
	BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ERROR_EXIT
	END
	DECLARE @replicationGroupName NVARCHAR(MAX) = ISNULL((SELECT name FROM App_ReplicationGroup WHERE id = @i_replicationGroupId), '')
	DECLARE @taskId INT, @blrpairId INT, @subClientId INT, @planId INT, @schedulePolicyTaskId INT, @storagePolicyId INT
	DECLARE @continuousReplicationGroupInfoTable TABLE (blrpairId INT, subClientId INT, planId INT)
	DECLARE @bkrpairCount INT = 0
	IF @replicationType = 1			-- PERIODICAL REPLICATION GROUP
	BEGIN
		SET @taskId = (SELECT taskId FROM App_ReplicationGroupAssociation WHERE componentNameId = @i_replicationGroupId)
		-- FOR REPLICATION GROUPS CREATED BEFORE SIMPLIFIED LIVE-SYNC PROJECT, NO ASSOCIATED REPLICATION PLANS EXIT, SO @subClientId AND @planId CAN BE NULL
		SELECT @subClientId = tma.subclientId,
			   @planId = p.id
		FROM TM_AssocEntity tma
JOIN APP_SubClientProp scp ON tma.taskId = @taskId AND scp.attrName = N'Associated Plan' AND scp.cs_attrName = CHECKSUM(N'Associated Plan') AND scp.modified = 0 AND scp.componentNameId = tma.subclientId
JOIN App_Plan p ON CAST(p.id AS NVARCHAR(255)) = scp.attrVal AND p.subType = 83918853
	END
	ELSE IF @replicationType = 2	-- CONTINUOUS REPLICATION GROUP
	BEGIN
		-- A CONTINUOUS REPLICATION GROUP COULD HAVE MULTIPLE BLRPAIRS AND SUBCLIENTS, BUT ONLY ONE ASSOCIATED REPLICATION PLAN
		INSERT INTO @continuousReplicationGroupInfoTable
		SELECT assoc.blrpairId, blr.subClientId, p.id
		FROM App_ReplicationGroupAssociation assoc
		JOIN BlrPair blr ON assoc.componentNameId = @i_replicationGroupId AND assoc.blrpairId = blr.id
JOIN APP_SubClientProp scp ON scp.attrName = N'Associated Plan' AND scp.cs_attrName = CHECKSUM(N'Associated Plan') AND scp.modified = 0 AND scp.componentNameId = blr.subClientId
JOIN App_Plan p ON CAST(p.id AS NVARCHAR(255)) = scp.attrVal AND p.subType = 83918853
		SET @bkrpairCount = @@ROWCOUNT
		-- FOR REPLICATION GROUPS CREATED BEFORE SIMPLIFIED LIVE-SYNC PROJECT, NO ASSOCIATED REPLICATION PLANS EXIT, SO @planId CAN BE NULL
		SET @planId = ISNULL((SELECT TOP 1 planId FROM @continuousReplicationGroupInfoTable), (SELECT convert(int,attrval) FROM App_ReplicationGroupProp WITH(NOLOCK) WHERE
attrName = 'Associated Plan' and componentnameid = @i_replicationGroupId))
	END
	-- SECURITY CHECK
	DECLARE @hasRights INT = 0
	-- FOR REPLICATION GROUP CREATED AFTER SIMPLIFIED LIVE-SYNC PROJECT, WE CHECK SECURITY ON PLAN ENTITY
	IF @planId IS NOT NULL
	BEGIN
		-- SECURITY CHECK ON PLAN ENTITY
EXEC sec_checkPermissionOnEntity @i_userId, 158, @hasRights OUTPUT, 158, @planId
		-- sec_checkPermissionOnEntity just checks for rights on the plan. For replication plans, you need some extra checks like checking rights on the Hypervisor
        -- associated with the replication task of the plan.
		IF(@hasRights = 0)
		BEGIN
			IF(@planId <> 0)
			BEGIN
EXEC [dbo].[sec_CheckRepPlanEntitiesSecurity] @planId,158, 0, @i_userId,0,@hasRights OUTPUT
			END
		END
	END
	-- FOR REPLICATION GROUP CREATED BEFORE SIMPLIFIED LIVE-SYNC PROJECT, WE CHECK SECURITY ON TASK ENTITY
	ELSE IF @taskId IS NOT NULL
	BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 117, @hasRights OUTPUT, 35, @taskId
	END
	IF @hasRights = 0
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ERROR_EXIT
	END
	-- RETRIEVE ENTITIES ASSOCIATED WITH REPLICATION PLAN
	IF @planId IS NOT NULL
	BEGIN
		-- SCHEDULE POLICY TASK
SET @schedulePolicyTaskId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @planId and attrName = 'Schedule policy')
		-- STORAGE POLICY
SET @storagePolicyId = (SELECT CAST(attrVal AS INT) FROM App_PlanProp WHERE componentNameId = @planId and attrName = 'Storage policy')
	END
	-- NEED TO MARK SUBCLIENT AS DELETED FIRST, OTHERWISE PLAN DELETION IS NOT ALLOWED
	-- MARK SUBCLIENT DELETED FOR PERIODICAL REPLICATION GROUP
	IF @subclientId IS NOT NULL
	BEGIN
UPDATE App_Application SET subclientStatus = subclientStatus | 0x00004 WHERE id = @subClientId
		IF @storagePolicyId = (SELECT dataArchGrpID FROM App_Application WHERE id = @subclientId)
		BEGIN
			UPDATE App_Application
			SET dataArchGrpID = 1, logArchGrpID = 1
			WHERE dataArchGrpID = @storagePolicyId
		END
	END
	-- MARK BLRPAIR AND SUBCLIENT RECORDS DELTED FOR CONTINUOUS REPLICATION GROUP
	IF @bkrpairCount > 0
	BEGIN
		UPDATE BlrPair
		SET flags = flags | 2 -- #define BLR_PAIR_FLAG_MARKED_DELETION   (1<<1)
		FROM BlrPair blr
		JOIN @continuousReplicationGroupInfoTable cont ON blr.id = cont.blrpairId
		UPDATE App_Application
SET subclientStatus = subclientStatus | 0x00004
		FROM App_Application app
		JOIN @continuousReplicationGroupInfoTable cont ON app.id = cont.subClientId
		IF @storagePolicyId = (SELECT dataArchGrpID FROM App_Application WHERE id = (SELECT TOP 1 subClientId FROM @continuousReplicationGroupInfoTable))
		BEGIN
			UPDATE App_Application
			SET dataArchGrpID = 1, logArchGrpID = 1
			FROM App_Application app
			WHERE dataArchGrpID = @storagePolicyId
		END
	END
	-- GET SCHEDULE POLICY TASK ID ASSOCIATED WITH THE PLAN
	IF @planId IS NOT NULL
	BEGIN
		-- REMOVE ASSOCIATION BETWEEN PLAN AND COMPANY, SO THAT WE CAN MARK THE PLAN SCHEDULE TO BE DELETED
		DELETE umsecassoc
		FROM UMSecurityAssociations umsecassoc
JOIN UMDSgroups grps ON umsecassoc.entityType1 = 158 AND umsecassoc.entityId1 = @planId AND umsecassoc.isUser = 0 AND umsecassoc.userOrGroupId = grps.id
		WHERE grps.umdsProviderId <> 0
		DELETE umsecassoc
		FROM UMSecurityAssociations umsecassoc
JOIN UMUsers users ON umsecassoc.entityType1 = 158 AND umsecassoc.entityId1 = @planId AND umsecassoc.isUser = 1 AND umsecassoc.userOrGroupId = users.id
		WHERE users.umdsProviderId <> 0
		-- MARK THE PLAN SCHEDULED TO BE DELETED
		DECLARE @xmlText XML
		EXEC AppPlanScheduleDeleteV2 @planId, @i_userId, @i_localeId, @xmlText OUTPUT, 0
	END
	IF @schedulePolicyTaskId IS NOT NULL
	BEGIN
UPDATE TM_Task SET deleted = 1, flags &= ~(536870912) WHERE taskId = @schedulePolicyTaskId
	END
	-- MARK TASK DELETED FOR PERIODICAL REPLICATION GROUP
	IF @taskId IS NOT NULL
	BEGIN
UPDATE TM_Task SET deleted = 1, flags &= ~(536870912) WHERE taskId = @taskId
	END
	--CLEANUP CREDENTIALS ASSOCIATED TO REPLICATION GROUP
DELETE App_CredentialAssoc WHERE entityId = @i_replicationGroupId AND entityType = 193
	-- CLEAN UP APP_REPLICATIONGROUP TABLE
	DELETE App_ReplicationGroup WHERE id = @i_replicationGroupId
	-- TRIGGER TM MAINTENANCE TO CLEAN UP RECORDS IN APP_VSAREPLICATION TABLE
	DECLARE @tmpOutputTable TABLE (outputString XML)
	INSERT INTO @tmpOutputTable
	EXEC TM_maintenance
	-- AUDIT REPLICATION GROUP DELETION
DECLARE @opMsgId    INT = (671 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId  INT = 0
	DECLARE @opId       INT = 0
	DECLARE @entityName NVARCHAR(510) = NULL
DECLARE @paramMsgId INT = (1788 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Deleted Replication Group [^1%s]
	EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- audit record parameter values
	EXEC EvGuiAuditSetParamData @opId, @replicationGroupName, 0
	-- tie up
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
ERROR_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode AND [localeId] = @i_localeId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SELECT @o_xml  as o_xmlString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteReplicationGroup')
	delete from GxQscripts where name = 'AppDeleteReplicationGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteReplicationGroup')
	delete from GXDBVersions where aliasname = 'AppDeleteReplicationGroup'
GO

insert into GXDBVersions values(2, 'AppDeleteReplicationGroup',  '00000000000000000000', 'AppDeleteReplicationGroup', '00000000000000000000')
GO

