

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteNonDataBearingEntitiesOfCompany.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppDeleteNonDataBearingEntitiesOfCompany"
--  |   Description: Stored procedure to bulk delete non data bearing entities of companies
--	|   marked for delete.
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppDeleteNonDataBearingEntitiesOfCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteNonDataBearingEntitiesOfCompany <<<'
	drop procedure AppDeleteNonDataBearingEntitiesOfCompany
END
IF EXISTS (select * from GxQscripts where name='AppDeleteNonDataBearingEntitiesOfCompany')
	delete from GxQscripts where name = 'AppDeleteNonDataBearingEntitiesOfCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteNonDataBearingEntitiesOfCompany')
	delete from GXDBVersions where aliasname = 'AppDeleteNonDataBearingEntitiesOfCompany'
GO
print '... Creating Procedure: AppDeleteNonDataBearingEntitiesOfCompany'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppDeleteNonDataBearingEntitiesOfCompany
  @companyId INTEGER
AS
  DECLARE @errorString nvarchar(1024)
  DECLARE @errorCode INT
  DECLARE @rowsDeleted INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
set @errorCode = 0
set @rowsDeleted = 0
BEGIN TRY
	DECLARE @c_flags INT = 0
	SELECT @c_flags = flags FROM UMDSProviders WHERE id = @companyId AND enabled=0
IF  @c_flags & 0x0002 = 0x0002
	BEGIN
		-- WORKFLOW_ENTITY (83)
		DELETE WF
		FROM WF_Definition WF
		INNER JOIN App_CompanyEntities App
On App.entityId = WF.WorkflowId AND App.entityType = 83
		WHERE App.companyId = @companyId
		-- REGION_ENTITY (102)
		DELETE RZ
		FROM APP_RegionZoneAssoc RZ
		INNER JOIN App_Region AR
		ON AR.id = RZ.regionId
		INNER JOIN App_CompanyEntities App
On App.entityId = AR.id AND App.entityType = 102
		WHERE App.companyId = @companyId
		DELETE RG
		FROM App_Region RG
		INNER JOIN App_CompanyEntities App
On App.entityId = RG.id AND App.entityType = 102
		WHERE App.companyId = @companyId
		-- ROLE_ENTITY (120)
		DELETE UP
		FROM UMRolesWithPermissionsExpanded UP
		INNER JOIN UMRoles UR
		ON UR.id = UP.roleId
		INNER JOIN App_CompanyEntities App
On App.entityId = UR.id AND App.entityType = 120
		WHERE App.companyId = @companyId
		DELETE UP
		FROM UMRolesPermissions UP
		INNER JOIN UMRoles UR
		ON UR.id = UP.roleId
		INNER JOIN App_CompanyEntities App
On App.entityId = UR.id AND App.entityType = 120
		WHERE App.companyId = @companyId
		DELETE US
		FROM UMSecurityAssociations US
		INNER JOIN UMRoles UR
		ON UR.id = US.roleId
		INNER JOIN App_CompanyEntities App
On App.entityId = UR.id AND App.entityType = 120
		WHERE App.companyId = @companyId
		DELETE UR
		FROM UMRoles UR
		INNER JOIN App_CompanyEntities App
On App.entityId = UR.id AND App.entityType = 120
		WHERE App.companyId = @companyId
		-- CUSTOM_QUERY_ENTITY (124)
		DELETE QL
		FROM NTQueryList QL
		INNER JOIN App_CompanyEntities App
On App.entityId = QL.queryId AND App.entityType = 124
		WHERE App.companyId = @companyId
		-- SMART_FOLDER_ENTITY (127)
		DELETE SFA
		FROM APP_SmartFolderAssoc SFA
		INNER JOIN App_SmartFolder SF
		ON SF.id = SFA.folderId
		INNER JOIN App_CompanyEntities App
On App.entityId = SF.id AND App.entityType = 127
		WHERE App.companyId = @companyId
		DELETE SF
		FROM App_SmartFolder SF
		INNER JOIN App_CompanyEntities App
On App.entityId = SF.id AND App.entityType = 127
		WHERE App.companyId = @companyId
		-- FW_TOPOLOGY_ENTITY (156)
		DELETE FT
		FROM APP_FirewallTopology FT
		INNER JOIN App_CompanyEntities App
On App.entityId = FT.topologyId AND App.entityType = 156
		WHERE App.companyId = @companyId
		-- PLAN_RULE_ENTITY (159)
		DELETE PR
		FROM APP_PlanRule PR
		INNER JOIN App_CompanyEntities App
On App.entityId = PR.ruleId AND App.entityType = 159
		WHERE App.companyId = @companyId
		-- SYNC_WEBFOLDER_ENTITY (111)
		DELETE SCF
		FROM App_SyncCloudFolder SCF
		INNER JOIN App_CompanyEntities App
On App.entityId = SCF.syncWebFolderId AND App.entityType = 111
		WHERE App.companyId = @companyId
		-- REPLICATION_GROUP_ENTITY (193)
		DELETE RG
		FROM App_ReplicationGroup RG
		INNER JOIN App_CompanyEntities App
On App.entityId = RG.id AND App.entityType = 193
		WHERE App.companyId = @companyId
		-- VM_ALLOCATION_POLICY_ENTITY (93)
		DELETE VPP
		FROM App_VmAllocationPolicyProp VPP
		INNER JOIN App_VmAllocationPolicy VP
			On VP.id = VPP.componentNameId
		INNER JOIN App_CompanyEntities App
On App.entityId = VP.id AND App.entityType = 93
		WHERE App.companyId = @companyId
		DELETE VP
		FROM App_VmAllocationPolicy VP
		INNER JOIN App_CompanyEntities App
On App.entityId = VP.id AND App.entityType = 93
		WHERE App.companyId = @companyId
		-- LM_TEMPLATE_ENTITY (86)
		DELETE NTS
		FROM NTSimpanaEventCriteria NTS
		INNER JOIN App_Template AT
			ON AT.templateId = NTS.templateId
				AND AT.commcellId = NTS.commcellId
		INNER JOIN App_CompanyEntities App
On App.entityId = AT.templateId AND App.entityType = 86
		WHERE App.companyId = @companyId
		DELETE AMT
		FROM APP_MonitorTemplateAssoc AMT
		INNER JOIN App_Template AT
			ON AT.templateId = AMT.templateId
				AND AT.commcellId = AMT.commcellId
		INNER JOIN App_CompanyEntities App
On App.entityId = AT.templateId AND App.entityType = 86
		WHERE App.companyId = @companyId
		DELETE AC
		FROM APP_Criteria AC
		INNER JOIN App_Template AT
			ON AT.templateId = AC.templateId
				AND AT.commcellId = AC.commcellId
		INNER JOIN App_CompanyEntities App
On App.entityId = AT.templateId AND App.entityType = 86
		WHERE App.companyId = @companyId
		DELETE AT
		FROM App_Template AT
		INNER JOIN App_CompanyEntities App
On App.entityId = AT.templateId AND App.entityType = 86
		WHERE App.companyId = @companyId
		-- ALERT_ENTITY
		DELETE NTCP
		FROM NTSelCriteriaParams NTCP
		INNER JOIN NTSelCriteria NTC
		On NTC.id = NTCP.selCriteriaid
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTC.ruleId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTC
		FROM NTSelCriteria NTC
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTC.ruleId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTM
		FROM NTmessages NTM
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTM.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTM
		FROM NTmessageFormat NTM
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTM.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NA
		FROM NTnotificationAction NA
		INNER JOIN NTnotificationRule NR
		ON NR.id = NA.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTF
		FROM NTattachedFiles NTF
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTF.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTQ
		FROM NTRomsQueue NTQ
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTQ.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTG
		FROM NTnotificationExternalGroups NTG
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTG.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTG
		FROM NTnotificationGroups NTG
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTG.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTU
		FROM NTnotificationUsers NTU
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTU.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTM
		FROM NTmessageTracking NTM
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTM.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTQ
		FROM NTSpoolQueue NTQ
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTQ.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NTM
		FROM NTmessageHistory NTM
		INNER JOIN NTnotificationRule NR
		ON NR.id = NTM.NTnotificationId
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		DELETE NR
		FROM NTnotificationRule NR
		INNER JOIN App_CompanyEntities App
On App.entityId = NR.id AND App.entityType = 64
		WHERE App.companyId = @companyId
		-- VM_ALLOCATION_POLICY_ENTITY (93)
		DELETE VPP
		FROM App_VmAllocationPolicyProp VPP
		INNER JOIN App_VmAllocationPolicy VP
			On VP.id = VPP.componentNameId
		INNER JOIN App_CompanyEntities App
On App.entityId = VP.id AND App.entityType = 93
		WHERE App.companyId = @companyId
		DELETE VP
		FROM App_VmAllocationPolicy VP
		INNER JOIN App_CompanyEntities App
On App.entityId = VP.id AND App.entityType = 93
		WHERE App.companyId = @companyId
		-- DELETE FROM APP_COMPANYENTITIES table
		DELETE App
		FROM App_CompanyEntities App
		WHERE App.companyId = @companyId AND
App.entityType IN (64, 86, 83, 102, 120, 124, 127,
156, 159,
111, 193, 64, 93)
		SET @rowsDeleted = @@ROWCOUNT
		-- Delete the non data bearing entities which are not covered above (i.e. unknown non-data bearing entities)
		IF object_id('tempdb.dbo.#entitiesToDeleteLater') is not null
        		DROP TABLE #entitiesToDeleteLater
		create table #entitiesToDeleteLater (entityType INT NOT NULL
			      PRIMARY KEY (entityType))
		-- CREDENTIAL_ENTITY: Though credential is non-data bearing entity, we want to delete it later once all the company libraries are deleted. If a library associated with credential is not deleted then corresponding credential should also not be deleted. The same logic is added in AppDeleteCompanyCredentialsAndKeyProviders.
		-- KEY_MANAGEMENT_SERVER_ENTITY : Though key provider is non-data bearing entity, we want to delete it later once all the company storage pools are deleted. If a storage pool associated with key provider is not deleted then corresponding key provider should also not be deleted.
		INSERT #entitiesToDeleteLater(entityType) values
(3), (7), (6),
(5), (28),
(17), (18),
(35), (68),
(11), (158),
(13), (15),
(9), (61),
(174), (178)
		IF object_id('tempdb.dbo.#nonDeletedEntities') is not null
			DROP TABLE #nonDeletedEntities
		create table #nonDeletedEntities (entityType INT NOT NULL
					  PRIMARY KEY (entityType))
		INSERT INTO #nonDeletedEntities
		SELECT DISTINCT App.entityType
		FROM App_CompanyEntities App
		LEFT JOIN #entitiesToDeleteLater DBE
			ON DBE.entitytype = App.entityType
		WHERE companyId = @companyId
				AND DBE.entityType IS NULL
AND App.flags & 0x4 = 0
		IF (SELECT count(0)
		FROM #nonDeletedEntities) > 0
		BEGIN
			DECLARE @entityType INT = 0
			DECLARE @nonDeletedValidEntities INT = 0
			DECLARE entityTypes CURSOR FOR
			SELECT entityType FROM #nonDeletedEntities
			OPEN entityTypes
			FETCH NEXT FROM entityTypes INTO @entityType
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
				DECLARE @idColName VARCHAR(128) = ''
					,@tableName VARCHAR(128) = ''
					,@entityNameColName VARCHAR(128) = ''
					,@whereClause VARCHAR(512) = ''
				SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause,  @entityNameColName = entityNameColName
				FROM APP_Entity
				WHERE
					entityType = @entityType
				IF @whereClause = ''
					SET @whereClause = '1=1'
				IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
				BEGIN
					-- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
					SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
				END
				SET @dynamicSQLStr =  'DELETE '  + @tableName +
											' FROM ' + @tableName +
											' INNER JOIN App_CompanyEntities App
											ON App.entityId = '  + @tableName + '.' + @idColName +
											' AND App.entityType = ' + CAST (@entityType AS VARCHAR(10)) +
											' WHERE App.companyId = ' + CAST (@companyId AS VARCHAR(10))  +
' AND App.flags & ' + CAST ((SELECT CONVERT(INT, 0x4)) AS VARCHAR(16)) + ' = 0 ' +
											' AND ' + @whereClause
				EXEC (@dynamicSQLStr)
				DELETE
				FROM App_CompanyEntities
				WHERE companyId = @companyId
					AND entityType = @entityType
				SET @rowsDeleted += @@ROWCOUNT
				FETCH NEXT FROM entityTypes INTO @entityType
			END
			CLOSE entityTypes
			DEALLOCATE entityTypes
		END
	END
	ELSE
	BEGIN
		set @errorCode = 1
		set @errorString = 'Cannot delete non data bearing entities of company since company is not marked for delete'
	END
END TRY
BEGIN CATCH
	set @errorCode = ERROR_NUMBER()
	set @errorString = 'Cannot delete non data bearing entities of company ' +ERROR_MESSAGE()
END CATCH
SELECT @errorCode AS 'errorCode',
       @errorString AS 'errorString',
	   @rowsDeleted AS 'rowsDeleted'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteNonDataBearingEntitiesOfCompany')
	delete from GxQscripts where name = 'AppDeleteNonDataBearingEntitiesOfCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteNonDataBearingEntitiesOfCompany')
	delete from GXDBVersions where aliasname = 'AppDeleteNonDataBearingEntitiesOfCompany'
GO

insert into GXDBVersions values(2, 'AppDeleteNonDataBearingEntitiesOfCompany',  '00000000000000000000', 'AppDeleteNonDataBearingEntitiesOfCompany', '00000000000000000000')
GO

