

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteNetworkInformation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual OR intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppDeleteNetworkInformation
--  |
--  | Description:  This Stored Procedure deletes all Network/Firewall information associated with given client/client group
--  |
--  |       Input:  i_clientId Id of the client whose network information has to be deleted
--	|				i_clientGroupId Id of the client group whose network information has to be deleted
--  |
--  |      Output:  None
--	|
--  |      Return:  None
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppDeleteNetworkInformation')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteNetworkInformation <<<'
	drop procedure AppDeleteNetworkInformation
END
IF EXISTS (select * from GxQscripts where name='AppDeleteNetworkInformation')
	delete from GxQscripts where name = 'AppDeleteNetworkInformation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteNetworkInformation')
	delete from GXDBVersions where aliasname = 'AppDeleteNetworkInformation'
GO
print '... Creating Procedure: AppDeleteNetworkInformation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppDeleteNetworkInformation
  @i_clientId INTEGER,
  @i_clientGroupId INTEGER
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorMsg VARCHAR(MAX) = ''
SET NOCOUNT ON
IF @i_clientId <=0 AND @i_clientGroupId <=0
BEGIN
	SET @o_errorCode = 1
	SET @o_errorMsg = 'Invalid Client ID : ' + CAST(@i_clientId AS VARCHAR(16)) + ' , Client Group ID : ' + CAST(@i_clientGroupId AS VARCHAR(16))
	GOTO RETURN_FROM_HERE
END
BEGIN TRY
-- Delete Network Configuration associated with given Client Group
IF @i_clientGroupId<>0
BEGIN
	-- App_Firewall routes (Network incoming section in Java console)
	DELETE AF
	FROM APP_Firewall AF
	WHERE AF.clientGroupId=@i_clientGroupId OR AF.forClientGroupId=@i_clientGroupId
	-- App_FWOutGoingRoutes (Network outgoing routes section in Java console)
	DELETE AFOR
	FROM App_FWOutGoingRoutes AFOR
	WHERE AFOR.clientGroupId=@i_clientGroupId OR AFOR.forClientGroupId=@i_clientGroupId
	-- The client group can be a proxy in one of the outgoing routes
	DELETE AFOR
	FROM App_FWOutGoingRoutes AFOR
	CROSS APPLY AFOR.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions/remoteProxy') Options(proxyGroupId)
	WHERE proxyGroupId.value('@clientGroupId', 'integer')=@i_clientGroupId
	-- Firewall Additional ports
	DELETE AFWR
	FROM APP_FWPortRange AFWR
	WHERE AFWR.clientGroupId=@i_clientGroupId
	-- DIPs
	DELETE APL
	FROM archPipeline APL
	WHERE APL.srcGroupId=@i_clientGroupId OR APL.destGroupId=@i_clientGroupId
	-- Firewall Topologies
	DECLARE @topologies TABLE (topologyId INTEGER)
	INSERT INTO @topologies
	SELECT AFTA.topologyId
	FROM APP_FirewallTopologyAssoc AFTA
	WHERE AFTA.groupId=@i_clientGroupId
	DELETE AFTA
	FROM APP_FirewallTopologyAssoc AFTA
	INNER JOIN @topologies T
	ON AFTA.topologyId=T.topologyId
	DELETE AFT
	FROM APP_FirewallTopology AFT
	INNER JOIN @topologies T
	ON AFT.topologyId=T.topologyId
	-- Firewall Options
	DELETE AFO
	FROM App_FirewallOptions AFO
	WHERE AFO.clientGroupId=@i_clientGroupId
	-- Firewall Trivial Configuration
	DELETE AFTC
	FROM App_FWTrivialConfig AFTC
	WHERE AFTC.clientGroupId=@i_clientGroupId
	-- Network Throttle
	DELETE ANTO
	FROM APP_NetworkThrottleOptions ANTO
	WHERE ANTO.clientGroupId=@i_clientGroupId
	DELETE ANT
	FROM APP_NetworkThrottle ANT
	WHERE ANT.clientGroupId=@i_clientGroupId OR ANT.forClientGroupId=@i_clientGroupId
	-- Handle HTTP Proxy Settings
	-- Delete credential information first
	DELETE CA
	FROM APP_CredentialAssoc CA
	INNER JOIN App_HTTPProxySettings HPS
	ON CA.assocId=HPS.credAssocId
	WHERE HPS.clientGroupId=@i_clientGroupId AND HPS.credAssocId<>0
	DELETE HPS
	FROM App_HTTPProxySettings HPS
	WHERE HPS.clientGroupId=@i_clientGroupId
END
-- Delete Network Configuration associated with given Client
IF @i_clientId<>0
BEGIN
	-- App_Firewall routes (Network incoming section in Java console)
	DELETE AF
	FROM APP_Firewall AF
	WHERE AF.clientId=@i_clientId OR AF.forClientId=@i_clientId
	-- App_FWOutGoingRoutes (Network outgoing routes section in Java console)
	DELETE AFOR
	FROM App_FWOutGoingRoutes AFOR
	WHERE AFOR.clientId=@i_clientId OR AFOR.forClientId=@i_clientId
	-- The client can be a proxy in one of the outgoing routes
	DELETE AFOR
	FROM App_FWOutGoingRoutes AFOR
	CROSS APPLY AFOR.fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions/remoteProxy') Options(proxyGroupId)
	WHERE proxyGroupId.value('@clientId', 'integer')=@i_clientId
	-- Firewall Additional ports
	DELETE AFWR
	FROM APP_FWPortRange AFWR
	WHERE AFWR.clientId=@i_clientId
	-- DIPs
	DELETE APL
	FROM archPipeline APL
	WHERE APL.srcClientId=@i_clientId OR APL.destClientId=@i_clientId
	-- Firewall Options
	DELETE AFO
	FROM App_FirewallOptions AFO
	WHERE AFO.clientId=@i_clientId
	-- Firewall Trivial Configuration
	DELETE AFTC
	FROM App_FWTrivialConfig AFTC
	WHERE AFTC.clientId=@i_clientId OR AFTC.proxyClientIdCS=@i_clientId OR AFTC.proxyClientIdMA=@i_clientId
	-- Network Throttle
	DELETE ANTO
	FROM APP_NetworkThrottleOptions ANTO
	WHERE ANTO.clientId=@i_clientId
	DELETE ANT
	FROM APP_NetworkThrottle ANT
	WHERE ANT.clientId=@i_clientId OR ANT.forClientId=@i_clientId
	-- Handle HTTP Proxy Settings
	-- Delete credential information first
	DELETE CA
	FROM APP_CredentialAssoc CA
	INNER JOIN App_HTTPProxySettings HPS
	ON CA.assocId=HPS.credAssocId
	WHERE HPS.clientId=@i_clientId AND HPS.credAssocId<>0
	DELETE HPS
	FROM App_HTTPProxySettings HPS
	WHERE HPS.clientId=@i_clientId
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = ERROR_NUMBER()
	SET @o_errorMsg = ERROR_MESSAGE()
	-- Rethrow exception for deadlock error for XE Capture
	IF (@o_errorCode = 1205)
	BEGIN
		;THROW;
	END
END CATCH
RETURN_FROM_HERE:
	SELECT @o_errorCode, @o_errorMsg
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteNetworkInformation')
	delete from GxQscripts where name = 'AppDeleteNetworkInformation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteNetworkInformation')
	delete from GXDBVersions where aliasname = 'AppDeleteNetworkInformation'
GO

insert into GXDBVersions values(2, 'AppDeleteNetworkInformation',  '00000000000000000000', 'AppDeleteNetworkInformation', '00000000000000000000')
GO

