

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteMobilePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDeleteMobilePolicy.sp,v $ $Id: AppDeleteMobilePolicy.sp,v 1.1.2.5 2020/12/17 08:29:19 jswaminathan Exp $";
--	+===================================================================+
--	|  					  AppDeleteMobilePolicy							|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppDeleteMobilePolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteMobilePolicy <<<'
	drop procedure AppDeleteMobilePolicy
END
IF EXISTS (select * from GxQscripts where name='AppDeleteMobilePolicy')
	delete from GxQscripts where name = 'AppDeleteMobilePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteMobilePolicy')
	delete from GXDBVersions where aliasname = 'AppDeleteMobilePolicy'
GO
print '... Creating Procedure: AppDeleteMobilePolicy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppDeleteMobilePolicy
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	-- Read the XML
	DECLARE @policyId			INT				= ISNULL (( SELECT ref.value('@policyId', 'INT')
														FROM @inXml.nodes ('Api_DeleteMobilePolicyReq/policy') R(ref)), 0)
	DECLARE @policyName	NVARCHAR(MAX)		= ISNULL (( SELECT ref.value('@policyName', 'NVARCHAR(MAX)')
														FROM @inXml.nodes ('Api_DeleteMobilePolicyReq/policy') R(ref)), '')
	IF @policyId = 0 AND @policyName <> ''
	BEGIN
		SET @policyId = ISNULL((SELECT mobilePolicyId FROM App_MobilePolicy WITH (NOLOCK) WHERE mobilePolicyName = @policyName), 0)
		IF @policyId = 0
		BEGIN
SET @errorCode = (3127 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
	END
	IF NOT EXISTS (SELECT 1 FROM App_MobilePolicy WITH (NOLOCK) WHERE mobilePolicyId = @policyId)
	BEGIN
SET @errorCode = (3127 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
	END
	BEGIN TRAN
	-- CHECK IF USER HAS AN ABILITY / PERMISSION TO DELETE THE PROPERTY
	DECLARE @userHasCapability INT = 0
	IF @userHasCapability <> 1
	BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*use the same message as it is generic*/
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        GOTO ERROR
    END
	DELETE FROM App_MobilePolicyProp
	WHERE componentId = @policyId
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
	DELETE FROM App_MobilePolicy
	WHERE mobilePolicyId = @policyId
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
ERROR:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRAN
		IF @errorString = ''
		BEGIN
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, 1, 0, 2)
		END
	END
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @outXml = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE)
							FOR XML PATH('Api_MobilePolicyResp'), TYPE)
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteMobilePolicy')
	delete from GxQscripts where name = 'AppDeleteMobilePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteMobilePolicy')
	delete from GXDBVersions where aliasname = 'AppDeleteMobilePolicy'
GO

insert into GXDBVersions values(2, 'AppDeleteMobilePolicy',  '00010001000200050000', 'AppDeleteMobilePolicy', '00010001000200050000')
GO

