

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteJMJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Author: Aravind Senguttuvan
--
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteJMJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteJMJobOptions <<<'
	drop procedure AppDeleteJMJobOptions
END
IF EXISTS (select * from GxQscripts where name='AppDeleteJMJobOptions')
	delete from GxQscripts where name = 'AppDeleteJMJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteJMJobOptions')
	delete from GXDBVersions where aliasname = 'AppDeleteJMJobOptions'
GO
print '... Creating Procedure: AppDeleteJMJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteJMJobOptions
  @inXML XML
AS
--Old JMDeleteJMJobOptions.sp was used as a class. Hence new SP was created
DECLARE @errorCode nvarchar(max)
DECLARE @errorMessage nvarchar(max)
DECLARE @inJobID INT =  @inXML.value('(/App_DeleteJMJobOptionsReq/@jobId)[1]', 'int')
DECLARE @inCommCellID INT = @inXML.value('(/App_DeleteJMJobOptionsReq/@commCellId)[1]', 'int')
DECLARE @inAttributeId INT = @inXML.value('(/App_DeleteJMJobOptionsReq/@attributeId)[1]', 'int')
DECLARE @outXML XML
BEGIN TRY
	IF @inJobID = 0 OR @inCommCellID = 0
	BEGIN
		SET @errorCode = 1
		SET @errorMessage = N'Invalid Jobid or Commcellid'
		goto CX_EXIT
	END
	IF @inAttributeId != 0
		--Only used for backward compatibility and also doesnt support deletion of attributeid 0
		DELETE FROM JMJobOptions
		WHERE jobId = @inJobID AND commCellId = @inCommCellID AND attributeId = @inAttributeId
	ELSE
	BEGIN
		IF EXISTS(SELECT req.value('@val','int') FROM @inXML.nodes('App_DeleteJMJobOptionsReq/attributeIdList') AS T(req))
		BEGIN
			DELETE FROM JMJobOptions
			WHERE jobId = @inJobID AND commCellId = @inCommCellID AND attributeId in (
			--for all input attribute ids
			SELECT req.value('@val','int')
			FROM @inXML.nodes('App_DeleteJMJobOptionsReq/attributeIdList') AS T(req)
			)
		END
		ELSE
		BEGIN
			SET @errorCode = 1
			SET @errorMessage = N'Invalid AttributeId and AttributeIdList'
			goto CX_EXIT
		END
	END
END TRY
BEGIN CATCH
	SET @errorCode = ERROR_NUMBER()
	SET @errorMessage = N'Exception Caught with FATAL ERROR : ' + ERROR_MESSAGE()
END CATCH
CX_EXIT:
SET @outXml = (SELECT @errorCode as '@errorCode', @errorMessage as '@errorMessage' FOR XML PATH('errorResp'), TYPE)
SELECT @outXml
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteJMJobOptions')
	delete from GxQscripts where name = 'AppDeleteJMJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteJMJobOptions')
	delete from GXDBVersions where aliasname = 'AppDeleteJMJobOptions'
GO

insert into GXDBVersions values(2, 'AppDeleteJMJobOptions',  '00000000000000000000', 'AppDeleteJMJobOptions', '00000000000000000000')
GO

