

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteFirewallTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteFirewallTopology')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteFirewallTopology <<<'
	drop procedure AppDeleteFirewallTopology
END
IF EXISTS (select * from GxQscripts where name='AppDeleteFirewallTopology')
	delete from GxQscripts where name = 'AppDeleteFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppDeleteFirewallTopology'
GO
print '... Creating Procedure: AppDeleteFirewallTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteFirewallTopology
  @topologyId INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @firewallGroups NWTopoGroupInfoTableType
DECLARE @topologyType INT
DECLARE @extendedOptions XML
BEGIN
	-- Not populating fwConfig column as this information can be fetched from DB if required
	INSERT INTO @firewallGroups (clientGroupId, fwGroupType)
	SELECT groupId, fwGroupType
	FROM APP_FirewallTopologyAssoc
	WHERE topologyId = @topologyId
	SELECT @topologyType = topologyType , @extendedOptions = extendedProperties
	FROM APP_FirewallTopology
	WHERE topologyId = @topologyId
	-- We will have to call deleteTopology to delete entries from this topology in APP_Firewall, APP_FWOutGoingRoutes, APP_FirewallOptions and APP_FWTrivialConfig(in case of a non-smart topology)
	EXEC deleteTopology @topologyId, @firewallGroups, @topologyType, @extendedOptions
	delete APP_FirewallTopology where topologyId = @topologyId --ON DELETE CASCADE on APP_FirewallTopologyAssoc's topologyId will delete the rows with @topologyId in APP_FirewallTopologyAssoc
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteFirewallTopology')
	delete from GxQscripts where name = 'AppDeleteFirewallTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteFirewallTopology')
	delete from GXDBVersions where aliasname = 'AppDeleteFirewallTopology'
GO

insert into GXDBVersions values(2, 'AppDeleteFirewallTopology',  '00000000000000000000', 'AppDeleteFirewallTopology', '00000000000000000000')
GO

