

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteEvents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |                       SP: " AppDeleteEvents.sp"                           |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppDeleteEvents <<<'

IF EXISTS (select * from sysobjects where name='AppDeleteEvents')
	drop procedure AppDeleteEvents
IF EXISTS (select * from GxQscripts where name='AppDeleteEvents')
	delete from GxQscripts where name = 'AppDeleteEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteEvents')
	delete from GXDBVersions where aliasname = 'AppDeleteEvents'
GO
print '... Creating Procedure: AppDeleteEvents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteEvents
  @i_xml XML
AS
  DECLARE @o_xml XML 
DECLARE @userId INT = 0
DECLARE @isAdminUser INT = 0
DECLARE @opMsgId INT
DECLARE @opEvMsgId INT
DECLARE @opId INT
DECLARE @paramMsgId INT
DECLARE @appTypeName NVARCHAR(MAX)
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(1024)
DECLARE @delEventString VARCHAR(MAX)
SET @userId  = ISNULL((SELECT ref.value('@userId','INTEGER') AS data FROM @i_xml.nodes('App_UpdateEventsReq/processinginstructioninfo/user') R ( ref )),0)
EXEC sec_checkPermissionOnEntity @userId, 1, @isAdminUser OUT,1,2
IF(@isAdminUser <>1 )
BEGIN
	SET @o_xml = (SELECT  1 AS '@errorCode', 'User does not have right to delete event messages' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
END
ELSE IF EXISTS( SELECT 1 FROM APP_AdvanceSettings WITH (NOLOCK)
					WHERE entityId = 2 -- Commcell level
					AND entityType = 3 --CLIENT_ENTITY
					AND keyName = N'bDisableDeleteEvents'
					AND value LIKE 'true'
					AND relativePath = N'CommServDB.Console'
					AND type = N'BOOLEAN'
					AND enabled = 1
					AND deleted = 0)
BEGIN
	SET @o_xml = (SELECT  1 AS '@errorCode', 'Deletion of events are disable on this CommServe' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
END
ELSE
BEGIN TRY
	BEGIN TRANSACTION
	DECLARE @entitiesSet BIT
	SET @entitiesSet = @i_xml.exist('/App_UpdateEventsReq/entities')
	CREATE TABLE #entityTable
	(
		_type_ INT,								--_type_ as defined in CvEntities.x and App_Entity
		typeIndex INT,							--position of _type_ in the given XML
		originalXML XML,						--XML blob that contains _type_
		parentTag VARCHAR(128),					--parentTag of the XML blob
		entityName NVARCHAR(200),				--entity name in XML
		entityId VARCHAR(100),					--entity ID in XML (It is in varchar because there are some entities that fill GUID as id)
		idFound INT DEFAULT 0,					--flag to tell whether we have got the ID or not (Reason we have a separate flag is for those entities that come with wrong name and some ID, we need to populate error message. So cannot just rely on entityId alone)
		fieldName VARCHAR(64),					--field name of the entity id in .x (like clientId, applicationId, mediaAgentId, roleId, etc.)
		isCustomEntity INT DEFAULT 0			--how the entity comes in input XML. If it is custom entity, then we need to populate it back in the same way.
	)
	DECLARE @delEventTable TABLE (eventId int, commcellId int)
	-- Insert events based on entity
	IF @entitiesSet = 1
	BEGIN
		EXECUTE EntityNameToIdConverterTableFormat @i_xml
		INSERT INTO @delEventTable
		SELECT evMsg.id, evMsg.commCellID
		FROM evMsg INNER JOIN #entityTable ENTITIES
		ON ENTITIES._type_ = evMsg.entityType AND ENTITIES.entityId = evMsg.entityId
		WHERE ENTITIES.entityId > 0
	END
	INSERT INTO @delEventTable
	SELECT DISTINCT
	ISNULL(T.C.value('@eventId','int'),0),
	ISNULL(T.C.value('@commcellId','int'),0)
	FROM @i_xml.nodes('App_UpdateEventsReq/DeletedEvents') T(C)
	MERGE evMsg
	USING @delEventTable as delT
	ON delT.eventId = evMsg.id AND delT.commcellId = evMsg.commcellId AND evMsg.type=0
	WHEN MATCHED THEN DELETE;
SET @opMsgId = (443 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @userId, 13 , @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @delEventString=''
	SELECT @delEventString = @delEventString+CONVERT(VARCHAR, eventId)+',' FROM @delEventTable
SET @paramMsgId = (1173 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @delEventString, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	SET @o_xml = (SELECT  @errorCode AS '@errorCode', '' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
	IF OBJECT_ID('tempdb.dbo.#entityTable') IS NOT NULL
		DROP TABLE #entityTable
	COMMIT TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_xml = (SELECT  1 AS '@errorCode', 'An error occured while deleting event messages' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
	ROLLBACK TRANSACTION
END CATCH
SELECT @o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteEvents')
	delete from GxQscripts where name = 'AppDeleteEvents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteEvents')
	delete from GXDBVersions where aliasname = 'AppDeleteEvents'
GO

insert into GXDBVersions values(2, 'AppDeleteEvents',  '00000000000000000000', 'AppDeleteEvents', '00000000000000000000')
GO

