

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteEntityTag.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDeleteEntityTag.sp,v $ $Id: AppDeleteEntityTag.sp,v 1.1.2.3 2020/10/23 13:13:20 sthakkar Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteEntityTag')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteEntityTag <<<'
	drop procedure AppDeleteEntityTag
END
IF EXISTS (select * from GxQscripts where name='AppDeleteEntityTag')
	delete from GxQscripts where name = 'AppDeleteEntityTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteEntityTag')
	delete from GXDBVersions where aliasname = 'AppDeleteEntityTag'
GO
print '... Creating Procedure: AppDeleteEntityTag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteEntityTag
  @xmlInput XML, 
  @xmlResult XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @userId INT
	DECLARE @localeId INT
	DECLARE @entityType INT
	DECLARE @errorString NVARCHAR(MAX)
	DECLARE @errorCode INT
	DECLARE @tagsHaveError INT = 0
	SET @localeId = ISNULL(@xmlInput.value('(//Api_EntityTagsReq/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
	SET @userId = ISNULL(@xmlInput.value('(//Api_EntityTagsReq/processinginstructioninfo/user/@userId)[1]', 'int') , 0)
	--Check if correct user is logged in
	IF @userId = 0
	BEGIN
		SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4671 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO errorexit
	END
	-- creating table from ixml
	IF object_id('tempdb.dbo.#tempAppEntityTagsTable') IS NOT NULL
		DROP TABLE #tempAppEntityTagsTable
	CREATE TABLE #tempAppEntityTagsTable (entityId INT, entityType INT,tagId INT, tagName NVARCHAR(max), tagValue NVARCHAR(max),hasError INT);
	--inserting data to table
	INSERT INTO #tempAppEntityTagsTable
	SELECT  ref.value('@entityId', 'INT'),ref.value('@entityType','INT'),sref.value('@id','INT'), sref.value('@name','NVARCHAR(MAX)') ,sref.value('@value','NVARCHAR(MAX)'), 0 FROM  @xmlInput.nodes('Api_EntityTagsReq/entityTag') R ( ref )
	OUTER APPLY R.ref.nodes('tag') S (sref)
	--removing duplicates by entityId, entityType, tagId
	;WITH cte AS (
		SELECT
			entityId,
			entityType,
			tagId,
			ROW_NUMBER() OVER (
				PARTITION BY
					entityId,
					entityType,
					tagId
				ORDER BY
					entityId,
					entityType,
					tagId
			) row_num
		 FROM #tempAppEntityTagsTable
	)
	DELETE FROM cte
	WHERE row_num > 1;
	--tagId can be 0 or null to delete every tag for the given entityID and entityType
	UPDATE #tempAppEntityTagsTable SET hasError = 1 where entityId IS NULL OR entityId = 0 OR  entityType IS NULL OR entityType = 0
	IF @@ROWCOUNT > 0
		SET @tagsHaveError = 1
	IF EXISTS (SELECT hasError FROM #tempAppEntityTagsTable WHERE hasError = 0)
	BEGIN
		SET @entityType = (SELECT TOP 1 entityType FROM #tempAppEntityTagsTable WHERE entityType IS NOT NULL);
		--creating table to check if user has permission on entities or not
		IF object_id('tempdb.dbo.#entityPermissionsTable') IS NOT NULL
			DROP TABLE  #entityPermissionsTable
		CREATE TABLE #entityPermissionsTable (entityId INT, entityType INT ,hasPermissions INT  );
		INSERT INTO #entityPermissionsTable
		SELECT DISTINCT a.entityId, a.entityType, 0  FROM #tempAppEntityTagsTable a WHERE a.hasError = 0
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
		INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
				SELECT entityId, 0, 0, 0,0 FROM #entityPermissionsTable
		EXEC sec_getPermissionsOnEntities @userId, @entityType
		--updating has permissions based on stored proc
		UPDATE #entityPermissionsTable
SET hasPermissions = CAST(SUBSTRING((SELECT permissionsString FROM #getPermissionsOnEntities_OutputTable WHERE entityId1 = #entityPermissionsTable.entityId),27,1) AS INT)
		-- Update #temapAppEntityTagsTable column hasError if   5. user does not have tag management permission on given entityID and entityType
		UPDATE #tempAppEntityTagsTable
			SET hasError = 2
			FROM #tempAppEntityTagsTable a INNER JOIN #entityPermissionsTable b ON   a.entityId = b.entityId AND a.entityType = b.entityType
			WHERE  b.hasPermissions = 0
		IF @@ROWCOUNT <> 0
			SET @tagsHaveError = 1
		-- Delete from App_EntityTags Table
		IF EXISTS (SELECT entityId FROM  #tempAppEntityTagsTable WHERE hasError = 0)
		BEGIN
			-- Delete all tags for entity when no tags are passed in xml request and only entity ids are passed OR tagIds match with existing tagIds in App_entityTagsTable
				DELETE C
				FROM App_EntityTags C
				 INNER JOIN #tempAppEntityTagsTable d ON c.entity_id = d.entityId AND c.entity_type = d.entityType
				 LEFT JOIN DM2DocTags T ON c.entity_tag_id = T.id
				WHERE d.hasError = 0 AND ((d.tagId is NULL AND d.tagName IS NULL AND d.tagValue IS NULL) OR (c.entity_tag_id = d.tagId AND d.tagName = t.TagValue AND c.entity_tag_value = d.tagValue))
		END
	END
	IF @tagsHaveError = 1
	BEGIN
		SET @errorCode = 1
		IF EXISTS (SELECT hasError FROM #tempAppEntityTagsTable WHERE hasError = 1)
		BEGIN
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4670 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		END
		IF EXISTS (SELECT hasError FROM #tempAppEntityTagsTable WHERE hasError = 2)
		BEGIN
			DECLARE @errorPermissions NVARCHAR(1000)
SET @errorPermissions = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4672 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = @errorString + @errorPermissions
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 0
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4674 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    GOTO errorexit
END CATCH
errorexit:
SET @xmlResult = (SELECT
		(
    			SELECT @errorCode AS '@errorCode',
           			@errorString AS '@errorMessage'
			FOR XML PATH('error'), TYPE
		)
		FOR XML PATH('Api_EntityTagsResp'))
IF object_id('tempdb.dbo.#entityPermissionsTable') IS NOT null DROP TABLE #entityPermissionsTable
IF object_id('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT null DROP TABLE #getPermissionsOnEntities_InputTable
IF object_id('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT null DROP TABLE #getPermissionsOnEntities_OutputTable
IF object_id('tempdb.dbo.#tempAppEntityTagsTable') IS NOT null DROP TABLE #tempAppEntityTagsTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteEntityTag')
	delete from GxQscripts where name = 'AppDeleteEntityTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteEntityTag')
	delete from GXDBVersions where aliasname = 'AppDeleteEntityTag'
GO

insert into GXDBVersions values(2, 'AppDeleteEntityTag',  '00010001000200030000', 'AppDeleteEntityTag', '00010001000200030000')
GO

