

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteDistributedStorage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppDeleteDistributedStorage')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteDistributedStorage <<<'
	drop procedure AppDeleteDistributedStorage
END
IF EXISTS (select * from GxQscripts where name='AppDeleteDistributedStorage')
	delete from GxQscripts where name = 'AppDeleteDistributedStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteDistributedStorage')
	delete from GXDBVersions where aliasname = 'AppDeleteDistributedStorage'
GO
print '... Creating Procedure: AppDeleteDistributedStorage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppDeleteDistributedStorage
  @userId INT,
  @localeId INT = 0,
  @xmlstr XML 	OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
DECLARE @name NVARCHAR(255), @credsId INT, @clusterName NVARCHAR(255)
	DECLARE @adminUserId INT = 1
	------ READ DISTRIBUTED STORAGE INFO FROM REQUEST XML ------
	DECLARE @distributedStorageId INT = ISNULL((SELECT  ref.value('@distributedStorageId', 'INT')
      FROM    @xmlstr.nodes('App_DeleteDistributedStorageRequest/distributedStorage') R ( ref )), 0)
	IF @userId <= 0
	BEGIN
SET @errorCode = (4625 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	------ CHECK IF REQUIRED FIELDS ARE VALID ------
	IF @distributedStorageId = 0
	BEGIN
SET @errorCode = (4626 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	ELSE
	BEGIN
		SELECT @name = name FROM App_DistributedStorage (NOLOCK) WHERE id = @distributedStorageId
		IF @name IS NULL
		BEGIN
SET @errorCode = (4623 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
	END
	------ SECURITY CHECK ------
	DECLARE @hasRight INT
EXEC sec_checkPermissionOnEntity @userId, 260, @hasRight OUTPUT, 195, @distributedStorageId
	IF @hasRight <> 1
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	-- GET CREDENTIAL RECORD ID THAT IS ASSOCIATED WITH THIS DISTRIBUTED STORAGE ENTITY
SET @credsId = ISNULL((SELECT credentialId FROM APP_CredentialAssoc (NOLOCK) WHERE entityType = 195 AND entityId = @distributedStorageId), 0)
	------ CHECK ASSOCIATED ENTITIES, SUCH AS CDM, DATASTORES ------
	IF EXISTS (SELECT 1 FROM MMMountPathToDistributedStorage (NOLOCK) WHERE DistributedStorageId = @distributedStorageId)
	BEGIN
SET @errorCode = (4661 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageId = @errorCode and localeId = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @name)
		GOTO PROC_EXIT
	END
IF EXISTS (SELECT 1 FROM HedVigDatastoreProp (NOLOCK) WHERE attrName = 'Distributed Storage ID' AND modified = 0 AND attrVal = CAST(@distributedStorageId AS NVARCHAR(255)))
	BEGIN
SET @errorCode = (4660 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageId = @errorCode and localeId = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @name)
		GOTO PROC_EXIT
	END
	-- DELETE STORAGE ARRAY THAT WAS CREATED DURING REGISTRATION OF THIS DISTRIBUTED STORAGE
	DECLARE @storageArrayId INT
SET @clusterName = ISNULL((SELECT attrVal FROM App_DistributedStorageProp (NOLOCK) WHERE componentNameId = @distributedStorageId AND attrName = 'Cluster Name' AND cs_attrName = CHECKSUM('Cluster Name')), '')
	SET @storageArrayId = (SELECT TOP 1 ControlHostId from SMControlHost (NOLOCK) where SMArrayId= @clusterName)
	IF @storageArrayId IS NOT NULL
	BEGIN
		-- CHECK IF THERE SNAPSHOTS ASSOCIATED WITH THIS STORAGE ARRAY
		IF EXISTS (SELECT 1 FROM SMSnap (NOLOCK) WHERE ControlHostId = @storageArrayId)
		BEGIN
SET @errorCode = (4662 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageId = @errorCode and localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @name)
			GOTO PROC_EXIT
		END
		ELSE
		BEGIN
			DECLARE @resultTmpTable TABLE (result XML)
			DECLARE @deleteStorageArrayRequest XML =
			(
				SELECT @storageArrayId AS 'array/@id'
				FOR XML PATH ('EVGui_MMSMDeleteArrayReq')
			)
			INSERT INTO @resultTmpTable
			EXEC MM_SMXMLDeleteArray @deleteStorageArrayRequest
			DECLARE @resultXML XML = (SELECT TOP 1 result FROM @resultTmpTable)
			SET @errorCode = ISNULL((SELECT  ref.value('@errorCode', 'INT') FROM @resultXML.nodes('CVGui_GenericResp') R ( ref )), 0)
			IF @errorCode <> 0
			BEGIN
				SET @errorString = ISNULL((SELECT  ref.value('@errorMessage', 'NVARCHAR(MAX)') FROM @resultXML.nodes('CVGui_GenericResp') R ( ref )), '')
				GOTO PROC_EXIT
			END
			-- REMOVE ASSOCIATION BETWEEN THIS STORAGE ARRAY AND THE CREDENTIAL RECORD
			DELETE APP_CredentialAssoc
WHERE credentialId = @credsId AND entityType = 153 AND entityId = @storageArrayId
		END
	END
	------ DELETE DISTRIBUTED STORAGE RECORD ------
	DELETE App_DistributedStorage WHERE id = @distributedStorageId
	------ DELETE CREDENTIAL RECORD ------
	IF @credsId IS NOT NULL AND @credsId <> 0
	BEGIN
		DELETE APP_CredentialAssoc
WHERE credentialId = @credsId AND entityType = 195 AND entityId = @distributedStorageId
		IF NOT EXISTS (SELECT 1 FROM APP_CredentialAssoc (NOLOCK) WHERE credentialId = @credsId)
		BEGIN
			DELETE FROM APP_Credentials WHERE credentialId = @credsId
EXEC sec_deleteSecurityAssociationsForEntity 174, @credsId
		END
	END
	------  AUDIT DELETE DISTRIBUTED STORAGE OPERATION ------
DECLARE @opMsgId    INT = (699 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId  INT = 0
	DECLARE @opId       INT = 0
DECLARE @paramMsgId INT = (1850 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- [^1%s]
	EXEC EvGuiAuditSetOperation  @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- audit record parameter values
	EXEC EvGuiAuditSetParamData @opId, @name, 0
	-- tie up
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs (NOLOCK) WHERE MessageId = @errorCode and localeId = @localeId)
	END
	SET @xmlstr =
	(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'), ROOT('App_DeleteDistributedStorageResponse'))
	select @xmlstr
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteDistributedStorage')
	delete from GxQscripts where name = 'AppDeleteDistributedStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteDistributedStorage')
	delete from GXDBVersions where aliasname = 'AppDeleteDistributedStorage'
GO

insert into GXDBVersions values(2, 'AppDeleteDistributedStorage',  '00000000000000000000', 'AppDeleteDistributedStorage', '00000000000000000000')
GO

