

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteCustomProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDeleteCustomProperty.sp,v $ $Id: AppDeleteCustomProperty.sp,v 1.2.12.5 2018/03/22 01:35:08 jiechen Exp $";
--	+===================================================================+
--	|  					  AppDeleteCustomProperty							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppDeleteCustomProperty <<<'

IF EXISTS (select * from sysobjects where name='AppDeleteCustomProperty')
	drop procedure AppDeleteCustomProperty
IF EXISTS (select * from GxQscripts where name='AppDeleteCustomProperty')
	delete from GxQscripts where name = 'AppDeleteCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteCustomProperty')
	delete from GXDBVersions where aliasname = 'AppDeleteCustomProperty'
GO
print '... Creating Procedure: AppDeleteCustomProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteCustomProperty
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @indexingFieldName	NVARCHAR(MAX)= ''
	-- Read the XML
	DECLARE @propertyId			INT				= ISNULL (( SELECT ref.value('@propertyId', 'INT')
														FROM @inXml.nodes ('App_DeleteCustomPropertyRequest/property') R(ref)), 0)
	DECLARE @propertyName	NVARCHAR(MAX)		= ISNULL (( SELECT ref.value('@propertyName', 'NVARCHAR(MAX)')
														FROM @inXml.nodes ('App_DeleteCustomPropertyRequest/property') R(ref)), '')
	IF @propertyId = 0 AND @propertyName <> ''
	BEGIN
		SET @propertyId = ISNULL((SELECT propertyId FROM App_CustomProperty WITH (NOLOCK) WHERE propertyName = @propertyName), 0)
		IF @propertyId = 0
		BEGIN
			-- TODO - Assign proper event message codes.
SET @errorCode = (3067 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
		END
	END
	IF NOT EXISTS (SELECT 1 FROM App_CustomProperty WITH (NOLOCK) WHERE propertyId = @propertyId)
	BEGIN
			-- TODO - Assign proper event message codes.
SET @errorCode = (3067 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
			GOTO ERROR_EXIT
	END
	BEGIN TRAN
	-- CHECK IF USER HAS AN ABILITY / PERMISSION TO DELETE THE PROPERTY
	DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 210, @userHasCapability OUTPUT, 166, @propertyId
	-- CHECK IF USER IS THE PROPERTY OWNER OR HAS DELETE CAPABILITY
    IF NOT EXISTS ( SELECT  propertyId
                    FROM    App_CustomProperty
                    WHERE       propertyId = @propertyId
                            AND ((ownerId = @inUserId) OR (@userHasCapability = 1)))
	BEGIN
SET @errorCode = (3106 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        GOTO ERROR
    END
	-- REMOVE SECURITY ASSOCIATION
EXEC sec_deleteSecurityAssociationsForEntity 166, @propertyId
	DELETE FROM App_CustomProperty
	WHERE propertyId = @propertyId
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
	DELETE FROM App_ComponentProp
WHERE componentType=18 AND componentId = @propertyId AND propertyTypeId=1008
	SELECT @errorCode = @@ERROR
	IF @errorCode <> 0 GOTO ERROR
ERROR:
	IF @errorCode <> 0
	BEGIN
		ROLLBACK TRAN
		IF @errorString = ''
		BEGIN
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, 1, 0, 2)
		END
	END
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @outXml = (SELECT
								    (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
									 FOR XML PATH('error'), TYPE)
							FOR XML PATH('App_CustomPropertyResponse'), TYPE)
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteCustomProperty')
	delete from GxQscripts where name = 'AppDeleteCustomProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteCustomProperty')
	delete from GXDBVersions where aliasname = 'AppDeleteCustomProperty'
GO

insert into GXDBVersions values(2, 'AppDeleteCustomProperty',  '00010002001200050000', 'AppDeleteCustomProperty', '00010002001200050000')
GO

