

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteCompanyCredentialsAndKeyProviders.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppDeleteCompanyCredentialsAndKeyProviders"
--  |   Description: Stored procedure to delete credential, key provider entity of company
--	|
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppDeleteCompanyCredentialsAndKeyProviders')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteCompanyCredentialsAndKeyProviders <<<'
	drop procedure AppDeleteCompanyCredentialsAndKeyProviders
END
IF EXISTS (select * from GxQscripts where name='AppDeleteCompanyCredentialsAndKeyProviders')
	delete from GxQscripts where name = 'AppDeleteCompanyCredentialsAndKeyProviders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteCompanyCredentialsAndKeyProviders')
	delete from GXDBVersions where aliasname = 'AppDeleteCompanyCredentialsAndKeyProviders'
GO
print '... Creating Procedure: AppDeleteCompanyCredentialsAndKeyProviders'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppDeleteCompanyCredentialsAndKeyProviders
  @companyId INTEGER
AS
  DECLARE @errorString nvarchar(1024)
  DECLARE @errorCode INT
  DECLARE @rowsDeleted INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
set @errorCode = 0
set @rowsDeleted = 0
BEGIN TRY
	DECLARE @c_flags INT = 0
	SELECT @c_flags = flags FROM UMDSProviders WHERE id = @companyId AND enabled=0
IF  @c_flags & 0x0002 = 0x0002
	BEGIN
		-- Update the credentials associated with non deleteble library or library which is not a company library as not ready for delete.
		IF object_id('tempdb.dbo.#entities') is not null
        		DROP TABLE #entities
		CREATE TABLE #entities (entityType INT NOT NULL
			      PRIMARY KEY (entityType))
		INSERT INTO #entities
		SELECT DISTINCT ACA.entityType
		FROM App_CompanyEntities App
		INNER JOIN APP_Credentials AC WITH(NOLOCK)
			ON AC.credentialId  = App.entityId
AND App.entityType = 174
				AND App.companyId = @companyId
		INNER JOIN APP_CredentialAssoc ACA WITH(NOLOCK)
			ON ACA.credentialId = AC.credentialId
		IF (SELECT count(0)
		FROM #entities) > 0
		BEGIN
			DECLARE @entityType INT = 0
			DECLARE entityTypes CURSOR FOR
			SELECT entityType FROM #entities
			OPEN entityTypes
			FETCH NEXT FROM entityTypes INTO @entityType
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
				DECLARE @idColName VARCHAR(128) = ''
					,@tableName VARCHAR(128) = ''
					,@entityNameColName VARCHAR(128) = ''
					,@whereClause VARCHAR(512) = ''
				SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause,  @entityNameColName = entityNameColName
				FROM APP_Entity
				WHERE
					entityType = @entityType
				IF @whereClause = ''
					SET @whereClause = '1=1'
IF @entityType = 186 -- For device controller, where clause has invalid id column name, hence fixing it here
					SET @whereClause = 'DeviceControllerId <> 0'
				IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
				BEGIN
					-- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
					SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
				END
				SET @dynamicSQLStr =  'UPDATE App
SET flags = App.flags | ' + CAST ((SELECT CONVERT(INT, 0x4)) AS VARCHAR(16)) +
										' FROM App_CompanyEntities App
										INNER JOIN APP_Credentials AC WITH(NOLOCK)
											ON AC.credentialId  = App.entityId
AND App.entityType = 174
												AND App.companyId = ' + CAST (@companyId AS VARCHAR(10)) +
										' INNER JOIN APP_CredentialAssoc ACA WITH(NOLOCK)
											ON ACA.credentialId = AC.credentialId
												AND ACA.entityType =  ' + CAST (@entityType AS VARCHAR(10)) +
										' LEFT JOIN ' + @tableName +
											' ON ACA.entityId = ' + @tableName + '.' + @idColName +
										' WHERE ' + @tableName + '.' + @idColName +  ' is NOT NULL  '
											+ ' AND ' + @whereClause
				EXEC (@dynamicSQLStr)
				FETCH NEXT FROM entityTypes INTO @entityType
			END
			CLOSE entityTypes
			DEALLOCATE entityTypes
		END
		DELETE AC
		FROM APP_Credentials AC
		INNER JOIN App_CompanyEntities App
On App.entityId = AC.credentialId AND App.entityType = 174
		WHERE App.companyId = @companyId
AND App.flags & 0x4 = 0
		SET @rowsDeleted = @@ROWCOUNT
		-- Update the key providers associated with non deleteble storage pool or storage pool which is not part of given company as not ready for delete.
		UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
		FROM App_companyEntities ACE
		INNER JOIN ArchEncKeyProvider AC WITH(NOLOCK)
			ON AC.KeyProviderId = ACE.entityId
AND ACE.entityType = 178
				AND ACE.companyId = @companyId
		INNER JOIN ArchCopyEncProperties ENC WITH(NOLOCK)
			ON AC.KeyProviderId = ENC.KeyProviderId
		INNER JOIN ArchGroupCopy AGC WITH(NOLOCK)
			ON ENC.CopyId =  AGC.id
		LEFT JOIN App_companyEntities ACE2 WITH(NOLOCK)
			ON ACE2.entityId = AGC.archGroupId
AND ACE2.entityType = 17
				AND ACE2.companyId = @companyId
		WHERE ACE2.entityId is NULL
OR ACE2.flags & 0x4 = 0x4
		-- Update the key providers associated un-deleted ArchEncKeyProviderAssoc, ArchCompanyEncProperties as not ready for delete.
		UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
		FROM App_companyEntities ACE
		INNER JOIN ArchEncKeyProvider AC WITH(NOLOCK)
			ON AC.KeyProviderId = ACE.entityId
AND ACE.entityType = 178
				AND ACE.companyId = @companyId
		INNER JOIN ArchEncKeyProviderAssoc ENC WITH(NOLOCK)
			ON AC.KeyProviderId = ENC.KeyProviderId
		UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
		FROM App_companyEntities ACE
		INNER JOIN ArchEncKeyProvider AC WITH(NOLOCK)
			ON AC.KeyProviderId = ACE.entityId
AND ACE.entityType = 178
				AND ACE.companyId = @companyId
		INNER JOIN ArchCompanyEncProperties ENC WITH(NOLOCK)
			ON AC.KeyProviderId = ENC.KeyProviderId
		DELETE AC
		FROM ArchEncKeyProvider AC
		INNER JOIN App_CompanyEntities App
On App.entityId = AC.KeyProviderId AND App.entityType = 178
		WHERE App.companyId = @companyId
AND App.flags & 0x4 = 0
		SET @rowsDeleted += @@ROWCOUNT
	END
	ELSE
	BEGIN
		set @errorCode = 1
		set @errorString = 'Cannot delete credentials of company since company is not marked for delete'
	END
END TRY
BEGIN CATCH
	set @errorCode = ERROR_NUMBER()
	set @errorString = 'Cannot delete credentials of company ' +ERROR_MESSAGE()
	-- rethrow deadlock error for XE to capture
	IF (@errorCode = 1205)
	BEGIN
	   ;THROW;
	END
END CATCH
SELECT @errorCode AS 'errorCode',
       @errorString AS 'errorString',
	   @rowsDeleted AS 'rowsDeleted'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteCompanyCredentialsAndKeyProviders')
	delete from GxQscripts where name = 'AppDeleteCompanyCredentialsAndKeyProviders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteCompanyCredentialsAndKeyProviders')
	delete from GXDBVersions where aliasname = 'AppDeleteCompanyCredentialsAndKeyProviders'
GO

insert into GXDBVersions values(2, 'AppDeleteCompanyCredentialsAndKeyProviders',  '00000000000000000000', 'AppDeleteCompanyCredentialsAndKeyProviders', '00000000000000000000')
GO

