

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteCMCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppDeleteCMCredentials					    |
--	|				Delete Credential Manager Records					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppDeleteCMCredentials <<<'

IF EXISTS (select * from sysobjects where name='AppDeleteCMCredentials')
	drop procedure AppDeleteCMCredentials
IF EXISTS (select * from GxQscripts where name='AppDeleteCMCredentials')
	delete from GxQscripts where name = 'AppDeleteCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteCMCredentials')
	delete from GXDBVersions where aliasname = 'AppDeleteCMCredentials'
GO
print '... Creating Procedure: AppDeleteCMCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteCMCredentials
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @ixml XML
-----------------------------------------------------------
AS
  DECLARE @oxml XML
SET NOCOUNT ON
BEGIN TRY
	DECLARE @userId int
	DECLARE @locale int
	DECLARE @o_ErrorString   NVARCHAR(max) =''
	DECLARE @o_ErrorCode     integer=0
	DECLARE @validData       integer=1
	if OBJECT_ID('tempdb.dbo.#credIdsToDelete') is not null drop table dbo.#credIdsToDelete
	if OBJECT_ID('tempdb.dbo.#credIdsUserHaveRights') is not null drop table dbo.#credIdsUserHaveRights
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
	FROM @ixml.nodes('App_DeleteCredentialRecordReq/processinginstructioninfo/user') R ( ref )),0)
	SET @locale = ISNULL((SELECT  ref.value('@localeId', 'int')
	FROM @ixml.nodes('App_DeleteCredentialRecordReq/processinginstructioninfo/locale') R ( ref )),0)
	create table #credIdsToDelete
	(
		credentialId integer PRIMARY KEY
	);
	create table #credIdsUserHaveRights
	(
		credentialId integer PRIMARY KEY
	);
	-- Get list of all credential id's user has requested to delete
	INSERT INTO #credIdsToDelete
	SELECT
	Tbl.Col.value('(credentialRecord/@credentialId)[1]', 'int')
	FROM @ixml.nodes('App_DeleteCredentialRecordReq/credentialRecordInfo') as Tbl(Col)
	SET @validData = 1
	IF @validData = 1
	BEGIN
		IF EXISTS (select 1 from #credIdsToDelete where (credentialId is NULL))
		BEGIN
			SET @o_ErrorCode = -1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3451 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	END
	IF @validData = 1
    BEGIN
		IF EXISTS (select 1 from #credIdsToDelete WHERE credentialId IN (SELECT distinct credentialId FROM APP_CredentialAssoc))
        BEGIN
			SET @o_ErrorCode = -1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3452 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
    END
	IF @validData = 1
	BEGIN
	 	IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') is not null drop table dbo.#getMemberUserGroupsHelperOutputTbl
		create table #getMemberUserGroupsHelperOutputTbl
		(
			isUser int,
			userOrGroupId int
		);
		EXEC sec_getMemberUserGroupsHelper @userId
		INSERT INTO #credIdsUserHaveRights
		(credentialId)
		SELECT DISTINCT entityId1 FROM UMSecurityAssociations Sec
		INNER JOIN #getMemberUserGroupsHelperOutputTbl Tbl
		ON Sec.isUser = Tbl.isUSer AND Sec.userOrGroupId = Tbl.userOrGroupId
WHERE entityType1 = 174 AND isCreator = 1
		--drop table dbo.#getMemberUserGroupsHelperOutputTbl
		IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') is not null drop table dbo.#getMemberUserGroupsHelperOutputTbl
		-- credential ids that user does not have ownership
		IF EXISTS (select 1 from #credIdsToDelete where credentialId NOT IN (SELECT distinct credentialId FROM #credIdsUserHaveRights))
		BEGIN
			SET @o_ErrorCode = -1
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3452 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
			SET @validData = 0
		END
	END
	-- final list of credential ids to delete
	IF @validData = 1
	BEGIN
		DELETE FROM APP_Credentials
		WHERE credentialId IN (SELECT distinct credentialId FROM #credIdsToDelete)
		-- -- remove all security association from the credential ID
		DECLARE @credIdToDelete INT = 0
		DECLARE deleteSecCred CURSOR
		FOR SELECT distinct credentialId FROM #credIdsToDelete
		OPEN deleteSecCred
		FETCH deleteSecCred INTO @credIdToDelete
		WHILE @@FETCH_STATUS = 0
		BEGIN
EXEC sec_deleteSecurityAssociationsForEntity 174, @credIdToDelete
			FETCH deleteSecCred INTO @credIdToDelete
		END
		CLOSE deleteSecCred
		DEALLOCATE deleteSecCred
		SET @o_ErrorCode = 0
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (29 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2722 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
    --Close cursor
    IF ( CURSOR_STATUS('global', 'deleteSecCred') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'deleteSecCred') >= 0 )
    CLOSE deleteSecCred
    IF ( CURSOR_STATUS('global','deleteSecCred') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','deleteSecCred') = -1 )
    DEALLOCATE deleteSecCred
END CATCH
SET @oxml =
(
	SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorMessage'
	FOR XML PATH ('error'), ROOT('App_DeleteCredentialRecordResp')
)
IF OBJECT_ID('tempdb.dbo.#credIdsToDelete') is not null drop table dbo.#credIdsToDelete
SELECT @oxml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteCMCredentials')
	delete from GxQscripts where name = 'AppDeleteCMCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteCMCredentials')
	delete from GXDBVersions where aliasname = 'AppDeleteCMCredentials'
GO

insert into GXDBVersions values(2, 'AppDeleteCMCredentials',  '00000000000000000000', 'AppDeleteCMCredentials', '00000000000000000000')
GO

