

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteBlrPairs.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppDeleteBlrPairs   - Mark pairs belonging to a replication group for deletion.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteBlrPairs')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteBlrPairs <<<'
	drop procedure AppDeleteBlrPairs
END
IF EXISTS (select * from GxQscripts where name='AppDeleteBlrPairs')
	delete from GxQscripts where name = 'AppDeleteBlrPairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteBlrPairs')
	delete from GXDBVersions where aliasname = 'AppDeleteBlrPairs'
GO
print '... Creating Procedure: AppDeleteBlrPairs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteBlrPairs
  @blrPairsXML XML,
  @repGroupId INT,
  @i_userId INT,
  @i_localeId INT
AS
DECLARE @errorCode    INT = 0
DECLARE @errorString  NVARCHAR(1024) = ''
DECLARE @o_xml        XML
SET NOCOUNT ON
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#continuousPairsToDelete') IS NOT NULL
        DROP TABLE #continuousPairsToDelete
	CREATE TABLE #continuousPairsToDelete (id INT, subClientId INT, srcName NVARCHAR(256), dstName NVARCHAR(256))
    -- CHECK IF SUCH REPLICATION GROUP EXISTS
DECLARE @planId INT = ISNULL((SELECT CONVERT(INT,attrVal) FROM App_ReplicationGroupProp WITH(NOLOCK) WHERE componentNameId = @repGroupId AND attrName = 'Associated Plan'),0)
    IF @planId = 0
    BEGIN
SET @errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
        GOTO ERROR_EXIT
    END
	-- SECURITY CHECK
    DECLARE @hasRights INT = 0
	 -- SECURITY CHECK ON PLAN ENTITY
EXEC sec_checkPermissionOnEntity @i_userId, 158, @hasRights OUTPUT, 158, @planId
    -- sec_checkPermissionOnEntity just checks for rights on the plan. For replication plans, you need some extra checks like checking rights on the Hypervisor
    -- associated with the replication task of the plan.
    IF(@hasRights = 0)
    BEGIN
        IF(@planId <> 0)
        BEGIN
EXEC [dbo].[sec_CheckRepPlanEntitiesSecurity] @planId,158, 0, @i_userId,0,@hasRights OUTPUT
        END
    END
	IF @hasRights = 0
    BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
        GOTO ERROR_EXIT
    END
	INSERT INTO #continuousPairsToDelete
		SELECT blr.id, blr.subClientId, blr.srcName, blr.dstName FROM BlrPair blr
		JOIN @blrPairsXML.nodes('BlockReplication_BLRDeletePairsReq/deletePair') R(ref) ON ref.value('@pairId','INT') = blr.id
	--MARK BLRPAIR AND SUBCLIENT RECORDS DELETED
	UPDATE BlrPair
        SET flags = flags | 2 -- #define BLR_PAIR_FLAG_MARKED_DELETION   (1<<1)
        FROM BlrPair blr
        JOIN #continuousPairsToDelete cont ON cont.id = blr.id
	 UPDATE App_Application
SET subclientStatus = subclientStatus | 0x00004
        FROM App_Application app
        JOIN #continuousPairsToDelete cont ON cont.subClientId = app.id
	DECLARE @repGroupName NVARCHAR(MAX) = (SELECT name FROM App_ReplicationGroup WITH(NOLOCK) WHERE id = @repGroupId)
	DECLARE @srcName NVARCHAR(256) = ''
	DECLARE @dstName NVARCHAR(256) = ''
DECLARE @opMsgId    INT = (694 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId  INT = 0
    DECLARE @opId       INT = 0
    DECLARE @entityName NVARCHAR(510) = NULL
DECLARE @paramMsgId INT = (1847 | (CAST(POWER(2, 24) AS BIGINT) * 85))  -- Replication pair: [^1%s] : [^2%s] of the replication group: [^3%s] is deleted.
	DECLARE GetPairsToDeleteCursor CURSOR FOR
    SELECT srcName, dstName FROM #continuousPairsToDelete
	OPEN GetPairsToDeleteCursor
		FETCH NEXT FROM GetPairsToDeleteCursor INTO @srcName, @dstName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC EvGuiAuditSetOperation  @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
		-- audit record parameter values
		EXEC EvGuiAuditSetParamData @opId, @srcName, 0
		EXEC EvGuiAuditSetParamData @opId, @dstName, 0
		EXEC EvGuiAuditSetParamData @opId, @repGroupName, 0
		-- tie up
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
	FETCH NEXT FROM GetPairsToDeleteCursor INTO @srcName, @dstName
	END --END GetPairsToDeleteCursor fetch loop
	CLOSE GetPairsToDeleteCursor
    DEALLOCATE GetPairsToDeleteCursor
ERROR_EXIT:
    IF @errorCode <> 0 AND @errorString = ''
    BEGIN
        SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode AND [localeId] = @i_localeId)
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SELECT @o_xml  as o_xmlString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteBlrPairs')
	delete from GxQscripts where name = 'AppDeleteBlrPairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteBlrPairs')
	delete from GXDBVersions where aliasname = 'AppDeleteBlrPairs'
GO

insert into GXDBVersions values(2, 'AppDeleteBlrPairs',  '00000000000000000000', 'AppDeleteBlrPairs', '00000000000000000000')
GO

