

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDeleteBackupSet.sp,v $ $Id: AppDeleteBackupSet.sp,v 1.10.60.3 2020/03/11 00:48:42 chandru Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 09/04/2007
-- Description:	Deletes a BackupSet .
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteBackupSet')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteBackupSet <<<'
	drop procedure AppDeleteBackupSet
END
IF EXISTS (select * from GxQscripts where name='AppDeleteBackupSet')
	delete from GxQscripts where name = 'AppDeleteBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteBackupSet')
	delete from GXDBVersions where aliasname = 'AppDeleteBackupSet'
GO
print '... Creating Procedure: AppDeleteBackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteBackupSet
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML		OUTPUT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @i_clientId			INT
	DECLARE @i_commcellId		INT
	DECLARE @i_instanceId		INT
	DECLARE @i_backupSetId		INT
	DECLARE @i_useXml			INT
	DECLARE @valid				INT
	DECLARE @subClientId		INT
	DECLARE @i_UserName		NVARCHAR(255)
	DECLARE @errorCode			INT
	DECLARE @errorString		NVARCHAR(1024)
	DECLARE @jobIdTbl table( jobId INT );
	DECLARE @idTbl table( id INT );
	DECLARE @GUIAuditBkpSetName NVARCHAR(255)
	DECLARE @GUIAuditClientName NVARCHAR(255)
	DECLARE @GUIAuditAppTypeId  INT
	DECLARE @GUIAuditUserId     INT
	SET @i_clientId = 0
	SET @errorCode = 0
	SET @errorString = ''
	SET @i_useXml = ISNULL(( SELECT ref.value('@useXml', 'INT')
								FROM @xmlText . nodes('CVGui_DeleteBackupSetReq') R ( ref ) ), 0)
	--GET BACKUPSET ID
	SET @i_backupSetId = ISNULL(( SELECT ref.value('@backupSetId', 'INT')
								FROM @xmlText . nodes('CVGui_DeleteBackupSetReq') R ( ref ) ), 0)
	IF @i_backupSetId < 2
	BEGIN
		SET @errorCode = -1
		SET @errorString = N'Invalid backup set id'
		GOTO EXIT_PROC
	END
	--GET USER NAME
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @xmlText.nodes('CVGui_DeleteBackupSetReq') R ( ref ) ), '')
	--GET GUI AUDIT TRAIL INFO
	SELECT @GUIAuditBkpSetName = B.NAME, @GUIAuditClientName = C.NAME, @GUIAuditAppTypeId = A.AppTypeId
	FROM APP_Application A, APP_BackupSetName B, APP_Client C
	WHERE A.backupSet = B.id
	AND	A.clientId = C.id
	AND	A.backupSet = @i_backupSetId
	SET @GUIAuditUserId = 0
	IF NOT EXISTS (SELECT id FROM UMUsers WHERE login LIKE @i_UserName)
	BEGIN
		SET @errorCode = -3
		SET @errorString = N'User would need to login into the Java Console to be able to delete the Hold'
		GOTO EXIT_PROC
	END
	SET @GUIAuditUserId = (SELECT id FROM UMUsers WHERE login LIKE @i_UserName)
	--USE DEFAULT INSTANCE
	SET @i_instanceId = ISNULL(( SELECT ref.value('@instanceId', 'INT')
								FROM @xmlText . nodes('CVGui_DeleteBackupSetReq') R ( ref ) ), 1)
	SET @i_commcellId = ISNULL(( SELECT ref.value('@commcellId', 'INT')
								FROM @xmlText . nodes('CVGui_DeleteBackupSetReq') R ( ref ) ), 2)
	--CHECK FOR RUNNING JOBS ON THE BACKUP SET
	INSERT INTO @jobIdTbl
		SELECT jobId FROM JMRstJobInfo WHERE bkpSetID = @i_backupSetId
		UNION
		SELECT jobId FROM JMBkpJobInfo WHERE applicationId IN (SELECT id FROM APP_Application WHERE backupSet = @i_backupSetId)
	IF EXISTS( SELECT jobId FROM @jobIdTbl)
	BEGIN
		SET @errorCode = -2
		SET @errorString = N'Unable to delete backup set. Jobs are still in progress'
		GOTO EXIT_PROC
	END
	--CHECK THAT IT IS AN LEGAL HOLD BACKUP SET
	IF NOT EXISTS(SELECT componentNameId FROM APP_BackupSetprop WHERE modified = 0 AND componentNameId = @i_backupSetId AND attrName = 'Prefered Web Server ClientId')
	BEGIN
		SET @errorCode = -4
		SET @errorString = N'Backup set is not for Legal Hold'
		GOTO EXIT_PROC
	END
BEGIN TRY
	BEGIN TRAN
	------------------------------------
	--DELETE BACKUP AND RESTORE TASKS
	------------------------------------
	INSERT INTO @idTbl
		SELECT ASSOC.taskId
		FROM TM_AssocEntity AS ASSOC, TM_Task AS T
		WHERE ASSOC.backupsetId = @i_backupSetId
		AND ASSOC.taskId = T.taskId
		AND T.taskType <> 4 -- Policy
	DELETE FROM TM_Task where taskId IN (SELECT id FROM @idTbl)
	DELETE FROM @idTbl	--CLEAR TEMP TABLE
	-----------------------
	--DELETE APPLICATIONS
	-----------------------
	DECLARE @appId		INT
	DECLARE @status		INT
	INSERT INTO @idTbl
	EXEC archCopyToAppDelete @i_clientId, 0, @i_instanceId, @i_backupSetId, 0
	--DELETE ARCH STUFF FOR APP ID
	DECLARE GetAppIdsCursor CURSOR FOR
	SELECT id, subclientStatus FROM APP_Application WHERE backupSet = @i_backupSetId
	OPEN GetAppIdsCursor
	FETCH FROM GetAppIdsCursor INTO @appId, @status
	WHILE @@FETCH_STATUS = 0
	BEGIN
IF (@status & 0x00008) <> 0x00008	--CV_STATUS_DEFAULT_
		BEGIN
			INSERT INTO @idTbl
			EXEC deleteBackupByAppId @appId
		END
		FETCH FROM GetAppIdsCursor INTO @appId, @status
	END
	CLOSE GetAppIdsCursor
	DEALLOCATE GetAppIdsCursor
	--DELETE BACKJOB RESTORE MAP HISTORY
	DELETE FROM JMJobRestoreHistoryInfo FROM JMJobRestoreHistoryInfo
	INNER JOIN JMRestoreStats ON JMRestoreStats.jobId = JMJobRestoreHistoryInfo.jobId AND JMRestoreStats.commCellId = JMJobRestoreHistoryInfo.commCellId
	WHERE JMRestoreStats.bkpSetID = @i_backupSetId
	--DELETE RESTORE HISTORY
	DELETE FROM JMJobStats FROM JMJobStats
	INNER JOIN JMRestoreStats ON JMRestoreStats.jobId = JMJobStats.jobId AND JMRestoreStats.commCellId = JMJobStats.commCellId
	WHERE JMJobStats.commCellId = @i_commcellId AND JMRestoreStats.bkpSetID = @i_backupSetId
	--DELETE JMJobDataStats HISTORY
	DELETE FROM JMJobDataStats
	WHERE CommCellId = @i_CommCellId AND AppId IN(SELECT id FROM APP_Application  WHERE backupSet = @i_backupSetId )
	--DELETE BACKUP HISTORY
	DELETE FROM JMJobStats FROM JMJobStats
	INNER JOIN JMBkpStats ON JMBkpStats.jobId = JMJobStats.jobId AND JMBkpStats.commCellId = JMJobStats.commCellId
	WHERE JMJobStats.commCellId = @i_commcellId AND JMBkpStats.appId IN (SELECT id FROM APP_Application  WHERE backupSet = @i_backupSetId )
	--DELETE THE SUBCLIENT PROPERTIES
	DELETE FROM APP_SubClientProp WHERE componentNameId IN (SELECT id FROM APP_Application WHERE backupSet = @i_backupSetId)
	DELETE FROM APP_ScFilterFile WHERE componentNameId IN (SELECT id FROM APP_Application WHERE backupSet = @i_backupSetId)
	--DELETE APP IDS
	DELETE FROM APP_Application WHERE backupSet = @i_backupSetId
	--SOFT DELETE LEGAL HOLD COMPLIANCE POLICY
	UPDATE DM2CompliancePolicy SET BackupsetId = 1, Attribute = (Attribute | 4) WHERE BackupsetId = @i_backupSetId
	-----------------------
	--DELETE BACKUP SET
	-----------------------
	DELETE FROM APP_BackupsetProp WHERE componentNameId = @i_backupSetId
	DELETE FROM APP_BackupsetName WHERE id = @i_backupSetId
	---------------------------------
	--CREATE GUI AUDIT TRAIL ENTRIES
	---------------------------------
	DECLARE @opMsgId INT
	DECLARE @opEvMsgId INT
	DECLARE @opId INT
	DECLARE @dataIsEvent INT
	DECLARE @paramMsgId INT
	DECLARE @appTypeName NVARCHAR(MAX)
SET @opMsgId = (70 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOperation @opMsgId, @GUIAuditUserId, @opEvMsgId OUTPUT, @opId OUTPUT
	SET @dataIsEvent = 0
SET @paramMsgId = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @GUIAuditClientName, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
SET @paramMsgId = (206 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @appTypeName = ISNULL((Select name from app_idaType where type = @GUIAuditAppTypeId), 'No Ida Name')
	EXEC EvGuiAuditSetParamData @opId, @appTypeName, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
SET @paramMsgId = (208 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @GUIAuditBkpSetName, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @GUIAuditUserId
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetAppIdsCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetAppIdsCursor') >= 0 )
	CLOSE GetAppIdsCursor
	IF ( CURSOR_STATUS('global','GetAppIdsCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetAppIdsCursor') = -1 )
	DEALLOCATE GetAppIdsCursor
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH
EXIT_PROC:
	IF @i_useXml = 0
		SELECT @errorCode AS errorCode, @errorString AS errorString
	ELSE
		SET @xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('CVGui_DeleteBackupSetResp'))
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteBackupSet')
	delete from GxQscripts where name = 'AppDeleteBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteBackupSet')
	delete from GXDBVersions where aliasname = 'AppDeleteBackupSet'
GO

insert into GXDBVersions values(2, 'AppDeleteBackupSet',  '00010010006000030000', 'AppDeleteBackupSet', '00010010006000030000')
GO

