

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeleteAdditionalSettingsForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===============================================================================================================+
--	| AppDeleteAdditionalSettingsForEntity - Delete additional settings for given entity			|
--	+===============================================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeleteAdditionalSettingsForEntity')
BEGIN
	print '>>> Drop Stored Procedure: AppDeleteAdditionalSettingsForEntity <<<'
	drop procedure AppDeleteAdditionalSettingsForEntity
END
IF EXISTS (select * from GxQscripts where name='AppDeleteAdditionalSettingsForEntity')
	delete from GxQscripts where name = 'AppDeleteAdditionalSettingsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteAdditionalSettingsForEntity')
	delete from GXDBVersions where aliasname = 'AppDeleteAdditionalSettingsForEntity'
GO
print '... Creating Procedure: AppDeleteAdditionalSettingsForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeleteAdditionalSettingsForEntity
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
--		entityId = Client or Client group id			---
--		entityType = Client -> 3, Client Group -> 28	---
-----------------------------------------------------------
  @entityId INTEGER,
  @entityType INTEGER,
  @keyName NVARCHAR(1024),
  @relativePath NVARCHAR(4000),
  @type NVARCHAR(80)
-----------------------------------------------------------
AS
SET NOCOUNT ON
  DECLARE @errorCode INTEGER = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
BEGIN TRY
	DECLARE @tranCount bit = 0
	IF @@TRANCOUNT = 0
	BEGIN
		BEGIN TRANSACTION
		SET @tranCount = 1
	END
	UPDATE APP_AdvanceSettings SET deleted = 1 WHERE entityId = @entityId AND entityType = @entityType AND keyName = @keyName AND relativePath = @relativePath AND type = @type AND sourceId = 0 AND sourceEntityType = 0
	IF @@ROWCOUNT > 0
	BEGIN
IF @entityType = 3
		BEGIN
			IF EXISTS(SELECT 1 FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId = @entityId AND @entityId <> 2)
			BEGIN
				--WORK_TOKEN_REGISTRY
				INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
				SELECT PMClientId, -1,6,'',@now,0,0,0
					FROM APP_VMToPMMap WITH(NOLOCK)
					WHERE VMClientId = @entityId
			END
			ELSE
			BEGIN
				INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
				VALUES(@entityId,-1,6,'',@now,0,0,0) --WORK_TOKEN_REGISTRY
			END
		END
ELSE IF @entityType = 28
		BEGIN
			INSERT INTO APP_WorkQueueRequest(clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT DISTINCT clientId,-1,6,'',@now,0,0,0 --WORK_TOKEN_REGISTRY
			FROM APP_ClientGroupAssoc WITH(NOLOCK)
			WHERE clientGroupId = @entityId
		END
	END
	IF @tranCount = 1
	BEGIN
		COMMIT TRANSACTION
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @tranCount = 1
	BEGIN
		ROLLBACK TRANSACTION
	END
	SET @errorCode = 1
END CATCH
SET NOCOUNT OFF
RETURN @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeleteAdditionalSettingsForEntity')
	delete from GxQscripts where name = 'AppDeleteAdditionalSettingsForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeleteAdditionalSettingsForEntity')
	delete from GXDBVersions where aliasname = 'AppDeleteAdditionalSettingsForEntity'
GO

insert into GXDBVersions values(2, 'AppDeleteAdditionalSettingsForEntity',  '00000000000000000000', 'AppDeleteAdditionalSettingsForEntity', '00000000000000000000')
GO

