

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDelAllVMBSets.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  AppDelAllVMBSets.sp										  */
/*                                                                            */
/*  Description :  It will mark the VM backupsets as deleted				*/
/*						for the input VSA backupset							*/
/*																			  */
/*				  															  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDelAllVMBSets.sp,v $ $Id: AppDelAllVMBSets.sp,v 1.1.2.2 2020/07/15 21:23:19 scheppuri Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDelAllVMBSets')
BEGIN
	print '>>> Drop Stored Procedure: AppDelAllVMBSets <<<'
	drop procedure AppDelAllVMBSets
END
IF EXISTS (select * from GxQscripts where name='AppDelAllVMBSets')
	delete from GxQscripts where name = 'AppDelAllVMBSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDelAllVMBSets')
	delete from GXDBVersions where aliasname = 'AppDelAllVMBSets'
GO
print '... Creating Procedure: AppDelAllVMBSets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDelAllVMBSets
  @EntityID integer,
  @ClientID integer,
  @EntityType integer 
AS
  DECLARE @errorCode integer 
  DECLARE @errorString nvarchar(max)
SET NOCOUNT ON
BEGIN
BEGIN TRY
IF @EntityType =6
BEGIN
	 --Mark the VM backupsets as deleted
Update BackupSet SET status = status | 0x00004, name=name+'_Deleted'
	FROM APP_BackupSetName BackupSet
	INNER JOIN APP_VMBackupSet vmb  WITH(READUNCOMMITTED) ON BackupSet.id=vmb.ChildBackupSetId AND vmb.ParentBackupSetId = @EntityID
WHERE (status & 0x00004) = 0
END
ELSE IF @EntityType =5
BEGIN
	 --Mark the VM backupsets as deleted
Update BackupSet SET status = status | 0x00004, name=name+'_Deleted'
	FROM APP_BackupSetName BackupSet
	INNER JOIN APP_VMBackupSet vmb  WITH(READUNCOMMITTED) ON BackupSet.id=vmb.ChildBackupSetId AND vmb.ParentBackupSetId in(select backupset from APP_Application where instance = @EntityID)
WHERE (status & 0x00004) = 0
END
ELSE IF @EntityType =4
BEGIN
	 --Mark the VM backupsets as deleted
Update BackupSet SET status = status | 0x00004, name=name+'_Deleted'
	FROM APP_BackupSetName BackupSet
	INNER JOIN APP_VMBackupSet vmb  WITH(READUNCOMMITTED) ON BackupSet.id=vmb.ChildBackupSetId AND vmb.ParentBackupSetId in(select backupset from APP_Application where appTypeId = @EntityID AND clientId = @clientId)
WHERE (status & 0x00004) = 0
END
ELSE IF @EntityType =3
BEGIN
	 --Mark the VM backupsets as deleted
Update BackupSet SET status = status | 0x00004, name=name+'_Deleted'
	FROM APP_BackupSetName BackupSet
	INNER JOIN APP_VMBackupSet vmb  WITH(READUNCOMMITTED) ON BackupSet.id=vmb.ChildBackupSetId AND vmb.ParentBackupSetId in(select backupset from APP_Application where clientId = @clientId)
WHERE (status & 0x00004) = 0
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SET @errorCode   = 1
        SET @errorString = 'Problems Executing AppDelAllVMBSets Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
SELECT @errorCode,@errorString
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDelAllVMBSets')
	delete from GxQscripts where name = 'AppDelAllVMBSets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDelAllVMBSets')
	delete from GXDBVersions where aliasname = 'AppDelAllVMBSets'
GO

insert into GXDBVersions values(2, 'AppDelAllVMBSets',  '00010001000200020000', 'AppDelAllVMBSets', '00010001000200020000')
GO

